C  @(#)calculat.f	1.15   2/24/97
C
C  Functions to start the calculation of a PIA
C
C  Function to calculate preparatory variables
C
      INTEGER FUNCTION CALC1()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'commona.h'
      INCLUDE 'piaparmsf.h'
      INTEGER I
C  Function declarations
      INTEGER AVGMEN,BENMEN
      CALC1 = 0
      IPRMPT = 1
      IF (IALTBI.NE.7) THEN
        CALC1 = BENMEN()
        IF (CALC1.GT.0) RETURN
      END IF
      IF (IALTAW.NE.7) THEN
        CALC1 = AVGMEN()
        IF (CALC1.GT.0) RETURN
      END IF
      CALL AVGPRO
      DO 100 I=ISTART+1951,1936+IX
  100 QCAMT(I-1936) = 0.
      CALL QCPRO(QCAMT,FQ,ISTART+1950,1937,IX)
      IF (IBASCH.NE.2) THEN
        CALL WGBSST(0,0,0)
      ELSE
        CALL WGBSST(1,0,0)
      END IF
      IF (JOASDI.NE.4) THEN
        CALL MINPRO
        CALL HIGHPR
        CALL EARNPR
        CALL ERNPRO
      END IF
      RETURN
      END
C********************************************************
C  Function to calculate results
C********************************************************
      INTEGER FUNCTION CALC2()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INCLUDE 'pebspage.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
      INTEGER I2,I,FVAL,DATE(2)
C  Function declarations
      DOUBLE PRECISION DIMAX
      INTEGER PEBSET,ERNYRC,ROUND5,ISPRIM
      CHARACTER*1 DINSCA,FINS2C,INSCAL
      REAL REPCAL,STOTC
      CALC2 = 0
      FVAL = 0
      IF (JOASDI.EQ.4) THEN
        I2 = 5
      ELSE
        I2 = 1
      END IF
      DO 500 I=1,I2
      IF (JOASDI.EQ.4) THEN
        FVAL = PEBSET(I)
        IF (FVAL.GT.0) THEN
          CALC2 = FVAL
          RETURN
        END IF
      END IF
      STOT(1) = STOTC(1)
      CALL TAXCAL
      IERNYR = ERNYRC()
C  Calculate future and total quarters of coverage
      CALL QCCAL
      IF (IOASDI.EQ.2) THEN
        DATE(1) = IDEATH(1)
        DATE(2) = IDEATH(2)
      ELSE
        DATE(1) = IENT(1)
        DATE(2) = IENT(2)
      END IF
      INSC = INSCAL(DATE,ISPRIM())
      FINSC = FINS2C()
      IF (TOTALI) THEN
        IF (IQCTOT.EQ.0) THEN
          CALC2 = 198
          RETURN
        END IF
        REPAVG = REPCAL()
        STOT(2) = STOTC(2)
        CALL ERNLIM(4,2,BASE)
      END IF
      CALL NCAL(0,N,NDROP,NELAP)
C  Calculate disability insured status in disability case
      IF (IOASDI.EQ.3) DINSC = DINSCA()
C  Calculate PIA
      CALL PIAC
C  Save PEBES values
      IF (JOASDI.EQ.4) THEN
        PIAPBS(I) = ROUND5(HIPIA)
        IF (I.EQ.5) THEN
          MFBPBS(I) = ROUND5(DIMAX(5,IAME(3),PIAPBS(5),1.5*PIAPBS(5)))
        ELSE
          MFBPBS(I) = ROUND5(HIMFB)
        END IF
        IF (I.EQ.4) THEN
          BNFTPB(I) = ROUND5(.75*PIAPBS(I))
        ELSE
          BNFTPB(I) = ROUND5(BENFIT(1))
        END IF
        PQCREQ(I) = IQCREQ
        IF (I.EQ.5) THEN
          PDISRE = DISREQ
          PQCDIY = QCDIYR
        END IF
      END IF
  500 CONTINUE
      RETURN
      END
C
C  This subroutine calculates future quarters of coverage earned, and
C  total QC's.
C
      SUBROUTINE QCCAL
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
      INTEGER I,I2
C  Calculate QC's
      IF (CURYR.GT.1950) THEN
        IQCTOT = QCTD
        IQCT50 = IQCTOT - QC51TD
      ELSE
C  Use simplified QC rule prior to 1951
        IF (STOT(1).LT.50.) THEN
          IQCTOT = 0
        ELSE
          IQCTOT = INT(STOT(1)) / 400
        END IF
        IQCT50 = IQCTOT
        QCTD = IQCTOT
        QC51TD = 0
      END IF
C  Clear QC's after last actual year
      DO 110 I=CURYR-1935,IX
  110 IQC(I) = 0
      I2 = MAX0(CURYR,1950)
      IF (IENT(2).GT.I2) THEN
        DO 120 I=I2-1935,IENT(2)-1936
        IQC(I) = MIN0(INT(EARNST(I,1)/QCAMT(I)),4)
  120   IQCTOT = IQCTOT+IQC(I)
      END IF
      IQCT51 = IQCTOT - IQCT50
      RETURN
      END
C
C  Function to round benefit down to $5 multiple
C
      INTEGER FUNCTION ROUND5(AMOUNT)
      DOUBLE PRECISION AMOUNT
      ROUND5 = 5*IDINT((AMOUNT+.01D0)/5.D0)
      RETURN
      END
C
C  Function to set information for additional PEBES cases
C
      INTEGER FUNCTION PEBSET(I)
      INTEGER AGENOW, I, KBIRT2(2)
C  Function declarations
      INTEGER ARDRI
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'pebspage.h'
      KBIRT2(1) = KBIRTH(1)
      KBIRT2(2) = KBIRTH(3)
      GOTO (100,200,300,400,500), I
C
C  Delayed retirement
C
  100 IAGE(1) = 70
      IAGE(2) = 0
      CALL DATCAL(IENT,KBIRT2,IAGE)
      CALL STBNDT
      IEND = KBIRTH(3)+69
      GOTO 600
C
C  Normal retirement
C
  200 IAGE(1) = NRA(1)
      IAGE(2) = NRA(2)
      CALL DATCAL(IENT,KBIRT2,IAGE)
      CALL STBNDT
      IEND = BENDAT(2)-1
      GOTO 600
C
C  Early retirement
C
  300 IF (NRA1(1).GE.IAGPLN) THEN
C  Retirement at earliest possible date
        IAGPL1(1) = NRA1(1)
        IAGPL1(2) = NRA1(2)
      ELSE
        IF (IAGPLN.GT.NRA(1)) THEN
C  Retirement after normal retirement age
          IAGPL1(1) = NRA(1)
          IAGPL1(2) = NRA(2)
        ELSE
C  Retirement between early and normal ages
          IAGPL1(1) = IAGPLN
          IAGPL1(2) = 0
        END IF
      END IF
      CALL DATCAL(IENT,KBIRT2,IAGPL1)
      CALL STBNDT
C  Check for entitlement prior to current date
      IF (((ISTART+1951-IENT(2))*12 + MONTHN - IENT(1)).GT.0) THEN
        IENT(2) = ISTART+1951
        IENT(1) = MONTHN
        CALL STBNDT
      END IF
C  Calculate age at entitlement
      CALL ENTAGE(IAGE,KBIRTH,IENT)
      CALL ENTAGE(IAGE1,KBIRTH,BENDAT)
C  Reset planned early retirement age
      IAGPL1(1) = IAGE(1)
      IAGPL1(2) = IAGE(2)
C  Check for last year of earnings
      IF (IAGPLN.GT.0) THEN
        IAGPL2 = IAGPLN
      ELSE
        IAGPL2 = 62
      END IF
C  Find age now
      IF (KBIRTH(1).GT.MONTHN) THEN
        AGENOW = ISTART+1951-KBIRTH(3)-1
      ELSE
        AGENOW = ISTART+1951-KBIRTH(3)
      END IF
      IAGPL2 = MAX0(IAGPL2,AGENOW)
C  Stop earnings in early retirement year
      IF (IAGPL1(1).GT.IAGPL2) IEND = KBIRTH(3)+IAGPL2-1
C  Continue earnings to year before current year
      IEND = MAX0(IEND,ISTART+1950)
      GOTO 600
C
C  Survivor
C
  400 IOASDI = 2
      JSURV = 1
      IDEATH(1) = MONTHN
      IENT(1) = MONTHN
      IDEATH(2) = ISTART+1951
      IENT(2) = ISTART+1951
      CALL STBNDT
      CALL ENTAGE(IAGE,KBIRTH,IENT)
      CALL ENTAGE(IAGE1,KBIRTH,BENDAT)
C  Stop earnings in year of death
      IEND = ISTART+1951
      GOTO 600
C
C  Disability
C
  500 IOASDI = 3
      IDEATH(1) = 0
      IDEATH(2) = 0
      JSURV = 0
      VALDI = 1
      IONSET(1) = MONTHN
      IENT(1) = MONTHN
      IONSET(2) = 15
      IONSET(3) = ISTART+1951
      IENT(2) = ISTART+1951
      CALL STBNDT
C  Stop earnings in year before disability
      IEND = ISTART+1950
C
C  Final preparation
  600 CALL ERNPRO
      CALL ELGYR
      PEBSET = ARDRI()
      RETURN
      END
