C  @(#)one_page.f	1.15   2/24/97
C
C  This subroutine prints out a one-page summary of a PIA calculation.
C
C  Definition of variables ('*' before variable name denotes dimensioned
C  variable array):
C
C  I      = temporary index used in do-loops.
C  I2     = temporary index used in various places.
C  IOUT   = output unit number.
C
      SUBROUTINE ONEPAG (IOUT)
      INTEGER I, I2, I3, I4, I5, I6, IOUT
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INCLUDE 'piadataf.h'
C
C  FORMAT statements
C
    1 FORMAT ('   Years of coverage = ',I2)
    2 FORMAT ('   WEP considered, but not applied')
    3 FORMAT ('   WEP applied')
    4 FORMAT ('   Frozen Minimum PIA (1977 Act):',F9.2)
  116 FORMAT ('1',T20,'R E T I R E M E N T    E S T I M A T E '///)
  117 FORMAT ('1',T20,'S U R V I V O R   E S T I M A T E '///)
  118 FORMAT ('1',T20,'D I S A B I L I T Y   E S T I M A T E'///)
  119 FORMAT (' ',T10,A20,T50,A28)
  120 FORMAT (' ',T10,A12)
  121 FORMAT (//' ',T10,'Date of birth: ',A9,I3,',',I5)
  122 FORMAT (' ',T10,'Date of death:  ',A9,I5)
  123 FORMAT (' ',T10,'Date of onset:  ',A9,I3,',',I5)
  124 FORMAT (///' ',T23,'R E G U L A R   E A R N I N G S '///)
  125 FORMAT ('   50',F10.2)
  126 FORMAT (' ',4(I4,F10.2),2X,I2,F10.2)
  127 FORMAT (//'   Dividend: ',F10.2,T55,'Divisor months: ',I4)
  128 FORMAT (///' ',T23,'I N D E X E D   E A R N I N G S '///)
  129 FORMAT (/'   Eff',T34,A9,T56,'Family'/'   date',T14,'AIME',
     &T24,'PIA',T34,'factor',T46,'MBA',T55,'maximum'/'   ',5('-'),
     &T13,6('-'),T23,6('-'),T33,9('-'),T45,6('-'),T55,7('-'))
  130 FORMAT ('   ',I2,T6,'/',I2,T13,I5,T22,F7.2,T34,F7.5,T44,F7.2,
     &T55,F7.2/)
  131 FORMAT ('   Old Start Calculation PIA:',F9.2 )
  132 FORMAT ('   New Start Calculation (pre-1977 Act) PIA:',F9.2 )
  133 FORMAT ('   Transitional Guarantee (1977 Act) PIA:',F9.2 )
  134 FORMAT ('   Special Minimum PIA:',F9.2)
  135 FORMAT ('   Re-indexed Widow (1983 Act) PIA:',F9.2)
C
C  Print one-page summary
C
      GO TO (310,315,320)IOASDI
  310 WRITE (IOUT,116)
      GO TO 325
  315 WRITE (IOUT,117)
      GO TO 325
  320 WRITE (IOUT,118)
  325 WRITE (IOUT,119) NAME,DATELN
      WRITE (IOUT,120) NHSSN
      WRITE (IOUT,121)MONTH(IBIRTH(1)),IBIRTH(2),IBIRTH(3)
      IF (IOASDI.EQ.2) WRITE (IOUT,122)MONTH(IDEATH(1)),IDEATH(2)
      IF(IOASDI.EQ.3)WRITE(IOUT,123)MONTH(IONSET(1)),IONSET(2),IONSET(3)
      WRITE (IOUT,124)
      IF (STOT(1).GT.0) WRITE (IOUT,125) STOT(1)
      DO 330 I=1,10
      I2=50+I
      I3=50+I+10
      I4=50+I+20
      I5=50+I+30
      I6=50+I+40
      IF (I6.EQ.100)I6=0
      WRITE (IOUT,126) I2,EARNST(14+I,3),I3,EARNST(14+I+10,3),I4,
     &EARNST(14+I+20,3),I5,EARNST(14+I+30,3),I6,EARNST(14+I+40,3)
  330 CONTINUE
      IF (IAPP(2).GT.0) WRITE (IOUT,127)FTEARN(2),12*N
      IF (IAPP(4).GT.0) WRITE (IOUT,127)FTEARN(4),12*N
      WRITE (IOUT,128)
      DO 335 I=1,10
      I2=50+I
      I3=50+I+10
      I4=50+I+20
      I5=50+I+30
      I6=50+I+40
      IF (I6.EQ.100)I6=0
      WRITE (IOUT,126)I2,VEARN(3,I),I3,VEARN(3,I+10),I4,
     &VEARN(3,I+20),I5,VEARN(3,I+30),I6,VEARN(3,I+40)
  335 CONTINUE
      WRITE (IOUT,127)FTEARN(3),12*N
      IF (ARF.GE.1) I=1
      IF (ARF.LT.1) I=2
      WRITE (IOUT,129) FACTOR(I)
      WRITE (IOUT,130) BENDAT(1),BENDAT(2)-1900,IAME(3),PIA(3),ARF,
     &BENFIT(1),MFB(3)
      IF (IAPP(1).GT.0) WRITE (IOUT,131)PIA(1)
      IF (IAPP(2).GT.0) WRITE (IOUT,132)PIA(2)
      IF (IAPP(4).GT.0) WRITE (IOUT,133)PIA(4)
      IF (IAPP(5).GT.0) THEN
        WRITE (IOUT,134) PIA(5)
        WRITE (IOUT,1) ISPMNT(1)
      END IF
      IF (IAPP(6).GT.0) WRITE (IOUT,135)PIA(6)
      IF (IAPP(7).GT.0) WRITE (IOUT,4) PIA(7)
      IF (IWIND.NE.0) THEN
        IF (IWIND.LT.0) THEN
          WRITE (IOUT,2)
        ELSE
          WRITE (IOUT,3)
        END IF
      END IF
      CALL NONINS(IOUT)
      IF (IOASDI.EQ.3) THEN
        WRITE (IOUT,*)
        CALL DISINS(IOUT)
      END IF
      RETURN
      END
