C  @(#)piaparms.f	1.5  2/24/97
C
C  Various subroutines to compute the PIA (Primary Insurance Amount)
C  and MFB (Maximum Family Benefit) under the applicable computation
C  methods.
C
C  Subroutine to apply catchup benefit increase
C
C  BCATCH = amount to be increased.
C *CACHUP = catch-up benefit increases.
C           I=1 is year of eligibility 1951+ISTART or earlier, 2 is year
C             of eligibility 1952+ISTART, ..., 10 is 1960+ISTART or
C             later.
C           J=1 is benefit increase in 1953+ISTART, 2 is 1954+ISTART,
C             ..., 8 is benefit increase in 1960+ISTART.
C  I120   = year, minus 1950, of catch-up benefit increase.
C  I122   = index of year of eligibility for catch-up benefit increase.
C
      SUBROUTINE BICCHP (I120,BCATCH,I122)
      INTEGER I120, I122
      DOUBLE PRECISION ROUND, BCATCH
      INCLUDE 'wrkrdataf.h'
C  Function declarations
      INTEGER CCHPXT
      IF (CCHPXT(I120,I122).GT.0) BCATCH =
C  Apply catch-up benefit increase
     &ROUND(BCATCH*(CACHUP(I122,I120-ISTART-2)/100.+1.),I120)
      RETURN
      END
C
C  Function to check for existence of catch-up benefit increase
C
C  I120   = year, minus 1950, of catch-up benefit increase.
C  I122   = index of year of eligibility for catch-up benefit increase.
C
      INTEGER FUNCTION CCHPXT(I120,I122)
      INTEGER I120, I122
      INCLUDE 'wrkrdataf.h'
      CCHPXT = 1
C  See if in catch-up period
      IF (I120.LT.ISTART+3.OR.I120.GT.ISTART+10) THEN
        CCHPXT = 0
        RETURN
      END IF
C  See if catch-up benefit increase is greater than 0
      IF (CACHUP(I122,I120-ISTART-2).LT..05) CCHPXT = 0
      RETURN
      END
C
C  This subroutine rounds a PIA or MFB to the appropriate multiple of
C  $0.10.
C
C    Definition of Variables ('*' before variable name denotes
C    variable array, with indices I, J, K, ...):
C
C  CRUDE  = unrounded, then rounded, PIA or MFB.
C  L      = year of benefit increase, or year prior to year of wage-
C             indexed formula, minus 1950.
C  Q      = fraction of $.01 above which PIA is rounded to next higher
C             dime, for June 1981 and earlier benefit increases, and
C             1982 and earlier Wage-Indexed formula AIME PIA'S.
C  X100   = 100 times CRUDE.
C
      DOUBLE PRECISION FUNCTION ROUND (CRUDE,L)
      INTEGER L
      DOUBLE PRECISION CRUDE, Q, X100
C  For 1982 and later benefit increases and 1983 and later wage-
C  indexed formulas, go to rounding-down section
      IF (L.GT.31) THEN
C  Round down to lower dime for June 1982 and later increases
      ROUND = DINT(10.*CRUDE+.001)/10.
      RETURN
      END IF
C  For rounding-up to dime, use half-cent rule for 1972 and
C  earlier increases; for 1973-81 benefit increases, round up to dime
C  in any case not already an exact multiple of $.10
      IF (L.GE.23) THEN
        Q = .01D0
      ELSE
        Q = .499D0
      END IF
      X100 = CRUDE*100.D0
C  If within tolerance of Q, do not round up
      IF (DMOD(X100,10.D0).LT.Q) THEN
        ROUND = CRUDE
C  Otherwise round up to dime
      ELSE
        ROUND = CRUDE + .10D0 - DMOD(X100,10.D0)/100.D0
      END IF
      RETURN
      END
C
C  Subroutine to project wage-indexed bend points
C
      SUBROUTINE BENDPC(MELGYR,BENDPT)
      INTEGER MELGYR,BENDPT(3)
      DOUBLE PRECISION TEMP
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piaparmsf.h'
      TEMP = FQ(MELGYR+13)/FQ(41)
C  Project applicable bend points from 1979 bend points
      BENDPT(2) = NINT(180.*TEMP)
      BENDPT(3) = NINT(1085.*TEMP)
      RETURN
      END
C
C  Subroutine to set MFB formula percentages and bend points
C
      SUBROUTINE MFBSET(MELGYR,BENDPT)
      INTEGER MELGYR,BENDPT(4)
      DOUBLE PRECISION TEMP
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
      TEMP = FQ(MELGYR+13)/FQ(41)
C  Assign values to MFB percents
      PERCM(1)=1.50
      PERCM(2)=2.72
      PERCM(3)=1.34
      PERCM(4)=1.75
C  Project the MFB bend points
      BENDPT(2) = NINT(230.*TEMP)
      BENDPT(3) = NINT(332.*TEMP)
      BENDPT(4) = NINT(433.*TEMP)
      RETURN
      END
C
C  Subroutine to set PIA formula percentages
C
C *TPERCP = percentages to be set.
C
      SUBROUTINE SPERCP(TPERCP)
      REAL TPERCP(3)
      TPERCP(1)=.90
      TPERCP(2)=.32
      TPERCP(3)=.15
      RETURN
      END
C
C  Function to find windfall percentage
C
C  BENYR  = year of benefit.
C  TELGYR = eligibility year minus 1951.
C  TSPMNT = years of coverage.
C
      REAL FUNCTION PERCWS(TELGYR,BENYR,TSPMNT)
      INTEGER TELGYR,TSPMNT,BENYR
      REAL TESTF,RV
C  Check year of eligibility
      RV = AMAX1(.90-.1*FLOAT(TELGYR-34),.40)
C  Check years of coverage
      IF (BENYR.GT.1988) THEN
        TESTF = .05
      ELSE
        TESTF = .10
      END IF
      RV = AMAX1(RV,.90-TESTF*FLOAT(30-TSPMNT))
      PERCWS = RV
      RETURN
      END
C
C  Subroutine to project minimum wage
C
      SUBROUTINE MINPRO
      INTEGER I
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piaparmsf.h'
      DO 10 I=1,IX
   10 WAGMIN(I) = .45*FQ(I)
      RETURN
      END
C
C  Subroutine to project minimum wage
C
      SUBROUTINE HIGHPR
      INTEGER I
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piaparmsf.h'
      DO 10 I=1,IX
   10 HIGH(I) = 1.60*FQ(I)
      RETURN
      END
