C  @(#)oldata.f	1.7   3/6/97
C
C  This subroutine reviews or updates historical average wages, benefit
C  increases, and other program parameters.
C
C  IHIST  = choice for review or update (0 to exit, 1 to review,
C           2 to update).
C
      SUBROUTINE OLDATA(PROGFL)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INCLUDE 'piaparmsf.h'
      CHARACTER*80 PROGFL
      INTEGER IHIST,KA,KW,I
C  Function declarations
      INTEGER MENSEL,GETHST,SAVHST
C
C  FORMAT statements
C
    7 FORMAT (T4,'0 to skip review of historical amounts'/
     &T4,'1 to review historical amounts'/
     &T4,'2 to update historical amounts')
   23 FORMAT (A1)
   39 FORMAT (T4,'Enter choice:')
   50 FORMAT (T36,'Warning')
   77 FORMAT (T23,'Review or update historical amounts')
   78 FORMAT (T4,75('_'))
   80 FORMAT (T9,I4,2X,F9.2,5X,I4,2X,F9.2,5X,I4,2X,F9.2)
   81 FORMAT (T4,29('-'),' Average wages ',28('-'))
   84 FORMAT (T9,I4,2X,F9.0,5X,I4,2X,F9.0,5X,I4,2X,F9.0)
   85 FORMAT (T4,32('-'),' Wage bases ',31('-'))
   86 FORMAT (T4,28('-'),' Old-law wage bases ',27('-'))
   88 FORMAT (T4,I4,F6.1)
   89 FORMAT (T4,28('-'),' Benefit increases',28('-'))
   90 FORMAT (T5,'You are about to update the historical amounts ',
     &'neccessary to compute Social'/T5,'Security benefits.  This',
     &' should be done once a year around November 1,'/T5,'when ',
     &'the new amounts are announced.'//T5,'If you continue, ',
     &'you will need the average wage for ',I4,', the wage base'/T5,
     &'(and old law wage base) for ',I4,', and the benefit increase ',
     &'for Dec ',I4,'.'//T5,'All four sets ',
     &'of projected average wages and benefit increases will be'/
     &T5,'automatically updated once you have updated the historical ',
     &'amounts.'//
     &T10,'Do you want to continue? (y or n)')
   91 FORMAT (T5,'Enter average wage for ',I4)
   92 FORMAT (T5,'Enter wage base for ',I4)
   93 FORMAT (T5,'Enter old law wage base for ',I4)
   95 FORMAT (T5,'Enter benefit increase for ',I4)
C
C  Read in historical amounts
C
      I = GETHST(PROGFL,10)
C
C  Review or update historical data
C
      CALL HYPHN1
      WRITE (6,77)
      CALL HYPHN2
      WRITE (6,39)
      WRITE (6,7)
      IHIST = MENSEL(0,2)
      IF (IHIST.EQ.0) RETURN
      GO TO (208,235) IHIST
C
C  Section to review historical data
C
  208 KA=MOD(ISTART+13,20)
      KW=MOD(ISTART+15,20)
C  Average wages
      WRITE (6,78)
      DO 210 I=1,20
      IF (I.GT.KA) THEN
      WRITE (6,80) 1936+I,FQ(I),1956+I,FQ(I+20)
      ELSE
      WRITE (6,80) 1936+I,FQ(I),1956+I,FQ(20),1976+I,FQ(I+40)
      END IF
  210 CONTINUE
      WRITE (6,81)
      CALL GETRET
C  Wage bases
      WRITE (6,78)
      DO 215 I=1,20
      IF (I.GT.KW) THEN
      WRITE (6,84) 1936+I,BASE(I),1956+I,BASE(I+20)
      ELSE
      WRITE (6,84) 1936+I,BASE(I),1956+I,BASE(I+20),1976+I,BASE(I+40)
      END IF
  215 CONTINUE
      WRITE (6,85)
      CALL GETRET
C  Old-law wage bases
      WRITE (6,78)
      DO 220 I=1,20
      IF (I.GT.KW) THEN
      WRITE (6,84) 1936+I,BASE77(I),1956+I,BASE77(I+20)
      ELSE
      WRITE (6,84) 1936+I,BASE77(I),1956+I,BASE77(I+20),1976+I,
     &BASE77(I+40)
      END IF
  220 CONTINUE
      WRITE (6,86)
      CALL GETRET
C  Benefit increases
      WRITE (6,78)
      DO 230 I=25,ISTART
      WRITE (6,88)1950+I,CPIINC(I)
  230 CONTINUE
      WRITE (6,89)
      CALL GETRET
      RETURN
C
C  Section to update historical data
C
C  Write warning about updating data
  235 CALL HYPHN1
      WRITE (6,50)
      CALL HYPHN2
      WRITE (6,90)1951+ISTART-1,1951+ISTART+1,1951+ISTART,1951+ISTART+1,
     &1951+ISTART,WAGMIN(ISTART+15)
      READ (5,23) ANSWER
      CALL TOUPPR(ANSWER)
      IF (ANSWER.NE.'Y'.AND.ANSWER.NE.'N') THEN
      CALL BEEP
      GO TO 235
      END IF
      IF (ANSWER.EQ.'N') RETURN
C  Update average wages
      KA=MOD(ISTART+13,20)
      KW=MOD(ISTART+15,20)
      DO 240 I=1,20
      IF (I.GT.KA) THEN
      WRITE (6,80) 1936+I,FQ(I),1956+I,FQ(I+20)
      ELSE
      WRITE (6,80) 1936+I,FQ(I),1956+I,FQ(20),1976+I,FQ(I+40)
      END IF
  240 CONTINUE
      WRITE (6,81)
      WRITE (6,91)1951+ISTART-1
      READ(5,*)FQ(ISTART+14)
C  Update wage bases
      DO 245 I=1,20
      IF (I.GT.KW) THEN
      WRITE (6,84) 1936+I,BASE(I),1956+I,BASE(I+20)
      ELSE
      WRITE (6,84) 1936+I,BASE(I),1956+I,BASE(I+20),1976+I,BASE(I+40)
      END IF
  245 CONTINUE
      WRITE (6,85)
      WRITE (6,92)1951+ISTART+1
      READ(5,*)BASE(ISTART+16)
C  Update old-law wage bases
      DO 250 I=1,20
      IF (I.GT.KW) THEN
      WRITE (6,84) 1936+I,BASE77(I),1956+I,BASE77(I+20)
      ELSE
      WRITE (6,84) 1936+I,BASE77(I),1956+I,BASE77(I+20),1976+I,
     &BASE77(I+40)
      END IF
  250 CONTINUE
      WRITE (6,86)
      WRITE (6,93)1951+ISTART+1
      READ(5,*)BASE77(ISTART+16)
C  Update benefit increases
      DO 255 I=25,ISTART
      WRITE (6,88)1950+I,CPIINC(I)
  255 CONTINUE
      WRITE (6,89)
      WRITE (6,95)1951+ISTART
      READ(5,*)CPIINC(ISTART+1)
C
C  Write updated data to file with ISTART increased by 1
C
      I = SAVHST(PROGFL)
      RETURN
      END
