// Functions for the <see cref=Pib54Ame"/> class to handle 1954 pib-ame
// conversion table.
//
// $Id: pib54ame.cpp 1.2 2011/08/08 08:45:12EDT 044579 Development  $

#include "pibtable.h"
#include "Resource.h"
#include "PiaException.h"

// <summary>The 1954 ame's.</summary>
const double Pib54Ame::ame54[] = {
  30.5, 31.0, 31.6, 32.1, 32.7, 33.2, 33.8, 34.3, 34.9, 35.4,
  36.0, 36.5, 37.1, 37.6, 38.2, 38.7, 39.3, 39.8, 40.4, 40.9,
  41.5, 42.0, 42.6, 43.1, 43.7, 44.2, 44.8, 45.3, 45.9, 46.4,
  47.0, 47.5, 48.1, 48.6, 49.2, 49.7, 50.3, 50.8, 51.4, 51.9,
  52.5, 53.0, 53.6, 54.1, 54.7, 55.2, 55.8, 56.3, 56.9, 57.4,
  58.0, 58.5, 59.1, 59.6, 60.2, 60.5, 60.7, 60.9, 61.1, 61.3,
  61.5, 61.7, 61.9, 62.1, 62.3, 62.5, 62.7, 62.9, 63.1, 63.3,
  63.5, 63.7, 63.9, 64.1, 64.3, 64.5, 64.7, 64.9, 65.1, 65.3,
  65.5, 65.7, 65.9, 66.1, 66.3, 66.5, 66.7, 66.9, 67.1, 67.3,
  67.5, 67.7, 67.9, 68.1, 68.3, 68.5, 68.7, 68.9, 69.1, 69.3,
  69.5, 69.7, 69.9, 70.1, 70.3, 70.5, 70.7, 70.9, 71.1, 71.3,
  71.5, 71.7, 71.9, 72.1, 72.3, 72.5, 72.7, 72.9, 73.1, 73.3,
  73.5, 73.7, 73.9, 74.1, 74.4, 74.6, 74.8, 75.0, 75.2, 75.4,
  75.6, 75.8, 76.0, 76.2, 76.4, 76.6, 76.8, 77.0, 77.2, 77.4,
  77.6, 77.8, 78.0, 78.2, 78.4, 78.6, 78.8, 79.0, 79.2, 79.4,
  79.6, 79.8, 80.0, 80.2, 80.4, 80.6, 80.8, 81.0, 81.2, 81.4,
  81.6, 81.8, 82.0, 82.2, 82.4, 82.6, 82.8, 83.0, 83.2, 83.4,
  83.6, 83.8, 84.0, 84.2, 84.4, 84.6, 84.8, 85.0, 85.2, 85.4,
  85.6, 85.8, 86.0, 86.2, 86.4, 86.6, 86.8, 87.0, 87.2, 87.4,
  87.6, 87.8, 88.0, 88.2, 88.4, 88.5
};

/// <summary>Returns 1954 conversion table ame.</summary>
///
/// <returns>1954 conversion table ame.</returns>
///
/// <exception cref="PiaException"><see cref="PiaException"/> of type
/// <see cref="PIA_IDS_PIB54PIA"/> if index is out of range (only in debug
/// mode).</exception>
///
/// <param name="index">Number of pia desired.</param>
double Pib54Ame::getAt( int index )
{
#ifndef NDEBUG
  if (index < 0 || index > 195)
    throw PiaException(PIA_IDS_PIB54PIA);
#endif
  return(ame54[index]);
}
