// Functions for the <see cref="Pib50Pib"/> class to handle 1950 pib-pia
// conversion table.
//
// $Id: pib50pib.cpp 1.10 2011/08/08 08:45:15EDT 044579 Development  $

#include "pibtable.h"
#include "Resource.h"
#include "PiaException.h"

// <summary>The 1950 pib's.</summary>
const double Pib50Pib::pib50[] = {
  10.00, 10.04, 10.08, 10.15, 10.20, 10.24, 10.28, 10.35, 10.40, 10.44,
  10.48, 10.55, 10.60, 10.64, 10.68, 10.75, 10.80, 10.84, 10.88, 10.95,
  11.00, 11.04, 11.08, 11.15, 11.20, 11.24, 11.28, 11.35, 11.40, 11.44,
  11.48, 11.55, 11.60, 11.64, 11.68, 11.75, 11.80, 11.84, 11.88, 11.95,
  12.00, 12.04, 12.08, 12.15, 12.20, 12.24, 12.28, 12.35, 12.40, 12.44,
  12.48, 12.55, 12.60, 12.64, 12.68, 12.75, 12.80, 12.84, 12.88, 12.95,
  13.00, 13.04, 13.08, 13.15, 13.20, 13.24, 13.28, 13.35, 13.40, 13.44,
  13.48, 13.55, 13.60, 13.64, 13.68, 13.75, 13.80, 13.84, 13.88, 13.95,
  14.00, 14.04, 14.08, 14.15, 14.20, 14.24, 14.28, 14.35, 14.40, 14.44,
  14.48, 14.55, 14.60, 14.64, 14.68, 14.75, 14.80, 14.84, 14.88, 14.95,
  15.00, 15.04, 15.12, 15.17, 15.24, 15.28, 15.36, 15.41, 15.48, 15.52,
  15.60, 15.64, 15.68, 15.76, 15.80, 15.88, 15.92, 16.00, 16.04, 16.13,
  16.20, 16.24, 16.32, 16.40, 16.44, 16.52, 16.60, 16.66, 16.72, 16.80,
  16.84, 16.93, 17.00, 17.08, 17.16, 17.23, 17.32, 17.36, 17.44, 17.54,
  17.60, 17.68, 17.76, 17.84, 17.92, 18.00, 18.08, 18.17, 18.24, 18.32,
  18.40, 18.50, 18.56, 18.68, 18.76, 18.83, 18.92, 19.00, 19.08, 19.15,
  19.24, 19.32, 19.36, 19.46, 19.52, 19.60, 19.68, 19.77, 19.84, 19.92,
  20.00, 20.06, 20.12, 20.20, 20.24, 20.33, 20.40, 20.44, 20.52, 20.60,
  20.64, 20.72, 20.80, 20.86, 20.92, 21.00, 21.04, 21.12, 21.16, 21.24,
  21.28, 21.35, 21.40, 21.48, 21.52, 21.59, 21.64, 21.68, 21.76, 21.82,
  21.88, 21.92, 22.00, 22.05, 22.08, 22.16, 22.20, 22.25, 22.28, 22.36,
  22.40, 22.45, 22.48, 22.56, 22.60, 22.65, 22.68, 22.76, 22.80, 22.85,
  22.88, 22.96, 23.00, 23.04, 23.08, 23.12, 23.16, 23.21, 23.24, 23.28,
  23.32, 23.39, 23.44, 23.48, 23.52, 23.56, 23.60, 23.64, 23.68, 23.74,
  23.76, 23.80, 23.88, 23.91, 23.96, 24.00, 24.04, 24.10, 24.16, 24.20,
  24.24, 24.30, 24.36, 24.40, 24.44, 24.50, 24.56, 24.60, 24.64, 24.70,
  24.76, 24.80, 24.84, 24.90, 24.96, 25.00, 25.04, 25.11, 25.16, 25.20,
  25.28, 25.33, 25.40, 25.44, 25.48, 25.55, 25.60, 25.64, 25.72, 25.78,
  25.84, 25.88, 25.92, 26.00, 26.04, 26.12, 26.16, 26.23, 26.28, 26.36,
  26.40, 26.47, 26.52, 26.60, 26.64, 26.70, 26.76, 26.80, 26.88, 26.94,
  27.00, 27.04, 27.12, 27.20, 27.24, 27.32, 27.40, 27.46, 27.52, 27.60,
  27.64, 27.73, 27.80, 27.84, 27.92, 28.00, 28.08, 28.16, 28.24, 28.31,
  28.36, 28.44, 28.52, 28.61, 28.68, 28.76, 28.84, 28.92, 29.00, 29.08,
  29.16, 29.25, 29.32, 29.40, 29.48, 29.58, 29.68, 29.76, 29.84, 29.92,
  30.00, 30.08, 30.16, 30.27, 30.36, 30.44, 30.52, 30.64, 30.72, 30.80,
  30.92, 31.00, 31.08, 31.16, 31.28, 31.36, 31.44, 31.52, 31.64, 31.73,
  31.80, 31.92, 32.00, 32.10, 32.20, 32.28, 32.40, 32.50, 32.60, 32.68,
  32.80, 32.90, 33.00, 33.08, 33.20, 33.30, 33.40, 33.48, 33.60, 33.70,
  33.80, 33.88, 34.00, 34.10, 34.20, 34.28, 34.40, 34.50, 34.60, 34.68,
  34.80, 34.90, 35.00, 35.08, 35.20, 35.30, 35.40, 35.48, 35.60, 35.70,
  35.80, 35.88, 36.00, 36.10, 36.20, 36.28, 36.40, 36.50, 36.60, 36.68,
  36.80, 36.90, 37.00, 37.08, 37.20, 37.30, 37.40, 37.48, 37.60, 37.70,
  37.80, 37.88, 38.00, 38.11, 38.20, 38.32, 38.44, 38.56, 38.68, 38.76,
  38.88, 39.00, 39.12, 39.20, 39.32, 39.44, 39.56, 39.68, 39.76, 39.89,
  40.00, 40.12, 40.20, 40.33, 40.44, 40.56, 40.68, 40.78, 40.88, 41.00,
  41.12, 41.22, 41.32, 41.44, 41.56, 41.67, 41.76, 41.88, 42.00, 42.11,
  42.20, 42.32, 42.44, 42.56, 42.68, 42.76, 42.88, 43.00, 43.12, 43.20,
  43.32, 43.44, 43.56, 43.68, 43.76, 43.89, 44.00, 44.12, 44.20, 44.33,
  44.44, 44.56, 44.68, 44.78, 44.88, 45.60
};

/// <summary>Returns 1950 conversion table pib.</summary>
///
/// <returns>1950 conversion table pib.</returns>
///
/// <exception cref="PiaException"><see cref="PiaException"/> of type
/// <see cref="PIA_IDS_PIB50PIB"/> if index is out of
/// range (only in debug mode).</exception>
///
/// <param name="index">Number of pib desired.</param>
double Pib50Pib::getAt( int index )
{
#ifndef NDEBUG
  if (index < 0 || index > 485)
    throw PiaException(PIA_IDS_PIB50PIB);
#endif
  return(pib50[index]);
}
