// Functions for the <see cref=Pib54Mfb"/> class to handle 1954 pib-mfb
// conversion table.
//
// $Id: pib54mfb.cpp 1.10 2011/08/08 08:45:14EDT 044579 Development  $

#include "pibtable.h"
#include "Resource.h"
#include "PiaException.h"

// <summary>The 1954 mfb's.</summary>
const double Pib54Mfb::mfb54[] = {
  50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00,
  50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00,
  50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00, 50.00,
  50.00, 50.00, 50.00, 50.00, 50.10, 50.25, 50.40, 50.55, 50.70, 50.85,
  51.00, 51.15, 51.30, 51.45, 51.60, 51.75, 51.90, 52.05, 52.20, 52.35,
  52.50, 52.65, 52.80, 52.95, 53.10, 53.25, 53.40, 53.55, 53.70, 53.85,
  54.00, 54.15, 54.30, 54.45, 54.60, 54.75, 54.90, 55.05, 55.20, 55.35,
  55.50, 55.65, 55.80, 55.95, 56.10, 56.25, 56.40, 56.55, 56.70, 56.85,
  57.00, 57.15, 57.30, 57.45, 57.60, 57.75, 57.90, 58.05, 58.20, 58.35,
  58.50, 58.65, 58.80, 58.95, 59.10, 59.25, 59.40, 59.55, 59.70, 59.85,
  60.00, 60.15, 60.30, 60.45, 60.60, 60.75, 60.90, 61.05, 61.20, 61.35,
  61.50, 61.65, 61.80, 61.95, 62.10, 62.25, 62.40, 62.55, 62.70, 62.85,
  63.00, 63.15, 63.30, 63.45, 63.60, 63.75, 63.90, 64.05, 64.20, 64.35,
  64.50, 64.65, 64.80, 64.95, 65.10, 65.25, 65.40, 65.55, 65.70, 65.85,
  66.00, 66.15, 66.30, 66.45, 66.60, 66.75, 66.90, 67.05, 67.20, 67.35,
  67.50, 67.65, 67.80, 67.95, 68.10, 68.25, 68.40, 68.55, 68.70, 68.85,
  69.00, 69.15, 69.30, 69.45, 69.60, 69.75, 69.90, 70.05, 70.20, 70.35,
  70.50, 70.65, 70.80, 70.95, 71.10, 71.25, 71.40, 71.55, 71.70, 71.85,
  72.00, 72.15, 72.30, 72.45, 72.60, 72.75, 72.90, 73.05, 73.20, 73.35,
  73.50, 73.65, 73.80, 73.95, 74.10, 74.25, 74.40, 74.55, 74.70, 74.85,
  75.00, 75.30, 75.45, 75.60, 75.75, 75.90, 76.05, 76.20, 76.35, 76.65,
  76.80, 76.95, 77.10, 77.25, 77.40, 77.55, 77.70, 78.00, 78.15, 78.30,
  78.45, 78.60, 78.75, 78.90, 79.05, 79.35, 79.50, 79.65, 79.80, 79.95,
  80.10, 80.25, 80.40, 80.70, 80.85, 81.00, 81.15, 81.30, 81.45, 81.60,
  81.75, 82.05, 82.20, 82.35, 82.50, 82.65, 82.80, 82.95, 83.10, 83.40,
  83.55, 83.70, 83.85, 84.00, 84.15, 84.30, 84.45, 84.75, 84.90, 85.05,
  85.20, 85.35, 85.50, 85.65, 85.80, 86.10, 86.25, 86.40, 86.55, 86.70,
  86.85, 87.00, 87.15, 87.45, 87.60, 87.75, 87.90, 88.05, 88.20, 88.35,
  88.50, 88.80, 88.95, 89.10, 89.25, 89.40, 89.55, 89.70, 89.85, 90.15,
  90.30, 90.45, 90.60, 90.75, 90.90, 91.05, 91.20, 91.50, 91.65, 91.80,
  91.95, 92.10, 92.25, 92.80, 92.80, 93.60, 94.40, 94.40, 95.20, 95.20,
  96.00, 96.00, 96.80, 97.60, 97.60, 98.40, 98.40, 99.20, 99.20, 100.00,
  100.00, 100.80, 101.60, 101.60, 102.40, 102.40, 103.20, 103.20,
  104.00, 104.80, 104.80, 105.60, 106.40, 106.40, 107.20, 108.00,
  108.00, 109.60, 109.60, 110.40, 111.20, 111.20, 112.00, 112.80,
  112.80, 114.40, 114.40, 115.20, 116.00, 116.00, 116.80, 117.60,
  117.60, 119.20, 119.20, 120.00, 120.80, 120.80, 121.60, 122.40,
  122.40, 124.00, 124.00, 124.80, 125.60, 125.60, 126.40, 127.20,
  127.20, 128.80, 128.80, 129.60, 130.40, 130.40, 131.20, 132.00,
  132.00, 133.60, 133.60, 134.40, 135.20, 135.20, 136.00, 136.80,
  136.80, 138.40, 138.40, 139.20, 140.00, 140.00, 140.80, 141.60,
  141.60, 143.20, 143.20, 144.00, 144.80, 144.80, 145.60, 146.40,
  146.40, 148.00, 148.00, 148.80, 149.60, 149.60, 150.40, 151.20,
  151.20, 152.80, 152.80, 153.60, 154.40, 154.40, 155.20, 156.00,
  156.00, 157.60, 157.60, 158.40, 159.20, 159.20, 160.00, 160.80,
  160.80, 162.40, 162.40, 163.20, 164.00, 164.00, 164.80, 165.60,
  165.60, 167.20, 167.20, 168.00, 168.80, 168.80, 169.60, 170.40,
  170.40, 172.00, 172.00, 172.80, 173.60, 173.60, 174.40, 175.20,
  175.20, 176.80, 176.80, 177.60, 178.40, 178.40, 179.20, 180.00,
  180.00, 181.60, 181.60, 182.40, 183.20, 183.20, 184.00, 184.80,
  184.80, 186.40, 186.40, 187.20, 188.00, 188.00, 188.80, 189.60,
  189.60, 191.20, 191.20, 192.00, 192.80, 192.80, 193.60, 194.40,
  194.40, 196.00, 196.00, 196.80, 197.60, 200.00
};

/// <summary>Returns 1954 conversion table mfb.</summary>
///
/// <returns>1954 conversion table mfb.</returns>
///
/// <exception cref="PiaException"><see cref="PiaException"/> of type
/// <see cref="PIA_IDS_PIB54MFB"/> if index is out
/// of range (only in debug mode).</exception>
///
/// <param name="index">Number of mfb desired.</param>
double Pib54Mfb::getAt( int index )
{
#ifndef NDEBUG
  if (index < 0 || index > 485)
    throw PiaException(PIA_IDS_PIB54MFB);
#endif
  return(mfb54[index]);
}
