// Declarations for the <see cref="BitAnnual"/> class to manage an array of
// annual bits for Windows.
//
// $Id: BitAnnualBase.h 1.8 8/26/2025 11:10:49 Olson,DavidJ. $

#pragma once

#include <bitset>

/// <summary>Size to use for bit array in <see cref="BitAnnual"/> (from 1937 to
/// 2200).</summary>
const int MAX_BITSET_SIZE = 264;

/// <summary>Bit array used in <see cref="BitAnnual"/> (a std::bitset).
/// </summary>
typedef std::bitset< MAX_BITSET_SIZE > BitAnnualData;
