C  @(#)coment.f	1.7   12/20/95
C
C  This subroutine writes out comments for law changes for the PIA
C  programs.
C
C  Definition of variables (* is a dimensioned array, with indices
C    I, J, K, ... )
C
C  I      = temporary index used in do-loops.
C  I1     = temporary index used in various places.
C  I2     = temporary index used in various places.
C  I3     = temporary index used in various places.
C  IOUT   = output file number.
C
      SUBROUTINE COMENT (IOUT)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INTEGER IOUT,I,I1,I2,I3,I4,I5
    1 FORMAT ('      ',A65)
    2 FORMAT ('      Changes from present law:')
    3 FORMAT ('      Phased in ',I4,'-',I4)
    4 FORMAT ('      Effective for entitlement in ',I4,' or later,'/
     &6X,'and eligibility in ',I4,' or later')
    5 FORMAT ('      Percent of wage base:',F5.2,' effective',I5)
    6 FORMAT ('      New Special Minimum dollar amount (Jan 1979 ',
     &'rate):',F8.2,' effective',I5)
    7 FORMAT ('      Maximum number of years:',I5,' effective',I5)
    8 FORMAT ('      No increase in retirement age to 67 effective',I5)
    9 FORMAT ('      Alternate benefit formulas:')
   10 FORMAT ('      ',I3,'% of first $',I4,' of AIME +',
     &I3, '% of AIME up to $',I4/
     &'        +',I3,'% of remainder for those eligible in',I5)
   11 FORMAT ('      ',I3,'% of first $',I4,' of AIME +',
     &I3, '% of AIME up to $',I4/
     &'        +',I3, '% of AIME up to $',I4,' +',
     &I3,'% of remainder for those eligible in',I5)
C
C  Output section
C
      WRITE (IOUT,2)
      DO 300 I=1,MAXJND
      IF (JIND(I).GT.0) THEN
      WRITE (IOUT,1) TIND(I)
      IF (I.EQ.2) WRITE (IOUT,20) PBP,JSTART(1,2),JSTART(2,2)
   20 FORMAT ('      Bend points are',F5.2,' wage-indexed from',I5,
     &' to',I5)
      IF (I.EQ.3) WRITE (IOUT,30) JSTART(1,3),JSTART(2,3)
   30 FORMAT ('      Bend points are CPI-indexed from',I5,' to',I5)
      IF (I.EQ.4) WRITE (IOUT,40) JSTART(1,4),JSTART(2,4)
   40 FORMAT ('      Earnings are CPI-indexed from',I5,' to',I5)
      IF (I.EQ.5) THEN
        WRITE (IOUT,9)
        DO 45 I5 = JSTART(1,5),JSTART(2,5)
        I1 = INT(100.*PERCPA(1,I5-1936)+.5)
        I2 = INT(100.*PERCPA(2,I5-1936)+.5)
        I3 = INT(100.*PERCPA(3,I5-1936)+.5)
        I4 = INT(100.*PERCPA(4,I5-1936)+.5)
        IF (NUMBP.EQ.2) WRITE (IOUT,10) I1,IBENPA(2,I5-1936),I2,
     &  IBENPA(3,I5-1936),I3,I5
        IF (NUMBP.EQ.3) WRITE (IOUT,11) I1,IBENPA(2,I5-1936),I2,
     &  IBENPA(3,I5-1936),I3,IBENPA(4,I5-1936),I4,I5
   45   CONTINUE
      END IF
      IF (I.EQ.6) THEN
      I1 = JSTART(1,6)
      I2 = JSTART(2,6)
      WRITE (IOUT,60) JSTART(1,6),JSTART(2,6)
   60 FORMAT ('      Bend points are indexed from',I5,' to',I5,' by:')
      WRITE (IOUT,70) (BPINC(I3),I3=I1,I2)
   70 FORMAT ('      ',10F8.2)
      END IF
      IF (I.EQ.7) WRITE (IOUT,80) CP,JSTART(1,7),JSTART(2,7)
   80 FORMAT ('      ',F5.2,
     &' percent subtracted from wage increase factor',
     &' for increase in bend points from',I5,' to',I5)
      IF (I.EQ.8) WRITE (IOUT,3) JSTART(1,8),JSTART(1,8)+2
      IF (I.EQ.9) WRITE (IOUT,100) CP,JSTART(1,9),JSTART(2,9)
  100 FORMAT ('      Benefit formula percentages decrease by',F5.2,
     &' percent relatively from',I5,' to',I5)
      IF (I.EQ.10) WRITE (IOUT,140) JSTART(1,10)
  140 FORMAT ('      No benefit increase in year of eligibility ',
     &'beginning',I5)
      IF (I.EQ.11) WRITE (IOUT,197) JSTART(1,11)
  197 FORMAT('      No Re-indexed widow effective',I5)
      IF (I.EQ.12) WRITE (IOUT,1) TINDWE(JIND(12))
      IF (I.EQ.13) THEN
        WRITE (IOUT,1) TINDSM(JIND(13))
        IF (MOD(JIND(13),2).EQ.1) WRITE (IOUT,6) ASPMIN,JSTART(1,13)
        IF (MOD(JIND(13),4).EQ.2.OR.MOD(JIND(13),4).EQ.3)
     &  WRITE (IOUT,7) JSPMIN,JSTART(1,13)
        IF (JIND(13).GT.3) WRITE (IOUT,5) BSPMIN,JSTART(1,13)
      END IF
      IF (I.EQ.14) WRITE (IOUT,200) JSTART(1,14)
  200 FORMAT ('      No Old-Start PIA effective',I5)
      IF (I.EQ.15) WRITE (IOUT,4) JSTART(1,15),JSTART(1,15)-2
      IF (I.GE.16.AND.I.LE.18) WRITE (IOUT,1) TINDTG(JIND(I))
      IF(I.EQ.23)WRITE(IOUT,205)JSTART(1,23)
  205 FORMAT('      No PIA Table Method effective',I5)
      IF(I.EQ.24)WRITE(IOUT,210)JSTART(1,24)
  210 FORMAT('      No Transitional Guarantee Method effective',I5)
      IF (I.EQ.27) WRITE (IOUT,8) JSTART(1,27)
      END IF
  300 CONTINUE
      RETURN
      END
