C  @(#)oldstart.f	1.1  2/24/97
C
C  Subroutine to calculate Old-Start PIA
C
C *IAME58 = new-start AME's in 1958 PIB-PIA Conversion Table.
C  IDIVOS = divisor for Old-Start pre-1951 earnings.
C  IERN49 = starting point for 3-year special earnings limit
C  IREGOS  = integer test quantity.
C *MFB50  = MFB in 1950 PIB-PIA Conversion Table.
C *MFB52  = MFB in 1952 PIB-PIA Conversion Table.
C *MFB54  = MFB in 1954 PIB-PIA Conversion Table.
C *PIA54  = PIA in 1954 PIB-PIA Conversion Table, starting with
C             interval 330.
C *PIB50  = intervals of PIB in 1950 PIB-PIA Conversion Table.
C *PIB58  = intervals of PIB in 1958 PIB-PIA Conversion Table.
C *TEST   = test quantity.
C
      SUBROUTINE OLDSTR(REGOS)
      INTEGER IAME58(51), IERN49, I, I1, I2,
     &IREGOS, AMND52(2), AMND54(2), AMND74(2)
      REAL MFB50(486), MFB52(486), MFB54(486),
     &PIA54(157), PIB50(486), PIB58(51)
      DOUBLE PRECISION REGOS(5)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      DOUBLE PRECISION ROUND
      INTEGER MOSCAL, I49C1, WEPAPP, CPIBAS, OLDPIA, COMPMY, INCRMT
      REAL Z4SET
      LOGICAL ISFRZY
      DATA AMND52 / 9,1952 /
      DATA AMND54 / 9,1954 /
      DATA AMND74 / 6,1974 /
C                                                                      
C  Data initialization of Old-Start quantities
C
C  1950 PIB-PIA Conversion Table PIB'S:
      DATA (PIB50(I),I=1,140) / 10.00,10.04,10.08,10.15,10.20,10.24,
     &10.28,10.35,10.40,10.44,10.48,10.55,10.60,10.64,10.68,10.75,10.80,
     &10.84,10.88,10.95,11.00,11.04,11.08,11.15,11.20,11.24,11.28,11.35,
     &11.40,11.44,11.48,11.55,11.60,11.64,11.68,11.75,11.80,11.84,11.88,
     &11.95,12.00,12.04,12.08,12.15,12.20,12.24,12.28,12.35,12.40,12.44,
     &12.48,12.55,12.60,12.64,12.68,12.75,12.80,12.84,12.88,12.95,13.00,
     &13.04,13.08,13.15,13.20,13.24,13.28,13.35,13.40,13.44,13.48,13.55,
     &13.60,13.64,13.68,13.75,13.80,13.84,13.88,13.95,14.00,14.04,14.08,
     &14.15,14.20,14.24,14.28,14.35,14.40,14.44,14.48,14.55,14.60,14.64,
     &14.68,14.75,14.80,14.84,14.88,14.95,15.00,15.04,15.12,15.17,15.24,
     &15.28,15.36,15.41,15.48,15.52,15.60,15.64,15.68,15.76,15.80,15.88,
     &15.92,16.00,16.04,16.13,16.20,16.24,16.32,16.40,16.44,16.52,16.60,
     &16.66,16.72,16.80,16.84,16.93,17.00,17.08,17.16,17.23,17.32,17.36,
     &17.44,17.54 /
      DATA (PIB50(I),I=141,280) / 17.60,17.68,17.76,17.84,17.92,18.00,
     &18.08,18.17,18.24,18.32,18.40,18.50,18.56,18.68,18.76,18.83,18.92,
     &19.00,19.08,19.15,19.24,19.32,19.36,19.46,19.52,19.60,19.68,19.77,
     &19.84,19.92,20.00,20.06,20.12,20.20,20.24,20.33,20.40,20.44,20.52,
     &20.60,20.64,20.72,20.80,20.86,20.92,21.00,21.04,21.12,21.16,21.24,
     &21.28,21.35,21.40,21.48,21.52,21.59,21.64,21.68,21.76,21.82,21.88,
     &21.92,22.00,22.05,22.08,22.16,22.20,22.25,22.28,22.36,22.40,22.45,
     &22.48,22.56,22.60,22.65,22.68,22.76,22.80,22.85,22.88,22.96,23.00,
     &23.04,23.08,23.12,23.16,23.21,23.24,23.28,23.32,23.39,23.44,23.48,
     &23.52,23.56,23.60,23.64,23.68,23.74,23.76,23.80,23.88,23.91,23.96,
     &24.00,24.04,24.10,24.16,24.20,24.24,24.30,24.36,24.40,24.44,24.50,
     &24.56,24.60,24.64,24.70,24.76,24.80,24.84,24.90,24.96,25.00,25.04,
     &25.11,25.16,25.20,25.28,25.33,25.40,25.44,25.48,25.55,25.60,25.64,
     &25.72,25.78 /
      DATA (PIB50(I),I=281,420) / 25.84,25.88,25.92,26.00,26.04,26.12,
     &26.16,26.23,26.28,26.36,26.40,26.47,26.52,26.60,26.64,26.70,26.76,
     &26.80,26.88,26.94,27.00,27.04,27.12,27.20,27.24,27.32,27.40,27.46,
     &27.52,27.60,27.64,27.73,27.80,27.84,27.92,28.00,28.08,28.16,28.24,
     &28.31,28.36,28.44,28.52,28.61,28.68,28.76,28.84,28.92,29.00,29.08,
     &29.16,29.25,29.32,29.40,29.48,29.58,29.68,29.76,29.84,29.92,30.00,
     &30.08,30.16,30.27,30.36,30.44,30.52,30.64,30.72,30.80,30.92,31.00,
     &31.08,31.16,31.28,31.36,31.44,31.52,31.64,31.73,31.80,31.92,32.00,
     &32.10,32.20,32.28,32.40,32.50,32.60,32.68,32.80,32.90,33.00,33.08,
     &33.20,33.30,33.40,33.48,33.60,33.70,33.80,33.88,34.00,34.10,34.20,
     &34.28,34.40,34.50,34.60,34.68,34.80,34.90,35.00,35.08,35.20,35.30,
     &35.40,35.48,35.60,35.70,35.80,35.88,36.00,36.10,36.20,36.28,36.40,
     &36.50,36.60,36.68,36.80,36.90,37.00,37.08,37.20,37.30,37.40,37.48,
     &37.60,37.70 /
      DATA (PIB50(I),I=421,486) / 37.80,37.88,38.00,38.11,38.20,38.32,
     &38.44,38.56,38.68,38.76,38.88,39.00,39.12,39.20,39.32,39.44,39.56,
     &39.68,39.76,39.89,40.00,40.12,40.20,40.33,40.44,40.56,40.68,40.78,
     &40.88,41.00,41.12,41.22,41.32,41.44,41.56,41.67,41.76,41.88,42.00,
     &42.11,42.20,42.32,42.44,42.56,42.68,42.76,42.88,43.00,43.12,43.20,
     &43.32,43.44,43.56,43.68,43.76,43.89,44.00,44.12,44.20,44.33,44.44,
     &44.56,44.68,44.78,44.88,45.60 /
C  1950 PIB-PIA Conversion Table MFB'S:
      DATA (MFB50(I),I=1,175) / 51*40.00,40.16,40.32,40.48,40.64,40.80,
     &40.96,41.12,41.28,41.44,41.60,41.76,41.92,42.08,42.24,42.40,42.56,
     &42.72,42.88,43.04,43.20,43.36,43.52,43.68,43.84,44.00,44.16,44.32,
     &44.48,44.64,44.80,44.96,45.12,45.28,45.44,45.60,45.76,45.92,46.08,
     &46.24,46.40,46.56,46.72,46.88,47.04,47.20,47.36,47.52,47.68,47.84,
     &48.00,48.16,48.32,48.48,48.64,48.80,48.96,49.12,49.28,49.44,49.60,
     &49.76,49.92,50.08,50.24,50.40,50.56,50.72,50.88,51.04,51.20,51.36,
     &51.52,51.68,51.84,52.00,52.16,52.32,52.48,52.64,52.80,52.96,53.12,
     &53.28,53.44,53.60,53.76,53.92,54.08,54.24,54.40,54.56,54.72,54.88,
     &55.04,55.20,55.36,55.52,55.68,55.84,56.00,56.16,56.32,56.48,56.64,
     &56.80,56.96,57.12,57.28,57.44,57.60,57.76,57.92,58.08,58.24,58.40,
     &58.56,58.72,58.88,59.04,59.20,59.36,59.52,59.68,59.84 /
      DATA (MFB50(I),I=176,315) / 60.00,60.16,60.32,60.48,60.64,60.80,
     &60.96,61.12,61.28,61.44,61.60,61.76,61.92,62.08,62.24,62.40,62.56,
     &62.72,62.88,63.04,63.20,63.36,63.52,63.68,63.84,64.00,64.16,64.32,
     &64.48,64.64,64.80,64.96,65.12,65.28,65.44,65.60,65.76,65.92,66.08,
     &66.24,66.40,66.56,66.72,66.88,67.04,67.20,67.36,67.52,67.68,67.84,
     &68.00,68.16,68.32,68.48,68.64,68.80,68.96,69.12,69.28,69.44,69.60,
     &69.76,69.92,70.08,70.24,70.40,70.56,70.72,70.88,71.04,71.20,71.36,
     &71.52,71.68,71.84,72.00,72.16,72.32,72.48,72.64,72.80,72.96,73.12,
     &73.28,73.44,73.60,73.76,73.92,74.08,74.24,74.40,74.56,74.72,74.88,
     &75.04,75.20,75.36,75.52,75.68,75.84,76.00,76.16,76.32,76.48,76.64,
     &76.80,76.96,77.12,77.28,77.44,77.60,77.76,77.92,78.08,78.24,78.40,
     &78.56,78.72,78.88,79.04,79.20,79.36,79.52,79.68,79.84,80.00,80.54,
     &81.06,81.60,82.14,82.66,83.20,83.74,84.26,84.80,85.34,85.86,86.40,
     &86.94,87.46 /
      DATA (MFB50(I),I=316,486) / 88.00,88.53,89.06,89.58,90.12,90.65,
     &91.18,91.70,92.23,92.76,93.30,93.82,94.35,94.88,95.42,95.94,96.48,
     &97.02,97.54,98.08,98.62,99.14,99.68,100.22,100.74,101.28,101.82,
     &102.36,102.90,103.43,103.97,104.51,105.05,105.58,106.12,106.66,
     &107.20,107.73,108.26,108.79,109.32,109.86,110.38,110.92,111.45,
     &111.98,112.51,113.04,113.58,114.11,114.65,115.18,115.72,116.26,
     &116.79,117.33,117.86,118.40,118.93,119.46,119.98,120.51,121.04,
     &121.57,122.10,122.62,123.15,123.68,124.22,124.75,125.29,125.82,
     &126.36,126.90,127.43,127.97,128.50,129.04,129.58,130.11,130.65,
     &131.18,131.72,132.26,132.79,133.33,133.86,134.40,134.93,135.46,
     &135.98,136.51,137.04,137.57,138.10,138.62,139.15,139.68,140.22,
     &140.75,141.29,141.82,142.36,142.90,143.43,143.97,144.50,145.04,
     &145.58,146.10,146.64,147.18,147.70,148.24,148.78,149.30,149.84,
     &54*150.00 /
C  1952 PIB-PIA Conversion Table MFB'S:
      DATA MFB52 / 61*45.00,6*45.60,5*46.40,6*47.20,
     &5*48.00,6*48.80,5*49.60,6*50.40,5*51.20,6*52.00,5*52.80,6*53.60,
     &5*54.40,6*55.20,5*56.00,6*56.80,5*57.60,6*58.40,5*59.20,6*60.00,
     &5*60.80,6*61.60,5*62.40,6*63.20,5*64.00,6*64.80,4*65.60,6*66.40,
     &4*67.20,5*68.00,5*68.80,5*69.60,5*70.40,5*71.20,4*72.00,6*72.80,
     &4*73.60,5*74.40,5*75.20,5*76.00,5*76.80,5*77.60,4*78.40,6*79.20,
     &2*80.00,2*80.80,81.60,2*82.40,83.20,2*84.00,2*85.60,86.40,
     &2*87.20,88.00,2*88.80,2*90.40,91.20,2*92.00,92.80,2*93.60,
     &2*95.20,96.00,2*96.80,97.60,2*98.40,2*100.00,100.80,2*101.60,
     &102.40,2*103.20,2*104.80,105.60,2*106.40,107.20,2*108.00,
     &2*109.60,110.40,2*111.20,112.00,2*112.80,2*114.40,115.20,
     &2*116.00,116.80,2*117.60,2*119.20,120.00,2*120.80,121.60,
     &2*122.40,2*124.00,124.80,2*125.60,126.40,2*127.20,2*128.80,
     &129.60,2*130.40,131.20,2*132.00,2*133.60,134.40,2*135.20,
     &136.00,2*136.80,2*138.40,139.20,2*140.00,140.80,2*141.60,
     &2*143.20,144.00,2*144.80,145.60,2*146.40,2*148.00,148.80,
     &2*149.60,150.40,2*151.20,2*152.80,153.60,2*154.40,155.20,
     &2*156.00,2*157.60,158.40,2*159.20,160.00,2*160.80,2*162.40,
     &163.20,2*164.00,164.80,2*165.60,2*167.20,168.00,50*168.75 /
C  1954 PIB-PIA Conversion Table PIA'S:
      DATA PIA54 / 2*64.70,64.90,2*65.10,65.30,2*65.50,2*65.90,
     &66.10,2*66.30,66.50,2*66.70,2*67.10,67.30,2*67.50,67.70,2*67.90,
     &2*68.30,68.50,2*68.70,68.90,2*69.10,2*69.50,69.70,2*69.90,
     &70.10,2*70.30,2*70.70,70.90,2*71.10,71.30,2*71.50,2*71.90,
     &72.10,2*72.30,72.50,2*72.70,2*73.10,73.30,2*73.50,73.70,2*73.90,
     &2*74.30,74.50,2*74.70,74.90,2*75.10,2*75.50,75.70,2*75.90,
     &76.10,2*76.30,2*76.70,76.90,2*77.10,77.30,2*77.50,2*77.90,
     &78.10,2*78.30,78.50,2*78.70,2*79.10,79.30,2*79.50,79.70,2*79.90,
     &2*80.30,80.50,2*80.70,80.90,2*81.10,2*81.50,81.70,2*81.90,
     &82.10,2*82.30,2*82.70,82.90,2*83.10,83.30,2*83.50,2*83.90,
     &84.10,2*84.30,84.50,2*84.70,2*85.10,85.30,2*85.50,85.70,2*85.90,
     &2*86.30,86.50,2*86.70,86.90,2*87.10,2*87.50,87.70,87.90,88.50 /
C  1954 PIB-PIA Conversion Table MFB'S:
      DATA (MFB54(I),I=1,175) / 34*50.00,50.10,50.25,50.40,50.55,
     &50.70,50.85,51.00,51.15,51.30,51.45,51.60,51.75,51.90,52.05,52.20,
     &52.35,52.50,52.65,52.80,52.95,53.10,53.25,53.40,53.55,53.70,53.85,
     &54.00,54.15,54.30,54.45,54.60,54.75,54.90,55.05,55.20,55.35,55.50,
     &55.65,55.80,55.95,56.10,56.25,56.40,56.55,56.70,56.85,57.00,57.15,
     &57.30,57.45,57.60,57.75,57.90,58.05,58.20,58.35,58.50,58.65,58.80,
     &58.95,59.10,59.25,59.40,59.55,59.70,59.85,60.00,60.15,60.30,60.45,
     &60.60,60.75,60.90,61.05,61.20,61.35,61.50,61.65,61.80,61.95,62.10,
     &62.25,62.40,62.55,62.70,62.85,63.00,63.15,63.30,63.45,63.60,63.75,
     &63.90,64.05,64.20,64.35,64.50,64.65,64.80,64.95,65.10,65.25,65.40,
     &65.55,65.70,65.85,66.00,66.15,66.30,66.45,66.60,66.75,66.90,67.05,
     &67.20,67.35,67.50,67.65,67.80,67.95,68.10,68.25,68.40,68.55,68.70,
     &68.85,69.00,69.15,69.30,69.45,69.60,69.75,69.90,70.05,70.20,70.35,
     &70.50,70.65,70.80,70.95,71.10 /
      DATA (MFB54(I),I=176,310) / 71.25,71.40,71.55,71.70,71.85,72.00,
     &72.15,72.30,72.45,72.60,72.75,72.90,73.05,73.20,73.35,73.50,73.65,
     &73.80,73.95,74.10,74.25,74.40,74.55,74.70,74.85,75.00,75.30,75.45,
     &75.60,75.75,75.90,76.05,76.20,76.35,76.65,76.80,76.95,77.10,77.25,
     &77.40,77.55,77.70,78.00,78.15,78.30,78.45,78.60,78.75,78.90,79.05,
     &79.35,79.50,79.65,79.80,79.95,80.10,80.25,80.40,80.70,80.85,81.00,
     &81.15,81.30,81.45,81.60,81.75,82.05,82.20,82.35,82.50,82.65,82.80,
     &82.95,83.10,83.40,83.55,83.70,83.85,84.00,84.15,84.30,84.45,84.75,
     &84.90,85.05,85.20,85.35,85.50,85.65,85.80,86.10,86.25,86.40,86.55,
     &86.70,86.85,87.00,87.15,87.45,87.60,87.75,87.90,88.05,88.20,88.35,
     &88.50,88.80,88.95,89.10,89.25,89.40,89.55,89.70,89.85,90.15,90.30,
     &90.45,90.60,90.75,90.90,91.05,91.20,91.50,91.65,91.80,91.95,92.10,
     &92.25,2*92.80,93.60,2*94.40,2*95.20 /
      DATA (MFB54(I),I=311,486) / 2*96.00,96.80,2*97.60,2*98.40,2*99.20,
     &2*100.00,100.80,2*101.60,2*102.40,2*103.20,104.00,2*104.80,
     &105.60,2*106.40,107.20,2*108.00,2*109.60,110.40,2*111.20,112.00,
     &2*112.80,2*114.40,115.20,2*116.00,116.80,2*117.60,2*119.20,
     &120.00,2*120.80,121.60,2*122.40,2*124.00,124.80,2*125.60,126.40,
     &2*127.20,2*128.80,129.60,2*130.40,131.20,2*132.00,2*133.60,
     &134.40,2*135.20,136.00,2*136.80,2*138.40,139.20,2*140.00,140.80,
     &2*141.60,2*143.20,144.00,2*144.80,145.60,2*146.40,2*148.00,
     &148.80,2*149.60,150.40,2*151.20,2*152.80,153.60,2*154.40,155.20,
     &2*156.00,2*157.60,158.40,2*159.20,160.00,2*160.80,2*162.40,
     &163.20,2*164.00,164.80,2*165.60,2*167.20,168.00,2*168.80,169.60,
     &2*170.40,2*172.00,172.80,2*173.60,174.40,2*175.20,2*176.80,
     &177.60,2*178.40,179.20,2*180.00,2*181.60,182.40,2*183.20,184.00,
     &2*184.80,2*186.40,187.20,2*188.00,188.80,2*189.60,2*191.20,
     &192.00,2*192.80,193.60,2*194.40,2*196.00,196.80,197.60,200.00 /
C  1958 PIB-PIA Conversion Table AME'S:
      DATA IAME58 / 76,78,80,81,83,85,87,89,90,92,94,96,97,99,101,102,
     &104,106,107,109,113,118,122,127,132,136,141,146,150,155,160,164,
     &169,174,178,183,188,193,197,202,207,211,216,221,225,230,235,239,
     &244,249,250 /
C  1958 PIB-PIA Conversion Table PIB'S:
      DATA PIB58 /16.20,16.84,17.60,18.40,19.24,20.00,20.64,21.28,21.88,
     &22.28,22.68,23.08,23.44,23.76,24.20,24.60,25.00,25.48,25.92,26.40,
     &26.94,27.46,28.00,28.68,29.25,29.68,30.36,30.92,31.36,32.00,32.60,
     &33.20,33.88,34.50,35.00,35.80,36.40,37.08,37.60,38.20,39.12,39.68,
     &40.33,41.12,41.76,42.44,43.20,43.76,44.44,44.88,45.60/
    2 FORMAT ('   Working on old-start PIA')
C  Skip over this section if not applicable
      IF (JIND(14).GT.0.AND.IENT(2).GE.JSTART(1,14)) RETURN
      IF (IPRMPT.EQ.1) WRITE (6,2)
      IAPP(1)=1
      IAPPN = 1
      REGOS(1) = 0.D0
      CALL NELAPC(1,NELAPO,DIDRPO)
      CALL NCAL(1,NOLD,NDROPO,NELAPO)
C  Determine correct method to use
      METHOS = MOSCAL()
      IERN49 = I49C1()
C  Calculate imputed earnings from 1937 to 1950
  260 CALL IMPUTE
C  Fill out remainder of VEARN
C  If 1977 Old-Start using Dec 1979 frozen PIA Table, do not use
C  earnings in year of eligibility or later
      I1 = IERNYR+14
      IF (METHOS.EQ.7.AND.IERNYR.GT.IELGYR(2)) I1 = IELGYR(2)+14
      IF (METHOS.EQ.6.AND.IELGYR(1).GT.27.AND.JIND(22)+JIND(26).GT.1)
     &I1 = MIN0(I1,IELGYR(1)+18)
      IF (TOTALI) THEN
        I2 = 4
      ELSE
        I2 = 3
      END IF
      DO 360 I=15,I1
  360 IF (.NOT.ISFRZY(I+1936)) VEARN(1,I) = EARNST(I,I2)
C  Order the earnings and compute average monthly earnings
      CALL ORDER (1,I1,NOLD,IERN49,IELGYR(2))
C  Save old-start AME
      IAMEOS = IAME(IAPPN)
C  Assign values to PIA formula percents
      PERCOS(1) = .40
      PERCOS(2) = .10
C  Assign values to bend points
      IBENOS(1) = 0
      IBENOS(2) = 50
      IBENOS(3) = 250
C  Calculate PIB before increase due to increment years
      PAIME(1,1) = AMIN0(IBENOS(2)-IBENOS(1),IAMEOS)
      PAIME(2,1) = AMIN0(IBENOS(3)-IBENOS(2),IAMEOS-IBENOS(2))
      PAIME(2,1) = AMAX1(0.,PAIME(2,1))
      PIB = 0.
      DO 365 I=1,2
  365 PIB = PIB + PAIME(I,1)*PERCOS(I)
      INCYRS = INCRMT()
C  Increase PIB 1% for each increment year
      PIBINC = PIB*(1.+FLOAT(INCYRS)/100.)
C  If this is 1939 Amendments, then PIB is PIA
      IF (METHOS.EQ.1) THEN
C  PIA is at least $10
      PIA(1) = AMAX1(PIBINC,10.)
C  MFB is 80% of Old-Start AMW, up to $85 or twice PIA
      MFB(1) = DMIN1(.8*DBLE(IAMEOS),85.D0,2.*PIA(1))
C  MFB is at least $20
      MFB(1) = DMAX1(20.D0,MFB(1))
C  This is end of 1939 Amendments calculation
      RETURN
      END IF
C  Find corresponding new-start AME for 1950 Amendments or later
      I2 = 1
C  Method 2 uses 1950 Conversion Table; other methods use 1958 Table
      IF (METHOS.EQ.2) THEN
  430   IF (PIBINC.LE.PIB50(I2)) GO TO 440
        I2 = I2+1
C  There are 486 lines in 1950 PIB-PIA Conversion Table; go back
C  and try again if not to end of table
        IF (I2.LT.486) GO TO 430
C  Find corresponding PIA and MFB
C  PIA's in Conversion Table start at $20 and increase at $.10 per
C  interval
  440   PIAEL(1) = 19.90 + DBLE(I2)/10.
        PIA(1) = PIAEL(1)
C  If entitled in September 1952 or later, apply 1952 increase
        IF (COMPMY(BENDAT,AMND52).LT.0) THEN
          MFB(1) = MFB50(I2)
          MFBEL(1) = MFB(1)
          RETURN
        ELSE
C  Increase is greater of $5 or 12.5%
          PIA(1) = ROUND(DMAX1(PIA(1)+5.00,PIA(1)*1.125),2)
C  If entitled in September 1954 or later, apply 1954 increase
          IF (COMPMY(BENDAT,AMND54).LT.0) THEN
            MFB(1) = MFB52(I2)
            RETURN
          ELSE
C  Increase is $5 up to I2=329; for greater amounts, use stored
C  Conversion Table
            IF (I2.LE.329) THEN
              PIA(1) = PIA(1)+5.00
            ELSE
              PIA(1) = PIA54(I2-329)
            END IF
            MFB(1) = MFB54(I2)
          END IF
        END IF
C  This is end of 1950 Old-Start
        RETURN
      END IF
  460 IF (PIBINC.LE.PIB58(I2)) GO TO 470
      I2=I2+1
C  There are 51 lines in 1958 PIB-PIA Conversion Table; go back and try
C  again if not to end of table
      IF (I2.LT.51) GO TO 460
  470 IAME(1)=IAME58(I2)
C  If not 1977 Old-Start with 1979+ eligibility, go to Old-Law
C  PIA calculation
      IF (METHOS.EQ.7) THEN
C  If eligible in 1982 or later, extend down below minimum
      IF (I2.EQ.1.AND.IELGYR(2).GT.30) IAME(1) =
     &INT(PIBINC*76./16.20+.999)
C  Find corresponding PIA in Dec 1978 PIA Table
      ITABEL(1) = CPIBAS (28,1,IELGYR(2),IAME(1),PIAEL(1),MFBEL(1),
     &PIA(1),MFB(1),ICCHUP)
C  Apply windfall provision, if applicable
      IF (JIND(12).EQ.1.AND.IELGYR(2).GE.JSTART(1,12)-1951) GO TO 480
      IF (WEPAPP().GT.0) THEN
C  Reduce PIA at eligibility by lesser of half of pension or half of PIA
        PIAW(1) = PIAEL(1)
        REGOS(1) = ROUND(.5*DBLE(PUBPEN),IELGYR(2))
        PIAEL(1) = ROUND(DMAX1(.5*PIAEL(1),PIAEL(1)-REGOS(1)),28)
        PIA(1) = PIAEL(1)
      END IF
C  Apply CPI increases to PIA
  480 CALL CPI77 (IELGYR(2),JIND(10),JSTART(1,10),IYCPI(1),
     &PIA(1),ICCHUP)
      CALL MFBSET(IELGYR(2),IBENDM)
      IF (TOTALI) CALL PRORAT
C  Find AIME MFB from Wage-Indexed formula
      CALL MFBCAL (1,IELGYR(2),PIAEL(1),MFBEL(1),MFB(1))
C  Apply CPI increases to MFB
      CALL CPI77 (IELGYR(2),JIND(10),JSTART(1,10),IYCPI(1),MFB(1),
     &ICCHUP)
C  This is end of 1977 Old-Start with Dec 1978 frozen PIA Table
      ELSE
C  Find corresponding PIA and MFB from PIA table
      IF (COMPMY(BENDAT,AMND74).LT.0) THEN
        ITABEL(1) = OLDPIA(1)
      ELSE
C  Number of benefit increases is same as for PIA Table
      IYCPI(1)=IYCPI(2)
C  Find which post-1973 PIA Table to use
      I1=24+IYCPI(1)
C Set number of reduction increments for new Roybal and Sanford
      Z4 = Z4SET()
C  Call post-1973 PIA Table subroutine
      ITABEL(1) = CPIBAS (I1,0,IELGYR(2),IAME(1),PIAEL(1),MFBEL(1),
     &PIA(1),MFB(1),ICCHUP)
      END IF
      END IF
C  For HR1917 (100th Congress) use both present guarantee and
C  special comp with old law less 3% less 3% per year
      IF (JIND(19)+JIND(21)+JIND(22)+JIND(25)+JIND(26).EQ.0) RETURN
      IF (JIND(22)+JIND(26).LT.2) RETURN
      IF (JIND(19).GT.0.AND.IELGYR(2).GT.32) RETURN
      IF (JIND(21).GT.0.AND.IELGYR(2).GT.(27+5*JIND(21))) RETURN
      IF (JIND(22).GT.1.AND.IELGYR(2).GT.40) RETURN
      IF (JIND(25).GT.0.AND.IELGYR(2).GT.(27+5*JIND(25))) RETURN
      IF (JIND(26).GT.1.AND.IELGYR(2).GT.37) RETURN
      IF (TOTALI) RETURN
      IF (IOASDI.EQ.2.AND.(IDEATH(2).LT.(KBIRTH(3)+62).OR.(IDEATH(2).EQ.
     &(KBIRTH(3)+62).AND.IDEATH(1).LT.KBIRTH(1)))) RETURN
      IF (METHOS.EQ.6) GO TO 500
      METHOS = 6
      REGOS(1) = PIA(1)
      REGOS(2) = PIAEL(1)
      REGOS(3) = PIAW(1)
      REGOS(4) = MFB(1)
      REGOS(5) = MFBEL(1)
      IREGOS = IAME(1)
      GO TO 260
  500 IF (JIND(19).GT.0) THEN
      PIA(1) = PIA(1) - DMAX1(0.D0,FACM19(IELGYR(2)-27)*(PIA(1)-PIA(3)))
      MFB(1) = MFB(1) - DMAX1(0.D0,FACM19(IELGYR(2)-27)*(MFB(1)-MFB(3)))
      END IF
      IF (JIND(26).GT.1.AND.IOASDI.NE.3.AND.KBIRTH(3).GT.1916.AND.
     &KBIRTH(3).LT.1927) THEN
        I1 = MIN0(IELGYR(1)-27,10)
        IF (I1.LT.1) I1 = 1
C
C  Age reduction is 5% per year for Roybal, No old start for Sanford
C
        FACM = FACM26(2,I1) -
     &  0.05*AMIN1(FLOAT(IENT(2)-1951-IELGYR(1)),3.) 
        IF (FACM.LT.0.) FACM = 0.
        IF (FACM.GT.1.) FACM = 1.
      PIA(1) = PIA(1) - DMAX1(0.D0,FACM*(PIA(1)-DMAX1(REGOS(1),PIA(3))))
      MFB(1) = MFB(1) - DMAX1(0.D0,FACM*(MFB(1)-DMAX1(REGOS(4),MFB(3))))
      PIA(1) = ROUND(PIA(1),IELGYR(2))
      MFB(1) = ROUND(MFB(1),IELGYR(2))
      END IF
      IF (PIA(1).GE.REGOS(1)) RETURN
      PIA(1) = REGOS(1)
      PIAEL(1) = REGOS(2)
      PIAW(1) = REGOS(3)
      MFB(1) = REGOS(4)
      MFBEL(1) = REGOS(5)
      IAME(1) = IREGOS
      RETURN
      END
C
C  Function to determine correct old-start method
C
      INTEGER FUNCTION MOSCAL()
      INTEGER AMND90(2), AMND50(2), AMND58(2), AMND65(2), AMND67(2)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
C  Declare functions
      INTEGER COMPMY
C  Set effective date of 1990 amendments
      DATA AMND90 / 6,1992 / AMND50 / 9,1950 /
      DATA AMND58 / 1,1959 / AMND65 / 1,1966 / AMND67 / 1,1968 /
C  If entitled prior to September 1950, use 1939 Amendments
      IF (COMPMY(IENT,AMND50).LT.0) THEN
        MOSCAL = 1
        RETURN
      END IF
C  If entitled from September 1950 to December 1958, use 1950
C  Conversion Table
      IF (COMPMY(IENT,AMND58).LT.0) THEN
        MOSCAL = 2
        RETURN
      END IF
C  If entitled from January 1959 to December 1965 use 1958 Conversion
C  Table
      IF (COMPMY(IENT,AMND65).LT.0) THEN
        MOSCAL = 3
        RETURN
      END IF
C  If entitled after 1965, but eligible prior to 1966, use 1958
C  Conversion Table or 1990 amendments
      IF (IELGYR(2).LT.15) THEN
        IF (COMPMY(IENT,AMND90).LT.0) THEN
          MOSCAL = 3
          RETURN
        ELSE
          MOSCAL = 8
          RETURN
        END IF
      END IF
C  Otherwise, if entitled in 1966-67, use 1965 Old-Start
      IF (COMPMY(IENT,AMND67).LT.0) THEN
        MOSCAL = 4
        RETURN
      END IF
C  If entitled after 1967, but died prior to 1968, use 1965
C  Old-Start or 1990 amendments
      IF (IELGYR(2).LT.17.AND.IOASDI.EQ.2) THEN
        IF (COMPMY(IENT,AMND90).LT.0) THEN
          MOSCAL = 4
          RETURN
        ELSE
          MOSCAL = 8
          RETURN
        END IF
      END IF
C  If born in 1916 or later and eligible in 1978 or later, go on
C  to Old-Start methods 6 and 7
      IF (KBIRTH(3).LT.1916.OR.IELGYR(2).LT.27) THEN
C  If born before 1916, use 1967 Old-Start
        IF (KBIRTH(3).LT.1916) THEN
          IF (COMPMY(IENT,AMND90).LT.0) THEN
            MOSCAL = 5
          ELSE
            MOSCAL = 8
          END IF
C  If born in 1916 or later, use 1965 Old-Start or 1990 amendments
        ELSE
          IF (COMPMY(IENT,AMND90).LT.0) THEN
            MOSCAL = 4
          ELSE
            MOSCAL = 8
          END IF
        END IF
      ELSE
C  If eligible in 1978, use Old-Start method 6
        IF (IELGYR(2).EQ.27) MOSCAL = 6
C  Otherwise use method 7
        IF (IELGYR(2).GE.28) MOSCAL = 7
        IF (JIND(20).GT.0.AND.MOSCAL.GT.6) THEN
          MOSCAL = 6
        END IF
      END IF
      RETURN
      END
C
C  Subroutine to impute earnings for 1937-50 for old-start
C
C  I2     = first year of imputed earnings
C  I3     = last year of imputed earnings
C
      SUBROUTINE IMPUTE()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER I,I2,I3,I4
      IF (METHOS.LT.5) THEN
C  Methods 1, 2, 3, and 4 use actual yearly earnings
        IF (TOTALI) THEN
          I4 = 4
        ELSE
          I4 = 3
        END IF
        DO 280 I=1,14
  280   VEARN(1,I) = EARNST(I,I4)
      ELSE
C  Zero out pre-1951 earnings
        DO 300 I=1,14
  300   VEARN(1,I) = 0.
C  1967 Old-Start allocates over 9 years, up to $3,000 per year
        IF (METHOS.EQ.5) THEN
          IDIVOS = 9
          I2 = 6
          I3 = 14
        ELSE
C  1977 Old-Start allocates over variable number of years
          I2 = MIN0(KBIRTH(3)-1915,14)
          I2 = MAX0(I2,1)
          I3 = 14
          IF (IOASDI.EQ.2) I3 = MIN0(I3,IDEATH(2) - 1937)
          IF (VALDI.EQ.1) I3 = MIN0(I3,FRZYR1 - 1937)
          IF (VALDI.EQ.2) I3 = MIN0(I3,FRZYR3 - 1937)
          I3 = MAX0(I3,1)
          I2 = MIN0(I2,I3)
          IDIVOS = I3 - I2 + 1
        END IF
C  If over $3,000 per year for divisor years, allocate $3,000 per year
C  up to 14 years
        IF (TOTALI) THEN
          I4 = 2
        ELSE
          I4 = 1
        END IF
        IF (STOT(I4).GT.3000.*FLOAT(IDIVOS)) THEN
          IDIVOS = MIN0(INT((STOT(I4)+.01)/3000.),14)
          IDIVOS = MIN0(IDIVOS,I3)
          I2 = MAX0(I3-IDIVOS,1)
          DO 320 I=I2+1,I3
  320     VEARN(1,I) = 3000.
C  If any earnings remain, put in next prior year
          VEARN(1,I2) = STOT(I4) - INT(STOT(I4)/3000.) * 3000.
        ELSE
C  If less than $3000 per year, fill out earnings array
          DO 340 I=I2,I3
  340     VEARN(1,I) = STOT(I4)/FLOAT(IDIVOS)
        END IF
      END IF
      RETURN
      END
C
C  Function to calculate number of increment years
C
      INTEGER FUNCTION INCRMT()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER I,I2
      IF (TOTALI) THEN
        I2 = 2
      ELSE
        I2 = 1
      END IF
      GO TO (370,370,370,370,390,400,400,400), METHOS
C  Under 1939 Amendments, 1950 Old-Start, or 1965 Old-Start, one
C  increment year for each year of at least $200 of earnings
  370 INCRMT = 0
      DO 380 I=1,14
      IF (EARNST(I,I2).GE.200.) INCRMT = INCRMT + 1
  380 CONTINUE
      RETURN
C  Under 1967 Old-Start, 14 increment years
  390 INCRMT = 14
      RETURN
C  Under 1977 Old-Start, one increment year for each $1650 of
C  cumulative earnings, with minimum 4 and Maximum 14
  400 INCRMT = MAX0(INT(STOT(I2))/1650,4)
      INCRMT = MIN0(INCRMT,14)
      RETURN
      END
