C  @(#)piadata.f	1.2  2/24/97
C
C  Subroutines dealing with piadata data
C
C  Subroutine to compute last year of usable earnings
C
C  IYEAR1 = year before attainment of normal retirement age.
C  IYEAR2 = year before deemed attainment of normal retirement age.
C
      INTEGER FUNCTION ERNYRC()
      INTEGER IYEAR1,IYEAR2
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Determine years of freeze
      IF (VALDI.GT.0) THEN
        IF (IONSET(1).EQ.1.AND.IONSET(2).EQ.1) THEN
          FRZYR1 = IONSET(3)
        ELSE
          FRZYR1 = IONSET(3)+1
        END IF
        IF (NRA(2)+KBIRTH(1).GT.12) THEN
          IYEAR1 = KBIRTH(3) + NRA(1)
        ELSE
          IYEAR1 = KBIRTH(3) + NRA(1) - 1
        END IF
        IF (IOASDI.EQ.3) THEN
          IF (NRA(2)+WAITPD(1).GT.12) THEN
            IYEAR2 = WAITPD(2)+NRA(1)-62
          ELSE
            IYEAR2 = WAITPD(2)+NRA(1)-63
          END IF
          FRZYR2 = MIN0(IYEAR1,IYEAR2)
          FRZYR2 = MIN0(FRZYR2,BENDAT(2)-1)
        ELSE
          FRZYR2 = MIN0(BENDAT(2)-1,IYEAR1)
        END IF
        IF (IOASDI.EQ.2) FRZYR2 = MIN0(FRZYR2,IDEATH(2)-1)
      END IF
C  Determine years of freeze for prior period of disability
      IF (VALDI.GT.1) THEN
        IF (ONSET1(1).EQ.1.AND.ONSET1(2).EQ.1) THEN
          FRZYR3 = ONSET1(3)
        ELSE
          FRZYR3 = ONSET1(3) + 1
        END IF
        IF (ONSET1(1).EQ.12) THEN
          FRZYR4 = DICES1(2)
        ELSE
          FRZYR4 = DICES1(2) - 1
        END IF
      END IF
C  For retirement, last year of earnings used is year prior to
C  entitlement
      IF (IOASDI.NE.2) THEN
        ERNYRC = BENDAT(2)-1951
      ELSE
C  For survivors, use earnings up to and including year of death
        ERNYRC = IDEATH(2)-1950
      END IF
      RETURN
      END
C
C  Subroutine to calculate currently insured QCs
C
      SUBROUTINE QCCURC(QTRYR)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER QTRYR(2), STRTQC(2)
C  Function declarations
      INTEGER QCSUMQ
C  Use 13-quarter measuring period
      STRTQC(1) = QTRYR(1)
      STRTQC(2) = QTRYR(2) - 3
      QCCUR = QCSUMQ(STRTQC, QTRYR)
      RETURN
      END
C
C  Function to add up pre-1951 earnings
C
      REAL FUNCTION STOTC(I2)
      INTEGER I2,I
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      STOTC = 0.
      DO 100 I = IBEGIN-1936,14
  100 STOTC = STOTC + EARNST(I,I2)
      IF (STOTC.GT.42000.) STOTC = 42000.
      RETURN
      END
C
C  Subroutine to determine number of required quarters of coverage for
C  disability insured status
C
C  TRIAL  = number of quarters to go beyond onset quarter.
C  DOSPEC = indicator for checking special insured status.
C           0: do not check special insured status.
C           1: check special insured status.
C
      SUBROUTINE QCDIRE(TRIAL,DOSPEC)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER QCTMPD(2), DOSPEC, TRIAL
C  Set ending quarter and year 
      QCDDT2(1) = (IONSET(1) + 2) / 3 + TRIAL
      QCDDT2(2) = IONSET(3) 
      IF (QCDDT2(1).GT. 4) THEN
        QCDDT2(1) = QCDDT2(1) - 4
        QCDDT2(2) = QCDDT2(2) + 1
      END IF
C  Set beginning quarter and year, based on 40 quarters 
      QCDDT1(1) = QCDDT2(1) + 1
      QCDDT1(2) = QCDDT2(2) - 10 
      IF (QCDDT1(1).GT. 4) THEN
        QCDDT1(1) = QCDDT1(1) - 4
        QCDDT1(2) = QCDDT1(2) + 1
      END IF
C  Check for special insured status before age 31 
      QCTMPD(1) = (KBIRTH(1) + 2) / 3 
      QCTMPD(2) = KBIRTH(3) + 31 
      IF (DOSPEC.EQ.1.AND.(QCDDT2(2).LT.QCTMPD(2).OR.
     &(QCDDT2(2).EQ.QCTMPD(2).AND.QCDDT2(1).LT.QCTMPD(1))))
     &CALL QCDISP()
C  Calculate number of elapsed quarters
      QCDIQT = 4 * (QCDDT2(2) - QCDDT1(2)) + QCDDT2(1) - QCDDT1(1) + 1
C  Calculate number of elapsed years
      QCDIYR = (QCDIQT + 2) / 4
C  Calculate number of qc's required
      DISREQ = QCDIQT / 2
      RETURN
      END
C
C  Function to set first quarter and year of disability insured period
C  for special insured status
C
      SUBROUTINE QCDISP()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Start with quarter after attainment of age 21 
      QCDDT1(1) = (KBIRTH(1) + 5) / 3
      QCDDT1(2) = KBIRTH(3) + 21
      IF (QCDDT1(1).GT.4) THEN
        QCDDT1(1) = QCDDT1(1) - 4
        QCDDT1(2) = QCDDT1(2) + 1
      END IF
C  Check for fewer than 12 qc's 
      IF (4 * (QCDDT2(2)-QCDDT1(2)) + QCDDT2(1)-QCDDT1(1)+1.LT.12) THEN
C  Use 12 quarters  
        QCDDT1(1) = QCDDT2(1) + 1
        QCDDT1(2) = QCDDT2(2) - 3
        IF (QCDDT1(1) .GT. 4) THEN
          QCDDT1(1) = QCDDT1(1) - 4
          QCDDT1(2) = QCDDT1(2) + 1
        END IF
      END IF
      RETURN
      END
C
C  Function to calculate earned quarters of coverage in disability
C  insured period
C
      SUBROUTINE QCDICA
      INTEGER I1
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Start with qc's in first year, starting with first quarter 
      QCTOTD = MIN0(IQC(QCDDT1(2)-1936),5-QCDDT1(1))
C  Continue with full years 
      DO 100 I1 = QCDDT1(2)-1935,QCDDT2(2)-1937
      QCTOTD = QCTOTD + IQC(I1)
  100 CONTINUE
C  End with qc's in last year, ending with last quarter
      QCTOTD = QCTOTD + MIN0(IQC(QCDDT2(2)-1936),QCDDT2(1))
      RETURN
      END
C
C  Function to calculate the disability insured status code
C
      CHARACTER*1 FUNCTION DINSCA()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER QCTMPD(2), I
C  Find quarter after quarter of age 21
      QCTMPD(1) = (KBIRTH(1) + 5) / 3
      QCTMPD(2) = KBIRTH(3) + 21
      IF (QCTMPD(1).GT.4) THEN
        QCTMPD(1) = QCTMPD(1) - 4
        QCTMPD(2) = QCTMPD(2) + 1
      END IF
      DO 100 I = 0,1
      CALL QCDIRE(I,0)
      CALL QCDICA
      IF (QCTOTD.GE.DISREQ) GO TO 200
  100 CONTINUE
      IF (QCDDT1(2).LT.QCTMPD(2).OR.
     &(QCDDT1(2).EQ.QCTMPD(2).AND.QCDDT1(1).LT.QCTMPD(1))) THEN
        DO 150 I = 0,1
          CALL QCDIRE(I,1)
          CALL QCDICA
          IF (QCTOTD.GE.DISREQ) GO TO 200
  150   CONTINUE
      END IF
C  Not fully insured
  200 IF (IQCTOT.LT.IQCREQ) THEN
        IF (TOTALI) THEN
          DINSCA = 'T'
        ELSE
          IF (IQCTOT.EQ.0) THEN
            DINSCA = '0'
          ELSE
            IF (QCTOTD.LT.DISREQ) THEN
              DINSCA = '5'
            ELSE
              DINSCA = '6'
            END IF
          END IF
        END IF
C  Fully insured
      ELSE
        IF (QCTOTD.LT.DISREQ) THEN
          IF (TOTALI) THEN
            DINSCA = 'T'
          ELSE
            DINSCA = '6'
          END IF
        ELSE
          IF (QCDIQT.EQ.40) THEN
            DINSCA = '1'
          ELSE
            DINSCA = '2'
          END IF
        END IF
      END IF
      RETURN
      END
C
C  Function to calculate the fully insured status code, after cwhs
C  insured status code has been calculated.
C
      CHARACTER*1 FUNCTION FINS2C()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Handle young survivors
      IF (IOASDI.EQ.2.AND.JSURV.EQ.1) THEN
C  Handle fully insured
        IF (INSC.EQ.'1'.OR.INSC.EQ.'3'.OR.INSC.EQ.'5'.OR.
     &  INSC.EQ.'6'.OR.INSC.EQ.'D') THEN
          FINS2C = '1'
        ELSE
C  Test for currently insured
          IF (INSC.EQ.'1'.OR.INSC.EQ.'2'.OR.INSC.EQ.'5') THEN
            FINS2C = '2'
          ELSE
            FINS2C = '5'
          END IF
        END IF
      ELSE
C  Test for totalized benefit
        IF (TOTALI) THEN
C  Handle fewer than 6 qcs
          IF (IQCTOT.LT.6) THEN
            FINS2C = '6'
          ELSE
C  Handle fully insured
            IF (INSC.EQ.'1'.OR.INSC.EQ.'3'.OR.INSC.EQ.'5'.OR.
     &      INSC.EQ.'6'.OR.INSC.EQ.'D') THEN
              FINS2C = '7'
            ELSE
              FINS2C = '3'
            END IF
          END IF
        ELSE
          IF (INSC.EQ.'1'.OR.INSC.EQ.'3'.OR.INSC.EQ.'5'.OR.
     &    INSC.EQ.'6'.OR.INSC.EQ.'D') THEN
            FINS2C = '1'
          ELSE
            FINS2C = '4'
          END IF
        END IF
      END IF
      RETURN
      END
C
C  Function to calculate the cwhs fully insured status code
C
C *DATE   = date (month and year) for which insured status code is
C             required.
C  ISWASP = worker's primary beneficiary status.
C           0: never a primary beneficiary.
C           1: is a primary beneficiary.
C           2: is a deceased primary beneficiary.
C
      CHARACTER*1 FUNCTION INSCAL(DATE,ISWASP)
      INTEGER DATE(2),ISWASP,QTRYR(2)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      CHARACTER*1 DEADIN,FINS1C
      INTEGER COMPMY
C  Handle deaths
      IF (IDEATH(2).GT.0.AND.COMPMY(IDEATH,DATE).LT.0) THEN
        INSCAL = DEADIN(ISWASP)
      ELSE
        CALL NELAPC(0,NELAP,DIDRP)
        CALL QCREQC
C  Calculate currently insured status
        IF (IOASDI.EQ.2.AND.JSURV.EQ.1) THEN
          QTRYR(2) = IDEATH(2)
          QTRYR(1) = (IDEATH(1) + 2) / 3
          CALL QCCURC(QTRYR)
        END IF
        INSCAL = FINS1C(QTRYR,ISWASP)
      END IF
      RETURN
      END
C
C  Function to calculate the cwhs fully insured status code for a
C  deceased worker.
C
C  ISWASP = worker's primary beneficiary status.
C           0: never a primary beneficiary.
C           1: is a primary beneficiary.
C           2: is a deceased primary beneficiary.
C
      CHARACTER*1 FUNCTION DEADIN(ISWASP)
      INTEGER ISWASP
      IF (ISWASP.EQ.2) THEN
        DEADIN = '7'
      ELSE
        DEADIN = '9'
      END IF
      RETURN
      END
C
C  Function to calculate the fully insured status code for one date,
C  after total and required quarters of coverage have been calculated,
C  and after checking that worker is alive.
C
C *QTRYR  = date (quarter (0-3) and year) for which insured status code
C             is required.
C  ISWASP = worker's primary beneficiary status.
C           0: never a primary beneficiary.
C           1: is a primary beneficiary.
C           2: is a deceased primary beneficiary.
C
      CHARACTER*1 FUNCTION FINS1C(QTRYR,ISWASP)
      INTEGER QTRYR(2),ISWASP,IYEAR
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      LOGICAL DEEMCA
      IF (IQCTOT.LT.IQCREQ) THEN
C  Handle totalization insured status
        IF (ISWASP.EQ.1.AND.TOTALI) THEN
          FINS1C = 'T'
          RETURN
        END IF
C  Handle deemed insured status
        IF (IDEEM.AND.QTRYR(2).GT.1983) THEN
          IF (DEEMCA(QTRYR)) THEN
            FINS1C = 'D'
            RETURN
          END IF
        END IF
C  Handle currently insured
        IF (QCCUR.GT.5) THEN
          FINS1C = '2'
        ELSE
          IF (ISEX.EQ.1) THEN
            IYEAR = 1887
          ELSE
            IYEAR = 1890
          END IF
C  Handle transitionally insured
          IF (IQCTOT.GT.2.AND.IQCTOT.GT.KBIRTH(3) - IYEAR) THEN
            FINS1C = '8'
          ELSE
            FINS1C = '4'
          END IF
        END IF
      ELSE
        IF (IQCTOT.LT.QCREQP) THEN
C  Not permanently insured
          IF (QCCUR.GT.5) THEN
            FINS1C = '1'
          ELSE
            FINS1C = '3'
          END IF
        ELSE
C  Permanently insured
          IF (QCCUR.GT.5) THEN
            FINS1C = '5'
          ELSE
            FINS1C = '6'
          END IF
        END IF
      END IF
      RETURN
      END
C
C  Function to check for deemed insured status, assuming eligible
C
C *QTRYR  = date (quarter (0-3) and year) for which insured status code
C             is required.
C
      LOGICAL FUNCTION DEEMCA(QTRYR)
      INTEGER QTRYR(2),QTR184(2),TQCTOT
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER QCSUMQ
      DATA QTR184 / 0, 1984 /
      CALL DQCRQC
      IF (DQCREQ.LT.0) THEN
        DEEMCA = .FALSE.
        RETURN
      END IF
      TQCTOT = QCSUMQ(QTR184,QTRYR)
      IF (TQCTOT.GE.DQCREQ) THEN
        DEEMCA = .TRUE.
      ELSE
        DEEMCA = .FALSE.
      END IF
      RETURN
      END
C
C  Subroutine to determine number of quarters of coverage required for
C  deemed insured status
C
      SUBROUTINE DQCRQC
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      IF (KBIRTH(3).LT.1924) THEN
        DQCREQ = 6
        RETURN
      END IF
      IF (KBIRTH(3).LT.1925) THEN
        DQCREQ = 8
        RETURN
      END IF
      IF (KBIRTH(3).LT.1926) THEN
        DQCREQ = 12
        RETURN
      END IF
      IF (KBIRTH(3).LT.1927) THEN
        DQCREQ = 16
        RETURN
      END IF
      IF (KBIRTH(3).LT.1929) THEN
        DQCREQ = 20
        RETURN
      END IF
C  If ineligible because of age, use -1
      DQCREQ = -1
      RETURN
      END
C
C  Subroutine to set number of QC's required for fully insured status
C
      SUBROUTINE QCREQC
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      IQCREQ = MAX(6,NELAP)
      IQCREQ = MIN(40,IQCREQ)
      RETURN
      END
C
C  Subroutine to set number of QC's required for permanently insured
C  status
C
      SUBROUTINE QCREQ1
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER DIDROP,ELAP1,ELAP2
      INTEGER DROPCA, IELGC1
      DIDROP = 0
      ELAP1 = MAX0(KBIRTH(3)+21, 1950)
      ELAP2 = IELGC1(0) - 1
      IF (VALDI.GT.0) DIDROP = DROPCA(ELAP1,ELAP2)
      QCREQP = MAX(6,NELAP)
      QCREQP = MIN(40,IQCREQ)
      RETURN
      END
C
C  Function returning number of years to drop out of elapsed period due
C  to disability
C
      INTEGER FUNCTION DROPCA(ELAP1,ELAP2)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER ELAP1,ELAP2,ELAP4,ELAP5,ELAP6,ELAP7
      DROPCA = 0
      IF (VALDI.EQ.0) RETURN
C  Check latest period of disability
      IF (IONSET(3).LE.ELAP2) THEN
        ELAP4 = MAX0(IONSET(3), ELAP1 + 1)
        IF (DICESS(2).GE.IONSET(3).AND.DICESS(2).LE.ELAP2) THEN
          ELAP5 = DICESS(2)
        ELSE
          ELAP5 = ELAP2
        END IF
        DROPCA = ELAP5 - ELAP4 + 1
      END IF
C  Check prior period of disability
      IF (VALDI.GE.2.AND.ONSET1(3).LT.ELAP4) THEN
        ELAP6 = MAX0(ONSET1(3), ELAP1 + 1)
        ELAP7 = MIN0(DICES1(2), ELAP4 - 1)
        DROPCA = ELAP5 - ELAP4 + 1 + ELAP7 - ELAP6 + 1
      END IF
      RETURN
      END
C
C  Function to determine if year is wholly within a period of disability
C
C  YEAR   = year considered.
C
      LOGICAL FUNCTION ISFRZY(YEAR)
      INTEGER YEAR
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      IF (VALDI.EQ.0) THEN
        ISFRZY = .FALSE.
        RETURN
      END IF
      IF (YEAR.GE.FRZYR1.AND.YEAR.LE.FRZYR2) THEN
        ISFRZY = .TRUE.
        RETURN
      END IF
      IF (VALDI.EQ.1) THEN
        ISFRZY = .FALSE.
        RETURN
      END IF
      IF (YEAR.GE.FRZYR3.AND.YEAR.LE.FRZYR4) THEN
        ISFRZY = .TRUE.
        RETURN
      END IF
      ISFRZY = .FALSE.
      RETURN
      END
