C  @(#)piaout.f	1.31   2/24/97
C
C  This subroutine prints out the detailed results of a PIA calculation.
C
C  Definition of variables ('*' before variable name denotes dimensioned
C  variable array):
C
C  I      = temporary index used in do-loops.
C  I2     = temporary index used in various places.
C  IDET   = indicator for file open.
C *IOS77  = output label for 1950 or 1977 Old-Start.
C  IOUT   = output unit number.
C *IYROS  = label for 1950, 1965, 1967, or 1977 Old-Start.
C  P2PAGE = indicator for 2-page summary (0 for not yet printed,
C           1 for already printed).
C  PAGE   = page counter.
C *TABLE  = output array of SS Acts, used in PIA Table output.
C
      SUBROUTINE PIAOUT (PROGFL,PAGE,ISUM)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'setup.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'taxesf.h'
      CHARACTER*80 PROGFL
      CHARACTER*11 OUTFIL
      CHARACTER*4 TABLE(10),IYROS(8)
      CHARACTER*24 IOS77(8)
      INTEGER PAGE, AMND79(2), IFILE, IOUT, I2, I, IDET, ISUM,
     &P2PAGE, I1, I4
      REAL TEMP
C  Function declarations
      INTEGER COMPMY
C
C  Data initialization
C
      DATA IYROS / '1939','1950','1950','1965','1967','1977','1977',
     &'1990' /
      DATA TABLE / '1952','1954','1958','1965','1967','1969',
     &'1971','1972','1973','1977' /
      DATA IOS77 / ' ','1950 Conversion Table','1958 Conversion Table',
     &' ',' ','Pre-1977 Act PIA Table','December 1978 PIA Table',
     &'Pre-1977 Act PIA Table' /
      DATA AMND79 / 6,1979 /
C
C  FORMAT statements
C
    2 FORMAT ('      PIA at eligibility =',F9.2/)
    3 FORMAT ('      MFB at eligibility =',F9.2/)
    4 FORMAT ('      Old-law PIA =',F9.2/)
    5 FORMAT ('      Old-law MFB =',F9.2/)
    6 FORMAT ('      Blending factor =',F7.4/)
   12 FORMAT (' ',T24,'Imputed',T35,'High n'/
     &6X,'Year  Earnings  Earnings    Years'/)
   13 FORMAT (' ',T30,'High n'/6X,'Year      Earnings       Years'/)
   14 FORMAT (' ',T34,'Earnings        Indexed       High n'/
     &'      Year      Earnings      * ',F11.2,6X,
     &'Earnings       Years'/)
   16 FORMAT (' ',T28,'percent of'/' ',T30,'old-law'/
     &' ',T31,'base      required   years of'/
     &'      year      earnings    required    earnings   coverage'/)
   19 FORMAT ('      Base year for indexing = ',I4/)
   20 FORMAT (' ',T20,A40//)
   21 FORMAT ('      1937-50',F11.2,I32)
   22 FORMAT ('      Years of coverage over 10, up to ',I2,' = ',I2)
   37 FORMAT (/'      AME =',F10.2,'/(',I2,'*12)','=',I6/)
   38 FORMAT (/'      Dec 1978 PIA =',F8.2)
   39 FORMAT ('      Dec 1978 PIA =',F8.2)
   41 FORMAT (/'      MFB =',F10.2)
   45 FORMAT ('      PIA at entitlement =',F9.2)
   50 FORMAT (/'      New-Start AME =',I6)
   52 FORMAT ('        =',F10.2/)
   53 FORMAT ('      Applicable table: ',A4,' Act'/)
   54 FORMAT ('      Noncovered pension =',F10.2/)
   56 FORMAT ('      MFB formula bend points =',I5,',',I5,' and',I5/)
   72 FORMAT ('      Pro Rata AIME = ',I7/)
   73 FORMAT (/'      Theoretical AIME =',F10.2,'/(',I2,'*12) =',F7.0)
   74 FORMAT ('      ',I4,2F10.2)
   75 FORMAT ('      ',I4,3F10.2)
   76 FORMAT ('      Applicable method: ',A4,' Amendments')
   77 FORMAT ('        ',A24/)
   78 FORMAT ('      PIB before applying increment years =')
   79 FORMAT (/'      1950 PIA =',F6.2)
   80 FORMAT (/'      1950 MFB =',F6.2)
   81 FORMAT ('      PIA after windfall =')
   82 FORMAT ('      Theoretical PIA = ',F9.2/)
   83 FORMAT ('      Pro Rata PIA = (',I3,'/',I3,') * ',F9.2, ' = ',
     &F9.2/)
   84 FORMAT ('      ',I4,2F14.2)
   85 FORMAT ('      Increment years = ',I2)
   86 FORMAT ('      Raw Pro Rata PIA = ',F9.2/)
   87 FORMAT ('      ',I4,F14.2,F19.4,2F14.2)
   88 FORMAT ('      ',I4,F14.2,19X,2F14.2)
   89 FORMAT (/'      PIB after applying increment years =',F7.2)
   90 FORMAT (/'      AIME =',F10.2,'/(',I2,'*12) =',I7)
   91 FORMAT (/'      PIA formula bend points =',I5,' and',I6/)
   92 FORMAT ('      PIA at eligibility =')
   93 FORMAT ('        ',F3.2,' *',F6.0,' +')
   94 FORMAT ('        ',F3.2,' *',F6.0,' =',F8.2/)
   95 FORMAT ('      Special minimum savings clause:'/2X,I2,
     &' years of coverage'/)
   96 FORMAT ('      ',F9.2,' - .5*',F8.2)
   97 FORMAT (/'      PIA formula bend points =',I5,',',I6,', and',I6/)
   99 FORMAT ('      ',I4,F14.2,F10.2,F14.2,I8)
  100 FORMAT ('      Years of coverage =',I3/)
  101 FORMAT (/'      Amount per year =',F6.2)
  102 FORMAT (/'      January 1979 PIA =',1X,I2,' *',F6.2,' =',F8.2)
  103 FORMAT (/'      MFB in January 1979 =',F9.2/)
  104 FORMAT (/'      PIA =',I3,' *',F6.2,' =',F9.2)
  105 FORMAT ('      Widow(er) born on ',A9,' ',I2,', ',I4/)
  106 FORMAT (/'      MFB at entitlement = (same as for wage-indexed)')
  107 FORMAT (' ',T30,'Contributions'//'      year',4X,
     &'Earnings     OASI',7X,'DI',6X,'OASDI',7X,'HI     OASDHI'/)
  108 FORMAT ('      ',I4,F12.2,5F10.2)
  109 FORMAT (/'      Total',F11.2,5F10.2)
  110 FORMAT ('      Widow(er) disabled on ',A9,' ',I2,', ',I4/)
  180 FORMAT ('      ',A65)
C
      IDET = 0
      P2PAGE = 0
C
C  Print one-page summary
C
      IF (ISUM.EQ.1) THEN
        CALL PRSTRT(PROGFL,IOUT,OUTFIL,IFILE)
        CALL ONEPAG (IOUT)
      END IF
C
C  Write out summary pages
C
      IF (ISUM.EQ.2.OR.(ISUM.EQ.3.AND.P2PAGE.EQ.0)) THEN
        CALL PRSTRT(PROGFL,IOUT,OUTFIL,IFILE)
        CALL TWOPG1 (IOUT,PAGE)
        CALL TWOPG2 (IOUT,PAGE)
        CALL TWOPG3 (IOUT,PAGE)
        IDET = 1
        P2PAGE = 1
      END IF      
C
C  Print detailed output
C
      IF (ISUM.EQ.3) THEN
        IF (TOTALI) THEN
          I4 = 2
        ELSE
          I4 = 1
        END IF
        IF (IDET.EQ.0) CALL PRSTRT(PROGFL,IOUT,OUTFIL,IFILE)
C
C  Earnings page for Old-start Method
C
      IF (IAPP(1).GT.0) THEN
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(1)
      WRITE (IOUT,12)
      I2=IERNYR+14
      DO 505 I=1,I2
      IF (I.EQ.14.AND.IBEGIN.EQ.1950) THEN
        TEMP = STOT(I4)
      ELSE
        TEMP = EARNST(I,I4+2)
      END IF
      IF (IORDER(1,I).LE.0) THEN
        WRITE (IOUT,74) 1936+I,TEMP,VEARN(1,I)
      ELSE
        WRITE (IOUT,75) 1936+I,TEMP,VEARN(1,I),VEARN(1,I)
      END IF
  505 CONTINUE
C  Print noninsured message
      CALL NONINS(IOUT)
C
C  Old-Start PIA detail page
C
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(1)
      WRITE (IOUT,76) IYROS(METHOS)
      WRITE (IOUT,77) IOS77(METHOS)
      CALL COMPYR(NOLD,NDROPO,NELAPO,DIDRPO,IOUT)
      WRITE (IOUT,37) FTEARN(1),NOLD,IAMEOS
      WRITE (IOUT,78)
      WRITE (IOUT,93) PERCOS(1),PAIME(1,1)
      WRITE (IOUT,94) PERCOS(2),PAIME(2,1),PIB
      WRITE (IOUT,85) INCYRS
      WRITE (IOUT,89) PIBINC
C  Methods 1 and 2 have different write-out beyond this point
      GO TO (690,620,630,630,630,630,630,630), METHOS
C  Continue method 2 writeout
  620 WRITE (IOUT,79) PIAEL(1)
      WRITE (IOUT,80) MFBEL(1)
      GO TO 690
C  Continue methods 3-8 writeout
  630 WRITE (IOUT,50) IAME(1)
C  Remainder of detail page varies by type of Old-Start PIA
      GO TO (690,690,690,690,690,650,660,650), METHOS
C  This section is for 1977 Old-Start, 1978 eligibility
  650 WRITE (IOUT,53) TABLE(ITABEL(1))
C  Test to see if CPI increases are applied
      IF (IYCPI(1).GT.0) CALL BIOUT(ICCHUP,25,IYCPI(1)+24,IOUT)
C  PIA and MFB writeout
      GO TO 690
C  This section is for 1977 Old-Start, 1979 or later eligibility
  660 IF (IWIND.EQ.0.AND..NOT.TOTALI) THEN
      WRITE (IOUT,38) PIAEL(1)
      ELSE
        IF (IWIND.NE.0) THEN
          WRITE (IOUT,38) PIAW(1)
        ELSE
          WRITE (IOUT,38) PIAELT(1)
        END IF
      END IF
C  Windfall information
      IF (IWIND.NE.0) THEN
        WRITE (IOUT,54) PUBPEN
        WRITE (IOUT,81)
        IF (PIAW(1).LT.PUBPEN) THEN
          WRITE (IOUT,96) PIAW(1),PIAW(1)
        ELSE
          WRITE (IOUT,96) PIAW(1),PUBPEN
        END IF
        WRITE (IOUT,52) PIAEL(1)
      END IF
C  Totalization information
      IF (TOTALI) THEN
        WRITE (IOUT,82) PIATOT(1)
        WRITE (IOUT,83) 3*IQCTOT,12*N,PIATOT(1),PIA(1)
        WRITE (IOUT,86) PIAEL(1)
      END IF
      WRITE (IOUT,56) IBENDM(2),IBENDM(3),IBENDM(4)
      CALL MFBOUT(1,IOUT)
C  Test to see if CPI increases are applied
      IF (IYCPI(1).GT.0) CALL BIOUT(ICCHUP,IELGYR(2)+1,IELGYR(2)+
     &IYCPI(1),IOUT)
C  PIA and MFB at entitlement
  690 CALL PIAMFB(1,IOUT)
C  Print noninsured message
      CALL NONINS(IOUT)
      END IF
C
C  Earnings for Old-law
C
      IF (IAPP(2).GT.0) THEN
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(2)
      WRITE (IOUT,13)
      I1 = MAX0(IBEGIN,1951)
      I2 = IERNYR+1950
      DO 710 I=I1,I2
      IF (IORDER(2,I-1950).LE.0) THEN
        WRITE (IOUT,84) I,EARNST(I-1936,I4+2)
      ELSE
        WRITE (IOUT,84) I,EARNST(I-1936,I4+2),VEARN(2,I-1950)
      END IF
  710 CONTINUE
C  Print noninsured message
      CALL NONINS(IOUT)
C
C   Old-law detail page
C
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(2)
      CALL COMPYR(N,NDROP,NELAP,DIDRP,IOUT)
      WRITE (IOUT,37) FTEARN(2),N,IAME(2)
      WRITE (IOUT,53) TABLE(ITABEL(2))
C  If no CPI increases apply to 1974 table, skip this section
      IF (IYCPI(2).GT.0) CALL BIOUT(ICCHUP,25,IYCPI(2)+24,IOUT)
C  Totalization information
      IF (TOTALI) THEN
        WRITE (IOUT,82) PIATOT(2)
        WRITE (IOUT,83) 3*IQCTOT,12*N,PIATOT(2),PIA(2)
      END IF
C  PIA and MFB at entitlement
      CALL PIAMFB(2,IOUT)
C  Print noninsured message
      CALL NONINS(IOUT)
      END IF
C
C  Earnings for wage-indexed
C
      IF (IAPP(3).GT.0) THEN
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(3)
      WRITE (IOUT,14) FQ(IELGYR(3)+13)
      I1 = MAX0(IBEGIN,1951)
      DO 750 I=I1,IERNYR+1950
      TEMP = EARNST(I-1936,I4+2)
      IF (IORDER(3,I-1950).LE.0) THEN
      IF (I.LE.IELGYR(3)+1949) THEN
        WRITE (IOUT,87) I,TEMP,UEARN(I-1950),VEARN(3,I-1950)
      ELSE
        WRITE (IOUT,88) I,TEMP,VEARN(3,I-1950)
      END IF
      ELSE
      IF (I.LE.IELGYR(3)+1949) THEN
        WRITE (IOUT,87) I,TEMP,
     &  UEARN(I-1950),VEARN(3,I-1950),VEARN(3,I-1950)
      ELSE
        WRITE (IOUT,88) I,TEMP,
     &  VEARN(3,I-1950),VEARN(3,I-1950)
      END IF
      END IF
  750 CONTINUE
C  Print noninsured message
      CALL NONINS(IOUT)
C
C  Wage-indexed detail page
C
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(3)
      WRITE (IOUT,19) IELGYR(3)+1949
      CALL COMPYR(N,NDROP,NELAP,DIDRP,IOUT)
      IF (TOTALI) THEN
        WRITE (IOUT,73) FTEARN(3),N,AMETOT(3)
      ELSE
        WRITE (IOUT,90) FTEARN(3),N,IAME(3)
      END IF
      IF (JIND(5).GT.0.AND.IELGYR(3)+1951.GE.JSTART(1,5).AND.
     &NUMBP.EQ.3) THEN
        WRITE (IOUT,97) (IBENDP(I),I=2,4)
      ELSE
        WRITE (IOUT,91) (IBENDP(I),I=2,3)
      END IF
      WRITE (IOUT,56) IBENDM(2),IBENDM(3),IBENDM(4)
      WRITE (IOUT,92)
      WRITE (IOUT,93) PERCP(1),PAIME(1,3)
      WRITE (IOUT,93) PERCP(2),PAIME(2,3)
      IF (IWIND.LE.0.AND..NOT.TOTALI) THEN
        TEMP = PIAEL(3)
      ELSE
        IF (IWIND.GT.0) THEN
          TEMP = PIAW(3)
        ELSE
          TEMP = PIAELT(3)
        END IF
      END IF
      IF (JIND(5).GT.0.AND.IELGYR(3)+1951.GE.JSTART(1,5).AND.
     &NUMBP.EQ.3) THEN
        WRITE (IOUT,93) PERCP(3),PAIME(3,3)
        WRITE (IOUT,94) PERCP(4),PAIME(4,3),TEMP
      ELSE
        WRITE (IOUT,94) PERCP(3),PAIME(3,3),TEMP
      END IF
      IF (IWIND.NE.0) THEN
C  Special minimum savings clause for windfall
        WRITE (IOUT,54) PUBPEN
        IF (IWIND.LT.0) THEN
          WRITE (IOUT,95) ISPMNT(2)
        ELSE
C  Windfall information
          WRITE (IOUT,100) ISPMNT(2)
          WRITE (IOUT,81)
          IF (IWIND.GT.1) THEN
C  Windfall percents
            WRITE (IOUT,93) PERCW(1),PAIME(1,3)
            WRITE (IOUT,93) PERCW(2),PAIME(2,3)
            WRITE (IOUT,94) PERCW(3),PAIME(3,3),PIAEL(3)
          ELSE
C  One-half noncovered pension
            WRITE (IOUT,96) PIAW(3),PUBPEN
            WRITE (IOUT,52) PIAEL(3)
          END IF
        END IF
      END IF
C  Totalization information
      IF (TOTALI) THEN
        WRITE (IOUT,82) PIATOT(3)
        WRITE (IOUT,83) 3*IQCTOT,12*N,PIATOT(3),PIA(3)
        WRITE (IOUT,86) PIAEL(3)
        WRITE (IOUT,72) IAME(3)
      END IF
      CALL MFBOUT(3,IOUT)
C  Real-wage-gain adjustment
      CALL PRRWG(IELGYR(3),IOUT,3)
C  Test to see if CPI increases are applied
      IF (IYCPI(3).GT.0) CALL BIOUT(ICCHUP,IELGYR(3)+1,IELGYR(3)+
     &IYCPI(3),IOUT)
C  PIA and MFB at entitlement
      CALL PIAMFB(3,IOUT)
C  Print noninsured message
      CALL NONINS(IOUT)
      END IF
C
C  Transitional Guarantee earnings
C
      IF (IAPP(4).GT.0) THEN
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(4)
      WRITE (IOUT,13)
      I2=IERNYR+1950
      DO 850 I=IBEGIN,I2
      IF (I.LE.1950) GO TO 850
      IF (IORDER(4,I-1950).LE.0) THEN
        WRITE (IOUT,84) I,EARNST(I-1936,I4)
      ELSE
        WRITE (IOUT,84) I,EARNST(I-1936,I4),VEARN(4,I-1950)
      END IF
  850 CONTINUE
C  Print noninsured message
      CALL NONINS(IOUT)
C
C  Transitional Guarantee detail page
C
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(4)
      CALL COMPYR(N,NDROP,NELAP,DIDRP,IOUT)
      WRITE (IOUT,37) FTEARN(4),N,IAME(4)
      WRITE (IOUT,39)  PIAEL(4)
      WRITE (IOUT,56) IBENDM(2),IBENDM(3),IBENDM(4)
      CALL MFBOUT(4,IOUT)
C  Test to see if CPI increases are applied
      IF (IYCPI(4).GT.0) CALL BIOUT(ICCHUP,IELGYR(2)+1,IELGYR(2)+
     &IYCPI(4),IOUT)
C  PIA and MFB at entitlement
      CALL PIAMFB(4,IOUT)
C  Print noninsured message
      CALL NONINS(IOUT)
      END IF
C
C  Special Minimum PIA earnings
C
      IF (IAPP(5).GT.0) THEN
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(5)
      WRITE (IOUT,16)
      IF (IBEGIN.LT.1951) WRITE (IOUT,21) STOT(I4),IORDER(5,14)
      I1 = MAX0(IBEGIN-1936,15)
      I2 = MIN0(IEND-1936,IERNYR+14)
      DO 860 I=I1,I2
  860 WRITE (IOUT,99) I+1936,EARNST(I,3),
     &PSPMIN(I-14),BASE77(I)*PSPMIN(I-14),IORDER(5,I)
C  Print noninsured message
      CALL NONINS(IOUT)
C
C  Special-Minimum detail page
C
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(5)
      WRITE (IOUT,100) ISPMNT(1)
      WRITE (IOUT,22) ISPMNR,IYRSPM
      WRITE (IOUT,101) SPMIN
C  If before 1979, skip the 1977 Amendments section
      IF (BENDAT(2).GT.1978) THEN
C  This section writes the 1977 Amendments Special-Minimum PIA
      WRITE (IOUT,102) IYRSPM,SPMIN,PIAEL(5)
C  If no CPI's apply, skip this section
      IF (COMPMY(BENDAT,AMND79).GE.0) THEN
      WRITE (IOUT,103) MFBEL(5)
      CALL BIOUT(ICCHUP,29,28+IYCPI(5),IOUT)
      END IF
      CALL PIAMFB(5,IOUT)
      ELSE
      WRITE (IOUT,104) IYRSPM,SPMIN,PIA(5)
      WRITE (IOUT,41) MFB(5)
      END IF
C  Print noninsured message
      CALL NONINS(IOUT)
      END IF
C
C  Re-indexed Widow Guarantee earnings
C
      IF (IAPP(6).GT.0) THEN
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(6)
      WRITE (IOUT,14) FQ(JELGYR+13)
      I2=IERNYR+1950
      DO 880 I=IBEGIN,I2
      IF (I.LE.1950) GO TO 880
      TEMP = EARNST(I-1936,I4+2)
      IF (IORDER(6,I-1950).LE.0) THEN
      IF (I.LE.JELGYR+1949) THEN
        WRITE (IOUT,87) I,TEMP,XEARN(I-1950),VEARN(6,I-1950)
      ELSE
        WRITE (IOUT,88) I,TEMP,VEARN(6,I-1950)
      END IF
      ELSE
      IF (I.LE.JELGYR+1949) THEN
        WRITE (IOUT,87) I,TEMP,
     &  XEARN(I-1950),VEARN(6,I-1950),VEARN(6,I-1950)
      ELSE
        WRITE (IOUT,88) I,TEMP,VEARN(6,I-1950),VEARN(6,I-1950)
      END IF
      END IF
  880 CONTINUE
C  Print noninsured message
      CALL NONINS(IOUT)
C
C  Re-indexed widow guarantee detail page
C
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(6)
      WRITE (IOUT,105) MONTH(JBIRTH(1)),JBIRTH(2),JBIRTH(3)
      IF (JSURV.EQ.2) WRITE (IOUT,110) MONTH(JONSET(1)),JONSET(2),
     &JONSET(3)
      WRITE (IOUT,19) JELGYR+1949
      CALL COMPYR(N,NDROP,NELAP,DIDRP,IOUT)
      WRITE (IOUT,90) FTEARN(6),N,IAME(6)
      IF (JIND(5).GT.0.AND.JELGYR+1951.GE.JSTART(1,5).AND.
     &NUMBP.EQ.3) THEN
        WRITE (IOUT,97) (JBENDP(I),I=2,4)
      ELSE
        WRITE (IOUT,91) (JBENDP(I),I=2,3)
      END IF
      WRITE (IOUT,92)
      WRITE (IOUT,93) JPERCP(1),PAIME(1,6)
      WRITE (IOUT,93) JPERCP(2),PAIME(2,6)
      IF (JIND(5).GT.0.AND.JELGYR+1951.GE.JSTART(1,5).AND.
     &NUMBP.EQ.3) THEN
        WRITE (IOUT,93) JPERCP(3),PAIME(3,6)
        WRITE (IOUT,94) JPERCP(4),PAIME(4,6),PIAEL(6)
      ELSE
        WRITE (IOUT,94) JPERCP(3),PAIME(3,6),PIAEL(6)
      END IF
C  Real-wage-gain adjustment
      CALL PRRWG(JELGYR,IOUT,6)
C  Test to see if CPI increases are applied
      IF (IYCPI(6).GT.0)
     &CALL BIOUT(JCCHUP,JELGYR+1,JELGYR+IYCPI(6),IOUT)
C  PIA at entitlement
      WRITE (IOUT,45) PIA(6)
      WRITE (IOUT,106)
C  Print noninsured message
      CALL NONINS(IOUT)
      END IF
C
C  Write frozen minimum results
C
      IF (IAPP(7).GT.0) THEN
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(7)
      WRITE (IOUT,2) PIAEL(7)
      WRITE (IOUT,3) MFBEL(7)
C  Test to see if CPI increases are applied
      IF (IENT(2).LT.KBIRTH(3)+65) THEN
        I1 = IENT(2) - 1950
      ELSE
        I1 = KBIRTH(3) + 65 - 1950
      END IF
      IF (IYCPI(7).GT.0) CALL BIOUT(ICCHUP,I1,I1+IYCPI(7)-1,IOUT)
C  PIA and MFB at entitlement
      CALL PIAMFB(7,IOUT)
C  Print noninsured message
      CALL NONINS(IOUT)
      END IF
C
C  Write blended transitional guarantee results
C
      IF (IAPP(8).GT.0) THEN
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,20) TITLE2(8)
      WRITE (IOUT,4) PIAEL(8)
      WRITE (IOUT,5) MFBEL(8)
      WRITE (IOUT,6) FACM
C  PIA and MFB at entitlement
      CALL PIAMFB(8,IOUT)
C  Print noninsured message
      CALL NONINS(IOUT)
      END IF
C
C  Write out taxes
C
C  Write out title
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,107)
C  Write out yearly data
      DO 930 I=IBEGIN-1936,IEND-1936
  930 WRITE (IOUT,108) I+1936,EARNST(I,3),(TAXES(I,I1),I1=1,5)
C  Write out totals
      WRITE (IOUT,109) ERNTOT,TAXTOT
C
C  End of ISUM = 3 if
C
      END IF
      CALL PRTOUT(PROGFL,OUTFIL,CMND1,CMND2)
      END
C
C  Subroutine to write out benefit increases
C
C  I5     = year of benefit increase, minus 1950.
C  I6     = index of catchup year (see JCCHUP).
C  I7     = first year benefit increase applied.
C  I8     = last year benefit increase applied.
C
      SUBROUTINE BIOUT (I6,I7,I8,IOUT)
      INTEGER I5, I6, I7, I8, IOUT
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
C  Function declarations
      INTEGER CCHPXT
      WRITE (IOUT,5)
    5 FORMAT ('      CPI increases applied:')
      DO 30 I5=I7,I8
      IF (I5.LE.28) THEN
        WRITE (IOUT,10) CPI29(I5),I5+1950
      ELSE
        WRITE (IOUT,10) CPIINC(I5),I5+1950
      END IF
   10 FORMAT ('         ',F4.1,' % for ',I4)
      IF (CCHPXT(I5,I6).GT.0)
     &WRITE (IOUT,20) CACHUP(I6,I5-ISTART-2),I5+1950
   20 FORMAT ('         ',F4.1,' % for ',I4,' catch-up')
   30 CONTINUE
      WRITE (IOUT,*)
      RETURN
      END
C
C  Subroutine to write out MFB calculation
C
C  I9     = method number.
C
      SUBROUTINE MFBOUT(I9,IOUT)
      INTEGER I9,IOUT
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
   10 FORMAT ('      MFB at eligibility =')
   20 FORMAT ('        ',F4.2,' *',I7)
   30 FORMAT ('        (MFB cap on DI cases) =',F9.2/)
   50 FORMAT ('        ',F4.2,' *',F8.2,' +')
   51 FORMAT ('        ',F4.2,' *',F8.2,' =',F10.2/)
      IF (ICAP(I9).EQ.1.OR.ICAP(I9).EQ.3) RETURN
      WRITE (IOUT,10)
      IF (ICAP(I9).EQ.2) THEN
        WRITE (IOUT,20) CAP(I9),IAME(I9)
        WRITE (IOUT,30) MFBEL(I9)
      ELSE
        WRITE (IOUT,50) PERCM(1),PPIAEL(1,I9)
        WRITE (IOUT,50) PERCM(2),PPIAEL(2,I9)
        WRITE (IOUT,50) PERCM(3),PPIAEL(3,I9)
        WRITE (IOUT,51) PERCM(4),PPIAEL(4,I9),MFBEL(I9)
      END IF
      RETURN
      END
C
C  Subrutine to write out number of computation years
C
      SUBROUTINE COMPYR(NP,NDROPP,NELAPP,DIDRPP,IOUT)
      INTEGER NP,NDROPP,NELAPP,IOUT,DIDRPP
      LOGICAL BOOL1,BOOL2
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
    1 FORMAT ('      Years wholly within disability freeze:')
    2 FORMAT ('      No years wholly within disability freeze'/)
    3 FORMAT ('         ',I4,' to ',I4)
    4 FORMAT ('         and')
    5 FORMAT ('      Number of DI dropout years =',I3/)
   20 FORMAT ('      Number of elapsed years =',I3/)
   21 FORMAT ('      Number of dropout years =',I3/)
   22 FORMAT ('      Number of computation years = ',I3,' -',I2,' = ',
     &I2)
      IF (VALDI.GT.0) THEN
        BOOL1 = FRZYR2.GE.FRZYR1
        BOOL2 = FRZYR4.GE.FRZYR3.AND.VALDI.GT.1
        IF (BOOL1.OR.BOOL2) THEN
          WRITE (IOUT,1)
          IF (BOOL2) WRITE (IOUT,3) FRZYR3,FRZYR4
          IF (BOOL1.AND.BOOL2) WRITE (IOUT,4)
          IF (BOOL1) WRITE (IOUT,3) FRZYR1,FRZYR2
          WRITE (IOUT,*)
        ELSE
          WRITE (IOUT,2)
        END IF
      END IF
      WRITE (IOUT,5) DIDRPP
      WRITE (IOUT,20) NELAPP
      WRITE (IOUT,21) NDROPP
      WRITE (IOUT,22) NELAPP,NDROPP,NP
      RETURN
      END
C
C  Subroutine to write out PIA and MFB at entitlement
C
C  I10    = method number.
C
      SUBROUTINE PIAMFB(I10,IOUT)
      INTEGER I10,IOUT
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
   45 FORMAT ('      PIA at entitlement =',F9.2/)
   46 FORMAT ('      MFB at entitlement =',F9.2/)
   47 FORMAT ('      MFB at entitlement ='/8X,F4.2,' *',F9.2)
   48 FORMAT ('        (MFB cap on DI cases) =',F9.2/)
      WRITE (IOUT,45) PIA(I10)
      IF (ICAP(I10).EQ.1.OR.ICAP(I10).EQ.3) THEN
        WRITE (IOUT,47) CAP(I10),PIA(I10)
        WRITE (IOUT,48) MFB(I10)
      ELSE
        WRITE (IOUT,46) MFB(I10)
      END IF
      RETURN
      END
C
C  Subroutine to print unused earnings warning
C
      SUBROUTINE UNUSED(IOUT)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER IOUT
      WRITE (IOUT,10) IERNYR+1950
   10 FORMAT ('      Warning! Earnings after',I5,' not used')
      RETURN
      END
C
C  Subroutine to print disability-insured message
C
      SUBROUTINE DISINS(IOUT)
      INTEGER IOUT
      WRITE (IOUT,10)
   10 FORMAT ('      Warning! Worker is assumed to be disability-',
     &'insured')
      RETURN
      END
C
C  Subroutine to write out real-wage-gain adjustment
C
      SUBROUTINE PRRWG(MELGYR,IOUT,I10)
      INTEGER MELGYR,IOUT,I10
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      IF (MELGYR.LE.ISTART.OR.IALTAW.NE.6) RETURN
      WRITE (IOUT,10) 1.+.01*(MELGYR-ISTART)
   10 FORMAT ('      Real-wage-gain adjustment for PEBES calculation:'/
     &'         Factor = ',F4.2)
      WRITE (IOUT,20) PIARWG(I10)
   20 FORMAT ('         PIA after adjustment = ',F7.2)
      IF (I10.EQ.3) WRITE (IOUT,30) MFBRWG(I10)
   30 FORMAT ('         MFB after adjustment = ',F7.2)
      WRITE (IOUT,*)
      RETURN
      END
C
C  Subroutine to write title and page number at top of page
C
      SUBROUTINE PGTIT2(IOUT,PAGE)
      INTEGER IOUT,PAGE
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
    9 FORMAT ('1')
   10 FORMAT (' ',T7,A28,10X,'PIA Calculation',T70,'Page',I3//)
      PAGE=PAGE+1
      WRITE (IOUT,9)
      WRITE (IOUT,10) DATELN,PAGE
      RETURN
      END
