C  @(#)prep.f	1.34   2/24/97
C
C  Subroutine to project old and new wage bases
C
C  I      = loop counter.
C  IBCP1  = first year of CPI-indexed wage base.
C  IBCP2  = last year of CPI-indexed wage base.
C  INEWB  = new wage base indicator.
C           0 = present law projection (1994 wage base is base base).
C           1 = new base base.
C  ISTYR  = year of last known wage base.
C
      SUBROUTINE WGBSST(INEWB,IBCP1,IBCP2)
      INTEGER IBCP1,IBCP2,I,ISTYR,INEWB
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piaparmsf.h'
      IF (INEWB.EQ.0) THEN
C  Project present-law base
        CALL WGBASE(IBCP1,IBCP2,BASE,1937,1936+IX,1951,0,ISTART+1952,
     &  CPIINC,FQ,FQINC,IX,IX-14)
      ELSE
C  Find last known base
        ISTYR = 0
        DO 100 I = 1953+ISTART,1936+IX
        IF (BASE(I-1936).EQ.0.AND.ISTYR.EQ.0) ISTYR = I - 1
  100   CONTINUE
        IF (ISTYR.EQ.0) ISTYR = 1936+IX
        CALL WGBASE(IBCP1,IBCP2,BASE,1937,1936+IX,1951,4,ISTYR,
     &  CPIINC,FQ,FQINC,IX,IX-14)
      END IF
C  Project old-law base
        CALL WGBASE(IBCP1,IBCP2,BASE77,1937,1936+IX,1951,2,
     &  ISTART+1952,CPIINC,FQ,FQINC,IX,IX-14)
      RETURN
      END
C
C  Subroutine to project steady earnings
C
      SUBROUTINE EARNPR
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
      INTEGER I
      DO 20 I=IBEGIN,IEND
      IF (EARNTP(I-1936).EQ.1) THEN
        IF (I.LT.1951) THEN
          ERNPBS(I-1936) = 3000.
        ELSE
          ERNPBS(I-1936) = 999999.
        END IF
      END IF
      IF (EARNTP(I-1936).EQ.2) ERNPBS(I-1936) = HIGH(I-1936)
      IF (EARNTP(I-1936).EQ.3) ERNPBS(I-1936) = FQ(I-1936)
      IF (EARNTP(I-1936).EQ.4) ERNPBS(I-1936) = WAGMIN(I-1936)
      IF (EARNTP(I-1936).EQ.5) ERNPBS(I-1936) = 0.
   20 CONTINUE
      RETURN
      END
C
C  This subroutine computes the year of eligibility
C
C  I1     = temporary variable.
C
      SUBROUTINE ELGYR ()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      INTEGER IELGC1,IELGC2,IELGC3
C
C  Calculate year of eligibility for worker
C
C  Start with year before age 62
      IELGYR(3) = IELGC3()
      IELGYR(1) = IELGC1(0)
C  Take disability into account
      IELGYR(3) = IELGC2(IELGYR(3))
      IELGYR(2) = IELGC2(IELGYR(1))
C  Account for age-65 computation point if proposed law
      IF (JIND(8).GT.0.AND.IELGYR(1).GE.JSTART(1,8)-1951) THEN
        IELGY1 = IELGC1(MIN0(3,IELGYR(1)+1952-JSTART(1,8)))
        IELGY1 = IELGC2(IELGY1)
      END IF
C
C  Calculate year of eligibility for widow
C
      IF (IOASDI.EQ.2.AND.JSURV.GT.1) THEN
        IF (JSURV.EQ.2) THEN
C  Disabled widow's elgyr is year before age 50, if later
          KELGYR = MAX0(LBIRTH(3)+50-1951,JONSET(3)-1951)
        ELSE
C  Aged widow's elgyr is year before age 60
          KELGYR = LBIRTH(3)+60-1951
        END IF
      END IF
      RETURN
      END
C
C  Subroutine to calculate dropout years and computation years
C  (assumes elapsed years have already been computed).
C
C  NX     = number of computation years.
C  NTYPE  = 0 if new-start, 1 if old-start.
C
      SUBROUTINE NCAL(NTYPE,NX,NDROPX,NELAPX)
      INTEGER NTYPE,NELAPX,NDROPX,NX,AMND80(2)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      INTEGER COMPMY
      DATA AMND80 / 7,1980 /
C  If death is in Sept 1954 or later, use 5 dropout years
      IF (IOASDI.EQ.2) THEN
C  If disability freeze, use 5 dropout for dis. in Sept 1954 or later
         IF (VALDI.EQ.1) THEN
            IF (IONSET(3).GT.1954.OR.(IONSET(3).EQ.1954.AND.
     &      IONSET(1).GT.8)) THEN
               NDROPX = 5
            ELSE
               NDROPX = 0
            END IF
         ELSE
            IF (IDEATH(2).GT.1954.OR.(IDEATH(2).EQ.1954.AND.
     &      IDEATH(1).GT.8)) THEN
               NDROPX = 5
            ELSE
               NDROPX = 0
            END IF
         END IF
      ELSE
C  If disability freeze, use 5 dropout for dis. in Sept 1954 or later
         IF (VALDI.EQ.1) THEN
            IF (IONSET(3).GT.1954.OR.(IONSET(3).EQ.1954.AND.
     &      IONSET(1).GT.8)) THEN
               NDROPX = 5
            ELSE
               NDROPX = 0
            END IF
         ELSE
C  If entitlement is in Sept 1954 or later, use 5 dropout
            IF (IENT(2).GT.1954.OR.(IENT(2).EQ.1954.AND.
     &      IENT(1).GT.8)) THEN
               NDROPX = 5
            ELSE
               NDROPX = 0
            END IF
         END IF
      END IF
C  1-for-5 dropout rule for DI, if not survivor
      IF ((VALDI.EQ.1.AND.COMPMY(PRRENT,AMND80).GE.0.AND.IOASDI.EQ.1).
     &OR.(COMPMY(IENT,AMND80).GE.0.AND.IOASDI.EQ.3)) THEN
         IF (NELAPX/5 .LT. 5) NDROPX = NELAPX/5
      END IF
C  Number of dropout years is 5, if JIND(15) is set
      IF (JIND(15).GT.0.AND.IENT(2).GE.JSTART(1,15).AND.IELGYR(2).GE.
     &JSTART(1,15)-1953) NDROPX = 5
C
      NX = MAX0(NELAPX-NDROPX,2)
      NDROPX=NELAPX-NX
C
C  Retirement modification prior to 1958
C
      IF (IOASDI.EQ.1.AND.IENT(2).LT.1958.AND.NTYPE.EQ.0) THEN
      NX=IELGYR(2)-2
      IF (NX.LT.2) NX=2
      NDROPX=NELAPX-NX
      END IF
      RETURN
      END
C
C  Subroutine to calculate elapsed years and DI dropout years
C
C  NELAP0 = start year.
C  NELAP1 = first elapsed year.
C  NELAP2 = last elapsed year.
C  NTYPE  = 0 if new-start, 1 if old-start.
C
      SUBROUTINE NELAPC(NTYPE,NELAPX,DIDRPX)
      INTEGER NTYPE,NELAP0,NELAP1,NELAP2,NELAPX,DIDRPX
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
      INTEGER DROPCA
C  Set first elapsed year
      IF (NTYPE .EQ. 1) THEN
        NELAP0 = 1936
      ELSE
        NELAP0 = 1950
      END IF
      NELAP1 = MAX0(KBIRTH(3)+21,NELAP0)
C  Set last elapsed year
      IF (JIND(8).GT.0.AND.IELGYR(1).GE.JSTART(1,8)-1951) THEN
        IF (((IOASDI.EQ.2.AND.IDEATH(2).GT.1960).OR.
     &  (IOASDI.NE.2.AND.IENT(2).GT.1960)).AND.
     &  IELGY1.LT.10.AND.VALDI.EQ.0) THEN
          NELAP2 = 1960
        ELSE
          NELAP2 = 1950+IELGY1
        END IF
      ELSE
        IF (((IOASDI.EQ.2.AND.IDEATH(2).GT.1960).OR.
     &  (IOASDI.NE.2.AND.IENT(2).GT.1960)).AND.
     &  IELGYR(2).LT.10.AND.VALDI.EQ.0) THEN
          NELAP2 = 1960
        ELSE
          NELAP2 = 1950+IELGYR(2)
        END IF
      END IF
      NELAPX = NELAP2 - NELAP1
      IF (JIND(8).GT.0.AND.IELGYR(1).GE.JSTART(1,8)-1951) THEN
        NELAPX = MIN0(NELAPX,43)
      ELSE
        NELAPX = MIN0(NELAPX,40)
      END IF
C  Check for years wholly or partially within period of disability
      DIDRPX = DROPCA(NELAP1,NELAP2)
      IF (DIDRPX.GT.0) NELAPX = NELAPX - DIDRPX
C  Use at least 2 elapsed years
      IF (NELAPX.LT.2) NELAPX = 2
      RETURN
      END
C
C  Function to compute year of eligibility before considering disability
C
C  JIND8  = 0 for present law, 1-3 for change to age-65 comp point
C
      INTEGER FUNCTION IELGC1(JIND8)
      INTEGER JIND8
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Start with year before age 62
      IELGC1 = KBIRTH(3)+62-1951
C  Account for age-65 computation point if proposed law
      IF (JIND8.GT.0)
     &IELGC1 = IELGC1 + JIND8
C  Account for age-65 computation point for older workers
      IF (ISEX.EQ.1.AND.IELGC1.LT.24) IELGC1 = MIN(24,IELGC1+3)
C  For survivors, IELGC1 is year before death
      IF (IOASDI.EQ.2.AND.IELGC1.GT.IDEATH(2)-1951)
     &IELGC1 = IDEATH(2)-1951
      RETURN
      END
C
C  Function to compute year of eligibility after considering disability
C
C  IELGYX = year prior to year of worker's attainment of age 62, for
C             old-age and disability, or year prior to year of worker's
C             death, for survivor.
C *JONSET = month, day, year of widow's disability onset (0 if none)
C             (year is 4 digits).
C
      INTEGER FUNCTION IELGC2 (IELGYX)
      INTEGER IELGYX
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      IELGC2 = IELGYX
C  Consider disability onset prior to eligibility
      IF (IOASDI.LT.3.AND.VALDI.EQ.1.AND.
     &IELGC2.GT.IONSET(3)-1951) IELGC2 = IONSET(3)-1951
      IF (IOASDI.EQ.3.AND.IELGC2.GT.IONSET(3)-1951)
     &IELGC2 = IONSET(3)-1951
      RETURN
      END
C
C  Function to compute year of eligibility before considering disability,
C  without considering prior age-65 comp point
C
      INTEGER FUNCTION IELGC3()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Start with year before age 62
      IELGC3 = KBIRTH(3) + 62 - 1951
C  For survivors, IELGC3 is year before death
      IF (IOASDI.EQ.2.AND.IELGC3.GT.IDEATH(2)-1951)
     &IELGC3 = IDEATH(2) - 1951
      RETURN
      END
C
C  Function to calculate relative earnings position
C
      REAL FUNCTION REPCAL()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'piadataf.h'
      INTEGER TEMP,I,QTR
      REAL TEST,REPTOT
      REPTOT = 0.
C  Reset years of earnings, if necessary
      IF (IBEGIN.GT.KBIRTH(3)+22) THEN
        TEMP = MAX0(KBIRTH(3)+22,1937)
        DO 80 I=TEMP-1936,IBEGIN-1937
   80   EARNST(I,1) = 0.
        IBEGIN = TEMP
      END IF
      IF (IEND.LT.IELGYR(2)+1951) THEN
        TEMP = IELGYR(2)+1951
        DO 90 I=IEND-1935,TEMP-1936
   90   EARNST(I,1) = 0.
        IEND = TEMP
      END IF
C  Calculate relative earnings position
      DO 100 I=IBEGIN-1936,IEND-1936
      IF (IQC(I).GT.0) THEN
        TEST = DMIN1(IQC(I)*BASE(I)/4.,EARNST(I,1))
        REP(I) = ANINT(TEST/FQ(I)*100000.)/100000.
      ELSE
        REP(I) = 0.
      END IF
  100 REPTOT = REPTOT + REP(I)
      REPCAL = ANINT(400000.*REPTOT/IQCTOT)/100000.
      IF (IOASDI.EQ.2.AND.IDEATH(2).EQ.IELGYR(2)+1951) THEN
        TEMP = IELGYR(2) + 16
      ELSE
        TEMP = IELGYR(2) + 15
      END IF
      DO 110 I=IBEGIN-1936,IEND-1936
C  Fill in earnings from 22 to eligibility, plus other years with at
C  least 1 QC
      IF (((I.LT.KBIRTH(3)-1914.OR.I.GT.TEMP-1).AND.IQC(I).GT.0).OR.
     &(I.GT.KBIRTH(3)-1915.AND.I.LT.TEMP))
     &EARNST(I,2) = REPCAL*FQ(I)
C  Prorate by quarter in year of death
      IF (I.EQ.IDEATH(2)-1937) THEN
        QTR = (IDEATH(1)+2)/3
        EARNST(I,2) = EARNST(I,2)*QTR/4.
      END IF
  110 EARNST(I,2) = ANINT(100.*EARNST(I,2))/100.
      RETURN
      END
C*******************************************
C  Function to check data for validity
C*******************************************
      INTEGER FUNCTION DATCHK()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER KBIRT2(2),IONST2(2),FVAL
C  Function declarations
      INTEGER AGECHK,BEGCHK,QCCHK,DTHCHK,DISCHK,WIDCHK,JSURCK,PBSACK,
     &ARDRI,ENDCHK,PRRCHK,WAITCK,SOASDI,COMPMY,IENTCK,BNDTCK
      LOGICAL NEEDBI,NEEDAW
      DATCHK = 0
      FVAL = 0
      IOASDI = SOASDI()
      IF (JOASDI.EQ.4) THEN
        CALL STPBDT
        CALL SETBIR(IBIRTH,KBIRTH)
C  IELGYR(2) is not yet calculated for PEBES case; use KBIRTH(3)+62
C  since there is no prior disability in PEBES case
        CALL NRACAL(KBIRTH(3)+61-1950,NRA)
        KBIRT2(1) = KBIRTH(1)
        KBIRT2(2) = KBIRTH(3)
        CALL DATCAL(NRADAT,KBIRT2,NRA)
        FVAL = AGECHK(NRADAT)
        IF (FVAL.GT.0) THEN
          DATCHK = FVAL
          RETURN
        END IF
      ELSE
        FVAL = IENTCK()
        IF (FVAL.GT.0) THEN
          DATCHK = FVAL
          RETURN
        END IF
        IF (RECALC) THEN
          FVAL = BNDTCK()
          IF (FVAL.GT.0) THEN
            DATCHK = FVAL
            RETURN
          END IF
        ELSE
          CALL STBNDT
        END IF
        IF (IOASDI.EQ.3) VALDI = 1
        FVAL = BEGCHK()
        IF (FVAL.GT.0) THEN
          DATCHK = FVAL
          RETURN
        END IF
        FVAL = ENDCHK()
        IF (FVAL.GT.0) THEN
          DATCHK = FVAL
          RETURN
        END IF
        CALL SETBIR(IBIRTH,KBIRTH)
        CALL NRACAL(KBIRTH(3)+61-1950,NRA)
        KBIRT2(1) = KBIRTH(1)
        KBIRT2(2) = KBIRTH(3)
        CALL DATCAL(NRADAT,KBIRT2,NRA)
      END IF
C  Set early retirement age
      IF (IOASDI.EQ.1) CALL NRA1C
      IF (JOASDI.NE.4) THEN
        CALL ENTAGE(IAGE,KBIRTH,IENT)
        CALL ENTAGE(IAGE1,KBIRTH,BENDAT)
        IAGPLN = 0
      END IF
      CALL QCTDCK
      FVAL = QCCHK()
      IF (FVAL.GT.0) THEN
        DATCHK = FVAL
        RETURN
      END IF
      FVAL = DTHCHK()
      IF (FVAL.GT.0) THEN
        DATCHK = FVAL
        RETURN
      END IF
      FVAL = JSURCK()
      IF (FVAL.GT.0) THEN
        DATCHK = FVAL
        RETURN
      END IF
      IF (VALDI.EQ.1) THEN
C  Write error message if onset after normal retirement age
        IONST2(1) = IONSET(1)
        IONST2(2) = IONSET(3)
        IF (COMPMY(IONST2,NRADAT).GE.0) THEN
          DATCHK = 159
          RETURN
        END IF
        FVAL = DISCHK()
        IF (FVAL.GT.0) THEN
          DATCHK = FVAL
          RETURN
        END IF
        IF (IOASDI.EQ.1) THEN
C  Write error message if entitlement after normal retirement age
          IF (COMPMY(PRRENT,NRADAT).GE.0) THEN
            DATCHK = 162
            RETURN
          END IF
          FVAL = PRRCHK()
          IF (FVAL.GT.0) THEN
            DATCHK = FVAL
            RETURN
          END IF
        END IF
      END IF
      IF (IOASDI.EQ.3) THEN
        FVAL = WAITCK()
        IF (FVAL.GT.0) THEN
          DATCHK = FVAL
          RETURN
        END IF
      END IF
      IF (JSURV.GT.1) THEN
        CALL SETBIR(JBIRTH,LBIRTH)
        CALL ENTAGE(JAGE,LBIRTH,IENT)
      END IF
      IF (JSURV.EQ.2) THEN
        FVAL = WIDCHK()
        IF (FVAL.GT.0) THEN
          DATCHK = FVAL
          RETURN
        END IF
      END IF
      IF (JOASDI.EQ.4) THEN
        FVAL = PBSACK()
        IF (FVAL.GT.0) THEN
          DATCHK = FVAL
          RETURN
        END IF
        IBASCH = 1
      ELSE
        CALL ELGYR
        FVAL = ARDRI()
        IF (FVAL.GT.0) THEN
          DATCHK = FVAL
          RETURN
        END IF
        IF (.NOT.NEEDBI()) IALTBI = 5
        IF (.NOT.NEEDAW()) IALTAW = 5
        IF (ANSCCH.NE.'Y') CALL ZEROCH
      END IF
      RETURN
      END
C*****************************************************
C  This subroutine projects average wages to 1936+IX.
C
C  Definition of variables (* is a dimensioned array, with indices
C    I, J, K, ... ):
C
C  I      = temporary index used in DO-loops.
C
      SUBROUTINE AVGPRO
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piaparmsf.h'
      INTEGER I
      DO 200 I=ISTART+14,IX
      FQ(I)=FQ(I-1)*(FQINC(I)/100.+1.)
C  Round to nearest penny
  200 FQ(I) = (AINT(FQ(I)*100.+.5))/100.
      RETURN
      END
C
C  Subroutine to calculate a date by adding year and month to prior date
C
      SUBROUTINE DATCAL(NEWDAT,OLDDAT,AGE)
      INTEGER NEWDAT(2),OLDDAT(2),AGE(2)
      NEWDAT(1) = OLDDAT(1) + AGE(2)
      NEWDAT(2) = OLDDAT(2) + AGE(1)
      IF (NEWDAT(1).GT.12) THEN
        NEWDAT(1) = NEWDAT(1) - 12
        NEWDAT(2) = NEWDAT(2) + 1
      END IF
      RETURN
      END
C
C  Subroutine to calculate worker age at entitlement
C
      SUBROUTINE ENTAGE(AGE,BIRTH,DATE1)
      INTEGER AGE(2),BIRTH(3),DATE1(2)
      AGE(1) = DATE1(2)-BIRTH(3)
      AGE(2) = DATE1(1)-BIRTH(1)
C  Adjust age downward if less than 0 months
      IF (AGE(2).LT.0) THEN
        AGE(2) = AGE(2)+12
        AGE(1) = AGE(1)-1
      END IF
C  Adjust age upward if more than 11 months
      IF (AGE(2).GT.11) THEN
        AGE(2) = AGE(2)-12
        AGE(1) = AGE(1)+1
      END IF
      RETURN
      END
C
C  Subroutine to project earnings at constant percentage rate
C
      SUBROUTINE ERNPRO
      INTEGER I
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
      DO 90 I=IBEGN1-1936,IEND1-1936
   90 EARNST(I,1) = ERNPBS(I)
      IF (PRBACK.GT.0) THEN
        DO 100 I=IBEGN1-1937,IBEGIN-1936,-1
        IF (PRBACK.EQ.2) THEN
          EARNST(I,1) = EARNST(I+1,1)/(1.+PERCFD/100.)
        ELSE
          EARNST(I,1) = EARNST(I+1,1)/(1.+(FQINC(I+1)+PERCFD)/100.)
        END IF
        IF (EARNST(I,1).GT.999999.99) THEN
          EARNST(I,1) = 999999.99
          EARNST(I,5) = 999999.99
          OVRMAX = 1
        END IF
  100   CONTINUE
      END IF
      IF (PRFWRD.GT.0) THEN
        DO 110 I=IEND1-1935,IEND-1936
        IF (PRFWRD.EQ.2) THEN
          EARNST(I,1) = EARNST(I-1,1)*(1.+PERCFD/100.)
        ELSE
          EARNST(I,1) = EARNST(I-1,1)*(1.+(FQINC(I)+PERCFD)/100.)
        END IF
        IF (EARNST(I,1).GT.999999.99) THEN
          EARNST(I,1) = 999999.99
          EARNST(I,5) = 999999.99
          OVRMAX = 1
        END IF
  110   CONTINUE
      END IF
C  Calculate HI earnings
      DO 120 I=IBEGIN-1936,IEND-1936
  120 EARNST(I,5) = EARNST(I,1) + EARNHI(I)
      DO 140 I=IBEGIN-1937,1,-1
      EARNST(I,1) = 0.
  140 EARNST(I,5) = 0.
      DO 150 I=IEND-1935,IX
      EARNST(I,1) = 0.
  150 EARNST(I,5) = 0.
C  Limit earnings to wage base
      CALL ERNLIM(3, 1, BASE)
      CALL ERNLIM(6, 5, BASEHI)
      RETURN
      END
C
C  Subroutine to limit earnings to wage base
C
C *BASET  = wage base in year 1936+I.
C  INDEX1 = index of limited earnings
C  INDEX2 = index of unlimited earnings
C
      SUBROUTINE ERNLIM(INDEX1,INDEX2,BASET)
      INTEGER INDEX1,INDEX2,I
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      DOUBLE PRECISION BASET(IX)
      DO 100 I=1,IX
  100 EARNST(I,INDEX1) = DMIN1(EARNST(I,INDEX2),BASET(I))
      RETURN
      END
