C  @(#)scanfile.f	1.19   2/24/97
C
C  This subroutine reads in the change from present law indicators and
C  any additional information from a file and transfers them to the
C  calling program.
C
C  Definition of variables (* is a dimensioned array, with indices
C    I, J, K, ... )
C
C  I      = temporary index used in do-loops.
C  I1     = temporary index used in various places.
C  I2     = temporary index used in various places.
C  NUMB   = number of chosen proposal.
C
      SUBROUTINE LWCHGF (IN)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INTEGER IN,I,I1,I2
C
C  FORMAT statements
    1 FORMAT (' Error reading JIND')
    2 FORMAT (' End of file reading JIND')
    3 FORMAT (' Error reading JSTART')
    4 FORMAT (' End of file reading JSTART')
    5 FORMAT (' Error reading JIND data')
    6 FORMAT (' End of file reading JIND data')
C
C  Read indicators for change from present law
C
      DO 100 I=1,MAXJND
  100 JIND(I) = 0
      JINDT = 0
      READ (IN,*,ERR=900,END=901) JIND
      DO 180 I=1,MAXJND
  180 JINDT = JINDT + JIND(I)
C
C  Read additional parameters
C
      IF (JIND(2).GT.0) THEN
C  If this run uses fraction-of-wage rate for bend points, read in years
C  affected
      READ (IN,*,ERR=902,END=903) JSTART(1,2)
      READ (IN,*,ERR=902,END=903) JSTART(2,2)
      READ (IN,*,ERR=904,END=905) PBP
      END IF
C  If this run uses CPI-indexed bend points, read in years affected
      IF (JIND(3).GT.0) THEN
      READ (IN,*,ERR=902,END=903) JSTART(1,3)
      READ (IN,*,ERR=902,END=903) JSTART(2,3)
      END IF
      IF (JIND(4).GT.0) THEN
C  If this run uses CPI-indexed earnings, read in years affected
      READ (IN,*,ERR=902,END=903) JSTART(1,4)
      READ (IN,*,ERR=902,END=903) JSTART(2,4)
      END IF
      IF (JIND(5).GT.0) THEN
C  Read in effective date, percentages and bend points for alternative
C  bend point formula
      READ (IN,*,ERR=902,END=903) JSTART(1,5),JSTART(2,5)
      READ (IN,*,ERR=904,END=905) NUMBP
      DO 200 I=JSTART(1,5),JSTART(2,5)
      READ (IN,*,ERR=904,END=905) (PERCPA(I1,I-1936),I1=1,NUMBP+1)
      READ (IN,*,ERR=904,END=905) (IBENPA(I1,I-1936),I1=2,NUMBP+1)
  200 CONTINUE
      END IF
      IF (JIND(6).GT.0) THEN
C  If this run uses specified increases for bend points, read in
C  years affected
      READ (IN,*,ERR=902,END=903) JSTART(1,6)
      READ (IN,*,ERR=902,END=903) JSTART(2,6)
      I1 = JSTART(1,6)
      I2 = JSTART(2,6)
C  Read in specified bend point increases
      DO 917 I=I1,I2
      READ (IN,*,ERR=904,END=905) BPINC(I-1950)
  917 CONTINUE
      END IF
      IF (JIND(7).GT.0) THEN
C  If this run uses constant percentage decline from wage increase
C  for bend point increase, read in years affected
      READ (IN,*,ERR=902,END=903) JSTART(1,7)
      READ (IN,*,ERR=902,END=903) JSTART(2,7)
      READ (IN,*,ERR=904,END=905) CP
      END IF
C  If this run uses age-65 computation point, read first year of
C  phase-in
      IF (JIND(8).GT.0) THEN
        READ (IN,*,ERR=902,END=903) JSTART(1,8)
      END IF
      IF (JIND(9).GT.0) THEN
C  If this run uses declining benefit formula percents, read in
C  years affected
      READ (IN,*,ERR=902,END=903) JSTART(1,9)
      READ (IN,*,ERR=902,END=903) JSTART(2,9)
      READ (IN,*,ERR=904,END=905) CP
      END IF
      IF (JIND(10).GT.0) THEN
C  If this run eliminates benefit increase in year of eligibility, read
C  beginning year
      READ (IN,*,ERR=902,END=903) JSTART(1,10)
      END IF
      IF (JIND(11).GT.0) THEN
      READ (IN,*,ERR=902,END=903) JSTART(1,11)
      END IF
C  If this run changes windfall elimination provision, read starting
C  year
      IF (JIND(12).GT.0) THEN
      READ (IN,*,ERR=902,END=903) JSTART(1,12)
      END IF
C  If this run changes special minimum, read starting year
      IF (JIND(13).GT.0) THEN
        READ (IN,*,ERR=902,END=903) JSTART(1,13)
C  Read dollar amount, if applicable
        IF (MOD(JIND(13),2).EQ.1) READ (IN,*,ERR=904,END=905) ASPMIN
C  Read maximum years, if applicable
        IF (MOD(JIND(13),4).EQ.2.OR.MOD(JIND(13),4).EQ.3)
     &  READ (IN,*,ERR=904,END=905) JSPMIN
C  Read percent of wage base for year of coverage, if applicable
        IF (JIND(13).GT.3) READ (IN,*,ERR=904,END=905) BSPMIN
      END IF
C  If this run eliminates old-start, read starting year
      IF (JIND(14).GT.0) THEN
      READ (IN,*,ERR=902,END=903) JSTART(1,14)
      END IF
C  If this run removes variable DI dropout years, read first year of
C  entitlement
      IF (JIND(15).GT.0) THEN
        READ (IN,*,ERR=902,END=903) JSTART(1,15)
      END IF
C  If this run eliminates PIA Table, read starting year
      IF (JIND(23).GT.0) THEN
      READ (IN,*,ERR=902,END=903) JSTART(1,23)
      END IF
C  If this run eliminates Transitional Guar, read starting year
      IF (JIND(24).GT.0) THEN
      READ (IN,*,ERR=902,END=903) JSTART(1,24)
      END IF
C  If this run eliminates age-67 retirement, read starting year
      IF (JIND(27).GT.0) THEN
      READ (IN,*,ERR=902,END=903) JSTART(1,27)
      END IF
C  If this run has retroactive wage indexing, read starting year
      IF (JIND(29).GT.0) THEN
      READ (IN,*,ERR=902,END=903) JSTART(1,29)
      END IF
C  If this run has Myers cpi-holdback, read years and amounts
      IF (JIND(30).GT.0) THEN
      READ (IN,*,ERR=902,END=903) JSTART(1,30),JSTART(2,30),ERN30,
     &PIA30
      END IF
      RETURN
C
C  Error messages
C
  900 WRITE (6,1)
      CALL EXIT(1)
  901 WRITE (6,2)
      CALL EXIT(1)
  902 WRITE (6,3)
      CALL EXIT(1)
  903 WRITE (6,4)
      CALL EXIT(1)
  904 WRITE (6,5)
      CALL EXIT(1)
  905 WRITE (6,6)
      CALL EXIT(1)
      END
C
C  Subroutine to read earnings from file
C
      INTEGER FUNCTION EARNF(IN)
      INCLUDE 'wrkrdataf.h'
      INTEGER I,IN
      EARNF = 0
      DO 10 I=IBEGN1-1936,IEND1-1936
      IF (EARNTP(I).EQ.0) THEN
        READ (IN,*,ERR=900) ERNPBS(I)
        IF (ERNPBS(I).GT.999999.99.OR.ERNPBS(I).LT.-1) EARNF = 28
      END IF
   10 CONTINUE
      RETURN
  900 EARNF = 69
      RETURN
      END
C
C  This subroutine retrieves average wages and/or average wage
C  increases for the latest Trustees Report alternatives from DATA
C  statements.
C
C  To update every year:
C    1. Delete the first year of data from TFQINC for all alternatives.
C    2  Adjust first ten years of data from TFQINC for all alternatives.
C    3. Increase parameter ISTRT2 by 1.
C    4. Check all dates (e.g. 1990 Trustees Report).
C  To update every 5 years:
C    1. Increase IX by 5 (when it is increased in ANYPIA).
C    2. Add 5 more years of data to TFQINC (when IYR increases in
C       ANYPIA).
C
C  Definition of variables (* is a dimensioned array, with indices
C    I, J, K, ... ):
C
C  I      = temporary index used in DO-loops.
C  ISTRT2 = first year of average wage projection minus 1936.
C *TFQINC = average wage increases (percent) in latest Trustees Report
C           I=1 is alt I, 2 is alt II, 3 is alt III, 4 is flat.
C           J=1 is 1937, 2 is 1938, ..., IX is 1936+IX.
C
      INTEGER FUNCTION AVGMEN()
      INTEGER ISTRT2, I
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piaparmsf.h'
      REAL TFQINC(4,IX)
      PARAMETER (ISTRT2 = 60)
C  1996 Trustees Report alt I average wages from 1996 to 2006, and
C  wage increases from 2007 on
      DATA (TFQINC(1,I),I=ISTRT2,IX)
     &/25681.63,26825.33,28004.92,29285.34,30612.08,31959.65,
     &33376.61,34870.04,36430.05,38091.67,39500.00,69*4.5/
C  1996 Trustees Report alt II average wages from 1996 to 2006, and
C  wage increases from 2007 on
      DATA (TFQINC(2,I),I=ISTRT2,IX)
     &/25638.88,26713.19,27765.16,28920.03,30141.03,31438.18,
     &32866.13,34448.89,36150.94,37968.04,40000.00,69*5.0/
C  1996 Trustees Report alt III average wages from 1996 to 2006, and
C  wage increases from 2007 on
      DATA (TFQINC(3,I),I=ISTRT2,IX)
     &/25350.67,26228.37,27628.78,28834.17,30201.60,31756.04,
     &33309.98,35014.17,36859.70,38841.32,41000.00,69*5.5/
C  Flat assumptions (no alt II-A)
C  Average wages from 1996 to 2006 and wage increases from 2007 on
      DATA (TFQINC(4,I),I=ISTRT2,IX)
     &/11*24705.66,69*0.0/
C
C  Check starting year
C
      AVGMEN = 0
      IF (ISTRT2.NE.ISTART+14) THEN
        AVGMEN = 62
        RETURN
      END IF
C
C  Set average wage increases
C
      IF (IALTAW.GT.0.AND.IALTAW.LT.5) THEN
C  Assign average wage for first year
      FQINC(ISTART+14)=(TFQINC(IALTAW,ISTART+14)/FQ(ISTART+13)-1.0)*100.
C  Fill in wage increases for all other years
      DO 100 I=ISTART+15,IX
      FQINC(I)=TFQINC(IALTAW,I)
      IF(FQINC(I).GT.12.)
     &FQINC(I)=(TFQINC(IALTAW,I)/TFQINC(IALTAW,I-1) -1.)*100.
  100 CONTINUE
      ELSE
C  Set flat and PEBES assumptions
      DO 200 I=ISTART+14,IX
  200 FQINC(I)= 0.0
      END IF
      RETURN
      END
C
C  This subroutine retrieves benefit increases for the latest Trustees
C  Report alternatives from DATA statements.  Benefit increases are
C  then projected to 2070.
C
C  To update every year:
C    1. Delete the first year of data from TCPINC for all alternatives.
C    2. Increase parameter ISTRT2 by 1.
C  To update every 5 years:
C    1. Increase IYR by 5 (when it is increased in ANYPIA).
C    2. Add 5 more years of data to TCPINC (when IYR increases in
C       ANYPIA).
C
C  Definition of variables (* is a dimensioned array, with indices
C    I, J, K, ... ):
C
C  I      = temporary index used in DO-loops.
C  I1     = temporary index used in DO-loops.
C  ISTRT2 = first year of projected benefit increase, minus 1950.
C *TCCHUP = catch-up benefit increases (percent) in latest Trustees
C           Report.
C           I=1 is alt I, 2 is alt II, 3 is alt III, 4 is flat.
C           J=1 is year of eligibility 1951+ISTART or earlier, 2 is year
C             of eligibility 1952+ISTART, ..., 10 is 1960+ISTART or
C             later.
C           K=1 is benefit increase in 1953+ISTART, 2 is 1954+ISTART,
C             ..., 8 is benefit increase in 1960+ISTART.
C *TCPINC = benefit increases (percent) in latest Trustees Report.
C           I=1 is alt I, 2 is alt II, 3 is alt III, 4 is flat.
C           J=1 is 1951, 2 is 1952, ..., IYR is 1950+IYR.
C
      INTEGER FUNCTION BENMEN ()
      INTEGER ISTRT2,I,I1
      INCLUDE 'wrkrdataf.h'
      REAL TCPINC(4,IYR),TCCHUP(4,10,8)
      PARAMETER (ISTRT2 = 47)
C  1996 Trustees Report alt I benefit increases
      DATA (TCPINC(1,I),I=ISTRT2,IYR)
     &/2.9,3.0,3.0,3.0,75*3.0/
C  1996 Trustees Report alt II benefit increases
      DATA (TCPINC(2,I),I=ISTRT2,IYR)
     &/3.2,3.3,3.4,3.5,3.7,3.9,73*4.0/
C  1996 Trustees Report alt III benefit increases
      DATA (TCPINC(3,I),I=ISTRT2,IYR)
     &/3.2,5.8,5.1,4.5,5.0,5.0,73*5.0/
C  Flat assumptions (no alt II-A)
      DATA (TCPINC(4,I),I=ISTRT2,IYR)
     &/79*0.0/
C  1996 Trustees Report alt I catch-up benefit increases
      DATA ((TCCHUP(1,I,I1),I1=1,8),I=1,10) / 80*0. /
C  1996 Trustees Report alt II catch-up benefit increases
      DATA ((TCCHUP(2,I,I1),I1=1,8),I=1,10) / 80*0. /
C  1996 Trustees Report alt III catch-up benefit increases
      DATA ((TCCHUP(3,I,I1),I1=1,8),I=1,10) / 80*0. /
C  1996 Trustees Report alt II-A catch-up benefit increases
      DATA ((TCCHUP(4,I,I1),I1=1,8),I=1,10) / 80*0. /
C
C  Check starting year
C
      BENMEN = 0
      IF (ISTRT2.NE.1+ISTART) THEN
        BENMEN = 61
        RETURN
      END IF
C
C  Set benefit increases
C
      DO 150 I=ISTART+1,IYR
      IF (IALTBI.GT.0.AND.IALTBI.LT.5) THEN
      CPIINC(I)=TCPINC(IALTBI,I)
      ELSE
      CPIINC(I)=0.
      END IF
  150 CONTINUE
C  Set catch-up increases
      IF (IALTBI.GT.4) THEN
        CALL ZEROCH
      ELSE
      DO 220 I1=1,8
      DO 220 I=1,10
  220 CACHUP(I,I1)=TCCHUP(IALTBI,I,I1)
      END IF
      RETURN
      END
