C  @(#)setup.f	1.14   2/24/97
C
C  Various subroutines to set up the PIA program.
C
C  This subroutine sets the titles of the assumptions that have no future
C  benefit increases or average wage increases.
C
      SUBROUTINE ASMTIT(PROGFL)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      CHARACTER*80 TITFIL,PROGFL
      INTEGER IN,I,I2
    1 FORMAT ('   Reading titles of assumptions from ',A40)
    2 FORMAT (A65)
      CALL FTITLR(PROGFL,IN,TITFIL,ISTART)
      WRITE (6,1) TITFIL
      DO 100 I=1,4
      READ (IN,2) TITASM(I)
  100 TITBSM(I) = TITASM(I)
      CLOSE (IN)
C  Set average wage assumption title
      I = 1949+ISTART
      I2 = I/1000
      TITASM(5)(20:20) = CHAR(48+I2)
      I = I-1000*I2
      I2 = I/100
      TITASM(5)(21:21) = CHAR(48+I2)
      I = I-100*I2
      I2 = I/10
      TITASM(5)(22:22) = CHAR(48+I2)
      I = I-10*I2
      TITASM(5)(23:23) = CHAR(48+I)
C  Set benefit increase assumption title
      I = 1951+ISTART
      I2 = I/1000
      TITBSM(5)(28:28) = CHAR(48+I2)
      I = I-1000*I2
      I2 = I/100
      TITBSM(5)(29:29) = CHAR(48+I2)
      I = I-100*I2
      I2 = I/10
      TITBSM(5)(30:30) = CHAR(48+I2)
      I = I-10*I2
      TITBSM(5)(31:31) = CHAR(48+I)
      RETURN
      END
C
C  Subroutine to get historical program amounts
C
      INTEGER FUNCTION GETHST(PROGFL,IN)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piaparmsf.h'
      CHARACTER*80 OLDFIL,PROGFL
      INTEGER IN,I
C  Open file with historical program parameters
      CALL FOLDR(PROGFL,IN,OLDFIL,ISTART)
      DO 100 I=1,ISTART
  100 READ (IN,*,END=900,ERR=920) CPIINC(I)
      DO 110 I=1,ISTART+13
  110 READ (IN,*,END=900,ERR=920) FQ(I)
      DO 120 I=2,ISTART+13
  120 FQINC(I) = 100.*(FQ(I)/FQ(I-1)-1.)
      DO 130 I=1,ISTART+15
  130 READ (IN,*,END=900,ERR=920) BASE(I)
      DO 132 I=1,54
  132 BASEHI(I) = BASE(I)
      DO 135 I=55,ISTART+15
  135 READ (IN,*,END=900,ERR=920) BASEHI(I)
      DO 140 I=1,ISTART+15
  140 READ (IN,*,END=900,ERR=920) BASE77(I)
      IF (IN.NE.5) CLOSE (IN)
      GETHST = 0
      RETURN
  900 WRITE (6,910) OLDFIL
  910 FORMAT ('   End of file reading from ',A80)
      GETHST = 72
      RETURN
  920 WRITE (6,930) OLDFIL
  930 FORMAT ('   Error reading from ',A80)
      GETHST = 72
      RETURN
      END
C
C  Subroutine to get law changes
C
      INTEGER FUNCTION GTLWCH(PROGFL)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'lawchgf.h'
      CHARACTER*80 PROGFL
      CHARACTER*15 LWCHFL
      INTEGER IN
      CALL FLWCHR(PROGFL,IN,LWCHFL)
      IF (IPRMPT.GT.0) WRITE (6,10) LWCHFL
   10 FORMAT ('   Reading law changes from ',A15)
      CALL LWCHGF(IN)
      IF (IN.NE.5) CLOSE (IN)
      GTLWCH = 0
      RETURN
      END
C
C  Subroutine to get base year
C
      INTEGER FUNCTION GTBSYR(PROGFL)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      CHARACTER*80 PROGFL
      CHARACTER*15 BASFIL
      INTEGER IN
      CALL FBASER(PROGFL,IN,BASFIL)
      IF (IPRMPT.GT.0) WRITE (6,10) BASFIL
   10 FORMAT ('   Reading computation year from ',A15)
      READ (IN,*,END=900,ERR=920) ISTART
      ISTART = ISTART - 1951
      IF (IN.NE.5) CLOSE (IN)
      GTBSYR = 0
      RETURN
  900 WRITE (6,910) BASFIL
  910 FORMAT ('   End of file reading from ',A15)
      GTBSYR = 88
      RETURN
  920 WRITE (6,930) BASFIL
  930 FORMAT ('   Error reading from ',A15)
      GTBSYR = 88
      RETURN
      END
C
C  Subroutine to save field office information
C
C  I      = temporary index.
C  IOUT   = output file number.
C
      INTEGER FUNCTION SAVEFO(PROGFL)
      CHARACTER*80 PROGFL
      CHARACTER*15 ADDFIL
      INTEGER I,IOUT
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
    2 FORMAT (A40)
      CALL FADDRW(PROGFL,IOUT,ADDFIL)
      WRITE (IOUT,2) FONAME
      WRITE (IOUT,2) FOTITL
      DO 130 I=1,4
  130 WRITE (IOUT,2) ADRESS(I)
      CLOSE (IOUT)
      SAVEFO = 0
      RETURN
      END
C
C  Subroutine to get field office address from file
C
      INTEGER FUNCTION GETFO(PROGFL)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      CHARACTER*80 PROGFL
      CHARACTER*15 FOFILE
      INTEGER IN,I
   20 FORMAT (A40)
      CALL FADDRR(PROGFL,IN,FOFILE)
      READ (IN,20,END=900,ERR=920) FONAME
      READ (IN,20,END=900,ERR=920) FOTITL
      DO 100 I=1,4
  100 READ (IN,20,END=900,ERR=920) ADRESS(I)
      IF (IN.NE.5) CLOSE (IN)
      GETFO = 0
      RETURN
  900 WRITE (6,910) FOFILE
  910 FORMAT ('   End of file reading from ',A15)
      GETFO = 91
      RETURN
  920 WRITE (6,930) FOFILE
  930 FORMAT ('   Error reading from ',A15)
      GETFO = 91
      RETURN
      END
C
C  Subroutine to save configuration to disk
C
      INTEGER FUNCTION SAVCNF(PROGFL,PRINIT)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INCLUDE 'setup.h'
      CHARACTER*80 PROGFL,PRINIT
      CHARACTER*15 CONFIL
      INTEGER IOUT
    1 FORMAT (I2)
    6 FORMAT (A40)
    7 FORMAT (A80)
      CALL FCONFW(' ',IOUT,CONFIL)
      WRITE (IOUT,1) IPRNTR,ICOLOR
      WRITE (IOUT,7) PROGFL
      WRITE (IOUT,7) PRINIT
      WRITE (IOUT,6) CMND1
      WRITE (IOUT,6) CMND2
      CLOSE (IOUT)
      SAVCNF = 0
      RETURN
      END
C
C  Subroutine to get configuration
C
      INTEGER FUNCTION GETCNF (PROGFL,PRINIT)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'setup.h'
      INTEGER IN
      CHARACTER*80 PROGFL(2),PRINIT
      CHARACTER*15 CONFIL
    1 FORMAT (A80)
   11 FORMAT (A40)
      CALL FCONFR(' ',IN,CONFIL)
      READ (IN,*,END=900,ERR=920) IPRNTR,ICOLOR
      READ (IN,1,END=900,ERR=920) PROGFL,PRINIT
      READ (IN,11,END=900,ERR=920) CMND1
      READ (IN,11,END=900,ERR=920) CMND2
      CLOSE (IN)
      GETCNF = 0
      RETURN
  900 WRITE (6,910) CONFIL
  910 FORMAT ('   End of file reading from ',A15)
      GETCNF = 67
      RETURN
  920 WRITE (6,930) CONFIL
  930 FORMAT ('   Error reading from ',A15)
      GETCNF = 67
      RETURN
      END
C
C  Subroutine to save historical program parameters
C
      INTEGER FUNCTION SAVHST(PROGFL)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INCLUDE 'piaparmsf.h'
      CHARACTER*80 OLDFIL,PROGFL
      INTEGER IOUT,I
   98 FORMAT (F4.1)
   99 FORMAT (F9.2)
  101 FORMAT (F7.0)
C  Open file to write
      CALL FOLDW(PROGFL,IOUT,OLDFIL,ISTART+1)
      DO 265 I=25,ISTART+1
  265 WRITE (IOUT,98) CPIINC(I)
      DO 270 I=1,ISTART+14
  270 WRITE (IOUT,99) FQ(I)
      DO 275 I=2,ISTART+14
  275 FQINC(I) = 100.*(FQ(I)/FQ(I-1)-1.)
      DO 280 I=1,ISTART+16
  280 WRITE (IOUT,101) BASE(I)
      DO 282 I=55,ISTART+16
  282 WRITE (IOUT,101) BASEHI(I)
      DO 285 I=1,ISTART+16
  285 WRITE (IOUT,101) BASE77(I)
      ISTART=ISTART+1
      CLOSE (IOUT)
      SAVHST = 0
      RETURN
      END
