C  @(#)two_page.f	1.26   2/24/97
C
C  This subroutine prints out a 2-page summary of a PIA calculation.
C
C  Definition of variables ('*' before variable name denotes dimensioned
C  variable array):
C
C  I      = temporary index used in do-loops.
C  IOUT   = output unit number.
C  PAGE   = page counter.
C
      SUBROUTINE TWOPG1 (IOUT,PAGE)
      INTEGER PAGE,IOUT,I
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'datamess.h'
      INTEGER PBSACK
      LOGICAL NEEDAW,NEEDBI
C
C  FORMAT statements
C
    1 FORMAT (' ',T26,'Summary of Results'/)
    3 FORMAT (/'      ',A40)
    6 FORMAT ('      Support PIA                = ',F9.2)
   12 FORMAT ('      Benefit after rounding     = ',F9.2)
   13 FORMAT ('      Benefit as of ',A9,' ',I4,' at age',I3,' and ',I2,
     &' months')
   14 FORMAT ('      Benefit as of ',A9,' ',I4)
   16 FORMAT ('      Previous disability entitlement in ',A9,' ',I4)
   17 FORMAT ('      Widow(er) born on ',A9,' ',I2,', ',I4)
   18 FORMAT ('      Widow(er) disabled on ',A9,' ',I2,', ',I4)
   19 FORMAT ('      Widow(er)''s normal retirement age = ',I2,' and ',
     &I2,' months')
   27 FORMAT ('        Not applicable')
   28 FORMAT ('        PIA = ',F9.2)
   29 FORMAT ('        MFB = ',F9.2)
   42 FORMAT ('      Normal retirement age =',I3,' and ',I2,' months')
   43 FORMAT ('      Early retirement age =',I3,' and ',I2,' months')
   47 FORMAT ('      Previous disability onset on ',A9,I3,',',I5)
   48 FORMAT ('      Benefits started in ',A9,' ',I4)
   55 FORMAT ('      Average Monthly Earnings   = ',I9)
   57 FORMAT ('      ',A6,' born on ',A9,' ',I2,', ',I4)
   58 FORMAT ('      Retired in ',A9,' ',I4,' at age',I3,' and ',I2,
     &' months')
   59 FORMAT ('      Died in ',A9,' ',I4)
   60 FORMAT ('      Benefits started in ',A9,' ',I4,' at age',I3,
     &' and ',I2,' months')
   61 FORMAT ('      Disabled on ',A9,I3,',',I5)
   62 FORMAT ('      Primary Insurance Amount   = ',F9.2)
   63 FORMAT ('      Number of months ',A9,' = ',I9)
   64 FORMAT ('      Indexed Monthly Earnings   = ',I9)
   65 FORMAT ('      Delayed increment factor   = ',F9.5)
   66 FORMAT ('      Actuarial reduction factor = ',F9.5)
   67 FORMAT ('      Benefit before rounding    = ',F9.2)
   68 FORMAT ('      Maximum Family Benefit     = ',F9.2///)
   69 FORMAT ('      Years of coverage          = ',I9)
   70 FORMAT ('      Type of beneficiary:  ',A41)
   71 FORMAT ('      Noncovered monthly pension = ',F8.2)
  180 FORMAT ('      ',A65)
      PAGE = 0
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,1)
      WRITE (IOUT,57) FMALE(ISEX),MONTH(IBIRTH(1)),IBIRTH(2),IBIRTH(3)
C  Write summary page title for retirees
      IF (IOASDI.EQ.1) THEN
        WRITE (IOUT,58)MONTH(IENT(1)),IENT(2),IAGE
        IF (RECALC) WRITE (IOUT,13) MONTH(BENDAT(1)),BENDAT(2),IAGE1
        IF (VALDI.GT.0) THEN
          WRITE (IOUT,47) MONTH(IONSET(1)),IONSET(2),IONSET(3)
          WRITE (IOUT,16) MONTH(PRRENT(1)),PRRENT(2)
        END IF
        WRITE (IOUT,42) NRA
        IF (NRA1(1).GT.0) WRITE (IOUT,43) NRA1
      END IF
C  Write summary page title for survivors
      IF (IOASDI.EQ.2) THEN
        WRITE (IOUT,59) MONTH(IDEATH(1)),IDEATH(2)
        WRITE (IOUT,48) MONTH(IENT(1)),IENT(2)
        IF (RECALC) WRITE (IOUT,14) MONTH(BENDAT(1)),BENDAT(2)
        IF (VALDI.GT.0) WRITE (IOUT,47) MONTH(IONSET(1)),IONSET(2),
     &  IONSET(3)
        WRITE (IOUT,70) SURVIV(JSURV)
        IF (JSURV.GT.1) WRITE (IOUT,17) MONTH(JBIRTH(1)),JBIRTH(2),
     &  JBIRTH(3)
        IF (JSURV.EQ.2) WRITE (IOUT,18) MONTH(JONSET(1)),JONSET(2),
     &  JONSET(3)
        IF (JSURV.EQ.3) WRITE (IOUT,19) NRA2
      END IF
C  Write summary page title for disability
      IF (IOASDI.EQ.3) THEN
        WRITE (IOUT,61) MONTH(IONSET(1)),IONSET(2),IONSET(3)
        WRITE (IOUT,60) MONTH(IENT(1)),IENT(2),IAGE
        IF (RECALC) WRITE (IOUT,13) MONTH(BENDAT(1)),BENDAT(2),IAGE1
      END IF
      IF (PUBPEN.GT.0.) WRITE (IOUT,71) PUBPEN
C  Write body of page
      DO 550 I=1,MAXCAL
      WRITE (IOUT,3) TITLE2(I)
      IF (IAPP(I).GE.1) THEN
      WRITE (IOUT,28) PIA(I)
      WRITE (IOUT,29) MFB(I)
      ELSE
      WRITE (IOUT,27)
      END IF
  550 CONTINUE
C
C  Write out bottom part of summary page
C
      WRITE (IOUT,*)
      GOTO (555,555,560,555,565,560,570) IAPPN
  555 WRITE (IOUT,55) IAME(IAPPN)
      GOTO 570
  560 WRITE (IOUT,64) IAME(IAPPN)
      GOTO 570
  565 WRITE (IOUT,69) ISPMNT(1)
  570 WRITE (IOUT,62) HIPIA
      IF (ARFAPP.GT.0) WRITE (IOUT,6) SUPPIA
      I = 1
      IF (ARF.LT.1.) I = 2
      WRITE (IOUT,63) FACTOR(I),MARDRI
      IF (ARF.GT.1.0) WRITE (IOUT,65) ARF
      IF (ARF.LT.1.0) WRITE (IOUT,66) ARF
      WRITE (IOUT,67) BENFIT(1)
      WRITE (IOUT,12) BENFIT(2)
      IF (ARFAPP.GT.0) THEN
        IF (ARFAPP.EQ.1) THEN
          WRITE (IOUT,180) MESG(246)
        ELSE
          WRITE (IOUT,180) MESG(247)
        END IF
      END IF
      WRITE (IOUT,68) HIMFB
C  Write changes from present law
      IF (JINDT.GT.0) CALL COMENT (IOUT)
C  Write title of benefit increase assumptions
      IF (NEEDBI()) THEN
      WRITE (IOUT,180) MESG(327)
      IF (IALTBI.LT.MAXASM) THEN
      WRITE (IOUT,180) TITBSM(IALTBI)
      ELSE
      WRITE (IOUT,180) TITLBI
      END IF
      END IF
C  Write title of average wage assumptions
      IF (NEEDAW()) THEN
      WRITE (IOUT,180) MESG(328)
      IF (IALTAW.LT.MAXASM) THEN
      WRITE (IOUT,180) TITASM(IALTAW)
      ELSE
      WRITE (IOUT,180) TITLAW
      END IF
      END IF
      IF (IQCTOT.LT.IQCREQ) CALL NONINP(IOUT)
      IF (IOASDI.EQ.3) THEN
        WRITE (IOUT,*)
        CALL DISINS(IOUT)
      END IF
      IF (PBSACK().EQ.0) THEN
        CALL BOTTM3(IOUT,'future'//CHAR(0),IALTAW)
      ELSE
        CALL BOTTM4(IOUT)
      END IF
      RETURN
      END
C
C  Write out second summary page year and earnings
C
C  IOUT   = output unit number.
C  PAGE   = page counter.
C
      SUBROUTINE TWOPG2 (IOUT,PAGE)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'commona.h'
      INTEGER IOUT,PAGE,I
      DOUBLE PRECISION TEMP
    4 FORMAT (/'      Warning! Earnings limited to 999999.99')
    7 FORMAT (/'      QC''s for ',I4,' and earlier',20X,I4/)
    9 FORMAT ('      Relative earnings position = ',F8.5)
   15 FORMAT ('      Projected wage bases:  ',A35)
   26 FORMAT (' ',T16,'Earnings Used In PIA Calculation'//)
   72 FORMAT (' ',T40,'Amount    Quarters'/
     &' ',T17,'Annual      Maximum     per         of'/
     &'      year     earnings     earnings     QC      coverage'/)
   73 FORMAT ('      ',I4,1X,F12.2,1X,F12.2,1X,F9.2,5X,I4,1X,F10.5,1X,
     &F12.2)
   74 FORMAT ('      ',I4,1X,F12.2,1X,F12.2,15X,I4,1X,F10.5,1X,F12.2)
   75 FORMAT (' ',T40,'Amount    Quarters  Relative     Attri-'/
     &' ',T17,'Annual      Maximum     per         of     earnings',
     &'      buted'/
     &'      year     earnings     earnings     QC      coverage',
     &'  position    earnings'/)
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,26)
      IF (TOTALI) THEN
        WRITE (IOUT,75)
      ELSE
        WRITE (IOUT,72)
      END IF
      DO 575 I=IBEGIN,IEND
      TEMP = EARNST(I-1936,3)
      IF (I.EQ.1950.AND.IBEGIN.EQ.1950) THEN
        IF (TOTALI) THEN
          WRITE (IOUT,74) I,TEMP,BASE(I-1936),IQC(I-1936),
     &    REP(I-1936),EARNST(I-1936,4)
        ELSE
          WRITE (IOUT,74) I,STOT(1),BASE(I-1936)
        END IF
      ELSE
        IF (I.LE.CURYR) THEN
          IF (TOTALI) THEN
            WRITE (IOUT,74) I,TEMP,BASE(I-1936),IQC(I-1936),
     &      REP(I-1936),EARNST(I-1936,4)
          ELSE
            WRITE (IOUT,74) I,TEMP,BASE(I-1936)
          END IF
        ELSE
          IF (TOTALI) THEN
            WRITE (IOUT,73) I,TEMP,BASE(I-1936),QCAMT(I-1936),
     &      IQC(I-1936),REP(I-1936),EARNST(I-1936,4)
          ELSE
            WRITE (IOUT,73) I,TEMP,BASE(I-1936),QCAMT(I-1936),
     &      IQC(I-1936)
          END IF
        END IF
      END IF
  575 CONTINUE
      WRITE (IOUT,7) CURYR,QCTD
      IF (TOTALI) WRITE (IOUT,9) REPAVG
      IF (BENDAT(2).GT.1951+ISTART.AND.IEND.GT.1951+ISTART)
     &WRITE (IOUT,15) WGBAS(IBASCH)
C  Print noninsured message
      IF (IQCTOT.LT.IQCREQ) THEN
      WRITE (IOUT,*)
      CALL NONINS(IOUT)
      END IF
C  Print unused earnings message
      IF (IERNYR+1950.LT.IEND) THEN
      WRITE (IOUT,*)
      CALL UNUSED(IOUT)
      END IF
C  Print disability-insured message
      IF (IOASDI.EQ.3) THEN
      WRITE (IOUT,*)
      CALL DISINS(IOUT)
      END IF
C  Print truncated earnings message
      IF (OVRMAX.GT.0) WRITE (IOUT,4)
      RETURN
      END
C
C  Write out third summary page (shows insured status)
C
C  IOUT   = output unit number.
C  PAGE   = page counter.
C
      SUBROUTINE TWOPG3 (IOUT,PAGE)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'commona.h'
      INTEGER IOUT,PAGE
    1 FORMAT ('      Fully insured status:')
    2 FORMAT ('         Required quarters of coverage: ',I3)
    3 FORMAT ('         Actual quarters of coverage: ',I3)
    4 FORMAT ('         Insured status: ',A55)
    5 FORMAT (/'      Disability insured status:')
    6 FORMAT ('         Period after disability: qtr ',I1,' of ',I4,
     &' to qtr ',I1,' of ',I4)
    7 FORMAT ('         Period before disability: qtr ',I1,' of ',I4,
     &' to qtr ',I1,' of ',I4)
    8 FORMAT ('         Period before prior disability: qtr ',I1,' of ',
     &I4,' to qtr ',I1,' of ',I4)
    9 FORMAT ('         Elapsed quarters of coverage: ',I3)
   10 FORMAT (/'      Currently insured status:')
   11 FORMAT ('         Required quarters of coverage: 6')
   26 FORMAT (' ',T25,'Insured Status'//)
      CALL PGTIT2(IOUT,PAGE)
      WRITE (IOUT,26)
C  Fully insured status
      WRITE (IOUT,1)
      WRITE (IOUT,2) IQCREQ
      WRITE (IOUT,3) IQCTOT
      IF (FINSC.EQ.'1') WRITE (IOUT,4)
     &'Fully insured                                         '
      IF (FINSC.EQ.'3') WRITE (IOUT,4)
     &'Not fully insured (eligible for totalization benefits)'
      IF (FINSC.EQ.'2'.OR.FINSC.EQ.'4'.OR.FINSC.EQ.'5') WRITE (IOUT,4)
     &'Not fully insured                                     '
      IF (FINSC.EQ.'6') WRITE (IOUT,4)
     &'Not insured for totalization benefits                 '
      IF (FINSC.EQ.'7') WRITE (IOUT,4)
     &'Fully insured (not eligible for totalization benefits)'
C  Disability insured status
      IF (IOASDI.EQ.3) THEN
        WRITE (6,5)
C  Period after cessation
        IF (QCDDT3(2).GT.0) WRITE (IOUT,6) QCDDT3(1),QCDDT3(2),
     &  QCDDT4(1),QCDDT4(2)
        IF (QCDDT1(2).GT.0) WRITE (IOUT,6) QCDDT1(1),QCDDT1(2),
     &  QCDDT2(1),QCDDT2(2)
        IF (QCDDT5(2).GT.0) WRITE (IOUT,6) QCDDT5(1),QCDDT5(2),
     &  QCDDT6(1),QCDDT6(2)
        WRITE (IOUT,9) QCDIQT
        WRITE (IOUT,2) DISREQ
        WRITE (IOUT,3) QCTOTD
        IF (FINSC.EQ.'1') THEN
          IF (DINSC.EQ.'1'.OR.DINSC.EQ.'2'.OR.DINSC.EQ.'3'.OR.
     &    DINSC.EQ.'4') THEN
            WRITE (IOUT,4)
     &      'Disability insured                                    '
          ELSE
            WRITE (IOUT,4)
     &      'Not disability insured                                '
          END IF
        ELSE
          WRITE (IOUT,4)
     &    'Not disability insured (not fully insured)              '
        END IF
      END IF
C  Currently insured status
      IF (IOASDI.EQ.2.AND.JSURV.EQ.1) THEN
        WRITE (IOUT,10)
        WRITE (IOUT,11)
        WRITE (IOUT,3) QCCUR
        IF (QCCUR.GT.5) THEN
          WRITE (IOUT,4)
     &    'Currently insured                                     '
        ELSE
          WRITE (IOUT,4)
     &    'Not currently insured                                 '
        END IF
      END IF
      RETURN
      END
C
C  Subroutine to write out generic warning
C
      SUBROUTINE BOTTM4(IOUT)
      INTEGER IOUT
      WRITE (IOUT,10)
   10 FORMAT (/'      The estimates we gave are based on your ',
     &'earnings record and any infor-')
      WRITE (IOUT,11)
   11 FORMAT ('      mation you gave us.  The estimate ',
     &'provided could change--it could')
      WRITE (IOUT,12)
   12 FORMAT ('      increase or decrease--depending on your actual ',
     &'future earnings,')
      WRITE (IOUT,13)
   13 FORMAT ('      future changes in the average wages of all ',
     &'employed persons, and on')
      WRITE (IOUT,14)
   14 FORMAT ('      future rates of inflation.')
      RETURN
      END
C
C  Subroutine to print noninsured paragraph
C
      SUBROUTINE NONINP(IOUT)
      INTEGER IOUT
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
    1 FORMAT (/'      This estimate is theoretical because 6 quarters ',
     &'are needed to be'/'      eligible for a totalization benefit; ',
     &'the worker has only',I2,'.')
    2 FORMAT (/'      This estimate is theoretical because the worker ',
     &'is fully insured.'/'      The worker must have fewer than',I3,
     &' quarters; he has',I4,'.')
   10 FORMAT (/'      This estimate is theoretical because the worker ',
     &'is not fully insured.'/'      A total of',I3,
     &' quarters are needed; he has only',I3,'.')
      IF (TOTALI) THEN
        IF (IQCTOT.LT.6) WRITE (IOUT,1) IQCTOT
        IF (IQCTOT.GE.IQCREQ) WRITE (IOUT,2) IQCTOT
      ELSE
        WRITE (IOUT,10) IQCREQ,IQCTOT
      END IF
      RETURN
      END
