C  @(#)anypia.f	1.36   3/6/97
C
C  This program calculates the PIA under Old-Start, Special minimum,
C  and pre- and post-1977 law for any worker retiring in 1940 or
C  later.  This version can handle a prior disability onset for
C  retirement and survivor cases.  This version reads actual
C  benefit increases and average wages from a data element.
C
C  To update every year:
C    1. Increase ISTART by 1 in BASEYEAR.DAT.
C    2. Create a new AWBIxx.DAT with 1 more year of data for CPIINC,
C       FQ, BASE, and BASE77.
C  To update every 5 years:
C    1. Increase IX and IY by 5.
C       Next time will be for 1991 version.
C    2. Add 5 years of data to all taxrates.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C  Definition of variables ('*' before variable name denotes dimensioned
C  variable array):
C
C  CHOICE = menu choice.
C  I1     = temporary index used in various places.
C  IERR   = error indicator (0 if no error, positive if error in input
C           file, age entry, or assumptions).
C
      PROGRAM ANYPIA
      INTEGER CHOICE
      CHARACTER*80 PROGFL(2),PRINIT
      INTEGER IOUT, IERR, IN
C  Function declarations
      INTEGER MENSEL,DATAIN,CALC1,SAVDIS,READFL,MODIFY,DATCHK,FOUT,
     &GETFO,GETCNF,GTBSYR,GETHST,GTLWCH,CALC2
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'commona.h'
      INCLUDE 'setup.h'
      INCLUDE 'piadataf.h'
C
C  FORMAT statements
C
    1 FORMAT (T33,'Data view menu')
    2 FORMAT (T4,'Not available in this version')
    3 FORMAT (T4,'0 to return to main menu'/
     &T4,'1 to open a file'/
     &T4,'2 to save a file'/
     &T4,'3 to delete a file'/
     &T4,'4 to view directory')
    4 FORMAT (T35,'File menu')
    5 FORMAT (T4,'0 to exit program'/
     &T4,'1 to open or save file'/
     &T4,'2 to view data'/
     &T4,'3 to run a setup program'/
     &T4,'4 to calculate the PIA for current case'/
     &T4,'5 to view help')
    6 FORMAT (T35,'Main menu')
    7 FORMAT (T4,'0 to return to main menu'/
     &T4,'1 to review or change configuration'/
     &T4,'2 to review or update historical amounts'/
     &T4,'3 to review or change computation year'/
     &T4,'4 to review or change field office information'/
     &T4,'5 to review or change law-change indicators')
    8 FORMAT (T35,'Data setup')
    9 FORMAT (T4,'0 to return to main menu'/
     &T4,'1 to enter new data'/
     &T4,'2 to modify current data')
   10 FORMAT (T35,'Help menu')
   11 FORMAT (T4,'0 to return to main menu'/
     &T4,'1 for a description of this program'/
     &T4,'2 for help on the main menu'/
     &T4,'3 for help on data entry in the forms')
   12 FORMAT (T33,'PIA calculation')
   14 FORMAT (T35,'Saving to disk')
   15 FORMAT ('   You can save the data entered for this case.  ',
     &'This would be useful if you'/'   wanted to change just ',
     &'part of the data.  For instance, you may want to'/
     &'   redo the computation assuming more or fewer years of ',
     &'covered earnings in'/'   the future.'//
     &'   If you save this case, the data will be available to ',
     &'any other user of'/'   this disk.  If the data is ',
     &'sensitive, you should safeguard the disk, or'/
     &'   else use the "delete a case" option from the "Case ',
     &'Selection" menu when'/'   you are finished with this case.'/)
   16 FORMAT ('   Do you want to save this case to disk? (y or n)')
   20 FORMAT (A1)
   39 FORMAT ('   Enter choice:')
C
C  Write out introduction on screen
C
      IPRMPT = 1
C  Get configuration
      IF (GETCNF(PROGFL,PRINIT).GT.0) CALL DONE
C  Get base year
      IF (GTBSYR(PROGFL(2)).GT.0) CALL DONE
C  Get law changes
      IF (GTLWCH(PROGFL(2)).GT.0) CALL DONE
C  Get field office address
      IF (GETFO(PROGFL(2)).GT.0) CALL DONE
C  Read in historical amounts
      IF (GETHST(PROGFL(2),10).GT.0) CALL DONE
C  Set titles of assumptions
      CALL ASMTIT(PROGFL(2))
C
C  Print main menu
C
  100 CALL HYPHN1
      WRITE (6,6)
      CALL HYPHN2
      WRITE (6,39)
      WRITE (6,5)
      CHOICE = MENSEL(0,5)
      GO TO (900,110,150,191,500,600), CHOICE+1
C
C  Print file menu
C
  110 CALL HYPHN1
      WRITE (6,4)
      CALL HYPHN2
      WRITE (6,39)
      WRITE (6,3)
      CHOICE = MENSEL(0,4)
      GO TO (100,115,120,125,130), CHOICE+1
C  Open file
  115 CALL FIN(PROGFL(1),ERNFIL,IN,IERR)
      IF (IERR.GT.0) GO TO 100
      CALL STATUS(290)
      IERR = READFL(IN)
      IF (IERR.GT.0) THEN
        CALL WARN(IERR)
        GO TO 100
      END IF
      IERR = DATCHK()
      IF (IERR.GT.0) THEN
        CALL WARN(IERR)
        GO TO 100
      END IF
      GO TO 100
C
C  See if case should be saved
C
  120 CALL HYPHN1
      WRITE (6,14)
      CALL HYPHN2
      WRITE (6,15)
  121 WRITE (6,16)
      READ (5,20) ANSWER
      CALL TOUPPR(ANSWER)
      IF (ANSWER.NE.'Y'.AND.ANSWER.NE.'N') THEN
        CALL BEEP
        GO TO 121
      END IF
      IF (ANSWER.EQ.'N') GO TO 100
C
C  Save this case
C
C  Open output file
      IERR = FOUT(PROGFL(1),ERNFIL,IOUT)
      IF (IERR.NE.0) GO TO 100
      CALL STATUS(292)
      IERR = SAVDIS(IOUT)
      GO TO 100
C
C  Delete a file
C
  125 WRITE (6,2)
      GO TO 100
C  View directory
  130 WRITE (6,2)
      GO TO 100
C
C  Print data entry menu
C
  150 CALL HYPHN1
      WRITE (6,1)
      CALL HYPHN2
      WRITE (6,39)
      WRITE (6,9)
      CHOICE = MENSEL(0,2)
      GO TO (100,160,170), CHOICE+1
C  Get case
  160 IERR = DATAIN()
      IF (IERR.GT.0) CALL WARN(IERR)
      GO TO 100
  170 IERR = MODIFY()
      IF (IERR.GT.0) CALL WARN(IERR)
      GO TO 100
C
C  Print data setup menu
C
  191 CALL HYPHN1
      WRITE (6,8)
      CALL HYPHN2
      WRITE (6,39)
      WRITE (6,7)
      CHOICE = MENSEL(0,5)
      GO TO (100,194,205,294,295,296) CHOICE+1
  194 CALL CONFIG(PROGFL,PRINIT)
      GOTO 100
  205 CALL OLDATA(PROGFL(2))
      GOTO 100
  294 CALL BASEYR
      GO TO 100
  295 CALL ADDRES(PROGFL(2))
      GO TO 100
  296 CALL LAWCHG(PROGFL(2),5)
      GO TO 100
C
C  Call PIA calculation
C
  500 IERR = DATCHK()
      IF (IERR.GT.0) THEN
        CALL WARN(IERR)
        GO TO 100
      END IF
      CALL HYPHN1
      WRITE (6,12)
      CALL HYPHN2
      IERR = CALC1()
      IF (IERR.GT.0) THEN
        CALL WARN(IERR)
        GO TO 100
      END IF
      IERR = CALC2()
      IF (IERR.GT.0) THEN
        CALL WARN(IERR)
        GO TO 100
      END IF
C
C  Write results to screen
C
      IF (JOASDI.EQ.4) THEN
        CALL PEBSCN
      ELSE
        CALL SUMSCN
      END IF
C
C  Write out results
C
      CALL GETPRT(ANSWER)
      IF (ANSWER.EQ.'Y') THEN
        CALL DATIME(DATELN)
        CALL GETPTR
        IF (JOASDI.EQ.4) THEN
          CALL PEBSPG(PROGFL(2))
        ELSE
          CALL PIAOWN(PROGFL(2))
        END IF
      END IF
      GO TO 100
C
C  Print help menu
C
  600 CALL HYPHN1
      WRITE (6,10)
      CALL HYPHN2
      WRITE (6,39)
      WRITE (6,11)
      CHOICE = MENSEL(0,3)
      GO TO (100,610,620,630) CHOICE+1
C  Write general help
  610 CALL INTRO2
      GO TO 100
C  Write help on main menu
  620 CALL INTRO1
      GO TO 100
C  Write forms help
  630 CALL INTRO3
      GO TO 100
C
C  All done
C
  900 CALL DONE
      END
C
C  Subroutine to print help on main menu
C
      SUBROUTINE INTRO1
      CALL HYPHN1
      WRITE (6,1)
    1 FORMAT (T34,'Main menu help')
      CALL HYPHN2
      WRITE (6,2)
    2 FORMAT (T4,'Help for main menu goes here.')
      CALL GETRET
      RETURN
      END
C
C  Subroutine to print first intro page
C
      SUBROUTINE INTRO2
      CALL HYPHN1
      WRITE (6,36)
   36 FORMAT(T10,'Social Security PIA Calculation Program, ',
     &'version 1990.1')
      CALL HYPHN2
      WRITE (6,37)
   37 FORMAT(T5,'This program calculates the Primary Insurance',
     &' Amount (PIA), Maximum'/
     &T5,'Family Benefit Amount (MFB) and Monthly Benefit Amount (MBA)',
     &' for most cases'/T5,'of Social Security benefits.  The ',
     &'following are specifically considered:'/
     &T7,'1. Old-age, survivors, or disability benefits.'/
     &T7,'2. All PIA calculations (except as noted below).'/
     &T7,'3. All amendments to the law through 1989.'/
     &T7,'4. Projected benefits through 2065.'//
     &T5,'The following are some of the limitations:'/
     &T7,'1. Some approximations are made for pre-1965 benefits',
     &' and the'/T10,'frozen minimum PIA.'/
     &T7,'2. Any applicable insured status requirement is ',
     &'assumed to be met.'/
     &T7,'3. Some calculations involving disability are not considered.'
     &//T5,'The source program is not copyrighted.  Distribution',
     &' is encouraged, with'/
     &T5,'acknowledgement to the Social Security Administration',
     &', Office of the'/T5,'Actuary.')
      CALL GETRET
      RETURN
      END
C
C  Subroutine to print second intro page
C
      SUBROUTINE INTRO3
      CALL HYPHN1
      WRITE (6,34)
   34 FORMAT (T32,'Running the program')
      CALL HYPHN2
      WRITE (6,38)
   38 FORMAT(T5,'This program is ',
     &'executed by answering the prompts which appear on the'/
     &T5,'following screens.  Each prompt should be answered',
     &' with the requested'/T5,'data and then the Return key.',
     &'  If more than one number is in a single'/T5,'response, the',
     &' numbers should be separated by commas.  Months should be'/
     &T5,'entered as numbers (1-12).  Years may be entered',
     &' as 4 digits, or as the'/T5,'last 2 digits ',
     &'only if in the 1900s.'//T5,'Two summary',
     &' pages with the results can be printed out.  All ',
     &'print lines'/T5,'are no more than 80 characters.  If desired,',
     &' additional detailed pages'/T5,'of output are available.'//
     &T5,'Press the F1 key at any time to stop the program')
      CALL GETRET
      RETURN
      END
