C  @(#)earnqc.f	1.11   3/6/97
C
C  Various subroutines to get earnings and coverage information
C
C  Subroutine to print title for earnings and coverage
C
      SUBROUTINE TITERN
      CALL HYPHN1
      WRITE (6,10)
   10 FORMAT (T25,'Earnings and coverage information')
      CALL HYPHN2
      RETURN
      END
C
C  Subroutine to get type of earnings
C
      SUBROUTINE GEARNT
      INCLUDE 'wrkrdataf.h'
      INTEGER I
      DO 10 I=IBEGN1,IEND1
   10 CALL EARN(I)
      RETURN
      END
C
C  Subroutine to review type of earnings
C
      SUBROUTINE EARNTR
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      CHARACTER*1 ANSERN
      INTEGER I
    1 FORMAT ('   Type of earnings for ',I4,' is ',A43)
      DO 10 I=IBEGN1,IEND1
      WRITE (6,1) I,ERNTYP(EARNTP(I-1936)+1)
      CALL CORECT(ANSERN)
      IF (ANSERN.NE.'Y') CALL EARN(I)
   10 CONTINUE
      RETURN
      END
C
C  Subroutine to get type of earnings for one year
C
C  YEAR   = year for which type of earnings is desired.
C
      SUBROUTINE EARN(YEAR)
      INTEGER I,YEAR
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
C  Function declaration
      INTEGER MENSEL
      WRITE (6,20) YEAR
   20 FORMAT ('   Enter type of earnings for ',I4,':')
      DO 30 I=0,4
   30 WRITE (6,40) I,ERNTYP(I+1)
   40 FORMAT (T7,I1,' for ',A43)
      EARNTP(YEAR-1936) = MENSEL(0,4)
      RETURN
      END
C
C  Function to get first year of earnings
C
C  IYR2   = last possible first year of earnings.
C  BEGIND = indicator for type of first year of earnings
C           (0=first year with no backward projection, 1=first year
C           before projection, 2=first year after projection).
C
      INTEGER FUNCTION BEGERN(IYR2,BEGIND)
      INTEGER IYR2,BEGIND,RV
      INCLUDE 'wrkrdataf.h'
    1 FORMAT ('   Enter first year for which there are earnings:')
    2 FORMAT ('   Enter first year of earnings before projection:')
    3 FORMAT ('   Enter first year of earnings after projection:')
   10 IF (BEGIND.EQ.0) WRITE (6,1)
      IF (BEGIND.EQ.1) WRITE (6,2)
      IF (BEGIND.EQ.2) WRITE (6,3)
      READ (5,*) RV
      IF (RV.LT.100) RV = 1900+RV
      IF (RV.GT.IYR2.OR.RV.LT.1937) THEN
        CALL WARN(8)
        GO TO 10
      END IF
      BEGERN = RV
      RETURN
      END
C
C  Subroutine to get last year there are earnings
C
C  ENDIND = indicator for type of last year of earnings
C           (0=last year with no backward projection, 1=last year
C           before projection, 2=last year after projection).
C
      INTEGER FUNCTION ENDERN(ENDIND)
      INCLUDE 'wrkrdataf.h'
      INTEGER ENDIND,RV
    1 FORMAT ('   Enter last year for which there are earnings:')
    2 FORMAT ('   Enter last year of earnings before projection:')
    3 FORMAT ('   Enter last year of earnings after projection:')
   10 IF (ENDIND.EQ.0) WRITE (6,1)
      IF (ENDIND.EQ.1) WRITE (6,2)
      IF (ENDIND.EQ.2) WRITE (6,3)
      READ (5,*) RV
      IF (RV.LT.100) RV = 1900+RV
      IF (RV.GT.IX+1936) THEN
        CALL WARN(9)
        GO TO 10
      END IF
      ENDERN = RV
      RETURN
      END
C
C  Subroutine to get quarters of coverage, 1937 to 1977
C
      SUBROUTINE GETQC
      INCLUDE 'wrkrdataf.h'
C  Function declaration
      INTEGER MENSEL,LSTQCY
      WRITE (6,10) LSTQCY()
   10 FORMAT ('   Enter number of quarters of coverage, 1937-',I4)
      QCTD = MENSEL(0,999)
      RETURN
      END
C
C  Subroutine to get quarters of coverage, 1951 to 1977
C
      SUBROUTINE GTQC51
      INCLUDE 'wrkrdataf.h'
C  Function declaration
      INTEGER MENSEL,LSTQCY
      WRITE (6,10) LSTQCY()
   10 FORMAT ('   Enter number of quarters of coverage, 1951-',I4)
      QC51TD = MENSEL(0,999)
      RETURN
      END
C
C  Subroutine to get annual quarters of coverage
C
      SUBROUTINE GETQC2()
      INTEGER I
      INCLUDE 'wrkrdataf.h'
C  Function declarations
      INTEGER MENSEL,QCSUM,LSTQCY
      DO 20 I=IBEGIN,LSTQCY()
      WRITE (6,10) I
   10 FORMAT ('   Enter quarters of coverage for ',I4)
      IQC(I-1936) = MENSEL(0,4)
   20 CONTINUE
      QCTD = QCSUM(1937,LSTQCY())
      QC51TD = QCSUM(1951,LSTQCY())
      RETURN
      END
C
C  Subroutine to get backward earnings projection percentage
C
      SUBROUTINE GPERCB
      INCLUDE 'wrkrdataf.h'
    1 FORMAT ('   Enter backward earnings projection percentage:')
   10 WRITE (6,1)
      READ (5,*) PERCBK
      IF (PERCBK.LT.0.0.OR.PERCBK.GT.9.9) THEN
        CALL WARN(106)
        GO TO 10
      END IF
      RETURN
      END
C
C  Subroutine to get forward earnings projection percentage
C
      SUBROUTINE GPERCF
      INCLUDE 'wrkrdataf.h'
    1 FORMAT ('   Enter forward earnings projection percentage:')
   10 WRITE (6,1)
      READ (5,*) PERCFD
      IF (PERCFD.LT.0.0.OR.PERCFD.GT.9.9) THEN
        CALL WARN(108)
        GO TO 10
      END IF
      RETURN
      END
