C  @(#)worker.f	1.11   3/6/97
C
C  Various subroutines to get worker information
C
C  Subroutine to write wage earner information title
C
      SUBROUTINE EARNER
      CALL HYPHN1
      WRITE (6,10)
      CALL HYPHN2
   10 FORMAT (T28,'Wage-earner information')
      RETURN
      END
C
C  Subroutine to get sex of worker
C
      SUBROUTINE ASEX
      INCLUDE 'wrkrdataf.h'
C  Function declaration
      INTEGER MENSEL
      WRITE (6,20)
   20 FORMAT ('   Enter sex-of-worker code (1=male, 2=female)')
      ISEX = MENSEL(1,2)
      RETURN
      END
C
C  Subroutine to get date of entitlement
C
      SUBROUTINE ENTITL()
      INCLUDE 'wrkrdataf.h'
   10 WRITE (6,20)
   20 FORMAT ('   For old-age benefits, mo/year of entitlement cannot ',
     &'be before age 62 and'/
     &'   1 month unless date of birth is on first or second day',
     &' of month, in'/
     &'   which case initial month of entitlement can be as early ',
     &'as month of'/'   62nd birthday.'/
     &'   Enter date of entitlement (month,year)')
      READ (5,*) IENT
      IF(IENT(2).LT.100)IENT(2)=1900+IENT(2)
      IF (IENT(1).LT.1.OR.IENT(1).GT.12) THEN
      CALL MONERR
      GO TO 10
      END IF
      IF (IENT(2).LT.1940) THEN
        CALL WARN(3)
        GO TO 10
      END IF
      IF (IENT(2).GT.1936+IX) THEN
        CALL WARN(103)
        GO TO 10
      END IF
      RETURN
      END
C
C  Subroutine to get date of benefit
C
      SUBROUTINE GBENDT()
      INCLUDE 'wrkrdataf.h'
      INTEGER BNDTCK,IERR
   20 FORMAT ('   Enter date of desired benefit (month,year)')
   10 WRITE (6,20)
      READ (5,*) BENDAT
      IF (BENDAT(2).LT.100) BENDAT(2) = 1900+BENDAT(2)
      IF (BENDAT(1).LT.1.OR.BENDAT(1).GT.12) THEN
        CALL MONERR
        GO TO 10
      END IF
      IF (BENDAT(2).LT.1940) THEN
        CALL WARN(118)
        GO TO 10
      END IF
      IF (BENDAT(2).GT.1936+IX) THEN
        CALL WARN(119)
        GO TO 10
      END IF
      IERR = BNDTCK()
      IF (IERR.GT.0) THEN
        CALL WARN(IERR)
        GO TO 10
      END IF
      RETURN
      END
C
C  Subroutine to get date of birth
C
      SUBROUTINE BIRTH(IYR2)
      INTEGER IYR2
      INCLUDE 'wrkrdataf.h'
   10 WRITE (6,20)
   20 FORMAT ('   Enter date of birth (month,day,year)')
      READ (5,*) IBIRTH
      IF (IBIRTH(1).LT.1.OR.IBIRTH(1).GT.12) THEN
      CALL MONERR
      GO TO 10
      END IF
      IF (IBIRTH(2).LT.1.OR.IBIRTH(2).GT.31) THEN
      CALL DAYERR
      GO TO 10
      END IF
      IF (IBIRTH(3).LT.100) IBIRTH(3)=IBIRTH(3)+1900
      IF (IBIRTH(3).GT.IYR2) THEN
        CALL WARN(55)
        GO TO 10
      END IF
      IF (IBIRTH(3).LT.1800) THEN
        CALL WARN(55)
        GO TO 10
      END IF
      RETURN
      END
C
C  Subroutine to get the month of processing
C
      SUBROUTINE PMONTH
      INCLUDE 'wrkrdataf.h'
   10 WRITE (6,20) ISTART+1951
   20 FORMAT ('   Month in ',I4,
     &' that this case is being or was processed')
      READ (5,*) MONTHN
      IF (MONTHN.LT.1.OR.MONTHN.GT.12) THEN
        CALL MONERR
        GO TO 10
      END IF
      RETURN
      END
C
C  Subroutine to get the planned retirement age
C
      SUBROUTINE PROAGE
      INCLUDE 'wrkrdataf.h'
   10 WRITE (6,20)
   20 FORMAT ('   Planned age of retirement')
      READ (5,*) IAGPLN
      IF (IAGPLN.LT.0.OR.IAGPLN.GT.99) THEN
        CALL WARN(104)
        GO TO 10
      END IF
      RETURN
      END
C
C  Subroutine to get type of benefit
C
      SUBROUTINE BENEFT
      INTEGER I
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
C  Function declaration
      INTEGER MENSEL
      WRITE (6,20)
   20 FORMAT ('   Enter type of benefit:')
      DO 30 I=1,4
   30 WRITE (6,40) I,BENTYP(I)
   40 FORMAT (T7,I1,' for ',A52)
      JOASDI = MENSEL(1,4)
      IF (JOASDI.EQ.3) WRITE (6,50)
   50 FORMAT ('   The worker is assumed to be disability-insured.')
      RETURN
      END
C
C  Subroutine to get totalization indicator
C
      SUBROUTINE GTOTAL
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INTEGER I
C  Function declarations
      INTEGER MENSEL
      WRITE (6,20)
   20 FORMAT (T4,'Enter totalization code:')
      DO 30 I=1,2
   30 WRITE (6,40) I-1,ATOTAL(I)
   40 FORMAT (T7,I1,' for ',A24)
      I = MENSEL(0,1)
      IF (I.EQ.0) THEN
        TOTALI = .FALSE.
      ELSE
        TOTALI = .TRUE.
      END IF
      RETURN
      END
C
C  Subroutine to get wage earner name and SSN
C
      SUBROUTINE NAMESS
      INCLUDE 'wrkrdataf.h'
      INTEGER I
    1 FORMAT (A35)
    2 FORMAT (A12)
    3 FORMAT ('   Enter line ',I1,' of wage earner address',
     &' (RETURN if none)')
   10 FORMAT ('   Enter name of wage earner (RETURN if none)')
   11 FORMAT ('   Enter social security number of wage earner',
     &' (Return if none)')
      WRITE (6,10)
      READ (5,1) NAME
      DO 100 I=1,3
      WRITE (6,3) I
  100 READ (5,1) NHADDR(I)
      WRITE (6,11)
      READ (5,2) NHSSN
      RETURN
      END
C
C  Subroutine to get recalculation indicator
C
      SUBROUTINE GRECAL
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INTEGER I
C  Function declarations
      INTEGER MENSEL
      WRITE (6,20)
   20 FORMAT (T4,'Enter recalculation code:')
      DO 30 I=1,2
   30 WRITE (6,40) I-1,ARECAL(I)
   40 FORMAT (T7,I1,' for ',A33)
      I = MENSEL(0,1)
      IF (I.EQ.0) THEN
        RECALC = .FALSE.
      ELSE
        RECALC = .TRUE.
      END IF
      RETURN
      END
C
C  Subroutine to get MQGE indicator
C
      SUBROUTINE GMQGE
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INTEGER I
C  Function declarations
      INTEGER MENSEL
      WRITE (6,20)
   20 FORMAT (T4,'Enter Medicare earnings code:')
      DO 30 I=1,2
   30 WRITE (6,40) I-1,AMQGE(I)
   40 FORMAT (T7,I1,' for ',A20)
      I = MENSEL(0,1)
      IF (I.EQ.0) THEN
        MQGE = .FALSE.
      ELSE
        MQGE = .TRUE.
      END IF
      RETURN
      END
C
C  Subroutine to get backward earnings projection indicator
C
      SUBROUTINE GPRBCK
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INTEGER I
C  Function declarations
      INTEGER MENSEL
      WRITE (6,20)
   20 FORMAT (T4,'Enter backward earnings projection code:')
      DO 30 I=1,3
   30 WRITE (6,40) I-1,APRBCK(I)
   40 FORMAT (T7,I1,' for ',A33)
      PRBACK = MENSEL(0,2)
      RETURN
      END
C
C  Subroutine to get forward earnings projection indicator
C
      SUBROUTINE GPRFWD
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INTEGER I
C  Function declarations
      INTEGER MENSEL
      WRITE (6,20)
   20 FORMAT (T4,'Enter forward earnings projection code:')
      DO 30 I=1,3
   30 WRITE (6,40) I-1,APRFWD(I)
   40 FORMAT (T7,I1,' for ',A33)
      PRFWRD = MENSEL(0,2)
      RETURN
      END
