C  @(#)ardri.f	1.17   12/20/95
C
C  This subroutine calculates the number of months of early or delayed
C  retirement, and the resulting adjustment factor.  It also checks for
C  inconsistent data or impossible ages at retirement or disability.
C
C  Definition of variables:
C
C  I1     = index of first month to which delayed retirement credit can
C           apply.
C  I2     = index of month after last month to which delayed retirement
C           credit can apply.
C  I3     = index of month of attainment of normal retirement age.
C  I4     = index of month of age 72 or 70.
C  I5     = index of month of entitlement.
C  I6     = index of January of year of entitlement, or month of
C           attainment of normal retirement age, if later.
C  I7     = maximum possible number of months of reduction.
C
      INTEGER FUNCTION ARDRI ()
      INTEGER AMND61(2), AMND67(2)
      INTEGER I1,I2,I3,I4,I5,I6,I7,FVAL
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      DOUBLE PRECISION RETCR
      INTEGER COMPYM, COMPMY
      DATA AMND61 / 8,1961 /
      DATA AMND67 / 2,1968 /
      ARDRI = 0
      MARDRI = 0
      FVAL = 0
C  Handle impossible age
      IF (IAGE(1).LT.0) THEN
        ARDRI = 141
        RETURN
      END IF
C
C  Delayed retirement credit
C
      IF (IOASDI.EQ.1) THEN
        FVAL = COMPYM(IAGE,NRA)
        IF (FVAL.GE.0) THEN
          I3 = KBIRTH(1)+NRA(2)+12*(KBIRTH(3)-1971+NRA(1))
          I1= MAX0(1,I3)
C  Decrease maximum age for DRI from 72 to 70 in January 1984
          IF (IELGYR(1).LE.24) THEN
            I4 = KBIRTH(1)+ 12*(KBIRTH(3)+72-1971)
            IF (IELGYR(1).GE.23) I4=MIN0(I4,157)
          END IF
          IF (IELGYR(1).GE.25) THEN
            I4 = KBIRTH(1)+ 12*(KBIRTH(3)+70-1971)
          END IF
          I5 = IENT(1)+12*(IENT(2)-1971)
          I6 = MAX0(12*(IENT(2)-1971)+1,I3)
          IF (I5.GE.I4) THEN
            I2 = I4
          ELSE
            I2 = I6
          END IF
C  No negative credits
          MARDRI = MAX0(I2-I1,0)
C  Calculate amount of DRI
          ARF = 1. + FLOAT(MARDRI)*RETCR(IELGYR(1))
          RETURN
C
C  Early retirement reduction
C
        ELSE
          FVAL = COMPYM(IAGE,NRA1)
          IF (FVAL.LT.0) THEN
            ARDRI = 142
            RETURN
          END IF
          MARDRI = NRA(1)*12 + NRA(2) - (IAGE(1)*12+IAGE(2))
          IF (MARDRI.LE.36) THEN
            ARF=1.-FLOAT(MARDRI)*5./900.
          ELSE
C  Do case of early retirement more than 3 years before NRA
            ARF = 1.-(36.*5./900.)-((FLOAT(MARDRI)-36.)*5./1200.)
          END IF
          RETURN
        END IF
      END IF
C
C  Young survivors
C
      IF (IOASDI.EQ.2) THEN
        GOTO (200,210,220) JSURV
  200   ARF = .75
        RETURN
C
C  Disabled widow
C
C  Check for benefits before February 1968
  210   IF (COMPMY(IENT,AMND67).LT.0) THEN
          ARDRI = 143
          RETURN
        END IF
C  Check for benefits before age 50
        IF (JAGE(1).LT.50) THEN
          ARDRI = 144
          RETURN
        END IF
C  Check for benefits after age 60
        IF (JAGE(1).GE.60) THEN
          ARDRI = 145
          RETURN
        END IF
C  Calculate reduction factor
        MARDRI = (60-JAGE(1))*12-JAGE(2)
        IF (IENT(2).LE.1972) ARF = .69167-(MARDRI*43./19800.)
        IF (IENT(2).GT.1972.AND.IENT(2).LT.1984)
     &                           ARF=.715-(MARDRI*43./24000.)
        IF (IENT(2).GE.1984) ARF = .715
        RETURN
C
C  Aged widow
C
  220 CALL NRA3C()
C  Check for impossible age
        FVAL = COMPYM(JAGE,NRA3)
        IF (FVAL.LT.0) THEN
          ARDRI = 146
          RETURN
        END IF
C  Determine widow's normal retirement age
      CALL NRACAL(LBIRTH(3)+59-1950,NRA2)
C  Benefit was 75 percent up to August 1961
        IF (COMPMY(BENDAT,AMND61).LT.0) THEN
          ARF=.75
          RETURN
        END IF
C  Full benefit was 82.5 percent until 1973
        IF (BENDAT(2).LE.1972) THEN
          IF (JAGE(1).GE.62) THEN
            ARF=.825
          ELSE
            MARDRI = (62-JAGE(1))*12-JAGE(2)
            ARF=.825-(MARDRI*5./900.)
          END IF
          RETURN
        END IF
C  Determine delayed retirement credit
        FVAL = COMPYM(JAGE,NRA2)
        IF (FVAL.GE.0) THEN
          ARF = 1.0
        ELSE
C  Determine reduction factor
          MARDRI = NRA2(1)*12 + NRA2(2) - (JAGE(1)*12 + JAGE(2))
          I7 = NRA2(1)*12 + NRA2(2) - 60*12
          ARF = 1. - FLOAT(MARDRI)*.285/FLOAT(I7)
        END IF
        RETURN
      END IF
C
C  Disability
C
      IF (IOASDI.EQ.3) THEN
        IF (IENT(2).LE.1959) THEN
C  Check for disability benefits prior to 1957
          IF (IENT(2).LT.1957) THEN
            ARDRI = 149
            RETURN
          END IF
C  Check for disability benefits prior to age 50
          IF (IAGE(1).LT.50) THEN
            ARDRI = 150
            RETURN
          END IF
        END IF
C  Check for disability after normal retirement age
        FVAL = COMPYM(IAGE,NRA)
        IF (FVAL.LT.0) THEN
          ARF = 1.0
        ELSE
          ARDRI = 151
        END IF
        RETURN
      END IF
      END
C
C  Subroutine to calculate normal retirement age
C
C  MELGYR = year prior to year of eligibility minus 1950.
C *NRAX   = normal retirement age, in years and months.
C *IENT   = month and year of entitlement.
C
      SUBROUTINE NRACAL(MELGYR,NRAX)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INTEGER NRAX(2),MELGYR
C  Do age-65 retirement age
      IF (MELGYR.LT.49) THEN
        NRAX(1)= 65
        NRAX(2)= 0
        RETURN
      END IF
C  Do elimination of age-67 retirement
      IF (JIND(27).GT.0 .AND. IENT(2).GE.JSTART(1,27)) THEN
        NRAX(1)= 65
        NRAX(2)= 0
        RETURN
      END IF
C  Do age 65 and 2 months to age 65 and 10 months retirement age
      IF (MELGYR.GE.49.AND.MELGYR.LT.54) THEN
      NRAX(1)= 65
      NRAX(2)= 2*(MELGYR-48)
      END IF
C  Do age 66 retirement age
      IF (MELGYR.GE.54.AND.MELGYR.LT.66) THEN
      NRAX(1)= 66
      NRAX(2)= 0
      END IF
C  Do age 66 and 2 months to age 66 and 10 months retirement age
      IF (MELGYR.GE.66.AND.MELGYR.LT.71) THEN
      NRAX(1)= 66
      NRAX(2) = 2*(MELGYR-65)
      END IF
C  Do age 67 retirement age
      IF (MELGYR.GE.71) THEN
      NRAX(1)= 67
      NRAX(2)= 0
      END IF
      RETURN
      END
C
C  Subroutine to calculate earliest possible retirement age
C
      SUBROUTINE NRA1C
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      IF (ISEX.LE.1) THEN
        IF (KBIRTH(3).GT.1899.OR.(KBIRTH(3).EQ.1899.AND.
     &  KBIRTH(1).GE.8)) THEN
          NRA1(1) = 62
          NRA1(2) = 0
        END IF
        IF (KBIRTH(3).EQ.1899.AND.KBIRTH(1).LT.8) THEN
          NRA1(1) = 62
          NRA1(2) = 8 - KBIRTH(1)
        END IF
        IF (KBIRTH(3).EQ.1898.OR.KBIRTH(3).EQ.1897) THEN
          NRA1(1) = 1961 - KBIRTH(3)
          NRA1(2) = 8 - KBIRTH(1)
          IF (NRA1(2).LT.0) THEN
            NRA1(2) = NRA1(2) + 12
            NRA1(1) = NRA1(1) - 1
          END IF
        END IF
        IF (KBIRTH(3).EQ.1896.AND.KBIRTH(1).GT.8) THEN
          NRA1(1) = 64
          NRA1(2) = 12 + 8 - KBIRTH(1)
        END IF
        IF (KBIRTH(3).LT.1896.OR.(KBIRTH(3).EQ.1896.AND.
     &  KBIRTH(1).LE.8)) THEN
          NRA1(1) = 65
          NRA1(2) = 0
        END IF
      ELSE
        IF (KBIRTH(3).GT.1894.OR.(KBIRTH(3).EQ.1894.AND.
     &  KBIRTH(1).GE.11)) THEN
          NRA1(1) = 62
          NRA1(2) = 0
        END IF
        IF (KBIRTH(3).EQ.1894.AND.KBIRTH(1).LT.11) THEN
          NRA1(1) = 62
          NRA1(2) = 11 - KBIRTH(1)
        END IF
        IF (KBIRTH(3).EQ.1893.OR.KBIRTH(3).EQ.1892) THEN
          NRA1(1) = 1956 - KBIRTH(3)
          NRA1(2) = 11 - KBIRTH(1)
          IF (NRA1(2).LT.0) THEN
            NRA1(2) = NRA1(2) + 12
            NRA1(1) = NRA1(1) - 1
          END IF
        END IF
        IF (KBIRTH(3).EQ.1891.AND.KBIRTH(1).GT.11) THEN
          NRA1(1) = 64
          NRA1(2) = 12 + 11 - KBIRTH(1)
        END IF
        IF (KBIRTH(3).LT.1891.OR.(KBIRTH(3).EQ.1891.AND.
     &  KBIRTH(1).LE.11)) THEN
          NRA1(1) = 65
          NRA1(2) = 0
        END IF
      END IF
C  Increase to age 62 and 1 month
      IF ((KBIRTH(3).GT.1919.OR.(KBIRTH(3).EQ.1919.AND.KBIRTH(1).GT.8)).
     &AND.KBIRTH(2).NE.1) NRA1(2)=1
      RETURN
      END
C
C  Subroutine to calculate earliest possible retirement age, widows
C
      SUBROUTINE NRA3C()
      INTEGER AMND56(2), AMND65(2)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER COMPMY
      DATA AMND56 / 11,1956 /
      DATA AMND65 / 9,1965 /
      NRA3(2) = 0
      IF (COMPMY(BENDAT,AMND56).LT.0) THEN
        NRA3(1) = 65
        RETURN
      END IF
      IF (COMPMY(BENDAT,AMND65).LT.0) THEN
        NRA3(1) = 62
        RETURN
      END IF
      NRA3(1) = 60
      RETURN
      END
C
C  Function to set amount of monthly credit
C
      DOUBLE PRECISION FUNCTION RETCR(MELGYR)
      INTEGER MELGYR
      IF (MELGYR.LT.28) RETCR= 1./1200.
      IF (MELGYR.GE.28.AND.MELGYR.LT.36) RETCR=1./400.
      IF (MELGYR.GT.35.AND.MELGYR.LT.54) RETCR =
     &((MELGYR-34)/2)/2400. + 1./400.
      IF (MELGYR.GE.54) RETCR= 2./300.
      RETURN
      END
