C  @(#)piacal.f	1.59  2/24/97
C
C  This subroutine computes the PIA (Primary Insurance Amount) and
C  MFB (Maximum Family Benefit) under the applicable computation
C  methods for most cases of benefit award, whether past, present,
C  or projected.  This is not the same program used in Social
C  Security benefit operations; it is used solely for cost-estimating
C  purposes in the Office of the Actuary.
C
C  The following are specifically considered:
C
C  1.  Retirement, survivors, or disability case.
C  2.  Male or female worker.
C  3.  Date of birth.
C  4.  Age in years and months at retirement.
C  5.  Date of death or disability.
C  6.  Projected benefit increases, average wages, and wage bases
C      for projected benefits.
C  7.  All rounding rules.
C  8.  All amendments to the Social Security Act through December 1989.
C  9.  Provision for 10 years of catch-up benefit increases.
C  10. Prior disability in old-age and survivor cases.
C
C  In addition, certain changes from present law can be handled via
C  variable JIND.
C
C  The following are some of the limitations:
C
C  1.  Some approximations are made in the benefit calculations for
C      entitlements prior to 1961.
C  2.  Some approximations are made in the $122 frozen minimum PIA
C      calculation.
C  3.  No distinction is made between initial awards and benefit
C      recomputations.  This is generally a problem only for initial
C      entitlements prior to 1961.
C  4.  Any applicable insured status requirement is assumed to be met.
C
C    Definition of Variables ('*' before variable name denotes
C    variable array, with indices I, J, K, ...):
C
C  I      = temporary index used in do-loops.
C  I1     = temporary index used in various places.
C  ITRANS = transitional guarantee period.
C *REGOS  = Regular Old-Start quantities where alternative exists
C           I=1 is PIA, 2 is PIAEL, 3 is PIAW, 4 is MFB, 5 is MFBEL.
C
      SUBROUTINE PIAC
      DOUBLE PRECISION REGOS(5)
      INTEGER AMND50(2), AMND82(2), AGE62(2), I, I1, ITRANS
C  Function declarations
      DOUBLE PRECISION ROUND, DIMAX
      INTEGER COMPMY
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
C
C  Data initialization
      DATA AMND50 / 9,1950 /
      DATA AMND82 / 6,1982 /
C
C  Initialize variables
C
      IAPPS = 0
      ARFAPP = 0
      ISPMNT(1) = 0
      ISPMNT(2) = 0
      IWIND=0
      NOLD=0
      METHOS=0
      SUPPIA = 0.
      DO 10 I=1,3
      PERCP(I)=0.
      PERCW(I)=0.
      IBENDP(I)=0
   10 JBENDP(I)=0
      DO 20 I=1,4
      PERCM(I) = 0.
   20 IBENDM(I)=0
      DO 30 I=1,IX
      DO 30 I1=1,MAXCAL
      IORDER(I1,I) = 0
   30 VEARN(I1,I)=0.
      DO 40 I=1,MAXCAL
      PIAW(I) = 0.
      IAME(I)=0
      CAP(I) = 0.
      ICAP(I) = 0
      PIAEL(I)=0.
      MFBEL(I)=0.
      PIA(I)=0.
      MFB(I)=0.
      IYCPI(I)=0
   40 IAPP(I)=0.
C  Fill out array with age 62
      AGE62(1) = KBIRTH(1)
      AGE62(2) = KBIRTH(3)+62
C  Calculate number of benefit increases applied to 1973 Act PIA Table
      IYCPI(2) = 0
      IF (BENDAT(2).GT.1974) THEN
        IYCPI(2) = BENDAT(2)-1975
C  Set month of benefit increase in year of entitlement
        MONBEN = 6
        IF (BENDAT(2).GE.1983) MONBEN = 12
C  If entitled in month of benefit increase or later, increase by 1
        IF (BENDAT(1).GE.MONBEN) IYCPI(2) = IYCPI(2)+1
      END IF
      CALL ICCHPC
C  Set first year of post-1950 earnings
      IERN50=MAX0(1,IBEGIN-1950)
C  If entitlement is before 1973, go on to next section
      IF (BENDAT(2).GT.1972.AND..NOT.TOTALI) CALL SPECMN()
C  If this is old-law calculation, do this section even if eligibility
C  is after 1978
      IF (JIND(1).GT.0.AND.IELGYR(2).GT.27.AND..NOT.TOTALI)
     &CALL PIATAB
C  Do notch proposals involving PIA table
      ITRANS = 5
      IF (JIND(17).GT.0) ITRANS = 5*JIND(17)
      IF (JIND(19).EQ.1) ITRANS=5
      IF (JIND(21).GT.0) ITRANS = 5*JIND(21)
      IF (JIND(22).GT.0) ITRANS=13
      IF (JIND(25).GT.0) ITRANS = 5*JIND(25)
      IF (JIND(26).GT.0) ITRANS=10
      IF ((JIND(17).GT.0.OR.JIND(19).GT.0.OR.JIND(21).GT.0.OR.
     &JIND(22).GT.0.OR.JIND(25).GT.0.OR.JIND(26).GT.0).AND.
     &IELGYR(2).GT.27.AND.IELGYR(1).LT.28+ITRANS.AND.IOASDI.NE.3.
     &AND..NOT.TOTALI) CALL PIATAB
      IF (JIND(20).GT.0.AND.IELGYR(2).GT.27.AND.IOASDI.NE.3.
     &AND..NOT.TOTALI) CALL PIATAB
C  If this is eligibility after 1978 or prior to 1953, go on to next
C  section
      IF (IELGYR(2).LT.28.AND.BENDAT(2).GT.1952.AND.
C  If this is a survivor case with death prior to 1953, go on to
C  next section
     &(IOASDI.NE.2.OR.IDEATH(2).GT.1952).AND.
C  Do not call PIA table if this is retroactive wage indexing
     &(JIND(29).EQ.0.OR.BENDAT(2).LT.JSTART(1,29))) CALL PIATAB
C  If this is not retirement or death within transition period,
C  go on to next section
      IF (JIND(16).EQ.2.OR.JIND(17).EQ.2.OR.JIND(18).EQ.2) ITRANS=10
      IF ((IELGYR(2).GT.27.AND.IELGYR(1).LT.28+ITRANS.AND.IOASDI.NE.3).
     &AND.(IOASDI.NE.2.OR.COMPMY(IDEATH,AGE62).GE.0).AND..NOT.TOTALI)
     &CALL TRNSGR
C  If this is not eligibility in 1979 or later, skip to next section
      IF (IELGYR(2).GT.27.OR.(JIND(29).GT.0.AND.
     &BENDAT(2).GE.JSTART(1,29))) CALL WAGIND
C  Must have a QC prior to 1951 for old-start
      IF (IQCT50.GT.0.AND.(KBIRTH(3).LT.1929.OR.IQCT51.LT.6))
     &CALL OLDSTR(REGOS)
C  If this is not a widow case with worker's eligibility 
C  in 1979 or later, skip to next section
      IF (IELGYR(2).GT.27.AND.IOASDI.EQ.2.AND.JSURV.GT.1.AND.
C  Death must be prior to month of attainment of age 62
     &(IDEATH(2).LT.(KBIRTH(3)+62).OR.(IDEATH(2).EQ.(KBIRTH(3)+62).
     &AND.IDEATH(1).LT.KBIRTH(1))).AND.
C  Widow must be eligible in 1985 or later, if worker died before 1985
     &(KELGYR.GT.33.OR.IDEATH(2).GE.1985).AND..NOT.TOTALI)
     &CALL REINDW
C  Frozen minimum
      IF (IELGYR(2).GT.27.AND.IELGYR(1).LT.31.AND..NOT.TOTALI)
     &CALL FROZMN
C  Reset transitional guarantee, if necessary
      IF (JIND(17)+JIND(18)+JIND(19)+JIND(26).GT.0.AND.
     &(IELGYR(2).GT.27.AND.IELGYR(1).LT.28+ITRANS.AND.IOASDI.NE.3).
     &AND.(IOASDI.NE.2.OR.COMPMY(IDEATH,AGE62).GE.0).AND..NOT.TOTALI)
     &CALL TRGRLC(ITRANS)
C
C  Calculate highest PIA and MFB
C
      HIPIA=0.
      IAPPN = 0
      DO 960 I=1,MAXCAL
      IF (HIPIA.LT.PIA(I)) THEN
        HIPIA = PIA(I)
C  Set applicable method number
        IAPPN = I
      END IF
  960 CONTINUE
C  Set applicable method number
      IF(IAPPN.GT.0) IAPP(IAPPN) = 2
C  Find support PIA
      IF (ARF.GT.1.0.AND.IAPPN.EQ.5) THEN
        DO 970 I=1,MAXCAL
        IF (SUPPIA.LT.PIA(I).AND.I.NE.5) THEN
          SUPPIA = PIA(I)
          IAPPS = I
        END IF
  970   CONTINUE
        IAPP(IAPPS) = 3
      END IF
C  Calculate MFB for Disability Amendments of 1980
      IF (IOASDI.EQ.3.AND.
C  If entitlement prior to June 1980, skip over 1980 Amendments
     &(IENT(2).GE.1981.OR.(IENT(2).EQ.1980.AND.IENT(1).GT.6)).AND.
C  If eligibility prior to 1979, skip over 1980 amendments
     &IELGYR(2).GE.28) THEN
      DO 980 I=1,MAXCAL
      IF (IAPP(I).GT.0) MFB(I) = DIMAX(I,IAME(3),PIA(I),1.5*PIA(3))
  980 CONTINUE
      END IF
      IF (IAPPN.GT.0) HIMFB = MFB(IAPPN)
C  Calculate benefit payable
      IF (IENT(1).GE.6) THEN
        I1 = IENT(2)-1950
      ELSE
        I1 = IENT(2)-1951
      END IF
C  Check for special minimum with delayed retirement credit
      IF (IAPPS.GE.1) THEN
        BENFIT(1) = ROUND(ARF*SUPPIA,I1)
        IF (BENFIT(1).GT.PIA(5)) THEN
          ARFAPP = 2
        ELSE
          BENFIT(1) = PIA(5)
          ARFAPP = 1
        END IF
      ELSE
        IF (COMPMY(IENT,AMND50).LT.0) THEN
          BENFIT(1) = ARF*HIPIA
        ELSE
          BENFIT(1) = ROUND(ARF*HIPIA,I1)
        END IF
      END IF
C  Round to lower dollar if June 1982 or later
      IF (COMPMY(BENDAT,AMND82).GE.0) THEN
        BENFIT(2) = DINT(BENFIT(1))
      ELSE
        BENFIT(2) = BENFIT(1)
      END IF
      RETURN
      END
C
C  Subroutine to calculate Special Minimum PIA
C
C  MFBT   = test MFB.
C
      SUBROUTINE SPECMN()
      INTEGER I
      DOUBLE PRECISION MFBT
C  Function declarations
      DOUBLE PRECISION ROUND, SPMINC
      INTEGER SPMNTC,MFBOLC
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'piadataf.h'
    3 FORMAT ('   Working on special minimum PIA')
      IF (IPRMPT.EQ.1) WRITE (6,3)
      IAPP(5)=1
      IAPPN = 5
C  Find years of coverage
      ISPMNT(1) = SPMNTC()
C  Set amount per year of coverage
      SPMIN = SPMINC(BENDAT)
C  Limit usable years of coverage to those in excess of 10, up to 20
C  usable years
      ISPMNR = 30
C  Change maximum years, if applicable
      IF ((MOD(JIND(13),4).EQ.2.OR.MOD(JIND(13),4).EQ.3).AND.
     &IENT(2).GE.JSTART(1,13)) ISPMNR = JSPMIN
      IYRSPM = MIN0(ISPMNT(1),ISPMNR) - 10
      IYRSPM = MAX0(0,IYRSPM)
C  PIA equals SPMIN times years of coverage between 10 and 30
      PIA(5) = FLOAT(IYRSPM)*SPMIN
C  Save "base" PIA for output purposes
      PIAEL(5) = PIA(5)
C  Find MFB by first checking if 1979 or later
      IF (BENDAT(2).LT.1979) THEN
        IAME(5) = MFBOLC(0)
      ELSE
C  Find January 1979 MFB
        MFB(5) = ROUND(1.5*PIA(5),28)
        MFBEL(5) = MFB(5)
C  Apply benefit increases if June 1979 or later
C  Number of benefit increases is 4 less than for PIA Table
      IYCPI(5)=IYCPI(2)-4
        IF (IYCPI(5).GT.0) THEN
          DO 670 I=29,28+IYCPI(5)
          PIA(5) = ROUND(PIA(5)*(CPIINC(I)/100.+1.),I)
          MFB(5) = ROUND(MFB(5)*(CPIINC(I)/100.+1.),I)
C  Test that MFB is at least 150% of PIA
          MFBT = ROUND(1.5*PIA(5),I)
          IF (MFB(5).LT.MFBT) MFB(5) = MFBT
C  Apply catch-up increase to PIA
          CALL BICCHP (I,PIA(5),1)
C  Apply catch-up increase to MFB
          CALL BICCHP (I,MFB(5),1)
C  Test that MFB is at least 150% of PIA
          MFBT = ROUND(1.5*PIA(5),I)
          IF (MFB(5).LT.MFBT) MFB(5) = MFBT
  670     CONTINUE
        END IF
      END IF
      RETURN
      END
C
C  Subroutine to calculate PIA Table PIA
C
C  N2     = number of computation years after modification for notch
C           proposals.
C
      SUBROUTINE PIATAB
      INTEGER N2, I1, IERN49, I, AMND74(2), I2
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      INTEGER I49C2,MFBOLC,CPIBAS,OLDPIA,COMPMY,IERSET
      LOGICAL ISFRZY
      REAL Z4SET
      DATA AMND74 / 6,1974 /
    4 FORMAT ('   Working on PIA Table calculation')
      IF (JIND(23).GT.0.AND.IENT(2).GE.JSTART(1,23)) RETURN
C  If a survivor case, death must be in month of attainment of age
C  62 or later for guarantee-type computations
      IF (IOASDI.EQ.2.AND.(IDEATH(2).LT.(KBIRTH(3)+62).OR.(IDEATH(2).EQ.
     &(KBIRTH(3)+62).AND.IDEATH(1).LT.KBIRTH(1))).AND.IELGYR(2).GT.27.
     &AND.JIND(1).EQ.0) RETURN
      IAPP(2) = 1
      IAPPN = 2
      IF (IPRMPT.EQ.1) WRITE (6,4)
      N2 = N
      IF (JIND(20).GT.0) N2 = MIN0(N,25)
      I1 = IERNYR
      IERN49 = I49C2()
      IF (JIND(22)+JIND(26).GT.0) I1 = MIN0(IERNYR,IELGYR(1)+4)
      IF (TOTALI) THEN
        I2 = 4
      ELSE
        I2 = 3
      END IF
C  Set earnings to be used
      DO 710 I=IERN50,IERNYR
  710 IF (.NOT.ISFRZY(I+1950)) VEARN(2,I) = EARNST(I+14,I2)
C  Order the earnings and compute average monthly earnings
      CALL ORDER (IERN50,I1,N2,IERN49,IELGYR(2))
C  See which PIA Table to use
      IF (COMPMY(BENDAT,AMND74).LT.0) THEN
        ITABEL(2) = OLDPIA(2)
      ELSE
C  Use 1973 Act
        I1=24+IYCPI(2)
C  Set number of reduction increments for new Roybal and Sanford
        Z4 = Z4SET()
C  Set number of years of significant earnings for Myers COLA-holdback
        IERN30 = IERSET()
        ITABEL(2) = CPIBAS (I1,0,IELGYR(2),IAME(2),PIAEL(2),MFBEL(2),
     &  PIA(2),MFB(2),ICCHUP)
        IF (TOTALI) THEN
          PIAEL(2) = PIA(2)
          CALL PRORAT
          PIA(2) = PIAEL(2)
          I = MFBOLC(1)
        END IF
      END IF
      RETURN
      END
C
C  Subroutine to calculate Transitional Guarantee PIA
C
      SUBROUTINE TRNSGR
      INTEGER I,I2
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      INTEGER CPIBAS
      LOGICAL ISFRZY
    5 FORMAT ('   Working on transitional guarantee PIA')
C  If this is old-law calculation, skip over this section
      IF (JIND(1).GT.0) RETURN
      IF (JIND(24).GT.0.AND.IENT(2).GE.JSTART(1,24)) RETURN
C  If a survivor case, death must be in month of attainment of age
C  62 or later
      IF (IOASDI.EQ.2.AND.(IDEATH(2).LT.(KBIRTH(3)+62).OR.(IDEATH(2).EQ.
     &(KBIRTH(3)+62).AND.IDEATH(1).LT.KBIRTH(1)))) RETURN
      IAPP(4)=1
      IAPPN = 4
      IF (IPRMPT.EQ.1) WRITE (6,5)
      IF (TOTALI) THEN
        I2 = 4
      ELSE
        I2 = 3
      END IF
C  Set earnings to be used, up to year prior to eligibility
      DO 760 I=IERN50,IELGYR(2)
  760 IF (.NOT.ISFRZY(I+1950)) VEARN(4,I) = EARNST(I+14,I2)
C  Use additional earnings if change in law
      IF (JIND(16).GT.0.OR.JIND(18).GT.0) THEN
        DO 765 I=IELGYR(2)+1,IERNYR
  765   IF (.NOT.ISFRZY(I+1950)) VEARN(4,I) = EARNST(I+14,I2)
      END IF
C  Order the earnings and compute average monthly earnings
      IF (JIND(16).GT.0.OR.JIND(18).GT.0) THEN
        CALL ORDER (IERN50,IERNYR,N,IERNYR,IELGYR(2))
      ELSE
        CALL ORDER (IERN50,IELGYR(1),N,IELGYR(1),IELGYR(2))
      END IF
C  Calculate Dec 1978 PIA
      ITABEL(4) = CPIBAS (28,1,IELGYR(2),IAME(4),PIAEL(4),MFBEL(4),
     &PIA(4),MFB(4),ICCHUP)
C  Find AIME MFB from Wage-Indexed formula
      CALL MFBSET(IELGYR(2),IBENDM)
      CALL MFBCAL (4,IELGYR(2),PIAEL(4),MFBEL(4),MFB(4))
C  Apply CPI increases to PIA and MFB
      CALL CPI77 (IELGYR(2),JIND(10),JSTART(1,10),IYCPI(4),
     &PIA(4),ICCHUP)
      CALL CPI77 (IELGYR(2),JIND(10),JSTART(1,10),IYCPI(4),
     &MFB(4),ICCHUP)
      RETURN
      END
C
C  Subroutine to calculate Wage-Indexed PIA
C
C  I      = temporary index used in do-loops.
C
      SUBROUTINE WAGIND
      INTEGER I,I2
      DOUBLE PRECISION TEST
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      DOUBLE PRECISION ROUND
      INTEGER SPMNTC, WEPAPP
      REAL PERCWS, PAIMEC
      LOGICAL ISFRZY
    6 FORMAT ('   Working on wage-indexed PIA')
      IF (IPRMPT.EQ.1.AND.JIND(1).EQ.0) WRITE (6,6)
C  Assign values to PIA formula percents and bend points
      CALL SPERCP(PERCP)
      CALL BENDPC(IELGYR(3),IBENDP)
C  If this is old-law calculation, skip over this section
      IF (JIND(1).GT.0) RETURN
      IAPP(3)=1
      IAPPN = 3
      ITABEL(3) = 10
C  Calculate indexing series if JIND(4) is set
      IF (JIND(4).GT.0) CALL FACTC
      IF (TOTALI) THEN
        I2 = 4
      ELSE
        I2 = 3
      END IF
C  Calculate indexed earnings
      DO 810 I=IERN50,IELGYR(3)-1
      IF (.NOT.ISFRZY(I+1950)) THEN
C  Multiply by average earnings in base year
        UEARN(I) = FQ(IELGYR(3)+13)*EARNST(I+14,I2)
C  Multiply by FACT if JIND(4) is set
        IF (JIND(4).GT.0) UEARN(I) = FACT(IELGYR(3)+13)*
     &  EARNST(I+14,I2)
C  Divide by average earnings in year 1950+I (1936+I+14)
        VEARN(3,I) = UEARN(I)/FQ(I+14)
C  Divide by FACT if JIND(4) is set
        IF (JIND(4).GT.0) VEARN(3,I) = UEARN(I)/FACT(I+14)
C  Round to nearest cent
        VEARN(3,I) = ANINT(VEARN(3,I)*100.)/100.
      END IF
  810 CONTINUE
C  Earnings after base year are not indexed
      DO 820 I=IELGYR(3),IERNYR
  820 IF (.NOT.ISFRZY(I+1950)) VEARN(3,I) = EARNST(I+14,I2)
C  Order indexed earnings and average highest N to determine AIME
      CALL ORDER (IERN50,IERNYR,N,IERNYR,IELGYR(3))
C  Reproject bend points if necessary
      IF (JIND(2)+JIND(3)+JIND(5)+JIND(6)+JIND(7).GT.0)
     &CALL BPCAL(IELGYR(3),IBENDP)
C  Reset formula percents if necessary
      IF (JIND(5)+JIND(9).GT.0) CALL PERCAL(IELGYR(3),PERCP)
C  Find portion of AIME in each AIME interval and PIA at eligibility
      PIAEL(IAPPN) = PAIMEC(IBENDP,PERCP,IELGYR(3))
C  Round the AIME PIA
      PIAEL(3) = ROUND (PIAEL(3),IELGYR(3))
C  Apply windfall provision, if applicable
      IF (JIND(12).EQ.1.AND.IELGYR(3).GE.JSTART(1,12)-1951) GO TO 870
      IF (WEPAPP().EQ.0) GO TO 870
      ISPMNT(2) = SPMNTC()
C  Check for special minimum savings clause
      IF (ISPMNT(2).GE.30) THEN
        IWIND = -1
      ELSE
C  Trial PIA is reduced by half of pension
        PIAW(3) = PIAEL(3)
        IWIND = 1
        TEST = ROUND(.5*DBLE(PUBPEN),IELGYR(3))
        PIAEL(3) = ROUND(PIAEL(3)-TEST,IELGYR(3))
        CALL SPERCP(PERCW)
        PERCW(1) = PERCWS(IELGYR(3),BENDAT(2),ISPMNT(2))
C  Recalculate the AIME PIA
        TEST = 0.
        DO 860 I=1,3
  860   TEST = TEST + PERCW(I)*PAIME(I,3)
C  Round the AIME PIA
        TEST = ROUND (TEST,IELGYR(3))
C  Take maximum of two trial PIA's
        IF (TEST.GT.PIAEL(3)) THEN
        IWIND=2
        PIAEL(3) = TEST
        END IF
      END IF
C  Set the PIA
  870 PIA(3)=PIAEL(3)
C  Apply real-wage-gain adjustment
      CALL RWGADJ(IELGYR(3),3)
C  Apply CPI increases to PIA
      CALL CPI77 (IELGYR(3),JIND(10),JSTART(1,10),IYCPI(3),
     &PIA(3),ICCHUP)
      CALL MFBSET(IELGYR(3),IBENDM)
      IF (TOTALI) CALL PRORAT
C  Calculate the AIME MFB
      CALL MFBCAL (3,IELGYR(3),PIAEL(3),MFBEL(3),MFB(3))
C  Apply CPI increases to MFB
      CALL CPI77 (IELGYR(3),JIND(10),JSTART(1,10),IYCPI(3),
     &MFB(3),ICCHUP)
      RETURN
      END
C
C  Subroutine to calculate Re-indexed Widow Guarantee PIA
C
      SUBROUTINE REINDW
      INTEGER I2, I
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      DOUBLE PRECISION ROUND
      REAL PAIMEC
      LOGICAL ISFRZY
    7 FORMAT ('   Working on re-indexed widow guarantee')
C  IF JIND(11) set skip over
      IF (JIND(11).GT.0.AND.IENT(2).GE.JSTART(1,11)) RETURN
      IAPP(6)=1
      IAPPN = 6
      IF (IPRMPT.EQ.1) WRITE (6,7)
C  Assign values to PIA formula percents
      CALL SPERCP(JPERCP)
C  Set eligibility year by considering year of death and widow's year
C  of eligibility
      JELGYR = MAX0(IELGYR(1),KELGYR)
C  Use 2 years prior to worker's age 62 point if that is earlier
      JELGYR=MIN0(JELGYR,KBIRTH(3)+62-1951)
      IF (TOTALI) THEN
        I2 = 4
      ELSE
        I2 = 3
      END IF
C  Calculate indexed earnings
      DO 910 I=IERN50,JELGYR-1
      IF (.NOT.ISFRZY(I+1950)) THEN
C  Multiply by average earnings in base year
        XEARN(I) = FQ(JELGYR+13)*EARNST(I+14,I2)
C  Divide by average earnings in year 1950+I (1936+I+14)
        VEARN(6,I) = XEARN(I)/FQ(I+14)
C  Round to nearest cent
        VEARN(6,I) = ANINT(VEARN(6,I)*100.)/100.
      END IF
  910 CONTINUE
C  Earnings after base year are not indexed
      DO 920 I=JELGYR,IERNYR
  920 IF (.NOT.ISFRZY(I+1950)) VEARN(6,I) = EARNST(I+14,I2)
C  Order indexed earnings and average highest N to determine AIME
      CALL ORDER (IERN50,IERNYR,N,IERNYR,IELGYR(2))
C  Project applicable bend points from 1979 bend points
      CALL BENDPC(JELGYR,JBENDP)
C  Reproject bend points if necessary
      IF (JIND(2)+JIND(3)+JIND(5)+JIND(6)+JIND(7).GT.0)
     &CALL BPCAL(JELGYR,JBENDP)
C  Reset formula percents if necessary
      IF (JIND(5)+JIND(9).GT.0) CALL PERCAL(JELGYR,JPERCP)
C  Find portion of AIME in each AIME interval
      PIAEL(IAPPN) = PAIMEC(JBENDP,JPERCP,JELGYR)
C  Round the AIME PIA
      PIAEL(IAPPN) = ROUND(PIAEL(IAPPN),JELGYR)
      PIA(IAPPN) = PIAEL(IAPPN)
      JCCHUP = MAX0(JELGYR-ISTART+1,1)
      IF (JCCHUP.GT.10) JCCHUP = 10
C  Set the MFB at eligibility equal to that for wage-indexed
      MFBEL(6)=MFBEL(3)
C  Apply real-wage-gain adjustment
      CALL RWGADJ(JELGYR,6)
C  Apply CPI increases to PIA
      CALL CPI77 (JELGYR,JIND(10),JSTART(1,10),IYCPI(6),
     &PIA(6),JCCHUP)
C  Set the MFB at entitlement equal to that for wage-indexed
      MFB(6)=MFB(3)
      RETURN
      END
C
C  Subroutine to calculate frozen minimum
C
      SUBROUTINE FROZMN
      INTEGER I1
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'lawchgf.h'
    1 FORMAT ('   Working on frozen minimum PIA')
      IAPP(7) = 1
      IF (IPRMPT.EQ.1) WRITE (6,1)
C  Set to at least $122 and $183 IF eligible prior to 1982
      PIA(7) = 122.D0
      PIAEL(7) = PIA(7)
      MFB(7) = 183.D0
      MFBEL(7) = MFB(7)
      IF (IENT(2).LT.KBIRTH(3)+65) THEN
        I1 = IENT(2)-1951
      ELSE
        I1 = KBIRTH(3)+65-1951
      END IF
C  Apply CPI increases beginning with earlier of year of entitlement
C  or year of age 65
      CALL CPI77 (I1,JIND(10),JSTART(1,10),IYCPI(7),
     &PIA(7),ICCHUP)
      CALL CPI77 (I1,JIND(10),JSTART(1,10),IYCPI(7),
     &MFB(7),ICCHUP)
      RETURN
      END
C
C  Subroutine to apply CPI increases to 1977 Amendments PIA or MFB
C
C *CPIINC = benefit increase in year 1950+J.
C  FIRSTY = first year of benefit increase minus 1951.
C  I12    = last year of benefit increase.
C  I13    = temporary index.
C  I16    = index of year of eligibility for catch-up benefit increases.
C  I17    = 1 if no benefit increase in year of eligibility, 0
C           otherwise.
C  I18    = first year of no benefit increase in year of eligibility.
C  I19    = number of years for which benefit increases are applied.
C  PIA77  = PIA or MFB to be increased.
C
      SUBROUTINE CPI77 (FIRSTY,I17,I18,I19,PIA77,I16)
      INTEGER I12, I13, FIRSTY, I16, I17, I18, I19, DATE1(2)
      DOUBLE PRECISION ROUND, PIA77
      INTEGER COMPMY
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piaparmsf.h'
      I19=0
      DATE1(1) = MONBEN
      DATE1(2) = FIRSTY+1951
C  If year of entitlement = year of eligibility, and entitlement is
C  prior to benefit increase month, there are no CPI increases applied
      IF (COMPMY(BENDAT,DATE1).LT.0) RETURN
C  Do not apply any increases prior to 1979, unless law change
      IF (FIRSTY+1.LE.28.AND.JIND(29).EQ.0) RETURN
C  Set last year of benefit increase
      I12 = BENDAT(2)-1951
C  If entitled in benefit increase month or later, apply benefit
C  increase in year of entitlement
      IF (BENDAT(1).GE.MONBEN) I12 = I12+1
C  Apply increases
      DO 10 I13=FIRSTY+1,I12
C  Do not apply increase if this is year of eligibility, JIND(10) is
C  set, and this is in year JSTART(10) or later
      IF (I17.GT.0.AND.I13.EQ.FIRSTY+1.AND.FIRSTY.GE.I18-1951) GO TO 10
      IF (I13.LE.28) THEN
        PIA77 = ROUND(PIA77*(CPI29(I13)/100.+1.),I13)
      ELSE
        PIA77 = ROUND(PIA77*(CPIINC(I13)/100.+1.),I13)
      END IF
C  Apply catch-up increase
      CALL BICCHP (I13,PIA77,I16)
C  Increment benefit increase counter
   10 I19=I19+1
      RETURN
      END
C
C  Subroutine to calculate an MFB at eligibility under the 1977 law
C
C *FQ     = annual average wages in year 1936+I.
C  I30    = year prior to year of eligibility minus 1950.
C  I31    = temporary index.
C  I32    = method number.
C *IBENDM = MFB bend points under this method.
C  MFB77  = MFB at entitlement.
C  MFBL   = MFB at eligibility.
C *PERCM  = Wage-Indexed MFB formula percentages.
C  PIAL   = PIA at eligibility.
C *PPIAEL = portion of PIAEL in each interval of Wage-Indexed MFB
C             formula, for each method (meaningless for PIA Table
C             and Special Minimum).
C
      SUBROUTINE MFBCAL (I32,I30,PIAL,MFBL,MFB77)
      INTEGER I30, I31, I32
      DOUBLE PRECISION MFB77, MFBL, PIAL
C  Function declarations
      DOUBLE PRECISION ROUND
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Find the portion of AIME in each MFB formula interval
      PPIAEL(1,I32) = DMIN1(PIAL,DBLE(IBENDM(2)))
      PPIAEL(2,I32) = DMIN1(PIAL-DBLE(IBENDM(2)),DBLE(IBENDM(3)-
     1IBENDM(2)))
      PPIAEL(2,I32)=AMAX1(0.,PPIAEL(2,I32))
      PPIAEL(3,I32) = DMIN1(PIAL-DBLE(IBENDM(3)),DBLE(IBENDM(4)-
     1IBENDM(3)))
      PPIAEL(3,I32)=AMAX1(0.,PPIAEL(3,I32))
      PPIAEL(4,I32) = DMAX1(PIAL-DBLE(IBENDM(4)),0.D0)
      MFB77=0.
C  Add up the percents times the intervals
      DO 10 I31=1,4
   10 MFB77=MFB77+PERCM(I31)*PPIAEL(I31,I32)
C  Round the result
      MFB77 = ROUND (MFB77,I30)
      MFBL=MFB77
      RETURN
      END
C
C  Subroutine to order earnings to compute an AIME or AME
C
C *FTEARN = sum of high N years of earnings (meaningless for Special
C           Minimum).
C  I40    = temporary index.
C  I41    = temporary index.
C  I42    = temporary index.
C  I44    = first year of earnings in period to be considered.
C  I45    = last year of earnings in period to be considered.
C  I47    = number of high years to be selected.
C  I49    = starting point for 3-year limitation on recent earnings.
C  I50    = year of first eligibility (IELGYR(2)) for earnings limits.
C *IORDER = 1 for year I if earnings in year I are among highest N;
C             I=1 to 5 is method number, J is year-1936 for I=1,
C             otherwise year-1950.
C  ITEMP  = temporary storage for NORDER.
C  IX     = last year of period minus 1936.
C *NORDER = array of numbers of the years included in the highest N.
C  TEARN  = sum of high N years of earnings (double precision).
C  TEMP   = temporary storage for XEARN.
C *WEARN  = earnings to be ordered.
C
      SUBROUTINE ORDER (I44,I45,I47,I49,I50)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INTEGER NORDER(IX), I40, I41, I42, I44, I45, I47, I49,
     &I50, ITEMP
      DOUBLE PRECISION TEMP, TEARN, WEARN(IX)
      INCLUDE 'lawchgf.h'
C  Initialize arrays
      DO 10 I40=1,IX
      NORDER(I40) = I40
      WEARN(I40) = VEARN(IAPPN,I40)
   10 IORDER(IAPPN,I40) = 0
      IF(I45.EQ.I44)GO TO 25
C  I40 is index of first number in comparison
      DO 20 I40=I44,I45-1
      DO 20 I41=I40+1,I45
C  If earnings are already ordered, skip to END of LOOP
      IF (WEARN(I40).GT.WEARN(I41)) THEN
C  Switch earnings
        TEMP = WEARN(I40)
        WEARN(I40) = WEARN(I41)
        WEARN(I41) = TEMP
C  Switch indices of earnings
        ITEMP = NORDER(I40)
        NORDER(I40) = NORDER(I41)
        NORDER(I41) = ITEMP
      END IF
   20 CONTINUE
C  Apply Roybal-Daub-Sanford restriction on post-1978 earnings
      IF (IAPPN.LE.2.AND.(JIND(19)+JIND(20)+JIND(22)+JIND(26)).GT.0.AND.
     &I50.GT.27) CALL ROYBAL(I44,I45,I49,NORDER,WEARN)
C  I42 is index of least earnings used in summation
   25 I42 = MAX0(I45-I47+1,I44)
      TEARN=0.
C  Add up highest earnings and set indicator for earnings being used
      DO 30 I40=I42,I45
      ITEMP=NORDER(I40)
      IORDER(IAPPN,ITEMP)=1
   30 TEARN=TEARN+WEARN(I40)
C  Set floating-point value
      FTEARN(IAPPN)=TEARN
C  Divide by number of computation months and round down to integer
      IAME(IAPPN) = TEARN/(FLOAT(I47)*12.)
      IF (JIND(28).GT.0.AND.I50.GT.40.AND.IAPPN.EQ.3) CALL DROPIN(I44,
     &I45,I47,I50,NORDER,TEARN,JIND(28),WEARN)
      RETURN
      END
C
C  Subroutine to set index for catchup year of eligibility
C
      SUBROUTINE ICCHPC
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      ICCHUP = MAX0(IELGYR(2)-ISTART+1,1)
      IF (ICCHUP.GT.10) ICCHUP=10
      RETURN
      END
C
C  Subroutine to apply real-wage-gain adjustment
C
C  I130   = year prior to year of eligibility minus 1950.
C  I131   = number of applicable method.
C  IALTAW = average wage assumptions (1=TR alternative I, 2=TR
C             alternative II-B, 3=TR alternative III, 4=TR alternative
C             II-A, 5=no increase beyond last known value, 6=PEBES
C             calculation (1% real wage gains), 7=other assumptions.
C
      SUBROUTINE RWGADJ (I130,I131)
      INTEGER I130, I131
C  Function declarations
      DOUBLE PRECISION ROUND
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      IF (I130.LE.ISTART.OR.IALTAW.NE.6) RETURN
      PIARWG(I131) = ROUND(PIAEL(I131)*(1.+.01*(I130-ISTART)),ISTART)
      PIA(I131) = PIARWG(I131)
      IF (I131.EQ.3) THEN
        MFBRWG(I131) = ROUND(MFBEL(I131)*(1.+.01*(I130-ISTART)),ISTART)
        MFB(I131) = MFBRWG(I131)
      END IF
      RETURN
      END
C
C  Function to calculate DI MFB
C
      DOUBLE PRECISION FUNCTION DIMAX(I1,IAIME,PIA100,PIA150)
      INTEGER I1, IAIME
      DOUBLE PRECISION PIA100, PIA150
C  Function declarations
      DOUBLE PRECISION ROUND
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
      MFBEL(I1) = ROUND(.85*DBLE(IAIME),IELGYR(2))
      DIMAX = MFBEL(I1)
      CALL CPI77(IELGYR(2),JIND(10),JSTART(1,10),
     &IYCPI(3),DIMAX,ICCHUP)
C  Check for 150% of PIA
      IF(DIMAX .GT. PIA150) THEN
        CAP(I1) = 1.5
        ICAP(I1) = 1
        DIMAX = ROUND(PIA150,IELGYR(2))
      ELSE
C  Check for 100% of PIA
        IF (DIMAX.LT.PIA100) THEN
          CAP(I1) = 1.0
          ICAP(I1) = 3
          DIMAX = PIA100
        ELSE
C  Use 85% of AIME
          CAP (I1) = .85
          ICAP(I1) = 2
        END IF
      END IF
      END
C
C  Function to determine if WEP is applicable
C
      INTEGER FUNCTION WEPAPP()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      IF (PUBPEN.GT..001.AND.IELGYR(2).GT.34.AND.IOASDI.NE.2) THEN
        WEPAPP = 1
      ELSE
        WEPAPP = 0
      END IF
      RETURN
      END
C
C  Function to calculate number of years of coverage
C
      INTEGER FUNCTION SPMNTC()
      INTEGER I1, I2, I
      REAL SPMNPR(2), FACTOR
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'lawchgf.h'
C  Set percents of old-law base required for year of coverage
      DATA SPMNPR / .25,.15 /
C  Find years of coverage before 1951
C  Credit one year of coverage for each $900 of pre-1951 earnings
      IF (TOTALI) THEN
        I2 = 2
      ELSE
        I2 = 1
      END IF
      SPMNTC = INT(STOT(I2)/900.)
C  Limit pre-1951 years of coverage to 14
      SPMNTC = MIN0(SPMNTC,14)
      IF (IAPPN.EQ.5) IORDER(5,14) = SPMNTC
C  Find years of coverage after 1950
      I1 = MAX0(1951,IBEGIN)
      I2 = MIN0(IEND,IERNYR+1950)
      DO 600 I=I1,I2
      IF (IAPPN.EQ.5) THEN
        IF (I.LT.1991) THEN
          FACTOR = SPMNPR(1)
        ELSE
          FACTOR = SPMNPR(2)
        END IF
        IF (JIND(13).GT.3.AND.I.GE.JSTART(1,13)) FACTOR = BSPMIN
        PSPMIN(I-1950) = FACTOR
      ELSE
        FACTOR = SPMNPR(1)
      END IF
C  Use actual, not theoretical, earnings
      IF (EARNST(I-1936,1).GE.FACTOR*BASE77(I-1936)) THEN
        IF (IAPPN.EQ.5) IORDER(5,I-1936) = 1
        SPMNTC = SPMNTC+1
      END IF
  600 CONTINUE
      RETURN
      END
C
C  Subroutine to calculate pro rata totalization benefit
C
      SUBROUTINE PRORAT
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      DOUBLE PRECISION ROUND,DECVTP
      INTEGER DECVTA
      PIAELT(IAPPN) = PIAEL(IAPPN)
      PIATOT(IAPPN) = PIA(IAPPN)
      PIA(IAPPN) = ROUND(IQCTOT*PIA(IAPPN)/(4.*N),24+IYCPI(2))
      PIAEL(IAPPN) = DECVTP(IELGYR(2),IYCPI(IAPPN),PIA(IAPPN),ICCHUP)
      IF (IELGYR(2).GT.27) THEN
        AMETOT(IAPPN) = IAME(IAPPN)
        IAME(IAPPN) = DECVTA(PIAEL(IAPPN))
      END IF
      RETURN
      END
C
C  Function to deconvert pia back to year of eligibility
C
C  PIA77  = PIA or MFB to be deconverted.
C
      DOUBLE PRECISION FUNCTION DECVTP(MELGYR,I19,PIA77,I16)
      INTEGER MELGYR,I16,I19,I
      DOUBLE PRECISION PIA77
      INCLUDE 'wrkrdataf.h'
C  Function declarations
      DOUBLE PRECISION UNRND,UNBCCH
      DECVTP = PIA77
C  Return if there are no CPI increases applied
      IF (I19.LE.0) RETURN
C  Do not handle year of eligibility prior to 1979
      IF (MELGYR.LT.28) RETURN
C  Divide out increases, starting with last one
      DO 100 I=MELGYR+I19,MELGYR+1,-1
      DECVTP = UNRND(DECVTP/(1.+CPIINC(I)/100.),I)
  100 DECVTP = UNBCCH(I,DECVTP,I16)
C     DECVTP = UNBCCH(I,DECVTP,I16)
      RETURN
      END
C
C  Function to divide out catch-up benefit increases
C
C  BCATCH = amount to be deconverted
C
      DOUBLE PRECISION FUNCTION UNBCCH(I1,BCATCH,I2)
      INTEGER I1,I2
      DOUBLE PRECISION BCATCH
      INCLUDE 'wrkrdataf.h'
C  Function declarations
      DOUBLE PRECISION UNRND
      UNBCCH = BCATCH
      IF (I1.LT.ISTART+3.OR.I1.GT.ISTART+10) RETURN
      IF (CACHUP(I2,I1-ISTART-2).LT..05) RETURN
      UNBCCH = UNRND(UNBCCH/(CACHUP(I2,I1-ISTART-2)/100.+1.),I1)
      RETURN
      END
C
C  Function to return a PIA or MFB unrounded to the appropriate
C  multiple of $.10
C
      DOUBLE PRECISION FUNCTION UNRND(CRUDE,L)
      INTEGER L
      DOUBLE PRECISION CRUDE, Q, X100
      IF (L.GT.31) THEN
C  Round up to higher dime for June 1982 and later increases
        UNRND = DINT(10.*CRUDE+.999)/10.
        RETURN
      END IF
C  For rounding-down to dime, use half-cent rule for 1972 and
C  earlier increases; for 1973-81 benefit increases, round down to dime
C  in any case not already an exact multiple of $.10
      IF (L.GE.23) THEN
        Q = 9.99D0
      ELSE
        Q = 9.501D0
      END IF
      X100 = CRUDE*100.D0
C  If within tolerance of Q, do not round up
      IF (10.D0-DMOD(X100,10.D0).GT.Q) THEN
        UNRND = CRUDE + .10D0 - DMOD(X100,10.D0)/100.D0
C  Otherwise round down to dime
      ELSE
        UNRND = CRUDE - DMOD(X100,10.D0)/100.D0
      END IF
      RETURN
      END
C
C  Function to find AME from PIA in PIA table
C
C  BELOWM = 0 to not adjust for PIA below minimum, 1 to adjust
C
      INTEGER FUNCTION MFBOLC(BELOWM)
      INTEGER BELOWM,I1,I,AMND74(2)
      DOUBLE PRECISION PIASM
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      DOUBLE PRECISION ROUND
      INTEGER CPIBAS,PL1972,COMPMY
      DATA AMND74 / 6,1974 /
C  Find old-law MFB from PIA Table for pre-1977 Special Minimum
C  Start with lowest applicable AME
      MFBOLC = 76
C  Test to see which PIA Table to use
  610 IF (COMPMY(BENDAT,AMND74).LT.0) THEN
C  Use 1972 Act for entitlements up to May 1974
        I = PL1972 (MFBOLC,PIASM,MFB(IAPPN))
      ELSE
C  Number of benefit increases is same as for PIA Table
        I1 = IYCPI(2)+24
        ITABEL(IAPPN) = CPIBAS (I1,0,IELGYR(2),MFBOLC,PIAEL(IAPPN),
     &  MFBEL(IAPPN),PIASM,MFB(IAPPN),ICCHUP)
      END IF
C  Test to see if test PIA is greater than Special Minimum PIA
      IF (PIA(IAPPN).LT.PIASM+.01) GO TO 620
C  Increment AME and try again
      MFBOLC = MFBOLC + 1
      IF (MFBOLC.LT.1000) GO TO 610
  620 IF (BELOWM.GT.0.AND.MFBOLC.EQ.76) MFB(IAPPN) =
     &ROUND(1.5*PIA(IAPPN),IYCPI(2)+24)
      RETURN
      END
C
C  Function to deconvert AIME from raw PIA
C
      INTEGER FUNCTION DECVTA(PIASUB)
      DOUBLE PRECISION PIASUB
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      IF (PIASUB.LT.PERCP(1)*FLOAT(IBENDP(2))) THEN
        DECVTA = INT(10.*PIASUB/9.)
      ELSE
        IF (PIASUB.LT.(PERCP(1)-PERCP(2))*FLOAT(IBENDP(2)) +
     &  PERCP(2)*FLOAT(IBENDP(3))) THEN
          DECVTA = INT((100.*PIASUB-(PERCP(1)-PERCP(2))*
     &    FLOAT(IBENDP(2)))/PERCP(2))
        ELSE
          DECVTA = INT((100.*PIASUB-(PERCP(1)-PERCP(2))*
     &    FLOAT(IBENDP(2))-(PERCP(2)-PERCP(3))*FLOAT(IBENDP(3)))/
     &    PERCP(3))
        END IF
      END IF
      IF (IELGYR(2).GT.31) DECVTA = DECVTA + 1
      RETURN
      END
C
C  Subroutine to set amount per year of coverage for special minimum
C
      DOUBLE PRECISION FUNCTION SPMINC(DATE1)
      INTEGER DATE1(2), AMND72(2), AMND74(2), AMND77(2)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
C  Function declarations
      INTEGER COMPMY
      DATA AMND72 / 1,1973 /
      DATA AMND74 / 3,1974 /
      DATA AMND77 / 1,1979 /
C  Set amount depending on year of retirement, starting with January 1979
      SPMINC = 11.50
C  From Jan 1973 to Feb 1974, was $8.50 per year of coverage
      IF (COMPMY(DATE1,AMND72).GE.0.AND.COMPMY(DATE1,AMND74).LT.0)
     &SPMINC = 8.50
C  From March 1974 to Dec 1978, was $9.00 per year of coverage
      IF (COMPMY(DATE1,AMND74).GE.0.AND.COMPMY(DATE1,AMND77).LT.0)
     &SPMINC = 9.00
C  Change dollar amount, if applicable
      IF (MOD(JIND(13),2).EQ.1.AND.DATE1(2).GE.JSTART(1,13))
     &SPMINC = ASPMIN
      RETURN
      END
C
C  Subroutine to find portion of AIME in each AIME interval, and the
C  PIA at eligibility
C
      REAL FUNCTION PAIMEC(MBENDP,MPERCP,MELGYR)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'lawchgf.h'
      INTEGER MBENDP(MAXBP), I, MELGYR
      REAL MPERCP(MAXBP), TEMP
      TEMP = 0
      PAIME(1,IAPPN) = AMIN0(IAME(IAPPN), MBENDP(2))
      PAIME(2,IAPPN) = AMIN0(IAME(IAPPN)-MBENDP(2), MBENDP(3)-MBENDP(2))
      PAIME(2,IAPPN) = AMAX1(0., PAIME(2,IAPPN))
      IF (JIND(5).GT.0.AND.MELGYR+1951.GE.JSTART(1,5).AND.
     &NUMBP.EQ.3) THEN
        PAIME(3,IAPPN) = AMIN0(IAME(IAPPN)-MBENDP(3),
     &    MBENDP(4)-MBENDP(3))
        PAIME(3,IAPPN) = AMAX1(0., PAIME(3,IAPPN))
        PAIME(4,IAPPN) = AMAX0(IAME(IAPPN)-MBENDP(4), 0)
C  Find AIME PIA
        DO 800 I=1,4
  800   TEMP = TEMP + MPERCP(I) * PAIME(I,IAPPN)
      ELSE
        PAIME(3,IAPPN) = AMAX0(IAME(IAPPN)-MBENDP(3), 0)
C  Find AIME PIA
        DO 850 I=1,3
  850   TEMP = TEMP + MPERCP(I) * PAIME(I,IAPPN)
      END IF
      PAIMEC = TEMP
      END
