C  @(#)wgbase.f	1.6   3/27/96
C
C  Subroutine to project wage bases.
C
C  This subroutine projects the wage base given the wage bases through
C  at least 1986, the average wage and benefit increases, and
C  the years of CPI-indexed wage base, if any.
C
C  Definition of variables (* before a variable name denotes an
C  arrayed variable, with indices I, J, ...)
C
C *BASET  = wage base series to be projected.
C  BASEUN = intermediate, unrounded wage base.
C  DEFCMP = increase in average wage due to deferred comp in 1990.
C *FQ     = average wage series.
C *FQINC  = average wage increase series.
C  I      = year under consideration.
C  I1     = temporary index used in various places.
C  IBCP1  = first year of CPI-indexed wage base.
C  IBCP2  = last year of CPI-indexed wage base.
C  IDIM1  = first year in BASET, FQ, and FQINC.
C  IDIM2  = last year in BASET, BI, FQ, and FQINC.
C  IDIM3  = first year in BI.
C  IFLAG  = indicator used in wage base projection.
C  ISTYR  = year of last known wage base.
C  IWBIND = type of wage base projection.
C           0 = present law, including 1994 amendments.
C           1 = prior law (ignore 1990-92 deferred comp increases).
C           2 = old law (ignore 1979-81 ad hoc increases).
C           3 = HI (unlimited base in 1994 and later).
C           4 = new wage bases (reset indexing procedure at base for
C               ISTYR, using 1994 amendments method).
C  NY     = number of years in BASET, FQ, and FQINC.
C  BY     = number of years in BI.
C
      SUBROUTINE WGBASE (IBCP1,IBCP2,BASET,IDIM1,IDIM2,IDIM3,IWBIND,
     &ISTYR,BI,FQ,FQINC,NY,BY)
      REAL FACTOR,DEFCMP
      INTEGER IDIM2,IWBIND,NY,BY,ISTYR,I,IFLAG,I1,IDIM1,IDIM3
      INTEGER IBCP1,IBCP2
      REAL BI(BY),FQINC(NY)
      DOUBLE PRECISION BASET(NY),FQ(NY),BASEUN
      DEFCMP = .0149249
      I = ISTYR
   10 IFLAG = 1
C  See if there is benefit increase in previous year
   20 IF (BI(I-IDIM3+IFLAG-1).GE.0.1) GO TO 30
C  If no benefit increase, wage base equals last previously set base
      BASET(I-IDIM1+IFLAG) = BASET(I-IDIM1)
      IFLAG=IFLAG+1
      IF (I+IFLAG.GT.IDIM2) GO TO 60
      GO TO 20
C  Increase wage base by wage or CPI increases, whichever are appro-
C  priate, from last base that was increased
   30 BASEUN = BASET(I-IDIM1)
C  Apply factor prior to 1995, project from 1992 average wage thereafter
      IF (I+IFLAG-1.LT.1995) THEN
        DO 50 I1=0,IFLAG-1
        IF (IWBIND.NE.1.AND.I+I1.GT.1989.AND.I+I1.LT.1993) THEN
          IF (I+I1.EQ.1990) THEN
            FACTOR = FQ(I+I1-IDIM1-1)/FQ(I+I1-IDIM1-2) + .02
          ELSE IF (I+I1.EQ.1991) THEN
            FACTOR = (FQ(I+I1-IDIM1-1) + .02*FQ(I+I1-IDIM1-2))/
     &      (FQ(I+I1-IDIM1-2) + .02*FQ(I+I1-IDIM1-3))
          ELSE
            FACTOR = (FQ(I+I1-IDIM1-1)*(1. + DEFCMP))/
     &      (FQ(I+I1-IDIM1-2) + .02*FQ(I+I1-IDIM1-3))
          END IF
        ELSE
          IF ((I+I1.LT.IBCP1).OR.(I+I1.GT.IBCP2)) THEN
            FACTOR = 1.0+FQINC(I+I1-IDIM1-1)/100.0
          ELSE
            FACTOR = 1.0+BI(I+I1-IDIM3-1)/100.0
          END IF
        END IF
        BASEUN = (BASEUN+.001)*FACTOR
   50   CONTINUE
      ELSE
        IF (IWBIND.EQ.4) THEN
          FACTOR = FQ(I+IFLAG-IDIM1-2) / FQ(ISTYR-IDIM1-1)
          BASEUN = BASET(ISTYR-IDIM1+1)
        ELSE
          FACTOR = FQ(I+IFLAG-IDIM1-2) / FQ(1993-IDIM1)
          IF (IWBIND.EQ.2) THEN
            BASEUN = 45000.
          ELSE IF (IWBIND.LT.2) THEN
            BASEUN = 60600.
          ELSE
            BASEUN = 9999999.
          END IF
        END IF
        BASEUN = BASEUN * FACTOR
      END IF
C  Round wage base to multiple of $300
      IF (IWBIND.EQ.2.AND.I+IFLAG-1.GT.1978.AND.I+IFLAG-1.LT.1982) THEN
        IF (I+IFLAG-1.EQ.1979) THEN
          BASET(I+IFLAG-IDIM1) = 22900.
        ELSE IF (I+IFLAG-1.EQ.1980) THEN
          BASET(I+IFLAG-IDIM1) = 25900.
        ELSE
          BASET(I+IFLAG-IDIM1) = 29700.
        END IF
      ELSE
        BASET(I+IFLAG-IDIM1) = DMAX1(AINT(BASEUN/300.0+0.5)*300.,
     &    BASET(I-IDIM1))
      END IF
C  Reset year indicator and go back to top of loop
   60 I=I+IFLAG
      IF (I.LE.IDIM2) GO TO 10
      RETURN
      END
C
C  Subroutine to project quarter of coverage amount
C
C  ISTYR  = year of last known quarter of coverage amount.
C  IY     = first year in QCQTR and WG.
C  NY     = number of years in QCQTR and WG.
C *QCQTR  = quarter of coverage amount series to be projected.
C *WG     = average wage series.
C
      SUBROUTINE QCPRO(QCQTR,WG,ISTYR,IY,NY)
      INTEGER NY,ISTYR,I,IY
      REAL QCQTR(NY)
      DOUBLE PRECISION WG(NY)
      IF (WG(1977-IY).EQ.0.0) RETURN
      DO 10 I = ISTYR+1-IY,NY
        IF (QCQTR(I).EQ.0.0) THEN
          QCQTR(I) = QCQTR(1979-IY)*WG(I-2)/WG(1977-IY)
C  Round to nearest $10
          QCQTR(I) = AMAX1(ANINT(QCQTR(I)/10.)*10.,QCQTR(I-1))
        END IF
   10 CONTINUE
      END
