C  @(#)piadata.h	1.3  2/24/97
C
C  This module contains definitions of variables related to pia data.
C
C  Definition of variables ('*' before variable name denotes
C  variable array, with indices I, J, K, ...):
C
C *AMETOT = average (indexed) monthly earnings before application of
C             totalization provision.
C  ARF    = reduction or increment factor.
C  ARFAPP = 1 if highest PIA is special minimum, delayed retirement
C           credits are involved, and benefit equals special minimum
C           PIA, 2 if highest PIA is special minimum, delayed retirement
C           credits are involved, and benefit equals support PIA
C           increased by increment factor, 0 otherwise.
C *BENFIT = benefit actually payable.
C           J=1 is before dollar rounding, 2 is after dollar rounding.
C *CAP    = for disability cases, appropriate percentage cap for MFB.
C  DINSC  = disability insured status code.
C           0: active (no QC's to date).
C           1: disability insured (fully insured and meets 20/40).
C           2: disability insured (fully insured and meets special
C              test).
C           3: disability insured (current DI beneficiary).
C           4: disability insured (based on blindness).
C           5: not fully insured or 20/40 (but some QC's to date).
C           6: not fully insured, but meets 20/40.
C           7: fully insured, but does not meet 20/40 or special test.
C           8: death (was a primary beneficiary).
C           9: death (was never a primary beneficiary).
C  DISREQ = number of quarters of coverage required for disability
C             insured status.
C  DIDRP  = number of years wholly or partially within a period of
C             disability, within the elapsed years.
C  DIDRPO = number of years wholly or partially within a period of
C             disability, within the elapsed years for old-start.
C  DQCREQ = number of quarters of coverage required for deemed fully
C             insured status.
C  DQCTOT = number of quarters of coverage earned for deemed fully
C             insured status.
C *EARNST = earnings passed to PIAC subroutine in year 1936+I.
C           J=1 is actual earnings, 2 is theoretical totalization
C             earnings, J=3 is actual earnings limited to OASDI wage
C             base, 4 is theoretical totalization earnings limited to
C             OASDI wage base, 5 is HI earnings, 6 is HI earnings
C             limited to HI wage base.
C  ERNTOT = total earnings.
C  FINSC  = fully insured status code.
C           1: Fully insured in nontotalization case.
C           2: Not fully insured, but currently insured, young survivor.
C           3: Totalization case with more than 5 qc's, but not fully
C              insured.
C           4: Not fully insured nontotalization case other than young
C              survivor.
C           5: Not fully or currently insured young survivor.
C           6: Totalization case with less than 6 qc's.
C           7: Fully insured totalization case.
C  FRZYR1 = first year wholly within period of disability.
C  FRZYR2 = last year wholly within period of disability.
C  FRZYR3 = first year wholly within prior period of disability.
C  FRZYR4 = last year wholly within prior period of disability.
C *FTEARN = sum of high N years of earnings (meaningless for Special
C           Minimum).
C  HIMFB  = highest applicable MFB.
C  HIPIA  = highest applicable PIA.
C *IAGE   = age at entitlement of worker, in years and months.  (For
C             survivor cases, age worker would have been in month
C             of entitlement of survivor.)
C *IAGE1  = age at benefit date of worker, in years and months.
C *IAME   = average (indexed) monthly earnings.  I=1: new-start AME
C             corresponding to Old-Start PIB.  I=2: PIA Table average
C             monthly earnings.  I=3: Wage-indexed average indexed
C             monthly earnings.  I=4: Transitional Guarantee average
C             monthly earnings.  I=5: average monthly earnings used
C             to find special minimum MFB (prior to 1979).  I=6:
C             re-indexed average monthly earnings.
C  IAMEOS = Old-Start AME.
C *IAPP   = 0 if method not applicable, 1 if applicable, 2 if this
C             gives highest PIA.
C             I=1 to 6 is method number: 1 for Old-Start, 2 for PIA
C             Table, 3 for Wage-Indexed method, 4 for Transitional
C             Guarantee, 5 for Special Minimum, 6 for Re-indexed Widow
C             Guarantee.
C  IAPPN  = number of PIA method with highest PIA.
C  IAPPS  = support PIA method number.
C *IBENDM = bend points for MFB formula under wage-indexed method (0 if
C             not applicable).
C *IBENDP = bend points for PIA formula under Wage-Indexed method (0 if
C             not applicable).
C *ICAP   = disability maximum family benefit cap indicator (=0 for
C             no cap, =1 for 1.5*PIA cap, =2 for .85*AIME cap, =3
C             for 1.0*PIA floor).
C  ICCHUP = index of year of eligibility for catch-up benefit increases.
C  IDIVOS = divisor for old-start pre-1951 earnings.
C *IELGYR = year prior to year of eligibility minus 1950 (minimum of 0).
C           I=1 is year prior to year of worker's attainment of age 62,
C             or age 65 for workers born in 1910 or earlier, for old-age
C             and disability, or year prior to year of worker's
C             death, if earlier, for survivor.
C           I=2 is year prior to year of worker's attainment of age 62,
C             or age 65 for workers born in 1910 or earlier, for old-age
C             and disability, or year of disability, if earlier, or
C             year prior to year of worker's death, if earlier, for
C             survivor.
C           I=3 is year prior to year of worker's attainment of age 62
C             for old-age and disability, or year of disability, if
C             earlier, or year prior to year of worker's death, if
C             earlier, for survivor.
C  IERN50 = initial year of earnings minus 1950 (minimum 1).
C  IERNYR = year prior to year of retirement or disability, or exact
C             year of death, minus 1950 (last year of earnings con-
C             sidered).
C  INCYRS = number of old-start increment years.
C  INSC   = fully insured status code as used in CWHS.
C           0: active (no QC's to date).
C           1: fully and currently insured.
C           2: currently but not fully insured.
C           3: fully but not currently insured.
C           4: uninsured (but some QC's to date).
C           5: permanently and currently insured.
C           6: permanently but not currently insured.
C           7: primary-entitled death.
C           8: transitionally insured.
C           9: non-primary-entitled death.
C           D: deemed fully insured (1983 amendments).
C           T: insured for totalization benefits.
C *IORDER = 1 for year I if earnings in year I are among highest N;
C             I=1 to 5 is method number, J is year-1936 for I=1,
C             otherwise year-1950.
C  IPRMPT = indicator for prompts to screen (0 for no prompts, 1 for
C             prompts).
C  IQCREQ = number of quarters of coverage required for fully-insured
C             status.
C  IQCT50 = number of quarters of coverage, 1937 to 1950.
C  IQCT51 = number of quarters of coverage, 1951 to 1949+ISTART.
C  IQCTOT = number of quarters of coverage, 1937 to 1949+ISTART.
C *ISPMIN = 0 if not year of coverage, 1 if year of coverage, in year
C             1936+I.
C *ISPMNT = total number of years of coverage.
C           I=1 is special minimum, 2 is windfall elimination
C             provision.
C *ITABEL = index of applicable PIA Table (1 is 1952 Act, 2 is 1954
C             Act, 3 is 1958 Act, 4 is 1965 Act, 5 is 1967 Act, 6
C             is 1969 Act, 7 is 1971 Act, 8 is 1972 Act, 9 is 1973
C             Act, 10 is 1977 Act).
C  IWIND  = windfall indicator in wage-indexed method (0 for no
C           windfall, 1 for one-half noncovered pension, 2 for
C           reduced first percentage, -1 for special minimum savings
C           clause).
C *IYCPI  = number of years for which benefit increases are applied
C             for each method.
C  IYRSPM = number of years of coverage in Special Minimum in excess of
C             10, up to 30.
C *JAGE   = age of widow, in years and months.
C *JBENDP = bend points for PIA formula under re-indexed widow guarantee
C             method (0 if not applicable).
C  JCCHUP = index of year of eligibility for re-indexed widow catch-up
C             benefit increases.
C  JELGYR = year prior to year of eligibility for re-indexed widow
C             guarantee minus 1950.
C *JPERCP = re-indexed widow PIA formula percentages.
C *KBIRTH = month, day, and year of day before birth of worker (year is
C             4 digits).
C  KELGYR = year prior to widow's year of eligibility minus 1950
C           (minimum of 0).
C *LBIRTH = month, day, and year of day before birth of widow.
C  MARDRI = number of months of actuarial reduction or delayed
C             retirement increment.
C  MAXBP  = maximum number of bend points in PIA formula (counting first
C             one as $0)
C  METHOS = Old-Start PIA calculation method: 1 for 1939 Amendments,
C             2 for 1950 Old-Start, 3 for 1950 Old-Start with 1958
C             Conversion Table, 4 for 1965 Old-Start, 5 for 1967 Old-
C             Start, 6 for 1977 Old-Start with Jan 1978 old-law PIA
C             Table, 7 for 1977 Old-Start with Dec 1978 frozen PIA
C             Table.
C *MFB    = MFB at entitlement for each method.
C *MFBEL  = MFB at eligibility for each method.
C *MFBRWG = MFB at eligibility after real-wage-gain adjustment.
C  N      = number of computation years.
C  NDROP  = number of dropout years.
C  NDROPO = number of dropout years for old-start method.
C  NELAP  = number of elapsed years in computation period calculation.
C  NELAPO = number of elapsed years in computation period for old-start
C             calculation.
C  NOLD   = number of computation years for old-start method.
C *NRA    = normal retirement age, in years and months.
C *NRA1   = earliest possible retirement age, in years and months.
C *NRA2   = widow's normal retirement age, in years and months.
C *NRA3   = earliest possible retirement age, in years and months, for
C             aged widows.
C *NRADAT = date of attainment of normal retirement age, as month and
C             year.
C  OVRMAX = 0 if no earnings over 999999.99, 1 otherwise.
C *PAIME  = portion of AIME in each interval of wage-indexed PIA
C             formula, for methods 3 and 6, portion of AME in each
C             integral of old-start PIA formula, for method 1.
C *PERCM  = wage-indexed MFB formula percentages.
C *PERCP  = wage-indexed PIA formula percentages.
C *PERCW  = windfall PIA formula percentages.
C *PIA    = PIA at entitlement for each method.
C *PIAEL  = PIA at eligibility for each method.
C           5: years of coverage times dollar amount ($8.50, $9.00, or
C             $11.50) for Special Minimum PIA.
C *PIAELT = PIA at eligibility before application of totalization
C             provision.
C *PIARWG = PIA at eligibility after real-wage-gain adjustment.
C *PIATOT = PIA at entitlement before application of totalization
C             provision.
C *PIAW   = PIA at eligibility before application of windfall
C           provision, if applicable (0 otherwise).
C           I=1 is Old-Start, 2 is not applicable, 3 is wage-indexed.
C  PIB    = Old-Start Primary Insurance Benefit before incrementing.
C  PIBINC = Old-Start Primary Insurance Benefit after incrementing.
C *PPIAEL = portion of PIAEL in each interval of Wage-Indexed MFB
C             formula, for each method (meaningless for PIA Table
C             and Special Minimum).
C  QCCUR  = quarters of coverage in prior 3 years.
C *QCDDT1 = beginning quarter and year of period of required quarters
C             of coverage for disability insured status.
C *QCDDT2 = ending quarter and year of period of required quarters
C             of coverage for disability insured status.
C *QCDDT3 = beginning quarter and year of period of required quarters
C             of coverage for disability insured status, for period
C             after disability cessation.
C *QCDDT4 = ending quarter and year of period of required quarters
C             of coverage for disability insured status, for period
C             after disability cessation.
C *QCDDT5 = beginning quarter and year of period of required quarters
C             of coverage for disability insured status, for period
C             before prior disability.
C *QCDDT6 = ending quarter and year of period of required quarters
C             of coverage for disability insured status, for period
C             before prior disability.
C  QCDIQT = number of quarters over which quarters of coverage must be
C             earned for disability insured status.
C  QCDIYR = number of years over which quarters of coverage must be
C             earned for disability insured status.
C  QCREQP = number of quarters of coverage required for permanently-
C             insured status.
C  QCTOTD = number of quarters of coverage earned for disability insured
C             status.
C *REP    = annual relative earnings position, year 1936+I.
C  REPAVG = overal relative earnings position.
C  SPMIN  = Special Minimum method dollar amount.
C *STOT   = sum of earnings from 1937 to 1950.
C  SUPPIA = support PIA when highest PIA is special minimum and
C             delayed retirement credits are involved.
C *UEARN  = earnings multiplied by FQ of base year in wage-indexed
C             method.
C *VEARN  = earnings used in each method; same indices as IORDER.
C             I=1 is imputed earnings in year 1936+I, 2 is actual
C             earnings in year 1950+I, 3 is indexed earnings in year
C             1950+I, 4 is actual earnings thru age 61, in year 1950+I,
C             5 is meaningless, 6 is indexed earnings in year 1950+I.
C *XEARN  = earnings multiplied by FQ of base year in re-indexed
C             widow guarantee method.
C
      INTEGER MAXBP
      PARAMETER (MAXBP=4)
C  Dimension common variables
      INTEGER IELGYR(3), JAGE(2), KELGYR, LBIRTH(3), NRA2(2), QCCUR,
     &QCDDT2(2), QCDDT1(2), QCDIQT, QCDIYR, QCTOTD, KBIRTH(3),
     &IAPP(MAXCAL), IAME(MAXCAL), IAGE(2), IAGE1(2), IQCREQ, IQCTOT,
     &IQCT50, IQCT51, ISPMNT(2), IYCPI(MAXCAL), ITABEL(MAXCAL),
     &IWIND, IYRSPM, IAPPS, DISREQ, NRA(2), NRA1(2), NRA3(2), OVRMAX,
     &IPRMPT, NDROP, NELAP, NRADAT(2), IBENDM(4), IBENDP(4),
     &ICAP(MAXCAL), FRZYR1, FRZYR2, FRZYR3, FRZYR4, IORDER(MAXCAL,IX),
     &IDIVOS, JBENDP(4), MARDRI, IAPPN, METHOS, N, NOLD, NDROPO,
     &NELAPO, IERN50, IERNYR, INCYRS, IAMEOS, ARFAPP, ICCHUP, JELGYR,
     &JCCHUP, QCDDT3(2), QCDDT4(2), QCDDT5(2), QCDDT6(2), DQCREQ,
     &DQCTOT, QCREQP, DIDRP, DIDRPO, ISPMIN(IX)
      CHARACTER*1 DINSC,FINSC,INSC
      DOUBLE PRECISION SUPPIA, EARNST(IX,6), HIPIA, HIMFB, PIA(MAXCAL),
     &PIAEL(MAXCAL), PIAELT(MAXCAL), MFBRWG(MAXCAL), MFB(MAXCAL),
     &PIATOT(MAXCAL), PIARWG(MAXCAL), PIAW(MAXCAL), UEARN(IX),
     &XEARN(IX), MFBEL(MAXCAL), BENFIT(2)
      REAL REP(IX), SPMIN, STOT(2), REPAVG, JPERCP(MAXBP),
     &PAIME(MAXBP,MAXCAL), PERCM(4), PERCP(MAXBP), PERCW(MAXBP),
     &CAP(MAXCAL), AMETOT(MAXCAL), ARF, ERNTOT, FTEARN(MAXCAL),
     &VEARN(MAXCAL,IX), PPIAEL(4,MAXCAL), PIB, PIBINC
      COMMON / PIADAT / SUPPIA, EARNST, HIPIA, HIMFB, PIA,
     &PIAEL, PIAELT, MFBRWG, MFB, PIATOT, PIARWG, PIAW, UEARN,
     &XEARN, MFBEL, BENFIT,
     &REP, SPMIN, STOT, REPAVG, JPERCP, PAIME, PERCM, PERCP, PERCW,
     &CAP, AMETOT, ARF, ERNTOT, FTEARN, VEARN, PPIAEL, PIB, PIBINC,
     &IELGYR, JAGE, KELGYR, LBIRTH, NRA2, QCCUR,
     &QCDDT2, QCDDT1, QCDIQT, QCDIYR, QCTOTD, KBIRTH,
     &IAPP, IAME, IAGE, IAGE1, IQCREQ, IQCTOT,
     &IQCT50, IQCT51, ISPMNT, IYCPI, ITABEL,
     &IWIND, IYRSPM, IAPPS, DISREQ, NRA, NRA1, NRA3, OVRMAX,
     &IPRMPT, NDROP, NELAP, NRADAT, IBENDM, IBENDP,
     &ICAP, FRZYR1, FRZYR2, FRZYR3, FRZYR4, IORDER,
     &IDIVOS, JBENDP, MARDRI, IAPPN, METHOS, N, NOLD, NDROPO,
     &NELAPO, IERN50, IERNYR, INCYRS, IAMEOS, ARFAPP, ICCHUP, JELGYR,
     &JCCHUP, QCDDT3, QCDDT4, QCDDT5, QCDDT6, DQCREQ,
     &DQCTOT, QCREQP, DIDRP, DIDRPO, ISPMIN,
     &DINSC, FINSC, INSC
