C  @(#)oldpia.f	1.13   2/24/97
C
C  Subroutines to handle old-law calculations
C
C  Subroutine to select correct PIA table subroutine
C
C  I      = highest AMW giving that PIA.
C  I9     = method number.
C
      INTEGER FUNCTION OLDPIA (I9)
      INTEGER I, I9, AMND52(2), AMND54(2), AMND58(2),
     &AMND65(2), AMND67(2), AMND69(2), AMND70(2), AMND72(2), AMND74(2)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
C  Function declarations
      INTEGER PL1952,PL1954,PL1958,PL1965,PL1967,PL1969,PL1971,PL1972,
     &COMPMY
      DATA AMND52 / 9,1952 /
      DATA AMND54 / 9,1954 /
      DATA AMND58 / 1,1959 /
      DATA AMND65 / 1,1965 /
      DATA AMND67 / 2,1968 /
      DATA AMND69 / 1,1970 /
      DATA AMND70 / 1,1971 /
      DATA AMND72 / 9,1972 /
      DATA AMND74 / 6,1974 /
      IF (COMPMY(BENDAT,AMND52).LT.0) THEN
        OLDPIA = -1
        RETURN
      END IF
C  1952 Act applies September 1952 to August 1954
      IF (COMPMY(BENDAT,AMND54).LT.0) THEN
        OLDPIA = PL1952 (IAME(I9),PIA(I9),MFB(I9))
        RETURN
      END IF
C  1954 Act applies September 1954 to December 1958
      IF (COMPMY(BENDAT,AMND58).LT.0) THEN
        OLDPIA = PL1954 (IAME(I9),PIA(I9),MFB(I9))
        RETURN
      END IF
C  1958 Act applies January 1959 to December 1964
      IF (COMPMY(BENDAT,AMND65).LT.0) THEN
        OLDPIA = PL1958 (IAME(I9),PIA(I9),MFB(I9),I)
        RETURN
      END IF
C  1965 Act applies January 1965 to January 1968
      IF (COMPMY(BENDAT,AMND67).LT.0) THEN
        OLDPIA = PL1965 (IAME(I9),PIA(I9),MFB(I9),I)
        RETURN
      END IF
C  1967 Act applies February 1968 to December 1969
      IF (COMPMY(BENDAT,AMND69).LT.0) THEN
        OLDPIA = PL1967 (IAME(I9),PIA(I9),MFB(I9),I)
        RETURN
      END IF
C  1969 Act applies January 1970 to December 1970
      IF (COMPMY(BENDAT,AMND70).LT.0) THEN
        OLDPIA = PL1969 (IAME(I9),PIA(I9),MFB(I9),I)
        RETURN
      END IF
C  1971 Act applies January 1971 to August 1972
      IF (COMPMY(BENDAT,AMND72).LT.0) THEN
        OLDPIA = PL1971 (IAME(I9),PIA(I9),MFB(I9),I)
        RETURN
      END IF
C  1972 Act applies September 1972 to May 1974
      IF (COMPMY(BENDAT,AMND74).LT.0) THEN
        OLDPIA = PL1972 (IAME(I9),PIA(I9),MFB(I9))
        RETURN
      END IF
      OLDPIA = -1
      RETURN
      END
C
C  Subroutine to apply CPI and wage base increases to 1973 Act PIA Table
C
C  I20    = temporary index used in various places.
C  I21    = year benefit increases are first applied minus 1950.
C  I22    = year for which PIA Table is desired, minus 1950 (result
C             includes benefit increases thru December of year
C             1950+I22).
C  I23    = 1 for Transitional Guarantee or 1977 Old-Start calculation
C             with 1979 or later eligibility, 0 otherwise.
C  I24    = year that AME is first included in PIA Table as of January,
C             minus 1950, if AME is greater than $1100 (otherwise =0).
C  I25    = year prior to year of eligibility minus 1950.
C  I26    = index of year of eligibility for catch-up benefit increases.
C  I28    = last AME in prior table.
C  I29    = last AME in extended table.
C *IB     = wage base in year 1936 + I.
C  JAME   = average monthly earnings.
C  MFB74  = MFB at entitlement.
C  MFBL   = MFB at eligibility for transitional guarantee or 1977 old-
C           start.
C  MFBT   = test MFB.
C  PIA74  = PIA at entitlement.
C  PIAL   = PIA at eligibility for transitional guarantee or 1977 old-
C           start.
C
      INTEGER FUNCTION CPIBAS (I22,I23,I25,JAME,PIAL,MFBL,PIA74,MFB74,
     &I26)
      INTEGER I24,JAME,I20,I21,I22,I23,I25,I26,I28,I29
      DOUBLE PRECISION MFBT, MFB74, MFBL, PIA74, PIAL
C  Function declarations
      DOUBLE PRECISION ROUND
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      CPIBAS = 9
      I24=0
      IF (JAME.GT.1100) THEN
C  This section (prior to line 40) is for AME's greater than 1100
        DO 10 I20=25,I22
   10   IF (JAME.LE.BASE(I20+14)/12.AND.I24.EQ.0) I24=I20
        IF (I24.EQ.0) I24 = I22
C  Find last PIA in June 1974 PIA Table
        CALL PL1973 (1100,PIA74,MFB74)
        IF (I24.GT.25) THEN
C  Extend table and apply increases up to year prior to when AME is
C  first included
          DO 20 I20=25,I24-1
C  Extension amount depends on two successive wage bases
          I28 = BASE(I20+13)/12.
          I29 = BASE(I20+14)/12.
C  Check to see if wage bases are exact multiples of $60 ($22,900 in
C  1979 and $25,900 in 1980 are not)
          IF (MOD(INT(BASE(I20+13)),60).NE.0)
     &      I28 = (INT(BASE(I20+13))/60+1)*5
          IF (MOD(INT(BASE(I20+14)),60).NE.0)
     &      I29 = (INT(BASE(I20+14))/60+1)*5
          PIA74 = PIA74 + .2D0*DBLE(I29-I28)
          MFB74 = ROUND(1.75*PIA74,I20-1)
C  Apply benefit increase
          IF (JIND(30).EQ.0.OR.I20+1950.LT.JSTART(1,30).OR.
     &      I20+1950.GT.JSTART(2,30).OR.PIA74.LT.PIA30.OR.
     &      IERN30.LT.5) THEN
            PIA74 = ROUND(PIA74*(1.+CPIINC(I20)/100.),I20)
            MFB74 = ROUND(MFB74*(1.+CPIINC(I20)/100.),I20)
C  Check to see that MFB is at least 150% of PIA
            MFBT = ROUND(1.5*PIA74,I20)
            IF (MFB74.LT.MFBT) MFB74 = MFBT
          END IF
C  After applying June 1978 increase, set Transitional Guarantee
C  or 1977 Old-Start (1979 or later eligibility) PIA at eligibility
          IF (I20.EQ.28.AND.I23.GT.0) PIAL = PIA74
C  Apply catch-up increase to PIA
          CALL BICCHP (I20,PIA74,I26)
C  Apply catch-up increase to MFB
          CALL BICCHP (I20,MFB74,I26)
C  Check to see that MFB is at least 150% of PIA
          MFBT = ROUND(1.5*PIA74,I20)
          IF (MFB74.LT.MFBT) MFB74 = MFBT
   20     CONTINUE
        END IF
C  Apply extension in year AME is first included in Table
        PIA74 = PIA74 + DBLE((JAME-INT(BASE(I24+13))/12+4)/5)
        MFB74 = ROUND(1.75*PIA74,I24)
C  Set year benefit increases are first applied minus 1950
        I21 = I24
C  Go to benefit increase section
      ELSE
C  Use extended PIA Table if Transitional Guarantee or 1977 Old-Start in
C  1982 or later
        IF (I25.LT.31.OR.I23.EQ.0.OR.JAME.GT.75) THEN
          CALL PL1973 (JAME,PIA74,MFB74)
          PIAL = PIA74
          MFBL = MFB74
C  Set year benefit increases are first applied minus 1950
          I21 = 25
C  If desired PIA is prior to June 1975, return to main program
          IF (I22.LT.I21) RETURN
C  Go to benefit increase section
        ELSE
C  Calculate downward-extended PIA Table values as of Dec 1978
          PIA74 = ROUND(DBLE(JAME)*121.8/76.,28)
          PIAL = PIA74
          MFB74 = ROUND(1.5*PIA74,28)
          MFBL = MFB74
C  Do not apply any benefit increases to extended minimum
          RETURN
        END IF
      END IF
C  Transition adjustment for HR 1917 (100 Congress version) and Sanford
      IF (Z4.GT.0.) THEN
        PIA74 = ROUND(PIA74*(1.-0.01*Z4),I24-1)
        MFB74 = ROUND(MFB74*(1.-0.01*Z4),I24-1)
      END IF
C  Apply benefit increases to PIA Table
      DO 70 I20=I21,I22
      IF (JIND(30).EQ.0.OR.I20+1950.LT.JSTART(1,30).OR.
     &  I20+1950.GT.JSTART(2,30).OR.PIA74.LT.PIA30.OR.
     &  IERN30.LT.5) THEN
        PIA74 = ROUND(PIA74*(1.+CPIINC(I20)/100.),I20)
        MFB74 = ROUND(MFB74*(1.+CPIINC(I20)/100.),I20)
C  Check to see that MFB is at least 150% of PIA
        MFBT = ROUND(1.5*PIA74,I20)
        IF (MFB74.LT.MFBT) MFB74 = MFBT
      END IF
C  After applying June 1978 increase, set Transitional Guarantee
C  or 1977 Old-Start (1979 or later eligibility) PIA at eligibility
      IF (I20.EQ.28.AND.I23.GT.0) PIAL = PIA74
C  Apply catch-up increase to PIA
      CALL BICCHP (I20,PIA74,I26)
C  Apply catch-up increase to MFB
      CALL BICCHP (I20,MFB74,I26)
C  Check to see that MFB is at least 150% of PIA
      MFBT = ROUND(1.5*PIA74,I20)
      IF (MFB74.LT.MFBT) MFB74 = MFBT
   70 CONTINUE
      RETURN
      END
C
C  Subroutine to calculate PIA's under 1973 Act, effective June 1974
C
C  FMBSUB = maximum family benefit returned.
C  IAVGMW = average monthly wage.
C  MFB73  = test MFB.
C  PIASUB = Primary Insurance Amount.
C
      SUBROUTINE PL1973 (IAVGMW,PIASUB,FMBSUB)
      INTEGER I,IAVGMW
      DOUBLE PRECISION MFB73, PIASUB, FMBSUB
C  Function declarations
      DOUBLE PRECISION ROUND
      INTEGER PL1972
      INCLUDE 'wrkrdataf.h'
C  Test to see if AME is in extension of table above $1000
      IF (IAVGMW.LE.1000) THEN
C  If under $1000 AME, first get 1972 Act value
        I = PL1972 (IAVGMW,PIASUB,FMBSUB)
C  Increase by 11%
        PIASUB = ROUND(1.11*PIASUB,24)
        FMBSUB = ROUND(1.11*FMBSUB,24)
C  MFB must be at least 1.5 times PIA
        MFB73 = ROUND(1.5*PIASUB,24)
        IF (FMBSUB.LT.MFB73) FMBSUB=MFB73
      ELSE
C  If over $1000 AME, extend beyond $1000 in $5 intervals
        PIASUB = DBLE((IAVGMW+4)/5)+249.00
C  MFB is 175% of PIA in extension
        FMBSUB = ROUND(1.75*PIASUB,24)
      END IF
      RETURN
      END
C
C  Subroutine to calculate PIA's under 1972 Act, effective Sept 1972
C
C  FMBSUB = maximum family benefit returned.
C  I60    = highest AMW giving that PIA.
C  IAVGMW = average monthly wage.
C  MFB72  = test MFB.
C  PIASUB = Primary Insurance Amount.
C
      INTEGER FUNCTION PL1972 (IAVGMW,PIASUB,FMBSUB)
      INTEGER IAVGMW, I60, AMD741(2), AMD742(2)
      DOUBLE PRECISION MFB72, PIASUB, FMBSUB
C  Function declarations
      DOUBLE PRECISION ROUND
      INTEGER PL1971, COMPMY
      INCLUDE 'wrkrdataf.h'
      DATA AMD741 / 3,1974 /
      DATA AMD742 / 6,1974 /
C  Test to see if AME is in extension of table above $750
      IF (IAVGMW.LE.750) THEN
C  If under $750 AME, first get 1971 Act value
        PL1972 = PL1971 (IAVGMW,PIASUB,FMBSUB,I60)
C  Increase by 20%
        PIASUB = ROUND(1.2*PIASUB,22)
        FMBSUB = ROUND(1.2*FMBSUB,22)
C  MFB must be at least 1.5 times PIA
        MFB72 = ROUND(1.5*PIASUB,22)
        IF (FMBSUB.LT.MFB72) FMBSUB=MFB72
      ELSE
C  If over $750 AME, extend beyond $750 in $5 intervals
        PIASUB = DBLE((IAVGMW+4)/5)+204.50
C  MFB is 175% of PIA in extension
        FMBSUB = ROUND(1.75*PIASUB,22)
      END IF
C  Check to see if temporary 7% increase applies (Mar-May 1974)
      IF (COMPMY(BENDAT,AMD741).GE.0.AND.COMPMY(BENDAT,AMD742).LT.0)
     &THEN
C  Apply 7% increase
        PIASUB = ROUND(1.07*PIASUB,24)
        FMBSUB = ROUND(1.07*FMBSUB,24)
      END IF
      PL1972 = 8
      RETURN
      END
C
C  Subroutine to calculate PIA's under 1971 Act
C
C  FMBSUB = maximum family benefit returned.
C  I70    = highest AMW giving that PIA.
C  IAVGMW = average monthly wage.
C  MFB71  = test MFB.
C  PIASUB = Primary Insurance Amount.
C
      INTEGER FUNCTION PL1971 (IAVGMW,PIASUB,FMBSUB,I70)
      INTEGER IAVGMW,I70
      DOUBLE PRECISION MFB71, PIASUB, FMBSUB
C  Function declarations
      DOUBLE PRECISION ROUND
      INTEGER PL1969
      INCLUDE 'wrkrdataf.h'
C  Test to see if AME is in extension of table above $650 (treat
C  $651 as being in table before extension, since correct value
C  results)
      IF (IAVGMW.LE.651) THEN
C  If under $651, first get 1969 Act value
        PL1971 = PL1969 (IAVGMW,PIASUB,FMBSUB,I70)
C  Increase by 10%
        PIASUB = ROUND(PIASUB*1.1,21)
      ELSE
C  Extend beyond $651
C  Test to see if on 20% extension, which starts at $657
        IF (IAVGMW.GT.656) PIASUB = DBLE((IAVGMW+4)/5)+145.4
C  From $652 to $656, use ad hoc values smoothing to 20% extension
        IF (IAVGMW.LE.656.AND.IAVGMW.GE.653) PIASUB=276.6
        IF (IAVGMW.EQ.652) PIASUB=275.8
      END IF
C  Calculate MFB
      IF (IAVGMW.LE.627) THEN
C  For AME's up to $436, MFB is 88% of AME
        IF (IAVGMW.LE.436) THEN
          FMBSUB = ROUND(.88*DBLE(I70),21)
C  For AME's from $437 to $627, MFB increases at 44% of AME
        ELSE
          FMBSUB = ROUND(383.68+.44*DBLE(I70-436),21)
        END IF
        MFB71 = ROUND(1.5*PIASUB,21)
        IF (IAVGMW.LT.240.OR.FMBSUB.LT.MFB71) FMBSUB=MFB71
      ELSE
C  MFB is 175% of PIA in extension
        FMBSUB = ROUND(1.75*PIASUB,21)
      END IF
      PL1971 = 7
      RETURN
      END
C
C  Subroutine to calculate PIA's under 1969 Act
C
C  FMBSUB = maximum family benefit returned.
C  I80    = highest AMW giving that PIA.
C  IAVGMW = average monthly wage.
C  PIASUB = Primary Insurance Amount.
C
      INTEGER FUNCTION PL1969 (IAVGMW,PIASUB,FMBSUB,I80)
      INTEGER IAVGMW,I80
      DOUBLE PRECISION PIASUB, FMBSUB
C  Function declarations
      DOUBLE PRECISION ROUND
      INTEGER PL1967
      INCLUDE 'wrkrdataf.h'
C  There is no extension of table, so get 1967 Act value
      PL1969 = PL1967 (IAVGMW,PIASUB,FMBSUB,I80)
C  Increase by 15%
      PIASUB = ROUND(1.15*PIASUB,20)
C  Minimum PIA of $64
      IF (PIASUB.LT.64.00) PIASUB=64.00
C  MFB does not change from 1967 Act for AME over $239
C  Below $239, MFB is 1.5 times PIA
      IF (IAVGMW.LE.239) FMBSUB = ROUND(1.5*PIASUB,20)
      PL1969 = 6
      RETURN
      END
C
C  Subroutine to calculate PIA's under 1967 Act
C
C  FMBSUB = maximum family benefit returned.
C  I90    = highest AMW giving that PIA.
C  IAVGMW = average monthly wage.
C  PIA67  = test PIA in MFB calculation.
C  PIASUB = Primary Insurance Amount.
C  ROUN67 = 0 or 1, used to round PIA.
C
      INTEGER FUNCTION PL1967 (IAVGMW,PIASUB,FMBSUB,I90)
      INTEGER IAVGMW,I90
      REAL ROUN67
      DOUBLE PRECISION PIASUB, FMBSUB, PIA67
C  Function declarations
      DOUBLE PRECISION ROUND
      INTEGER PL1965
      INCLUDE 'wrkrdataf.h'
C  Test to see if AME is in extension of table above $550 (treat
C  $551 to $553 as being in table before extension, since correct
C  value results)
      IF (IAVGMW.LE.553) THEN
C  If under $554, first get 1965 Act value
        PL1967 = PL1965 (IAVGMW,PIASUB,FMBSUB,I90)
C  Increase by 13%
        PIASUB = ROUND(PIASUB*1.13,18)
C  Minimum PIA of $55
        PIASUB = DMAX1(PIASUB,55.D0)
      ELSE
C  Extend beyond $553
C  Extension for this table is at 28.43%
        PIASUB=189.598+.2843*(IAVGMW-550)
C  Round PIA to nearest $1 in the extension
        ROUN67=0.
        IF (DMOD(PIASUB,1.D0).GE..49999) ROUN67=1.
        PIASUB=PIASUB+ROUN67-DMOD(PIASUB,1.D0)
C  Find the highest AMW giving that same PIA, for MFB calculation
        I90=IAVGMW
   20   I90=I90+1
        PIA67 = 189.598+.2843*DBLE(I90-550)
        ROUN67=0.
        IF (DMOD(PIA67,1.D0).GT..49999) ROUN67=1.
        PIA67 = PIA67+ROUN67-DMOD(PIA67,1.D0)
        IF (PIA67-PIASUB.LT..1.AND.PIA67-PIASUB.GT.-.1) GO TO 20
        I90=I90-1
C  I90 is now highest AMW giving that same PIA
      END IF
      PL1967 = 5
C  Find MFB for AMW's up to $370
      IF (IAVGMW.LE.370) THEN
C  For AMW's from $179 to $370, MFB is same as in 1965 Act
C  For AMW's from $180 to $370, MFB is 150% of PIA
        IF (IAVGMW.LT.179) FMBSUB = ROUND(1.5*PIASUB,18)
        RETURN
      END IF
C  For AMW's above $436, MFB is $348.80 plus 40% of AMW above $436
      IF (IAVGMW.GT.436) THEN
        FMBSUB = 348.80+.4*DBLE(I90-436)
C  MFB is maximum of $434.40
        FMBSUB = DMIN1(FMBSUB,434.40D0)
      ELSE
C  MFB is 80% of AMW for AMW's from $371 to $436
        FMBSUB = .8*DBLE(I90)
      END IF
      RETURN
      END
C
C  Subroutine to calculate PIA's under 1965 Act
C
C  FMBSUB = maximum family benefit returned.
C  I100   =highest AMW giving that PIA.
C  IAVGMW = average monthly wage.
C  PIASUB = Primary Insurance Amount.
C
      INTEGER FUNCTION PL1965 (IAVGMW,PIASUB,FMBSUB,I100)
      INTEGER IAVGMW,I100
      DOUBLE PRECISION PIASUB, FMBSUB
C  Function declarations
      DOUBLE PRECISION ROUND
      INTEGER PL1958
      INCLUDE 'wrkrdataf.h'
C  Start with 1958 Act, even for values above the original maximum
C  AMW of $400 in the 1958 Act
      PL1965 = PL1958 (IAVGMW,PIASUB,FMBSUB,I100)
      PL1965 = 4
C  For AMW's up to $94, increase PIA by $4
      IF (IAVGMW.LT.95) THEN
      PIASUB=PIASUB+4.
C  Minimum PIA of $44
      PIASUB = DMAX1(PIASUB,44.D0)
C  MFB of 150% of PIA
      FMBSUB=1.5*PIASUB
      RETURN
      END IF
C  For AMW's from $95 to $403, increase PIA by 7% (include $401 to $403
C  as if from 1958 Act)
      IF (IAVGMW.LT.404) THEN
        PIASUB = ROUND(PIASUB*1.07,15)
      ELSE
C  For AMW's above $403, increase PIA by $9 to match increase at
C  $403 (7% of $127.00 is $8.89), rounded to a dollar
        PIASUB = PIASUB+9.
      END IF
C  Find MFB for AMW's up to $314
      IF (IAVGMW.LT.315) THEN
C  For AMW's from $142 to $314, MFB is same as in 1958 Act
        IF (IAVGMW.LT.142) FMBSUB = ROUND(1.5*PIASUB,15)
C  For AMW's up to $141, MFB is 150% of PIA
        RETURN
      END IF
C  Find MFB for AMW's above $314
      IF (IAVGMW.GT.370) THEN
C  For AMW's above $370, MFB is $296 plus 40% of AMW above $370
        FMBSUB = 296.+.4*DBLE(I100-370)
C  MFB is maximum of $368.00
        FMBSUB = DMIN1(FMBSUB,368.00D0)
      ELSE
C  For AMW's from $315 to $370, MFB is 80% of AMW
        FMBSUB = .8*DBLE(I100)
      END IF
      RETURN
      END
C
C  Subroutine to calculate PIA's under 1958 Act
C
C  FMBSUB = maximum family benefit returned.
C  I110   = highest AMW producing that PIA.
C  IAVGMW = average monthly wage.
C  PIA58  = test PIA in MFB calculation.
C  PIASUB = Primary Insurance Amount.
C  ROUN58 = 0 or 1, used to round PIA.
C
      INTEGER FUNCTION PL1958 (IAVGMW,PIASUB,FMBSUB,I110)
      INTEGER IAVGMW,I110,AMND61(2)
      REAL ROUN58
      DOUBLE PRECISION PIASUB, FMBSUB, PIA58
      INCLUDE 'wrkrdataf.h'
      INTEGER COMPMY
      DATA AMND61 / 8,1961 /
      PL1958 = 3
      IF (IAVGMW.LE.84) THEN
C  Up to $84, 1958 Act increased PIA's by $3, rounded up to even
C  dollar
      PIASUB=3.49+.55*IAVGMW
      ELSE
C  Over $84, 1958 Act increased PIA's by 7% (.5885 equals 1.07
C  times the .55 in 1954 Act)
      PIASUB = .5885*AMIN0(IAVGMW,110)
      PIASUB = PIASUB+.214*AMAX0(0,IAVGMW-110)
      END IF
C  Round to whole dollar
      ROUN58 = 0.
      IF (DMOD(PIASUB,1.D0).GT..49999) ROUN58 = 1.
      PIASUB = PIASUB+ROUN58-DMOD(PIASUB,1.D0)
C  Minimum PIA of $33
      PIASUB = DMAX1(PIASUB,33.D0)
C  PIA for AMW of $553 was made ad hoc in 1967 Act
      IF (IAVGMW.EQ.553) PIASUB=159.00
C  Minimum PIA increased as of August 1961 to $40
      IF (COMPMY(BENDAT,AMND61).GE.0)
     &PIASUB = DMAX1(PIASUB,40.D0)
C  Calculate maximum family benefit
      IF (IAVGMW.GT.127) THEN
C  Find the highest AMW giving that same PIA
      I110=IAVGMW
   30 I110=I110+1
      PIA58 = 41.195+.214*DBLE(I110)
      ROUN58=0.
      IF (DMOD(PIA58,1.D0).GT..49999) ROUN58=1.
      PIA58 = PIA58+ROUN58-DMOD(PIA58,1.D0)
      IF (PIA58-PIASUB.LT..1.AND.PIA58-PIASUB.GT.-.1) GO TO 30
C  Test AMW is 1 greater than required, except for ad hoc interval
C  ending at $553
      IF (I110.NE.553) I110=I110-1
      FMBSUB = DMIN1(.8*DBLE(I110),254.D0)
      ELSE
C  For AMW's up to $127, MFB is 150% of PIA
        FMBSUB = DMAX1(1.5*PIASUB,PIASUB+20.)
      END IF
      RETURN
      END
C
C  Subroutine to calculate PIA's under 1952 Act
C
C  FMBSUB = maximum family benefit returned.
C  IAVGMW = average monthly wage.
C  PIASUB = Primary Insurance Amount.
C
      INTEGER FUNCTION PL1952 (IAVGMW,PIASUB,FMBSUB)
      INTEGER IAVGMW
      DOUBLE PRECISION PIASUB, FMBSUB
C  Function declarations
      DOUBLE PRECISION ROUND
C  PIA is 55% of first $100 of AMW plus 15% of excess
      PIASUB = .55*AMIN0(100,IAVGMW)
      PIASUB = ROUND(PIASUB+.15*AMAX0(0,IAVGMW-100),2)
C  Minimum PIA of $25
      PIASUB = DMAX1(PIASUB,25.D0)
C  MFB is 80% of AMW
C  Minimum MFB of $45
      FMBSUB = DMAX1(.8*DBLE(IAVGMW),45.D0)
C  Maximum MFB of $168.75
      FMBSUB = DMIN1(FMBSUB,168.75D0)
      PL1952 = 1
      RETURN
      END
C
C  Subroutine to calculate PIA's under 1954 Act
C
C  FMBSUB = maximum family benefit returned.
C  IAVGMW = average monthly wage.
C  PIASUB = Primary Insurance Amount.
C
      INTEGER FUNCTION PL1954 (IAVGMW,PIASUB,FMBSUB)
      INTEGER IAVGMW
      DOUBLE PRECISION PIASUB, FMBSUB
C  Function declarations
      DOUBLE PRECISION ROUND
C  PIA is 55% of first $110 of AMW plus 20% of excess
      PIASUB = .55*AMIN0(110,IAVGMW)
      PIASUB = ROUND(PIASUB+.2*AMAX0(0,IAVGMW-110),4)
C  Minimum PIA of $30
      PIASUB = DMAX1(PIASUB,30.D0)
C  MFB is 80% of AMW
C  Minimum MFB of $50
C  Minimum MFB of 150% of PIA
      FMBSUB = DMAX1(.8*DBLE(IAVGMW),50.D0,1.5*PIASUB)
C  Maximum MFB of $200
      FMBSUB = DMIN1(FMBSUB,200.D0)
      PL1954 = 2
      RETURN
      END
