C  %W%   %G%
C
C  Subroutines specific to unix
C
C  This subroutine opens a case saved on disk.
C
C  ERNFIL = name of file with earnings.
C  IERR   = error indicator.
C  IN     = number of input file.
C
      SUBROUTINE FIN(PROGFL,ERNFIL,IN,IERR)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*40 ERNFIL
      INTEGER IN,IERR
      WRITE (6,10)
   10 FORMAT ('   Enter name of file for this case (must be a legal ',
     &'pathname')
      READ (5,20) ERNFIL
   20 FORMAT (A40)
      CALL CONCAT(INFILE,PROGFL//CHAR(0),ERNFIL//CHAR(0))
      OPEN (UNIT=8,FILE=INFILE,IOSTAT=IERR,STATUS='OLD',
     &IOINTENT='INPUT',ERR=30)
      IN = 8
      RETURN
   30 WRITE (6,40) IERR
   40 FORMAT ('   *** File error',I5,'.  Please check name. ***')
      CALL BEEP
      RETURN
      END
C
C  This subroutine opens a file to save a case to disk.
C
C  ERNFIL = name of file with earnings.
C  IERR   = error indicator.
C  IOUT   = number of output file.
C
      INTEGER FUNCTION FOUT(PROGFL,ERNFIL,IOUT)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*40 ERNFIL
      INTEGER IOUT
      FOUT = 0
      WRITE (6,10)
   10 FORMAT ('   Enter name of file for this case (must be a legal ',
     &'pathname')
      READ (5,20) ERNFIL
   20 FORMAT (A40)
      CALL CONCAT(INFILE,PROGFL//CHAR(0),ERNFIL//CHAR(0))
      OPEN (UNIT=9,FILE=INFILE,IOINTENT='OUTPUT',IOSTAT=FOUT,ERR=30)
      IOUT = 9
      RETURN
   30 WRITE (6,40) FOUT
   40 FORMAT ('   *** File error',I5,'.  Please check name. ***')
      CALL BEEP
      RETURN
      END
C
C  This subroutine opens the file with historical program parameters
C
C  IN     = number of input file.
C  OLDFIL = name of input file.
C
      SUBROUTINE FOLDR(PROGFL,IN,OLDFIL,ISTART)
      CHARACTER*80 OLDFIL,PROGFL
      CHARACTER*160 INFILE
      INTEGER ISTART,IN
      WRITE (OLDFIL,5) ISTART+51
    5 FORMAT ('awbi',I2,'.dat')
      CALL CONCAT(INFILE,PROGFL//CHAR(0),OLDFIL//CHAR(0))
      OPEN (UNIT=IN,FILE=INFILE,STATUS='OLD',IOINTENT='INPUT',ERR=10)
      RETURN
   10 WRITE (6,20) INFILE
   20 FORMAT ('   Unable to open ',A80)
      CALL DONE
      END
C
C  This subroutine opens the file with historical program parameters
C
C  IOUT   = number of output file.
C  OLDFIL = name of output file.
C
      SUBROUTINE FOLDW(PROGFL,IOUT,OLDFIL,ISTART)
      CHARACTER*80 OLDFIL,PROGFL
      CHARACTER*160 INFILE
      INTEGER ISTART,IOUT
      WRITE (OLDFIL,10) ISTART+51
   10 FORMAT ('awbi',I2,'.dat')
      CALL CONCAT(INFILE,PROGFL//CHAR(0),OLDFIL//CHAR(0))
      OPEN (UNIT=IOUT,FILE=INFILE,IOINTENT='OUTPUT',ERR=20)
      RETURN
   20 WRITE (6,30) INFILE
   30 FORMAT ('   Unable to open ',A80)
      CALL DONE
      END
C
C  This subroutine opens the file with titles of assumptions
C
C  IN     = number of input file.
C  TITFIL = name of input file.
C
      SUBROUTINE FTITLR(PROGFL,IN,TITFIL,ISTART)
      CHARACTER*80 TITFIL,PROGFL
      CHARACTER*160 INFILE
      INTEGER ISTART,IN
      WRITE (TITFIL,5) ISTART+51
    5 FORMAT ('titles',I2,'.dat')
      IN=14
      CALL CONCAT(INFILE,PROGFL//CHAR(0),TITFIL//CHAR(0))
      OPEN (UNIT=IN,FILE=INFILE,STATUS='OLD',IOINTENT='INPUT',ERR=10)
      RETURN
   10 WRITE (6,20) INFILE
   20 FORMAT ('   Unable to open ',A80)
      CALL DONE
      END
C
C  This subroutine opens the file with titles of assumptions
C
C  IOUT   = number of output file.
C  TITFIL = name of output file.
C
      SUBROUTINE FTITLW(PROGFL,IOUT,TITFIL,ISTART)
      CHARACTER*80 TITFIL,PROGFL
      CHARACTER*160 INFILE
      INTEGER ISTART,IOUT
      WRITE (TITFIL,10) ISTART+51
   10 FORMAT ('titles',I2,'.dat')
      IOUT=14
      CALL CONCAT(INFILE,PROGFL//CHAR(0),TITFIL//CHAR(0))
      OPEN (UNIT=IOUT,FILE=INFILE,IOINTENT='OUTPUT',ERR=20)
      RETURN
   20 WRITE (6,30) INFILE
   30 FORMAT ('   Unable to open ',A80)
      CALL DONE
      END
C
C  This subroutine opens the file with the configuration parameters
C  as file 11.
C
C  IN     = number of input file.
C
      SUBROUTINE FCONFR(PROGFL,IN,CONFIL)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*15 CONFIL
      INTEGER IN
      CONFIL = 'config.dat'
      CALL CONCAT(INFILE,PROGFL//CHAR(0),CONFIL//CHAR(0))
      OPEN (UNIT=11,FILE=INFILE,STATUS='OLD',IOINTENT='INPUT',ERR=10)
      IN = 11
      RETURN
   10 WRITE (6,20) INFILE
   20 FORMAT ('   Could not open ',A50)
      CALL DONE
      END
C
C  This subroutine opens the file with the configuration parameters
C  as file 11.
C
C  IOUT   = number of output file.
C
      SUBROUTINE FCONFW(PROGFL,IOUT,CONFIL)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*15 CONFIL
      INTEGER IOUT
      CONFIL = 'config.dat'
      CALL CONCAT(INFILE,PROGFL//CHAR(0),CONFIL//CHAR(0))
      OPEN (UNIT=11,FILE=INFILE,IOINTENT='OUTPUT',ERR=10)
      IOUT = 11
      RETURN
   10 WRITE (6,20) INFILE
   20 FORMAT ('   Could not open ',A50)
      CALL DONE
      END
C
C  This subroutine opens the file with the law change indicators
C  as file 15.
C
C  IN     = number of input file.
C
      SUBROUTINE FLWCHR(PROGFL,IN,LWCHFL)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*15 LWCHFL
      INTEGER IN
      LWCHFL = 'lawchg.dat'
      CALL CONCAT(INFILE,PROGFL//CHAR(0),LWCHFL//CHAR(0))
      OPEN (UNIT=15,FILE=INFILE,STATUS='OLD',IOINTENT='INPUT',ERR=10)
      IN = 15
      RETURN
   10 WRITE (6,20) INFILE
   20 FORMAT ('   Could not open ',A50)
      CALL DONE
      END
C
C  This subroutine opens the file with the law change indicators
C  as file 15.
C
C  IOUT   = number of output file.
C
      SUBROUTINE FLWCHW(PROGFL,IOUT,LWCHFL)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*15 LWCHFL
      INTEGER IOUT
      LWCHFL = 'lawchg.dat'
      CALL CONCAT(INFILE,PROGFL//CHAR(0),LWCHFL//CHAR(0))
      OPEN (UNIT=15,FILE=INFILE,IOINTENT='OUTPUT',ERR=10)
      IOUT = 15
      RETURN
   10 WRITE (6,20) INFILE
   20 FORMAT ('   Could not open ',A50)
      CALL DONE
      END
C
C  This subroutine opens the file with the base year as file 11.
C
C  IN     = number of input file.
C
      SUBROUTINE FBASER(PROGFL,IN,BASFIL)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*15 BASFIL
      INTEGER IN
      BASFIL = 'baseyear.dat'
      CALL CONCAT(INFILE,PROGFL//CHAR(0),BASFIL//CHAR(0))
      OPEN (UNIT=11,FILE=INFILE,STATUS='OLD',IOINTENT='INPUT',ERR=10)
      IN = 11
      RETURN
   10 WRITE (6,20) INFILE
   20 FORMAT ('   Could not open ',A50)
      CALL DONE
      END
C
C  This subroutine opens the file with the base year as file 11.
C
C  IOUT   = number of output file.
C
      SUBROUTINE FBASEW(PROGFL,IOUT,BASFIL)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*15 BASFIL
      INTEGER IOUT
      BASFIL = 'baseyear.dat'
      CALL CONCAT(INFILE,PROGFL//CHAR(0),BASFIL//CHAR(0))
      OPEN (UNIT=11,FILE=INFILE,IOINTENT='OUTPUT',ERR=10)
      IOUT = 11
      RETURN
   10 WRITE (6,20) INFILE
   20 FORMAT ('   Could not open ',A50)
      CALL DONE
      END
C
C  This subroutine opens the file with the Social Security office
C  address as file 12.
C
C  IN     = number of input file.
C
      SUBROUTINE FADDRR(PROGFL,IN,ADDFIL)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*15 ADDFIL
      INTEGER IN
      ADDFIL = 'fo.dat'
      CALL CONCAT(INFILE,PROGFL//CHAR(0),ADDFIL//CHAR(0))
      OPEN (UNIT=12,FILE=INFILE,STATUS='OLD',IOINTENT='INPUT',ERR=10)
      IN = 12
      RETURN
   10 WRITE (6,20) INFILE
   20 FORMAT ('   Could not open ',A50)
      CALL DONE
      END
C
C  This subroutine opens the file with the Social Security office
C  address as file 12.
C
C  IOUT   = number of output file.
C
      SUBROUTINE FADDRW(PROGFL,IOUT,ADDFIL)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*15 ADDFIL
      INTEGER IOUT
      ADDFIL = 'fo.dat'
      CALL CONCAT(INFILE,PROGFL//CHAR(0),ADDFIL//CHAR(0))
      OPEN (UNIT=12,FILE=INFILE,IOINTENT='OUTPUT',ERR=10)
      IOUT = 12
      RETURN
   10 WRITE (6,20) INFILE
   20 FORMAT ('   Could not open ',A50)
      CALL DONE
      END
C
C  This subroutine opens a file for printout.
C
      SUBROUTINE PRSTRT(PROGFL,IOUT,OUTFIL,IFILE)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*11 OUTFIL
      INTEGER IOUT,IFILE,I,IERR
      OUTFIL = 'outfile.xx'
      IOUT = 8
C  Use page counter for 2 characters
      IFILE = IFILE+1
      IF (IFILE.GT.100) IFILE = 0
      I = IFILE/10
      OUTFIL(9:9) = CHAR(48+I)
      OUTFIL(10:10) = CHAR(48+IFILE-10*I)
      OUTFIL(11:11) = CHAR(0)
      CALL CONCAT(INFILE,PROGFL//CHAR(0),OUTFIL//CHAR(0))
      OPEN (UNIT=IOUT,FILE=INFILE,CARRIAGECONTROL='FORTRAN',
     &IOINTENT='OUTPUT',ERR=10,IOSTAT=IERR)
      RETURN
   10 WRITE (6,20) INFILE,IERR
   20 FORMAT ('Cannot open output file ',A40/'IERR = ',I5)
      CALL DONE
      END
C
C  This subroutine sends a printfile to the printer.
C
      SUBROUTINE PRTOUT(PROGFL,OUTFIL,CMND1,CMND2)
      CHARACTER*80 PROGFL
      CHARACTER*160 INFILE
      CHARACTER*11 OUTFIL
      CHARACTER*40 CMND1,CMND2
      CLOSE (UNIT=8)
      CALL CONCAT(INFILE,PROGFL//CHAR(0),OUTFIL//CHAR(0))
      CALL PTOUTC(INFILE,CMND1,CMND2)
      RETURN
      END
C
C  Subroutine to clear the screen
C
      SUBROUTINE CLS
C     CALL system("clear")
      RETURN
      END
C
C  Subroutine to print warning about printer
C
      SUBROUTINE GETPTR
      CALL HYPHN1
      WRITE (6,10)
   10 FORMAT (T32,'Prepare printer')
      CALL HYPHN2
      WRITE (6,25)
   25 FORMAT ('   Printer should be on and paper should be positioned'/
     &'   1/2 inch below top of form')
      CALL GETRET
      RETURN
      END
C
C  This subroutine converts a response to one-letter uppercase, using
C  ASCII
C
      SUBROUTINE TOUPPR(ANSUP)
      CHARACTER*1 ANSUP
      IF (ICHAR(ANSUP).GT.96) ANSUP = CHAR(ICHAR(ANSUP)-32)
      RETURN
      END
