C  Module IBM
C
C  This module contains IBM-dependent subroutines.
C
C  This subroutine returns the date and time in a 28-character variable,
C  suitable for printing.
C
C *DATE   = date returned from DATIMX call.
C  DATELN = date and time for output.
C
      SUBROUTINE DATIME (DATELN)
      CHARACTER*28 DATELN
      CHARACTER*3 DYOFWK(7),MONTH3(12)
      INTEGER*4 DATE(14)
      DATA DYOFWK / 'Sun','Mon','Tue','Wed','Thu','Fri','Sat' /
      DATA MONTH3 / 'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug',
     &'Sep','Oct','Nov','Dec' /
   10 FORMAT (A3,1X,A3,1X,I2,1X,I2,':',I2,':',I2,1X,I4,4X)
      CALL DATIMX(DATE)
      WRITE (DATELN,10) DYOFWK(DATE(12)),MONTH3(DATE(7)),DATE(6),
     &DATE(5),DATE(4),DATE(3),DATE(8)
      RETURN
      END
C
C  This subroutine opens a case saved on disk.
C
C  ERNFIL = name of file with earnings.
C  IERR   = error indicator.
C  IN     = number of input file.
C
      SUBROUTINE FIN(PROGFL,ERNFIL,IN,IERR)
      CHARACTER*80 PROGFL
      CHARACTER*40 ERNFIL
      IERR = 0
      WRITE (6,10)
   10 FORMAT ('   Enter name of data element with earnings, in the '/
     &'   form FILENAME.(MEMBER)')
      READ (5,20) ERNFIL
   20 FORMAT (A40)
      IN = 5
      RETURN
      END
C
C  This subroutine opens a file to save a case to disk.
C
C  ERNFIL = name of file with earnings.
C  IERR   = error indicator.
C  IOUT   = number of output file.
C
      INTEGER FUNCTION FOUT(PROGFL,ERNFIL,IOUT)
      CHARACTER*80 PROGFL
      CHARACTER*40 ERNFIL
      FOUT = 0
      WRITE (6,10)
   10 FORMAT ('   Enter name of data element with earnings, in the '/
     &'   form FILENAME.ELTNAME/VERSION')
      READ (5,20) ERNFIL
   20 FORMAT (A40)
      IOUT = 9
      RETURN
      END
C
C  This subroutine opens the file with historical program parameters
C  as file 10.
C
C  IN     = number of input file.
C
      SUBROUTINE FOLDR(PROGFL,IN,OLDFIL,ISTART)
      CHARACTER*80 OLDFIL,PROGFL
      WRITE (OLDFIL,5) ISTART+51
    5 FORMAT ('AWBI',I2)
      IF (IN.NE.5) OPEN (UNIT=IN)
      RETURN
      END
C
C  This subroutine opens the file with historical program parameters
C  as file 10.
C
C  IOUT   = number of output file.
C
      SUBROUTINE FOLDW(PROGFL,IOUT,OLDFIL,ISTART)
      CHARACTER*80 OLDFIL,PROGFL
      WRITE (OLDFIL,5) ISTART+51
    5 FORMAT ('AWBI',I2)
      OPEN (UNIT=10)
      IOUT = 10
      RETURN
      END
C
C  This subroutine opens the file with titles of assumptions as
C  file 14.
C
C  IN   = number of input file.
C
      SUBROUTINE FTITLR(PROGFL,IN,TITFIL,ISTART)
      CHARACTER*80 TITFIL,PROGFL
      WRITE (TITFIL,5) ISTART+51
    5 FORMAT ('TITLES',I2)
      OPEN (UNIT=14)
      IN = 14
      RETURN
      END
C
C  This subroutine opens the file with titles of assumptions as
C  as file 14.
C
C  IOUT   = number of output file.
C
      SUBROUTINE FTITLW(PROGFL,IOUT,TITFIL,ISTART)
      CHARACTER*80 TITFIL,PROGFL
      WRITE (TITFIL,5) ISTART+51
    5 FORMAT ('TITLES',I2)
      OPEN (UNIT=14)
      IOUT = 14
      RETURN
      END
C
C  This subroutine opens the file with the configuration parameters
C  as file 11.
C
C  IN     = number of input file.
C
      SUBROUTINE FCONFR(PROGFL,IN,CONFIL)
      CHARACTER*80 PROGFL
      CHARACTER*15 CONFIL
      CONFIL = 'CONFIG'
      OPEN (UNIT=11)
      IN = 11
      RETURN
      END
C
C  This subroutine opens the file with the configuration parameters
C  as file 11.
C
C  IOUT   = number of output file.
C
      SUBROUTINE FCONFW(PROGFL,IOUT,CONFIL)
      CHARACTER*80 PROGFL
      CHARACTER*15 CONFIL
      CONFIL = 'CONFIG'
      OPEN (UNIT=11)
      IOUT = 11
      RETURN
      END
C
C  This subroutine opens the file with the computation year
C  as file 13.
C
C  IN     = number of input file.
C
      SUBROUTINE FBASER(PROGFL,IN,BASFIL)
      CHARACTER*80 PROGFL
      CHARACTER*15 BASFIL
      BASFIL = 'BASEYR'
      OPEN (UNIT=13)
      IN = 13
      RETURN
      END
C
C  This subroutine opens the file with the computation year
C  as file 13.
C
C  IOUT   = number of output file.
C
      SUBROUTINE FBASEW(PROGFL,IOUT,BASFIL)
      CHARACTER*80 PROGFL
      CHARACTER*15 BASFIL
      BASFIL = 'BASEYR'
      OPEN (UNIT=13)
      IOUT = 13
      RETURN
      END
C
C  This subroutine opens the file with the law-change indicators
C  as file 15.
C
C  IN     = number of input file.
C
      SUBROUTINE FLWCHR(PROGFL,IN,LWCHFL)
      CHARACTER*80 PROGFL
      CHARACTER*15 LWCHFL
      LWCHFL = 'LAWCHG'
      OPEN (UNIT=15)
      IN = 15
      RETURN
      END
C
C  This subroutine opens the file with the law-change indicators
C  as file 15.
C
C  IOUT   = number of output file.
C
      SUBROUTINE FLWCHW(PROGFL,IOUT,LWCHFL)
      CHARACTER*80 PROGFL
      CHARACTER*15 LWCHFL
      LWCHFL = 'LAWCHG'
      OPEN (UNIT=15)
      IOUT = 15
      RETURN
      END
C
C  This subroutine opens the file with the Social Security office
C  address as file 12.
C
C  IN     = number of input file.
C
      SUBROUTINE FADDRR(PROGFL,IN,ADDFIL)
      CHARACTER*80 PROGFL
      CHARACTER*15 ADDFIL
      ADDFIL = 'ADDRESS'
      OPEN (UNIT=12)
      IN = 12
      RETURN
      END
C
C  This subroutine opens the file with the Social Security office
C  address as file 12.
C
C  IOUT   = number of output file.
C
      SUBROUTINE FADDRW(PROGFL,IOUT,ADDFIL)
      CHARACTER*80 PROGFL
      CHARACTER*15 ADDFIL
      ADDFIL = 'ADDRESS'
      OPEN (UNIT=12)
      IOUT = 12
      RETURN
      END
C
C  This subroutine opens a file for printout.
C
      SUBROUTINE PRSTRT(PROGFL,IOUT,DATELN,OUTFIL,IFILE)
      CHARACTER*80 PROGFL
      CHARACTER*11 OUTFIL
      CHARACTER*28 DATELN
      OUTFIL = 'PIAHHMMSS##'
C  Use current time for 6 characters
      OUTFIL(4:5) = DATELN(13:14)
      OUTFIL(6:7) = DATELN(16:17)
      OUTFIL(8:9) = DATELN(19:20)
C  Use page counter for 2 characters
      IFILE = IFILE+1
      IF (IFILE.GE.100) IFILE = 0
      I = IFILE/10
      OUTFIL(10:10) = CHAR(48+I)
      OUTFIL(11:11) = CHAR(48+IFILE-10*I)
      IOUT = 6
      RETURN
      END
C
C  This subroutine sends a printfile to the printer.
C
      SUBROUTINE PRTOUT(PROGFL,OUTFIL,PRNTR)
      CHARACTER*80 PROGFL
      CHARACTER*11 OUTFIL,PRNTR
      RETURN
      END
C
C  This subroutine is a dummy (cannot clear screen in Univac).
C
      SUBROUTINE CLS
      RETURN
      END
C
C  Subroutine to print warning about printer
C
      SUBROUTINE GETPTR(PRNTR)
      CHARACTER*11 PRNTR
C  Initialize with null characters
      DO 5 I=1,11
    5 PRNTR(I:I) = CHAR(0)
      CALL HYPHN1
      WRITE (6,10)
   10 FORMAT (T32,'Prepare printer')
      CALL HYPHN2
      WRITE (6,20)
   20 FORMAT ('   Printer should be on and paper should be positioned'/
     &'   1/2 inch below top of form')
      CALL GETRET
      RETURN
      END
C
C  This subroutine converts a response to one-letter uppercase, using EBCDIC
C
      SUBROUTINE TOUPPR(ANSUP)
      CHARACTER*1 ANSUP
      IF (ICHAR(ANSUP).LT.193) ANSUP = CHAR(ICHAR(ANSUP)+64)
      RETURN
      END
