C  @(#)lawchg.f	1.9   3/6/97
C
C  This subroutine prints the title for changes in law.
C
      SUBROUTINE TITLLC
    2 FORMAT (T25,'Changes from present law')
      CALL HYPHN1
      WRITE (6,2)
      CALL HYPHN2
      RETURN
      END
C
C  This subroutine reads in the change from present law indicators and
C  any additional information and transfers them to the calling program.
C
C  Definition of variables (* is a dimensioned array, with indices
C    I, J, K, ... )
C
C  ANSWER = answer to prompt.
C  I      = temporary index used in do-loops.
C  I1     = temporary index used in various places.
C  I2     = temporary index used in various places.
C  NUMB   = number of chosen proposal.
C
      SUBROUTINE LAWCHG (PROGFL,IN)
      INTEGER I,I1,I2,NUMB,IN,IOUT
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
      INCLUDE 'lawchgf.h'
      CHARACTER*80 PROGFL
      CHARACTER*15 LWCHFL
C
C  FORMAT statements
C
    1 FORMAT (A1)
    3 FORMAT (3X,I2,') ',A65)
    4 FORMAT (T24,'Type of special minimum proposal')
    5 FORMAT ('   Enter change from present law:'/
     &'    0) no more changes from present law ')
    6 FORMAT ('   Enter type of special minimum proposal:')
    7 FORMAT (T20,'Type of transitional guarantee proposal')
    8 FORMAT ('   Enter type of transitional guarantee proposal:')
    9 FORMAT (T21,'Type of windfall elimination provision')
   10 FORMAT ('   Is there a change from present law? (y or n)')
   11 FORMAT ('   Enter type of windfall elimination provision')
   12 FORMAT ('   Enter first year bend points increase at fraction '/
     &'   of wage rate increase')
   13 FORMAT ('   Enter first year of CPI-indexed bend points'/)
   14 FORMAT ('   Enter first year of CPI-indexed earnings'/)
   15 FORMAT ('   Enter first year of alternative benefit formula ')
   16 FORMAT ('   Enter first year bend points increasing at specified',
     &' rate ')
   17 FORMAT ('   Enter bend point increases in ',I4,/)
   18 FORMAT ('   Enter first year of wage-rate minus a constant'/)
   19 FORMAT ('   Enter first year of decline in benefit formula ',
     &'percents')
   20 FORMAT ('   Enter first year of windfall elimination provision ',
     &'change')
   21 FORMAT ('   Enter first year of no benefit increase in year of'/
     &' eligibility'/)
   22 FORMAT ('   Enter first year of special minimum change'/)
   23 FORMAT ('   Enter alternative special minimum dollar amount'/)
   24 FORMAT ('   Enter maximum number of years of coverage for '/
     &' special minimum'/)
   25 FORMAT ('   Enter first year of no Old-Start method'/)
   26 FORMAT ('   Enter first year of no PIA Table method'/)
   27 FORMAT ('   Enter first year of no Transitional Guarantee ',
     &'Method')
   28 FORMAT ('   Enter first year of entitlements without variable ',
     &'dropout years')
   29 FORMAT ('   Enter first year of phase-in to age-65 comp point')
   30 FORMAT ('   Enter last year bend points increase at fraction '/
     &'   of wage rate increase')
   31 FORMAT ('   Enter last year of CPI-indexed bend points'/)
   32 FORMAT ('   Enter last year of CPI-indexed earnings'/)
   33 FORMAT ('   Enter first alternative PIA percentage for ',I4)
   34 FORMAT ('   Enter last year bend points increasing at specified',
     &' rate ')
   35 FORMAT ('   Enter second year of decline in benefit formula ',
     &'percents'/)
   36 FORMAT ('   Enter first year for not using re-indexed widow '/
     &' guarantee'/)
   37 FORMAT (T2,I4)
   38 FORMAT (T2,F9.2)
   39 FORMAT (T20,'Type of childcare drop-in year proposal')
   40 FORMAT ('   Enter type of childcare drop-in year proposal:')
   41 FORMAT (T20,'Type of PIA table declining excess proposal')
   42 FORMAT ('   Enter type of PIA table declining excess proposal:')
   43 FORMAT ('   Enter percent of old-law maximum required for year ',
     &'of coverage')
   44 FORMAT ('   Enter first year of no age-67 retirement')
   45 FORMAT ('   Enter last year of alternative benefit formula')
   46 FORMAT ('   Enter number of bend points in alt benefit formula')
   47 FORMAT ('   Enter second alternative PIA percentage for ',I4)
   48 FORMAT ('   Enter third alternative PIA percentage for ',I4)
   49 FORMAT ('   Enter fourth alternative PIA percentage for ',I4)
   50 FORMAT ('   Enter first alternative PIA bend point for ',I4)
   51 FORMAT ('   Enter second alternative PIA bend point for ',I4)
   52 FORMAT ('   Enter third alternative PIA bend point for ',I4)
   53 FORMAT ('   Enter first year of retro wage indexing:')
   54 FORMAT ('   Enter first year of Myers COLA-cutback proposal:')
   55 FORMAT ('   Enter last year of Myers COLA-cutback proposal:')
   56 FORMAT ('   Enter amount required for Myers year of earnings:')
   57 FORMAT ('   Enter minimum PIA required for Myers proposal:')
C
C  Read indicators for change from present law
C
      DO 100 I=1,MAXJND
  100 JIND(I) = 0
      JINDT = 0
      CALL TITLLC
  105 WRITE (6,10)
      READ (5,1) ANSWER
      CALL TOUPPR(ANSWER)
      IF (ANSWER.NE.'Y'.AND.ANSWER.NE.'N') THEN
      CALL BEEP
      GO TO 105
      END IF
      IF (ANSWER.EQ.'N') RETURN
      I1 = (MAXJND-1)/10
  110 DO 112 I=1,I1
      CALL TITLLC
      WRITE (6,5)
      DO 111 I2=10*I-9,10*I
  111 WRITE (6,3) I2,TIND(I2)
  112 CALL GETRET
  115 CALL TITLLC
      WRITE (6,5)
      DO 120 I=10*I1+1,MAXJND
  120 WRITE (6,3) I,TIND(I)
      READ (5,*) NUMB
      IF (NUMB.LT.0.OR.NUMB.GT.MAXJND) THEN
      CALL BEEP
      GO TO 115
      END IF
C
C  Set change indicator
C
      IF (NUMB.GT.0) THEN
      GOTO (130,130,130,130,130,130,130,130,130,130,130,135,140,
     &130,130,160,160,160,130,130,160,130,130,130,130,185,130,180,
     &130,130) NUMB
  130 JIND(NUMB) = 1
      GO TO 110
  135 CALL HYPHN1
      WRITE (6,9)
      CALL HYPHN2
      WRITE (6,11)
      DO 137 I=1,2
  137 WRITE (6,3) I,TINDWE(I)
      READ (5,*) JIND(NUMB)
      IF (JIND(NUMB).LT.1.OR.JIND(NUMB).GT.2) THEN
      CALL BEEP
      GO TO 135
      END IF
      GO TO 110
  140 CALL HYPHN1
      WRITE (6,4)
      CALL HYPHN2
      WRITE (6,6)
      DO 150 I=1,3
  150 WRITE (6,3) I,TINDSM(I)
      READ (5,*) JIND(NUMB)
      IF (JIND(NUMB).LT.1.OR.JIND(NUMB).GT.3) THEN
      CALL BEEP
      GO TO 140
      END IF
      GOTO 110
  160 CALL HYPHN1
      WRITE (6,7)
      CALL HYPHN2
      WRITE (6,8)
      DO 170 I=1,2
  170 WRITE (6,3) I,TINDTG(I)
      READ (5,*) JIND(NUMB)
      IF (JIND(NUMB).LT.1.OR.JIND(NUMB).GT.2) THEN
      CALL BEEP
      GO TO 160
      END IF
      GOTO 110
  180 CALL HYPHN1
      WRITE (6,39)
      CALL HYPHN2
      WRITE (6,40)
      DO 181 I=1,8
  181 WRITE (6,3)I,TINDCD(I)
      READ (5,*) JIND(NUMB)
      IF (JIND(NUMB).LT.1.OR.JIND(NUMB).GT.8) THEN
      CALL BEEP
      GO TO 180
      END IF
      GO TO 110
  185 CALL HYPHN1
      WRITE (6,41)
      CALL HYPHN2
      WRITE (6,42)
      DO 186 I=1,2
  186 WRITE (6,3)I,TIND26(I)
      READ (5,*) JIND(NUMB)
      IF (JIND(NUMB).LT.1.OR.JIND(NUMB).GT.2) THEN
      CALL BEEP
      GO TO 185
      END IF
      GO TO 110
      END IF
      DO 190 I=1,MAXJND
  190 JINDT = JINDT + JIND(I)
C
C  Read additional parameters
C
      IF (JIND(2).GT.0) THEN
C  If this run uses fraction-of-wage rate for bend points, read in years
C  affected
      WRITE (6,12)
      READ (IN,*) JSTART(1,2)
      WRITE (6,30)
      READ (IN,*) JSTART(2,2)
      WRITE (6,212)
  212 FORMAT (' Enter percent wage rate applied to bend points')
      READ (IN,*) PBP
      END IF
C  If this run uses CPI-indexed bend points, read in years affected
      IF (JIND(3).GT.0) THEN
      WRITE (6,13)
      READ (IN,*) JSTART(1,3)
      WRITE (6,31)
      READ (IN,*) JSTART(2,3)
      END IF
      IF (JIND(4).GT.0) THEN
C  If this run uses CPI-indexed earnings, read in years affected
      WRITE (6,14)
      READ (IN,*) JSTART(1,4)
      WRITE (6,32)
      READ (IN,*) JSTART(2,4)
      END IF
      IF (JIND(5).GT.0) THEN
C  Read in effective date, percentages and bend points for alternative
C  bend point formula
        WRITE (6,15)
        READ (IN,*) JSTART(1,5)
        WRITE (6,45)
        READ (IN,*) JSTART(2,5)
        WRITE (6,46)
        READ (IN,*) NUMBP
        DO 520 I=JSTART(1,5),JSTART(2,5)
          WRITE (6,33) I
          READ (IN,*) PERCPA(1,I-1936)
          WRITE (6,47) I
          READ (IN,*) PERCPA(2,I-1936)
          WRITE (6,48) I
          READ (IN,*) PERCPA(3,I-1936)
          IF (NUMBP.EQ.3) THEN
            WRITE (6,49) I
            READ (IN,*) PERCPA(4,I-1936)
          END IF
          WRITE (6,50) I
          READ (IN,*) IBENPA(2,I-1936)
          WRITE (6,51) I
          READ (IN,*) IBENPA(3,I-1936)
          IF (NUMBP.EQ.3) THEN
            WRITE (6,52) I
            READ (IN,*) IBENPA(4,I-1936)
          END IF
  520   CONTINUE
      END IF
      IF (JIND(6).GT.0) THEN
C  If this run uses specified increases for bend points, read in
C  years affected
      WRITE (6,16)
      READ (IN,*) JSTART(1,6)
      WRITE (6,34)
      READ (IN,*) JSTART(2,6)
      I1 = JSTART(1,6)
      I2 = JSTART(2,6)
C  Read in specified bend point increases
      DO 917 I=I1,I2
      WRITE (6,17) I
      READ (IN,*) BPINC(I-1950)
  917 CONTINUE
      END IF
      IF (JIND(7).GT.0) THEN
C  If this run uses constant percentage decline from wage increase
C  for bend point increase, read in years affected
      WRITE (6,18)
      READ (IN,*) JSTART(1,7)
      WRITE (6,218)
  218 FORMAT (' Enter last year of wage-rate minus a constant'/)
      READ (IN,*) JSTART(2,7)
      WRITE (6,318)
  318 FORMAT (' Enter the constant percent to be subtracted from ',
     &'wage rate for bend point increase'/)
      READ (IN,*) CP
      END IF
C  If this run uses age-65 computation point, read first year of
C  phase-in
      IF (JIND(8).GT.0) THEN
      WRITE (6,29)
        READ (IN,*) JSTART(1,8)
      END IF
      IF (JIND(9).GT.0) THEN
C  If this run uses declining benefit formula percents, read in
C  years affected
      WRITE (6,19)
      READ (IN,*) JSTART(1,9)
      WRITE (6,35)
      READ (IN,*) JSTART(2,9)
      WRITE (6,219)
  219 FORMAT(' Enter constant percent subtracted from wage-rate',
     &' when applying to bend points'/)
      READ (IN,*) CP
      END IF
      IF (JIND(10).GT.0) THEN
C  If this run eliminates benefit increase in year of eligibility, read
C  beginning year
      WRITE (6,21)
      READ (IN,*) JSTART(1,10)
      END IF
      IF (JIND(11).GT.0) THEN
      WRITE (6,36)
      READ (IN,*) JSTART(1,11)
      END IF
C  If this run changes windfall elimination provision, read starting
C  year
      IF (JIND(12).GT.0) THEN
      WRITE (6,20)
      READ (IN,*) JSTART(1,12)
      END IF
C  If this run changes special minimum, read starting year
      IF (JIND(13).GT.0) THEN
      WRITE (6,22)
      READ (IN,*) JSTART(1,13)
C  Read dollar amount, if applicable
      IF (MOD(JIND(13),4).EQ.1) THEN
      WRITE (6,23)
      READ (IN,*) ASPMIN
      END IF
C  Read maximum years, if applicable
      IF (MOD(JIND(13),4).GE.2) THEN
      WRITE (6,24)
      READ (IN,*) JSPMIN
      END IF
C  Read percent, if applicable
      IF (JIND(13).GE.4) THEN
        WRITE (6,43)
        READ (IN,*) BSPMIN
      END IF
      END IF
C  If this run eliminates old-start, read starting year
      IF (JIND(14).GT.0) THEN
      WRITE (6,25)
      READ (IN,*) JSTART(1,14)
      END IF
C  If this run removes variable DI dropout years, read first year of
C  entitlement
      IF (JIND(15).GT.0) THEN
      WRITE (6,28)
        READ (IN,*) JSTART(1,15)
      END IF
C  If this run eliminates PIA Table, read starting year
      IF (JIND(23).GT.0) THEN
      WRITE (6,26)
      READ (IN,*) JSTART(1,23)
      END IF
C  If this run eliminates Transitional Guar, read starting year
      IF (JIND(24).GT.0) THEN
      WRITE (6,27)
      READ (IN,*) JSTART(1,24)
      END IF
C  If this run eliminates age-67 retirement, read starting year
      IF (JIND(27).GT.0) THEN
        WRITE (6,44)
        READ (IN,*) JSTART(1,27)
      END IF
C  If this run has retro wage indexing, read starting year
      IF (JIND(29).GT.0) THEN
        WRITE (6,53)
        READ (IN,*) JSTART(1,29)
      END IF
C  If this run has Myers COLA-cutback proposal, read years
      IF (JIND(30).GT.0) THEN
        WRITE (6,54)
        READ (IN,*) JSTART(1,30)
        WRITE (6,55)
        READ (IN,*) JSTART(2,30)
        WRITE (6,56)
        READ (IN,*) ERN30
        WRITE (6,57)
        READ (IN,*) PIA30
      END IF
C
C  Save to disk
C
      CALL FLWCHW(PROGFL,IOUT,LWCHFL)
      DO 900 I=1,MAXJND
  900 WRITE (IOUT,37) JIND(I)
      IF (JIND(2).GT.0) THEN
      WRITE (IOUT,37) JSTART(1,2)
      WRITE (IOUT,37) JSTART(2,2)
      WRITE (IOUT,38) PBP
      END IF
      IF (JIND(3).GT.0) THEN
      WRITE (IOUT,37) JSTART(1,3)
      WRITE (IOUT,37) JSTART(2,3)
      END IF
      IF (JIND(4).GT.0) THEN
      WRITE (IOUT,37) JSTART(1,4)
      WRITE (IOUT,37) JSTART(2,4)
      END IF
      IF (JIND(5).GT.0) THEN
        WRITE (IOUT,37) JSTART(1,5),JSTART(2,5)
        WRITE (IOUT,37) NUMBP
        DO 800 I=JSTART(1,5),JSTART(2,5)
          WRITE (IOUT,38) (PERCPA(I1,I-1936),I1=1,NUMBP+1)
          WRITE (IOUT,37) (IBENPA(I1,I-1936),I1=2,NUMBP+1)
  800   CONTINUE
      END IF
      IF (JIND(6).GT.0) THEN
      WRITE (IOUT,37) JSTART(1,6)
      WRITE (IOUT,37) JSTART(2,6)
      DO 125 I=JSTART(1,6),JSTART(2,6)
  125 WRITE (IOUT,38) BPINC(I-1950)
      END IF
      IF (JIND(7).GT.0) THEN
      WRITE (IOUT,37) JSTART(1,7)
      WRITE (IOUT,37) JSTART(2,7)
      WRITE (IOUT,38) CP
      END IF
      IF (JIND(9).GT.0) THEN
      WRITE (IOUT,37) JSTART(1,9)
      WRITE (IOUT,37) JSTART(2,9)
      WRITE (IOUT,38) CP
      END IF
      IF (JIND(10).GT.0) WRITE (IOUT,37) JSTART(1,10)
      IF (JIND(12).GT.0) WRITE (IOUT,37) JSTART(1,12)
      IF (JIND(13).GT.0) THEN
        WRITE (IOUT,37) JSTART(1,13)
        IF (MOD(JIND(13),2).EQ.1) WRITE (IOUT,38) ASPMIN
        IF (MOD(JIND(13),4).GE.2) WRITE (IOUT,37) JSPMIN
        IF (JIND(13).GE.4) WRITE (IOUT,38) BSPMIN
      END IF
      IF (JIND(14).GT.0) WRITE (IOUT,37) JSTART(1,14)
      IF (JIND(15).GT.0) WRITE (IOUT,37) JSTART(1,15)
      IF (JIND(23).GT.0) WRITE (IOUT,37) JSTART(1,23)
      IF (JIND(24).GT.0) WRITE (IOUT,37) JSTART(1,24)
      IF (JIND(27).GT.0) WRITE (IOUT,37) JSTART(1,27)
      IF (JIND(29).GT.0) WRITE (IOUT,37) JSTART(1,29)
      IF (JIND(30).GT.0) THEN
        WRITE (IOUT,37) JSTART(1,30)
        WRITE (IOUT,37) JSTART(2,30)
        WRITE (IOUT,38) ERN30
        WRITE (IOUT,38) PIA30
      END IF
      CLOSE (IOUT)
      RETURN
      END
