// Functions for the <see cref=Pib52Ame"/> class to handle 1952 pib-ame
// conversion table.
//
// $Id: pib52ame.cpp 1.2 2011/08/08 08:45:12EDT 044579 Development  $

#include "pibtable.h"
#include "Resource.h"
#include "PiaException.h"

// <summary>The 1952 ame's.</summary>
const double Pib52Ame::ame52[] = {
  25.0, 25.5, 26.1, 26.6, 27.2, 27.7, 28.3, 28.8, 29.4, 29.9,
  30.5, 31.0, 31.6, 32.1, 32.7, 33.2, 33.8, 34.3, 34.9, 35.4,
  36.0, 36.5, 37.1, 37.6, 38.2, 38.7, 39.3, 39.8, 40.4, 40.9,
  41.5, 42.0, 42.6, 43.1, 43.7, 44.2, 44.8, 45.3, 45.9, 46.4,
  47.0, 47.5, 48.1, 48.6, 49.2, 49.7, 50.3, 50.8, 51.4, 51.9,
  52.5, 53.0, 53.6, 54.1, 54.7, 55.0, 55.2, 55.3, 55.5, 55.6,
  55.8, 55.9, 56.1, 56.2, 56.4, 56.5, 56.7, 56.8, 57.0, 57.1,
  57.3, 57.4, 57.6, 57.7, 57.9, 58.0, 58.2, 58.3, 58.5, 58.6,
  58.8, 58.9, 59.1, 59.2, 59.4, 59.5, 59.7, 59.8, 60.0, 60.1,
  60.3, 60.4, 60.6, 60.7, 60.9, 61.0, 61.2, 61.3, 61.5, 61.6,
  61.8, 61.9, 62.1, 62.2, 62.4, 62.5, 62.7, 62.8, 63.0, 63.1,
  63.3, 63.4, 63.6, 63.7, 63.9, 64.0, 64.2, 64.3, 64.5, 64.6,
  64.8, 64.9, 65.1, 65.2, 65.4, 65.5, 65.7, 65.8, 66.0, 66.1,
  66.3, 66.4, 66.6, 66.7, 66.9, 67.0, 67.2, 67.3, 67.5, 67.6,
  67.8, 67.9, 68.1, 68.2, 68.4, 68.5, 68.7, 68.8, 69.0, 69.1,
  69.3, 69.4, 69.6, 69.7, 69.9, 70.0, 70.2, 70.3, 70.5, 70.6,
  70.8, 70.9, 71.1, 71.2, 71.4, 71.5, 71.7, 71.8, 72.0, 72.1,
  72.3, 72.4, 72.6, 72.7, 72.9, 73.0, 73.2, 73.3, 73.5, 73.6,
  73.8, 73.9, 74.1, 74.2, 74.4, 74.5, 74.7, 74.8, 75.0, 75.1,
  75.3, 75.4, 75.6, 75.7, 75.9, 76.0, 76.2, 76.3, 76.5, 76.6,
  76.8, 76.9, 77.0, 77.0, 77.0, 77.1
};

/// <summary>Returns 1952 conversion table mfb.</summary>
///
/// <returns>1952 conversion table mfb.</returns>
///
/// <exception cref="PiaException"><see cref="PiaException"/> of type
/// <see cref="PIA_IDS_PIB52MFB"/> if index is out of range
/// (only in debug mode).</exception>
///
/// <param name="index">Number of mfb desired.</param>
double Pib52Ame::getAt( int index )
{
#ifndef NDEBUG
  if (index < 0 || index > 205)
    throw PiaException(PIA_IDS_PIB52MFB);
#endif
  return(ame52[index]);
}
