C  @(#)wrkrdata.h	1.6   2/24/97
C
C  This module contains declarations for variables pertaining to worker.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C  Definition of variables ('*' before variable name denotes dimensioned
C  variable array):
C
C *BASE   = wage base under present law through 1986, projected
C             thereafter, in year 1936+I.
C *BASE77 = old-law wage bases (ignoring 1979-81 ad hoc increases),
C             in year 1936+I.
C *BENDAT = date of benefit (month and year).
C  BLIND  = indicator for disability insured status allowed based on
C             fully insured status only because of blindness.
C           FALSE: no blindness.
C           TRUE: blindness.
C *CACHUP = catch-up benefit increases.
C           I=1 is year of eligibility 1951+ISTART or earlier, 2 is year
C             of eligibility 1952+ISTART, ..., 10 is 1960+ISTART or
C             later.
C           J=1 is benefit increase in 1953+ISTART, 2 is 1954+ISTART,
C             ..., 8 is benefit increase in 1960+ISTART.
C *CPIINC = benefit increase in year 1950+J.
C  CURYR  = current year (through which qc's are known).
C *DICESS = month and year of disability cessation (0 if none) (year is
C             4 digits).
C *DICES1 = month and year of prior disability cessation (0 if none)
C             (year is 4 digits).
C *EARNHI = additional HI earnings in year 1936+I.
C *EARNTP = type of earnings in year 1936+I (0=year by year entered on
C             keyboard, 1=maximum, 2=average, 3=low, 4=old-law maximum).
C *ERNPBS = OASDI earnings as entered in year 1936+I.
C *FQINC  = increase in annual average wages in year 1936+I (percent).
C  IAGPLN = planned retirement age as entered.
C  IALTAW = average wage assumptions (1=TR alternative I, 2=TR
C             alternative II-B, 3=TR alternative III, 4=TR alternative
C             II-A, 5=no increase beyond last known value, 6=PEBES
C             calculation (1% real wage gains), 7=other assumptions.
C  IALTBI = benefit increase assumptions (1=TR alternative I, 2=TR
C             alternative II-B, 3=TR alternative III, 4=TR alternative
C             II-A, 5=no increase beyond last known value, 6=PEBES
C             calculation (no future benefit increases), 7=other
C             assumptions.
C  IBEGIN = beginning year of earnings after projection.
C  IBEGN1 = beginning year of earnings before projection.
C *IBIRTH = month, day, and year of birth of worker (year is 4 digits).
C *IDEATH = month and year of death if IOASDI=2, meaningless otherwise
C             (year is 4 digits).
C  IDEEM  = indicator for deemed insured status possible.
C           FALSE: no deemed insured status possible.
C           TRUE: deemed insured status possible.
C  IEND   = last year of earnings after projection.
C  IEND1  = last year of earnings before steady projection.
C *IENT   = month and year of entitlement (year is 4 digits).
C  IOASDI = type of benefit (1 for old-age, 2 for survivor, 3 for
C             disability).
C *IONSET = month, day, year of disability onset (0 if none) (year is 4
C             digits).
C *IQC    = number of quarters of coverage in 1936+I.
C  ISEX   = sex (1=male, 2=female).
C  ISTART = first year of average wage projection minus 1950.
C  IX     = last year of period minus 1936.
C  IYR    = last year of period minus 1950.
C  JALTAW = last average wage increase assumption read in.
C  JALTBI = last benefit increase assumption read in.
C  JBASCH = last ad hoc base change read in.
C *JBIRTH = month, day, and year of birth of widow (year is 4 digits).
C  JOASDI = type of calculation (1 for old-age, 2 for survivor, 3 for
C             disability, 4 for PEBES).
C *JONSET = month, day, year of widow's disability onset (0 if none)
C             (year is 4 digits).
C  JSURV  = 1 for no survivor widow, 2 for disabled widow, 3 for
C             aged widow.
C  MAXASM = maximum number of average wage or benefit increase
C             assumptions.
C  MAXYRS = maximum number of years of earnings, or implied earnings,
C             allowed.
C  MONTHN = current month (1-12).
C  MQGE   = HI earnings code (FALSE for no HI earnings, TRUE for HI
C             earnings).
C  NAME   = name of worker.
C *NHADDR = address of number holder.
C  NHSSN  = Social Security number of worker.
C *ONSET1 = month, day, year of prior disability onset (0 if none) (year
C             is 4 digits).
C  PERCBK = backward projection percentage factor.
C  PERCFD = forward projection percentage factor.
C  PRBACK = indicator for backward projection (0=no projection,
C             1=project with average wages, 2=project at constant rate).
C  PRFWRD = indicator for forward projection (0=no projection,
C             1=project with average wages, 2=project at constant rate).
C *PRRENT = date of prior entitlement to disability (month and year).
C *PRREN1 = date of second prior entitlement to disability (month and
C             year).
C  PUBPEN = amount of noncovered public pension subject to offset
C             provision.
C  QCTD   = quarters of coverage earned to date from 1937.
C  QC51TD = quarters of coverage earned to date from 1951.
C  RECALC = recalculation code (FALSE for initial entitlement, TRUE for
C             recalculation).
C *TAXTYP = type of taxes (0 for employee, 1 for self-employed).
C  TITLAW = description of the average wage assumptions.
C  TITLBI = description of the benefit increase assumptions.
C  TOTALI = totalization indicator (FALSE for none, TRUE for
C             totalization).
C  VALDI  = disability code (0 for no prior disability, 1 for disability
C             immediately prior to entitlement).
C *WAITPD = first month of waiting period (month and year).
C *WAITP1 = first month of prior waiting period (month and year).
C
      INTEGER MAXYRS, MAXASM, MAXCAL, IX, IYR
      PARAMETER (MAXYRS=60, MAXASM=7, MAXCAL=8, IX=139, IYR=125)
C  Dimension common variables
      DOUBLE PRECISION BASE(IX), BASE77(IX), CACHUP(10,8), ERNPBS(IX),
     &MAXERN, EARNHI(IX)
      REAL CPIINC(IYR), PUBPEN, FQINC(IX), PERCFD, PERCBK
      INTEGER IQC(IX), BENDAT(2), IBIRTH(3), IDEATH(2), IONSET(3),
     &JBIRTH(3), TAXTYP(IX), VALDI, IAGPLN, IALTAW, IALTBI, IBEGIN,
     &IEND, IEND1, ISEX, ISTART, JOASDI, MONTHN, JSURV, CURYR,
     &PRRENT(2), WAITPD(2), JONSET(3), IENT(2), IBASCH, IOASDI,
     &QCTD, QC51TD, EARNTP(IX), PRFWRD, PRBACK, IBEGN1, DICESS(2),
     &JALTAW, JALTBI, JBASCH, ONSET1(3), DICES1(2), PRREN1(2), WAITP1(2)
      LOGICAL IDEEM, TOTALI, RECALC, BLIND, MQGE
      CHARACTER*1 ANSCCH
      CHARACTER*65 TITLAW, TITLBI
      CHARACTER*35 NAME,NHADDR(3)
      CHARACTER*12 NHSSN
      COMMON / WRKRDT / BASE, BASE77, CACHUP, ERNPBS, MAXERN, EARNHI,
     &PUBPEN, FQINC, CPIINC, PERCFD, PERCBK,
     &IQC, BENDAT, IBIRTH, IDEATH, IONSET, JBIRTH, TAXTYP, VALDI,
     &IAGPLN, IALTAW, IALTBI, IBEGIN, IEND, IEND1, ISEX, ISTART,
     &JOASDI, MONTHN, JSURV, PRRENT, WAITPD, DICESS, DICES1, ONSET1,
     &JONSET, IENT, IBASCH, QCTD, QC51TD, EARNTP, PRFWRD, PRBACK,
     &IBEGN1, JALTAW, JALTBI, JBASCH, IOASDI, CURYR, PRREN1, WAITP1,
     &BLIND, IDEEM, MQGE, RECALC, TOTALI,
     &ANSCCH, TITLAW, TITLBI, NAME, NHADDR, NHSSN
