C  @(#)savdis.f	1.24   6/16/97
C
C  Function to read case from file
C
C  IN     = unit number to read from.
C
      INTEGER FUNCTION READFL(IN)
      INCLUDE 'wrkrdataf.h'
      INTEGER IN,ISTRT1,IEND2,I,IERR
C  Function declarations
      INTEGER EARNF,BENRDF,AVGRDF,WAGBSF,WAITPF,PRIORF,ENDCHK,BNDTCK,
     &JSURCK,BEGCHK,QCSUM,DTHCHK,IENTCK,LSTQCY,PBSACK,MODYCK,ERNTPF,
     &IBIRTF,IONSTF,TAXF,ERNFHI
      LOGICAL QCBYYR
    2 FORMAT (A35)
    3 FORMAT (A12)
      READFL = 0
C  Read starting year
      READ (IN,*,ERR=299) ISTRT1
      ISTRT1 = ISTRT1 - 1951
C  Read sex of worker
      READ (IN,*,ERR=299) ISEX
C  Set error code if incorrect sex
      IF (ISEX.LT.1.OR.ISEX.GT.2) THEN
      IERR = 1
      GO TO 300
      END IF
C  Read type of benefit
      READ (IN,*,ERR=299) JOASDI
C  Set error code if incorrect type of benefit
      IF (JOASDI.LT.1.OR.JOASDI.GT.4) THEN
        IERR = 6
        GO TO 300
      END IF
C  Read recalculation indicator
      READ (IN,*,ERR=299) I
      IF (I.EQ.0) THEN
        RECALC = .FALSE.
      ELSE
        RECALC = .TRUE.
      END IF
C  Read totalization indicator
      READ (IN,*,ERR=299) I
      IF (I.EQ.0) THEN
        TOTALI = .FALSE.
      ELSE
        TOTALI = .TRUE.
      END IF
C  Read HI earnings indicator
      READ (IN,*,ERR=299) I
      IF (I.EQ.0) THEN
        MQGE = .FALSE.
      ELSE
        MQGE = .TRUE.
      END IF
C  Read month, day and year of birth of worker
      IERR = IBIRTF(IN)
      IF (IERR.GT.0) GO TO 300
C  Get current operating month for PEBES case
      READ (IN,*,ERR=299) MONTHN
      IF (JOASDI.EQ.4.AND.(MONTHN.LT.1.OR.MONTHN.GT.12)) THEN
        IERR = 56
        GOTO 300
      END IF
C  Read month and year of entitlement
      READ (IN,*,ERR=299) IENT(1)
      READ (IN,*,ERR=299) IENT(2)
C  Read month and year of benefit
      READ (IN,*,ERR=299) BENDAT(1)
      READ (IN,*,ERR=299) BENDAT(2)
C  Read planned age at retirement
      READ (IN,*,ERR=299) IAGPLN
      IF (JOASDI.LT.4) THEN
C  Set error code if incorrect date of entitlement
        IERR = IENTCK()
        IF (IERR.GT.0) GO TO 300
        IAGPLN = 0
      END IF
      IF (RECALC) THEN
        IERR = BNDTCK()
        IF (IERR.GT.0) GO TO 300
      ELSE
        CALL STBNDT
      END IF
      READ (IN,*,ERR=299) PRBACK
      IF (PRBACK.LT.0.OR.PRBACK.GT.2) THEN
        IERR = 25
        GO TO 300
      END IF
      READ (IN,*,ERR=299) PERCBK
C  Read first year of earnings after projection
      READ (IN,*,ERR=299) IBEGIN
C  Set error code if incorrect first year of earnings
      IF (IBEGIN.GT.1936+IX.OR.IBEGIN.LT.1937) THEN
        IERR = 8
        GO TO 300
      END IF
C  Read first year of earnings before projection
      READ (IN,*,ERR=299) IBEGN1
C  Set error code if incorrect first year of earnings
      IF (IBEGN1.GT.1936+IX.OR.IBEGN1.LT.1937) THEN
        IERR = 8
        GO TO 300
      END IF
C  Set error code if first year of earnings too early
      IERR = BEGCHK()
      IF (IERR.GT.0) GO TO 300
      READ (IN,*,ERR=299) PRFWRD
      IF (PRFWRD.LT.0.OR.PRFWRD.GT.2) THEN
        IERR = 27
        GO TO 300
      END IF
      READ (IN,*,ERR=299) PERCFD
C  Read last year of earnings before projection
      READ (IN,*,ERR=299) IEND2
      IEND1 = IEND2
C  Set error code if incorrect last year of earnings
      IF (IEND1.GT.1936+IX) THEN
        IERR = 9
        GO TO 300
      END IF
C  Read last year of earnings after projection
      READ (IN,*,ERR=299) IEND
C  Set error code if incorrect last year of earnings
      IF (IEND.GT.1936+IX) THEN
        IERR = 9
        GO TO 300
      END IF
      IERR = ENDCHK()
      IF (IERR.GT.0) GO TO 300
C  Read type of earnings
      IERR = ERNTPF(IN)
      IF (IERR.GT.0) GO TO 300
C  Read quarters of coverage, 1937 to 1977
      READ (IN,*,ERR=299) QCTD
C  Read quarters of coverage, 1951 to 1977
      READ (IN,*,ERR=299) QC51TD
      CALL QCTDCK
C  Set error code if negative quarters of coverage
      IF (QCTD.LT.0) THEN
        IERR = 33
        GO TO 300
      END IF
      IF (QC51TD.LT.0) THEN
        IERR = 40
        GO TO 300
      END IF
C  Read annual quarters of coverage if necessary
      IF (QCBYYR()) THEN
        DO 110 I=IBEGIN-1936,LSTQCY()-1936
        READ (IN,*,ERR=299) IQC(I)
        IF (IQC(I).GT.4.OR.IQC(I).LT.0) THEN
          IERR = 41
          GO TO 300
        END IF
  110   CONTINUE
        QCTD = QCSUM(1937,LSTQCY())
        QC51TD = QCSUM(1951,LSTQCY())
      END IF
C  Read month and year of death
      READ (IN,*,ERR=299) IDEATH(1),IDEATH(2)
      IF (JOASDI.EQ.2) THEN
C  Set error code if incorrect date of death
        IERR = DTHCHK()
        IF (IERR.GT.0) GO TO 300
      ELSE
C  Clear date of death
        IDEATH(1) = 0
        IDEATH(2) = 0
      END IF
C  Read indicator for type of survivor
      READ (IN,*,ERR=299) JSURV
      IF (JOASDI.EQ.2) THEN
C  Set error code if incorrect type of survivor
        IERR = JSURCK()
        IF (IERR.GT.0) GO TO 300
      ELSE
        JSURV = 0
      END IF
C  Read disability code
      READ (IN,*,ERR=299) VALDI
C  Set error code if impossible disability code
      IF (VALDI.LT.0.OR.VALDI.GT.1) THEN
      IERR = 23
      GO TO 300
      END IF
C  Set error code if no disability in disability case
      IF (JOASDI.EQ.3.AND.VALDI.LT.1) THEN
      IERR = 24
      GO TO 300
      END IF
      IF (JOASDI.EQ.4) VALDI = 0
C  Read month, day, and year of disability onset
      IERR = IONSTF(IN)
      IF (IERR.GT.0) GO TO 300
C  Read date of prior entitlement to disability
      IERR = PRIORF(IN)
      IF (IERR.GT.0) GO TO 300
C  Read first month of waiting period
      IERR = WAITPF(IN)
      IF (IERR.GT.0) GO TO 300
C  Read month, day, and year of birth of widow
      READ (IN,*,ERR=299) JBIRTH(1),JBIRTH(2),JBIRTH(3)
      IF (JSURV.GT.1) THEN
C  Set error code if impossible month or day of birth
        IF (MODYCK(JBIRTH).GT.0) THEN
          IERR = 17
          GO TO 300
        END IF
      END IF
C  Read month, day, and year of widow's disability onset
      READ (IN,*,ERR=299) JONSET(1),JONSET(2),JONSET(3)
      IF (JSURV.EQ.2) THEN
C  Set error code if incorrect month or day of onset
        IF (MODYCK(JONSET).GT.0) THEN
          IERR = 34
          GO TO 300
        END IF
C  Set error code if year of onset too early
      IF (JONSET(3).LT.1940) THEN
      IERR = 36
      GO TO 300
      END IF
C  Set error code if year of onset too late
      IF (JONSET(3).GT.1936+IX) THEN
      IERR = 37
      GO TO 300
      END IF
      END IF
C  Read trigger for benefit increase assumption
      READ (IN,*,ERR=299) IALTBI
C  Set error code if impossible benefit increase code
      IF (IALTBI.LT.1.OR.IALTBI.GT.MAXASM) THEN
      IERR = 19
      GO TO 300
      END IF
C  Project benefit increases
      IF (IALTBI.EQ.MAXASM) THEN
        IERR = BENRDF(IN,ISTRT1)
        IF (IERR.GT.0) GO TO 300
      ELSE
        ANSCCH = 'N'
      END IF
C  Read trigger for type of average wage assumptions
      READ (IN,*,ERR=299) IALTAW
C  Set error code if impossible average wage code
      IF (IALTAW.LT.1.OR.IALTAW.GT.MAXASM) THEN
      IERR = 20
      GO TO 300
      END IF
C  Check for valid PEBES assumption
      IF (JOASDI.EQ.4) THEN
        IERR = PBSACK()
        IF (IERR.GT.0) GO TO 300
      END IF
C  Project average wage increases
      IF (IALTAW.EQ.MAXASM) THEN
        IERR = AVGRDF(IN,ISTRT1)
        IF (IERR.GT.0) GO TO 300
      END IF
C  Read trigger for ad hoc wage base change
      READ (IN,*,ERR=299) IBASCH
C  Set error code for impossible wage base code
      IF (IBASCH.LT.1.OR.IBASCH.GT.2) THEN
      IERR = 21
      GO TO 300
      END IF
      IF (JOASDI.EQ.4) IBASCH = 1
C  Read projected wage bases
      IF (IBASCH.EQ.2) THEN
        IERR = WAGBSF(IN)
        IF (IERR.GT.0) GO TO 300
      END IF
      CALL ZERERN
      IF (MQGE) THEN
        IERR = ERNFHI(IN)
        IF (IERR.GT.0) GO TO 300
      END IF
C  Read earnings, if necessary
      IERR = EARNF(IN)
      IF (IERR.GT.0) GO TO 300
      IF (JOASDI.EQ.4) CALL STPBDT
      DO 280 I=IEND2-1935,IEND1-1936
  280 ERNPBS(I) = ERNPBS(IEND2-1936)
C  Read tax type
      IERR = TAXF(IN)
      IF (IERR.GT.0) GO TO 300
C  Read amount of noncovered public pension
      READ (IN,*,ERR=299) PUBPEN
C  Set error code if negative public pension
      IF (PUBPEN.LT.0.OR.PUBPEN.GT.9999999.) THEN
      IERR = 22
      GO TO 300
      END IF
      READ (IN,2,ERR=299) NAME
      DO 290 I=1,3
  290 READ (IN,2,ERR=299) NHADDR(I)
      READ (IN,3,ERR=299) NHSSN
      CLOSE(IN)
      RETURN
C  Error section
  299 IERR = 69
  300 READFL = IERR
      CLOSE(IN)
      RETURN
      END
C
C  Subroutine to read HI earnings from file
C
      INTEGER FUNCTION ERNFHI(IN)
      INCLUDE 'wrkrdataf.h'
      INTEGER I,IN
      ERNFHI = 0
      DO 10 I=IBEGIN-1936,IEND-1936
      READ (IN,*,ERR=900) EARNHI(I)
      IF (EARNHI(I).GT.999999.99.OR.EARNHI(I).LT.-1) ERNFHI = 38
   10 CONTINUE
      RETURN
  900 ERNFHI = 69
      RETURN
      END
C
C  Subroutine to read tax type
C
C  IN     = number of input file.
C
      INTEGER FUNCTION TAXF(IN)
      INTEGER IN,I
      INCLUDE 'wrkrdataf.h'
      TAXF = 0
      DO 285 I=IBEGIN-1936,IEND-1936
      READ (IN,*,ERR=900) TAXTYP(I)
      IF (TAXTYP(I).LT.0.OR.TAXTYP(I).GT.1) THEN
        TAXF = 38
        RETURN
      END IF
  285 CONTINUE
      RETURN
  900 TAXF = 69
      RETURN
      END
C
C  Subroutine to read month, day, and year of disability onset
C
C  IN     = number of input file.
C
      INTEGER FUNCTION IONSTF(IN)
      INTEGER IN,IERR
      INCLUDE 'wrkrdataf.h'
C  Function declarations
      INTEGER MODYCK,DISCHK
      READ (IN,*,ERR=900) IONSET(1),IONSET(2),IONSET(3)
      IF (VALDI.GT.0) THEN
C  Set error code if incorrect month or day of onset
        IF (MODYCK(IONSET).GT.0) THEN
          IONSTF = 14
          RETURN
        END IF
C  Set error code if year of onset too early
        IERR = DISCHK()
        IF (IERR.GT.0) THEN
          IONSTF = IERR
          RETURN
        END IF
      END IF
      IONSTF = 0
      RETURN
  900 IONSTF = 69
      RETURN
      END
C
C  Subroutine to read month, day and year of birth of worker
C
C  IN     = number of input file.
C
      INTEGER FUNCTION IBIRTF(IN)
      INTEGER IN
      INCLUDE 'wrkrdataf.h'
C  Function declarations
      INTEGER MODYCK
      READ (IN,*,ERR=900) IBIRTH(1)
      READ (IN,*,ERR=900) IBIRTH(2)
      READ (IN,*,ERR=900) IBIRTH(3)
C  Set error code if incorrect month or day of birth
      IF (MODYCK(IBIRTH).GT.0) THEN
        IBIRTF = 4
        RETURN
      END IF
C  Set error code if incorrect year of birth
      IF (JOASDI.EQ.4) THEN
        IF (IBIRTH(3).GT.ISTART+1949) THEN
          IBIRTF = 35
          RETURN
        END IF
      ELSE
        IF (IBIRTH(3).GT.1936+IX) THEN
          IBIRTF = 55
          RETURN
        END IF
      END IF
      IBIRTF = 0
      RETURN
  900 IBIRTF = 69
      RETURN
      END
C
C  Subroutine to read indicators for type of earnings
C
C  IN     = number of input file.
C
      INTEGER FUNCTION ERNTPF(IN)
      INTEGER I,IN
      INCLUDE 'wrkrdataf.h'
      DO 100 I=IBEGN1-1936,IEND1-1936
        READ (IN,*,ERR=900) EARNTP(I)
C  Set error code if incorrect type of earnings
        IF (JOASDI.LT.4) THEN
          IF (EARNTP(I).LT.0.OR.EARNTP(I).GT.4) THEN
            ERNTPF = 7
            RETURN
          END IF
        ELSE
          EARNTP(I) = 0
        END IF
  100 CONTINUE
      ERNTPF = 0
      RETURN
  900 ERNTPF = 69
      RETURN
      END
C
C  This subroutine reads in benefit increases beginning with December
C  of 1951+ISTRT1.
C
C  I      = temporary index used in DO-loops.
C  I1     = temporary index used in DO-loops.
C  IN     = number of input file.
C
      INTEGER FUNCTION BENRDF (IN,ISTRT1)
      INTEGER ISTRT1,I,IN,I1
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'commona.h'
    4 FORMAT (A1)
    8 FORMAT (A65)
      BENRDF = 0
C  Read benefit increases
      DO 110 I=ISTRT1+1,BENDAT(2)-1950
  110 READ (IN,*) CPIINC(I)
C  Read answer to catch-up benefit increase prompt.
      READ (IN,4) ANSCCH
      CALL TOUPPR(ANSCCH)
      IF (ANSCCH.NE.'Y'.AND.ANSCCH.NE.'N') THEN
        BENRDF = 31
        RETURN
      END IF
C  Read catch-up benefit increases for 10 years of eligibility
      IF (ANSCCH.EQ.'Y') THEN
      DO 120 I=1,10
      DO 120 I1=1,8
  120 READ (IN,*) CACHUP(I,I1)
      ELSE
        CALL ZEROCH
      END IF
C  Get title of assumptions
      READ (IN,8) TITLBI
      RETURN
      END
C
C  This subroutine reads in average wage increases.
C
C  I      = temporary index used in DO-loops.
C  IN     = number of input file.
C
      INTEGER FUNCTION AVGRDF(IN,ISTRT1)
      INTEGER IN,ISTRT1,I
      INCLUDE 'wrkrdataf.h'
    7 FORMAT (A65)
      AVGRDF = 0
      DO 110 I=ISTRT1+14,BENDAT(2)-1936
  110 READ (IN,*) FQINC(I)
C  Get title of assumptions
      READ (IN,7) TITLAW
      RETURN
      END
C
C  Function to read wage bases from file
C
      INTEGER FUNCTION WAGBSF(IN)
      INTEGER I,IN
      INCLUDE 'wrkrdataf.h'
      WAGBSF = 0
      DO 10 I=ISTART+16,IENT(2)-1936
      READ (IN,*,ERR=900) BASE(I)
      IF (BASE(I).LT..0.OR.BASE(I).GT.9999999.) THEN
        WAGBSF = 39
        RETURN
      END IF
   10 CONTINUE
      DO 20 I=ISTART+16,IENT(2)-1936
      READ (IN,*,ERR=900) BASE77(I)
      IF (BASE77(I).LT..0.OR.BASE77(I).GT.9999999.) THEN
        WAGBSF = 39
        RETURN
      END IF
   20 CONTINUE
      RETURN
  900 WAGBSF = 69
      RETURN
      END
C
C  Function to read date of prior entitlement to disability
C
      INTEGER FUNCTION PRIORF(IN)
      INTEGER IN
      INCLUDE 'wrkrdataf.h'
      PRIORF = 0
      READ (IN,*,ERR=900) PRRENT(1)
      READ (IN,*,ERR=900) PRRENT(2)
      IF (VALDI.EQ.1.AND.JOASDI.EQ.1) THEN
        IF (PRRENT(1).LT.1.OR.PRRENT(2).GT.12) THEN
          PRIORF = 42
          RETURN
        END IF
        IF (PRRENT(2).LT.IONSET(3)) THEN
          PRIORF = 43
          RETURN
        END IF
        IF (PRRENT(2).GT.IENT(2)) THEN
          PRIORF = 44
          RETURN
        END IF
      ELSE
        PRRENT(1) = 0
        PRRENT(2) = 0
      END IF
      RETURN
  900 PRIORF = 69
      RETURN
      END
C
C  Function to read first month of waiting period
C
      INTEGER FUNCTION WAITPF(IN)
      INTEGER IN
      INCLUDE 'wrkrdataf.h'
      WAITPF = 0
      READ (IN,*,ERR=900) WAITPD(1)
      READ (IN,*,ERR=900) WAITPD(2)
      IF (JOASDI.EQ.2) THEN
        IF (WAITPD(1).LT.1.OR.WAITPD(2).GT.12) THEN
          WAITPF = 45
          RETURN
        END IF
        IF (WAITPD(2).LT.IONSET(3)) THEN
          WAITPF = 46
          RETURN
        END IF
        IF (WAITPD(2).GT.IENT(2)) THEN
          WAITPF = 47
          RETURN
        END IF
      ELSE
        WAITPD(1) = 0
        WAITPD(2) = 0
      END IF
      RETURN
  900 WAITPF = 69
      RETURN
      END
C
C  This subroutine saves data to disk.
C
      INTEGER FUNCTION SAVDIS(IOUT)
      INTEGER IOUT, I, J
      INCLUDE 'wrkrdataf.h'
      INTEGER LSTQCY
      LOGICAL QCBYYR
C
C  FORMAT statements
C
   14 FORMAT (T2,I4)
   16 FORMAT (T2,6F6.2)
   17 FORMAT (A35)
   18 FORMAT (T2,8F7.1)
   19 FORMAT (T2,A65)
   20 FORMAT (A1)
   21 FORMAT (T2,6F8.4)
   22 FORMAT (T2,6I8)
   23 FORMAT (T2,6F10.2)
   25 FORMAT (A12)
      SAVDIS = 0
      WRITE (IOUT,14) ISTART+1951
      WRITE (IOUT,14) ISEX
      WRITE (IOUT,14) JOASDI
      IF (RECALC) THEN
        I = 1
      ELSE
        I = 0
      END IF
      WRITE (IOUT,14) I
      IF (TOTALI) THEN
        I = 1
      ELSE
        I = 0
      END IF
      WRITE (IOUT,14) I
      IF (MQGE) THEN
        I = 1
      ELSE
        I = 0
      END IF
      WRITE (IOUT,14) I
      WRITE (IOUT,14) IBIRTH(1)
      WRITE (IOUT,14) IBIRTH(2)
      WRITE (IOUT,14) IBIRTH(3)
      WRITE (IOUT,14) MONTHN
      WRITE (IOUT,14) IENT
      WRITE (IOUT,14) BENDAT
      WRITE (IOUT,14) IAGPLN
      WRITE (IOUT,14) PRBACK
      WRITE (IOUT,16) PERCBK
      WRITE (IOUT,14) IBEGIN
      WRITE (IOUT,14) IBEGN1
      WRITE (IOUT,14) PRFWRD
      WRITE (IOUT,16) PERCFD
      WRITE (IOUT,14) IEND1
      WRITE (IOUT,14) IEND
      DO 100 I=IBEGN1-1936,IEND1-1936
  100 WRITE (IOUT,14) EARNTP(I)
      WRITE (IOUT,14) QCTD
      WRITE (IOUT,14) QC51TD
      IF (QCBYYR()) THEN
        DO 110 I=IBEGIN,LSTQCY()
  110   WRITE (IOUT,14) IQC(I-1936)
      END IF
      WRITE (IOUT,14) IDEATH(1)
      WRITE (IOUT,14) IDEATH(2)
      WRITE (IOUT,14) JSURV
      WRITE (IOUT,14) VALDI
      WRITE (IOUT,14) IONSET
      WRITE (IOUT,14) PRRENT
      WRITE (IOUT,14) WAITPD
      WRITE (IOUT,14) JBIRTH(1)
      WRITE (IOUT,14) JBIRTH(2)
      WRITE (IOUT,14) JBIRTH(3)
      WRITE (IOUT,14) JONSET(1)
      WRITE (IOUT,14) JONSET(2)
      WRITE (IOUT,14) JONSET(3)
      WRITE (IOUT,14) IALTBI
C  Save user-specified benefit increase assumptions
      IF (IALTBI.EQ.MAXASM) THEN
      DO 130 I=ISTART+1,BENDAT(2)-1950
  130 WRITE (IOUT,16) CPIINC(I)
      WRITE (IOUT,20) ANSCCH
C  Save user-specified catch-up benefit increases
      IF (ANSCCH.EQ.'Y'.OR.ANSCCH.EQ.'y') THEN
      DO 135 I=1,10
  135 WRITE (IOUT,18) (CACHUP(I,J),J=1,8)
      END IF
      WRITE (IOUT,19) TITLBI
      END IF
      WRITE (IOUT,14) IALTAW
C  Save user-specified average wage assumptions
      IF (IALTAW.EQ.MAXASM) THEN
      DO 160 I=ISTART+14,BENDAT(2)-1936
  160 WRITE (IOUT,21) FQINC(I)
      WRITE (IOUT,19) TITLAW
      END IF
      WRITE (IOUT,14) IBASCH
      IF (IBASCH.EQ.2) THEN
        DO 175 I=ISTART+16,BENDAT(2)-1936
  175   WRITE (IOUT,22) BASE(I)
        DO 180 I=ISTART+16,BENDAT(2)-1936
  180   WRITE (IOUT,22) BASE77(I)
      END IF
C  Save user-specified earnings
      DO 190 I=IBEGN1-1936,IEND1-1936
  190 IF (EARNTP(I).EQ.0) WRITE (IOUT,23) ERNPBS(I)
      IF (MQGE) THEN
        DO 195 I=IBEGIN-1936,IEND-1936
  195   WRITE (IOUT,23) EARNHI(I)
      END IF
      DO 200 I=IBEGIN,IEND
  200 WRITE (IOUT,14) TAXTYP(I-1936)
      WRITE (IOUT,23) PUBPEN
      WRITE (IOUT,17) NAME
      DO 210 I=1,3
  210 WRITE (IOUT,17) NHADDR(I)
      WRITE (IOUT,25) NHSSN
      CLOSE (IOUT)
      RETURN
      END
