C  %W%   %G%
C
C  This module contains declarations for variables dealing with changes
C  in law.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C  Definition of variables ('*' before variable name denotes dimensioned
C  variable array):
C
C  ASPMIN = alternative special minimum dollar amount (as of 1979).
C *BPINC  = bend point increase percentages for PIA formula in year
C             1950+J (used if JIND(6) is set).
C  BSPMIN = alternative percent of old-law wage base required for
C             special minimum year of coverage.
C  CP     = constant percent subtracted from wage increase for bend
C             point projection (used IF JIND(7) is set), or constant
C             percent decline in benefit formula percents (used if
C             JIND(9) is set).
C *CPI29  = benefit increases used for retroactive wage indexing.
C           I=1 is 1951, 2 is 1952, ..., 28 is 1978.
C  ERN30  = earnings required for year of earnings in Myers COLA-
C             cutback proposal.
C  FACM   = blending factor used in Roybal-style notch proposal.
C *FACM19 = special weighting factor for ad-hoc blend weights
C *FACM26 = special weighting factor for ad-hoc blend weights
C *FACT   = indexing factor when mixture of wage and CPI
C *IBENPA = bend points in alternative PIA formula.
C           I = 1 is 0, 2 is first real bend point, 3 is second real
C             bend point, 4 is third real bend point (if any).
C           J = 1 is 1937 year of eligibility, ..., IX is 1936+IX.
C  IELGY1 = year prior to year of eligibility minus 1950 (minimum of 0),
C             using age 62 through JSTART(1,8)-1, age 63 in JSTART(1,8),
C             age 64 in JSTART(1,8)+1, and age 65 in JSTART(1,8)+2 and
C             later (see JIND(8)).
C  IERN30 = number of years of earnings after 1978 with earnings greater
C             than ERN30 (for Myers COLA-cutback proposal).
C *JIND   = indicators for changes from present law.
C             (1) = 0 is for present law, including 1977 Amendments
C                 = 1 is for pre-1977 law benefits
C             (2) = 0 is for bend points increasing at wage rate
C                 = 1 is for bend points increasing at fraction of
C                     wage rate
C             (3) = 0 is for bend points increasing at wage rate
C                 = 1 is for bend points increasing at CPI rate
C             (4) = 0 for earnings indexed to wage rate
C                 = 1 for earnings indexed to CPI rate
C             (5) = 0 for not using new benefit formula
C                 = 1 for using new benefit formulas (percents and bend
C                     points), varying by year of eligibility
C             (6) = 0 for bend points increasing at wage rate
C                 = 1 for bend points increasing at specified rates
C             (7) = 0 for bend points increasing at wage rate
C                 = 1 for bend points increasing at wage rate minus
C                   a constant percent
C             (8) = 0 for present law computation period
C                 = 1 for age-65 computation period, phased in over
C                     3 years (ages 63, 64, 65)
C             (9) = 0 for constant benefit formula percents
C                 = 1 for declining benefit formula percents
C             (10) = 0 for normal benefit increases
C                  = 1 for no benefit increase in year of eligibility
C             (11) = 0 for using re-indexed widow guarantee
C                  = 1 for not using re-indexed widow guarantee
C             (12) = 0 for using windfall elimination provision
C                  = 1 for not using windfall elimination provision
C                  = 2 for using modified windfall elimination provision
C             (13) = 0 for present law special minimum provision.
C                  = 1 for new 1979 dollar amount
C                  = 2 for new maximum years of coverage
C                  = 3 for dollar amount and years
C                  = 4 for new year of coverage percent
C                  = 5 for yoc percent and dollar amount
C                  = 6 for yoc percent and years
C                  = 7 for yoc percent, dollar amount, and years
C             (14) = 0 for present-law old start method
C                  = 1 for no old start method
C             (15) = 0 for present-law (variable) DI dropout years
C                  = 1 for 5-year DI dropout
C             (16) = 0 for present-law transitional guarantee
C                  = 1 for using earnings after age 62 (5-yr guarantee)
C                  = 2 for using earnings after age 62 (10-yr guarantee)
C             (17) = 0 for present-law transitional guarantee
C                  = 1 for average of old-law and aime (5-yr guarantee)
C                  = 2 for average of old-law and aime (10-yr guarantee)
C             (18) = 0 for present-law transitional guarantee
C                  = 1 for average of type-16 transitional guarantee and
C                      aime (5-yr guarantee)
C                  = 2 for average of type-16 transitional guarantee and
C                      aime (10-yr guarantee)
C             (19) = 0 for present-law transitional guarantee
C                  = 1 for average of old-law (with limit of 3 recent
C                      years) and aime, using special weighting (Daub)
C             (20) = 0 for present-law transitional guarantee
C                  = 1 for old-law (with limit of 3 recent years), no
C                      limit to guarantee period (HR1917 from 99th Congress)
C             (21) = 0 for present law transitional guarantee
C                  = 1 for guarantee of old-law less 3% less 3% per year
C                      (5-yr guarantee)
C                  = 2 for guarantee of old-law less 3% less 3% per year
C                      (10-yr guarantee) (HR1917 from 100th Congress)
C             (22) = 0 for present-law transitional guarantee
C                  = 1 for guarantee of old-law less 3% per year of
C                      eligibliity after 1978 less 3% per year of age to 65
C                      The proposal provides for an actual reduction of 1.25%
C                      per month, which is approximated in the program by 3%
C                      for each year between eligibility and entitlement
C             (23) = 0 for present-law PIA table method
C                  = 1 for no PIA table method
C             (24) = 0 for present-law transitional guarantee
C                  = 1 for no transitional guarantee
C             (25) = 0 for present-law transitional guarantee
C                  = 1 for third Robyal proposal with 5-yr guarantee
C                  = 2 for third Roybal proposal with 10-yr guarantee
C             (26) = 0 for present-law transitional guarantee
C                  = 1 for second Sanford proposal
C                  = 2 for fourth Roybal proposal
C             (27) = 0 for present-law computation
C                  = 1 for no age-67 retirement age
C             (28) = 0 for present-law computation
C                  = 1 for 1 child care drop-in year annual AIME <= max
C                  = 2 for 5 drop-in years limited to max indx wages
C                  = 3 for 1 year limited to average wage series
C                  = 4 for 5 years limited to average wage series
C                  = 5 for 1 year limited to ages 25-50 av wg series
C                  = 6 for 5 years limited to ages 25-50 av wg series
C                  = 7 for 1 year limited to ages 25-50 max ix wages
C                  = 8 for 5 years limited to ages 25-50 max ix wages
C             (29) = 0 for present-law computation
C                  = 1 for retroactive wage indexing
C             (30) = 0 for present-law computation
C                  = 1 for Myers cpi-holdback (5 years earnings)
C  JINDT  = total of JIND.
C  JSPMIN = alternative maximum number of years of coverage
C           considered in special minimum calculation (30 in PL).
C *JSTART = first and last years of proposal to change law, corres-
C             ponding to JIND.
C           2: first and last years of fraction-wage-rate bend points.
C           3: first and last years of CPI-indexed bend points.
C           4: first and last years of CPI-indexed earnings.
C           5: first and last years of alternative benefit formulas.
C           6: first and last years of bend points increasing at
C              specified rates.
C           7: first and last years of wage-rate-minus-constant bend
C              points.
C           8: year that age-62 attainments have age-63 computation
C              point (age-65 computation point 2 years later).
C           9: first and last years of decline in benefit formula per-
C              cents.
C           10: first year of no benefit increase in year of eligibility.
C           12: first year of changed windfall elimination provision.
C           13: first year of new special minimum calculation.
C           14: first year of no old start method.
C           15: first year of entitlements for no DI variable dropout
C               years (for eligibility 2 years prior, or later).
C           29: first year of retroactive wage indexing.
C           30: first year of Myers cpi-holdback (5 years earnings).
C  MAXJND = maximum number of changes from present law.
C  NUMBP  = number of alternative bend points.
C  PBP    = percentage of wage increase applied to bend points.
C *PERCPA = alternative PIA formula percentages.
C           I = 1 first percentage, 2 is second percentage, 3 is
C             third percentage, 4 is fourth percentage (if any).
C           J = 1 is 1937 year of eligibility, ..., IX is 1936+IX.
C  PIA30  = minimum PIA required for Myers COLA-cutback proposal to
C             be applied.
C *TIND   = labels for changes in law.
C *TINDCD = labels for childcare dropin proposals.
C *TINDSM = labels for changes in special minimum.
C *TINDTG = labels for changes in transitional guarantee.
C *TINDWE = labels for changes in windfall elimination provision.
C *TIND26 = labels for specific PIA table blend transition proposals.
C  Z4     = Reduction factor (in multiples of 1%) for new Roybal and
C             Sanford proposals (JIND(21), JIND(22), or JIND(25) GT 0.)
C
      INTEGER MAXJND
      PARAMETER (MAXJND=30)
      CHARACTER*65 TIND(MAXJND), TINDCD(8), TINDSM(7), TINDTG(2),
     &TINDWE(2), TIND26(2)
C  Dimension variables for changes from present law
      INTEGER JIND(MAXJND), JSTART(2,MAXJND), IBENPA(4,IX), IELGY1,
     &JINDT, JSPMIN, NUMBP, IERN30
      REAL PERCPA(4,IX), ASPMIN, BSPMIN, CP, FACM, PBP, FACM19(5),
     &BPINC(IYR), FACT(IX), FACM26(2,10), CPI29(28), Z4, ERN30, PIA30
      COMMON / LWCHGA / TIND,TINDCD,TINDSM,TINDTG,TINDWE,TIND26
      COMMON / LWCHGB / ASPMIN,BSPMIN,CP,FACM,FACM19,FACM26,IBENPA,
     &IELGY1,JIND,JINDT,JSPMIN,JSTART,NUMBP,PBP,PERCPA,CPI29,Z4,ERN30,
     &PIA30,IERN30,BPINC,FACT
