C  @(#)piaclc.f	1.19   2/24/97
C
C  Various subroutines to handle changes from present law.
C
C  Subroutine to re-order earnings for child care dropin years
C
C *DAGE   = age at which drop-in years begin
C *DDIF   = increase in earnings for year with current dropin year
C *DEARN  = amount of earnings for a year as a drop-in year
C *DUSE   = indicator that a year was selected for drop-in
C  HDIFF  = index for year with highest drop-in increase
C  I40    = temporary index.
C  I41    = temporary index.
C  I42    = temporary index.
C  I44    = first year of earnings in period to be considered.
C  I45    = last year of earnings in period to be considered.
C  I47    = number of high years to be selected.
C  I50    = year of first eligibility (IELGYR(2)) for earnings limits.
C  I51    = temporary index
C  I52    = temporary index.
C  I53    = actual year retrieved from NORDER
C  I54    = first potential dropin year (YOB+DAGE(proposal)).
C  I55    = last potential dropin year (age 50).
C  I56    = temporary index.
C *IORDER = 1 for year I if earnings in year I are among highest N;
C             I=1 to 5 is method number, J is year-1936 for I=1,
C             otherwise year-1950.
C  ITEMP  = temporary storage for NORDER.
C  IX     = last year of period minus 1936.
C  JDROP  = number of potential drop-in years fro proposal.
C  JVAL   = value of JIND(28) 1-4 are age 18 start, 5-8 are age 25,
C              3-6 are limited to average earnings in indexing year,
C              odds use 1 drop-in year, evens use 5.
C  LOLOSS = year of smallest wages included in comp.
C *NORDER = array of numbers of the years included in the highest N.
C  TEARN  = sum of high N years of earnings (double precision).
C  TEMP   = temporary storage for XEARN.
C *WEARN  = earnings to be ordered.
C  WGAV   = annualized AIME, the normal drop-in amount
C  WGCAP  = drop-in limit, worker's indexing amount, or, alternatively,
C             maximum indexed wages for year considered
C
      SUBROUTINE DROPIN(I44,I45,I47,I50,NORDER,TEARN,JVAL,WEARN)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'piaparmsf.h'
      REAL DDIFF(IX)
      DOUBLE PRECISION TEMP, TEARN, WEARN(IX), DEARN(IX), WGAV, WGCAP
      INTEGER HDIFF, DUSE(IX), DAGE(8), NORDER(IX), I40,
     &I41, I42, I44, I45, I47, I50, I51, I52, I53, I54, I55, I56, JVAL,
     &JDROP, LOLOSS, ITEMP
      INCLUDE 'lawchgf.h'
      DATA DAGE/4*18,4*25/
C  Initialize arrays
      DO 10 I40=1,IX
      DEARN(I40) = WEARN(I40)
      DDIFF(I40) =0.
   10 DUSE(I40) = 0
      IF(I45.EQ.I44)RETURN
      I54 = IBIRTH(3) + DAGE(JVAL) - 1950
      I55 = IBIRTH(3) - 1900
      JDROP = 5 - 4 * (JVAL - 2 * INT(JVAL/2))
C  Start loop to calculate special values
      I51 = I44 - 1
  100 I51 = I51 + 1
      WGAV = 12. * IAME(IAPPN)
      IF (WEARN(I51).GT.WGAV) GO TO 200
      I53 = NORDER(I51)
      WGCAP = BASE(I53+14)*FQ(I50+13)/FQ(I53+14)
      IF (JVAL.GT.2.AND.JVAL.LT.7.AND.FQ(I50+13).LT.WGCAP)
     -WGCAP=FQ(I50+13)
      IF (WGAV.GT.WGCAP) WGAV = WGCAP
      IF (I53.GE.I54.AND.I53.LE.I55.AND.WGAV.GT.DEARN(I51))
     -DEARN(I51)=WGAV
      GO TO 100
C  Next set differentials, individually for each dropout year
  200 LOLOSS = I45-I47+1
      DO 210 I56 = 1,JDROP
      HDIFF = I51
      DDIFF(I51)=DEARN(I51)-WEARN(I51)
      DO 220 I52 = I51-1,I44,-1
      IF (DUSE(I52).GT.0) GO TO 220
      IF (I52.GT.LOLOSS) THEN
         DDIFF(I52) = DEARN(I52) - WEARN(I52)
      ELSE
         DDIFF(I52) = DEARN(I52) - WEARN(LOLOSS)
      END IF
      IF (DDIFF(I52).GT.DDIFF(HDIFF)) HDIFF = I52
  220 CONTINUE
      DUSE(HDIFF) = 1
      WEARN(HDIFF) = DEARN(HDIFF)
      IF (HDIFF.LT.LOLOSS) THEN
       IORDER(IAPPN,NORDER(LOLOSS)) = 0
       IORDER(IAPPN,NORDER(HDIFF)) = 1
       LOLOSS = LOLOSS + 1
      END IF
      IF (DUSE(LOLOSS).GT.0.) LOLOSS = LOLOSS+1
      IF (DUSE(LOLOSS).GT.0.) LOLOSS = LOLOSS+1
      IF (DUSE(LOLOSS).GT.0.) LOLOSS = LOLOSS+1
  210 IF (DUSE(LOLOSS).GT.0.) LOLOSS = LOLOSS+1
C  I40 is index of first number in comparison
      DO 230 I40=I44,I51-1
      I42=I40+1
C  I42 is index of second number in comparison
      DO 230 I41=I42,I45
C  If earnings are already ordered, skip to END of LOOP
      IF (WEARN(I40).LE.WEARN(I41)) GO TO 230
C  Switch earnings
      TEMP=WEARN(I40)
      WEARN(I40)=WEARN(I41)
      WEARN(I41)=TEMP
C  Switch indices of earnings
      ITEMP=NORDER(I40)
      NORDER(I40)=NORDER(I41)
      NORDER(I41)=ITEMP
  230 CONTINUE
C  I42 is index of least earnings used in summation
   25 I42=I45-I47+1
      TEARN=0.
C  Add up highest earnings and set indicator for earnings being used
      DO 30 I40=I42,I45
      ITEMP=NORDER(I40)
      IORDER(IAPPN,ITEMP)=1
   30 TEARN=TEARN+WEARN(I40)
C  Set floating-point value
      FTEARN(IAPPN)=TEARN
C  Divide by number of computation months and round down to integer
      IAME(IAPPN) = TEARN/(FLOAT(I47)*12.)
      RETURN
      END
C
C  Function to set number of reduction increments for new Roybal and
C  Sanford
C
      REAL FUNCTION Z4SET()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
      Z4SET = 0.
      IF (JIND(21).GT.0) Z4SET = 3.*(IELGYR(2) - 26)
      IF (JIND(22).GT.1.AND.IOASDI.NE.3.AND.KBIRTH(3).GT.1916.AND.
     &KBIRTH(3).LT.1930) Z4SET = 5. + 2.*(IELGYR(1)-27) +
     &AMIN1(FLOAT(IENT(2)-1951-IELGYR(1)),3.)
      IF (JIND(25).GT.0) Z4SET = 3.25*(IELGYR(2) - 26)
      IF (Z4SET.LE.0.) Z4SET = 0.
      RETURN
      END
C
C  Function to set 3-year limitation starting year for old starts
C
      INTEGER FUNCTION I49C1()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
C  Set 3-year limitation year
      I49C1 = IERNYR + 14
C  Use 1979 for HR 1917 from 99th Congress
      IF (JIND(20).GT.0.AND.METHOS.EQ.7) I49C1 = 42
C  Use age 62 to start 3-year limitation for Daub
      IF (JIND(19).GT.0.AND.METHOS.EQ.6.AND.IELGYR(1).GT.27)
     &I49C1 = IELGYR(1) + 14
      RETURN
      END
C
C  Function to 3-year limitation year for new starts
C
      INTEGER FUNCTION I49C2()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
      I49C2 = IERNYR
      IF (JIND(19).GT.0) I49C2 = IELGYR(1)
      IF (JIND(20).GT.0) I49C2 = 28
      RETURN
      END
C
C  Subroutine to project bend points for changes in law
C
      SUBROUTINE BPCAL(MELGYR,MBENDP)
      INTEGER MELGYR,I,I2,I3,I4,MBENDP(4)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piaparmsf.h'
      INCLUDE 'lawchgf.h'
C  Reproject bend points if JIND(2) is set
      IF (JIND(2).GT.0) THEN
C  If before starting point, skip to next part
        IF (1950+MELGYR+1.GE.JSTART(1,2)) THEN
C  Accumulate fractional wage increases to I2
          I2=MELGYR-1
          IF (1950+I2+2.GT.JSTART(2,2)) I2 = JSTART(2,2)-1950-2
C  I3 is starting year of fractional wage increases
          I3 = JSTART(1,2)-1950-2
          CALL BENDPC(I3,MBENDP)
          DO 821 I=I3,I2
          MBENDP(2) = NINT(FLOAT(MBENDP(2))*(1.+PBP*FQINC(I+14)/100.))
  821     MBENDP(3) = NINT(FLOAT(MBENDP(3))*(1.+PBP*FQINC(I+14)/100.))
C  If beyond ending year, continue projecting at wage rate
          IF (1950+MELGYR+1.GT.JSTART(2,2)) THEN
            MBENDP(2) = NINT(FLOAT(MBENDP(2))*FQ(MELGYR+13)/FQ(I2+14))
            MBENDP(3) = NINT(FLOAT(MBENDP(3))*FQ(MELGYR+13)/FQ(I2+14))
          END IF
        END IF
      END IF
C  Reproject bend points if JIND(3) is set
      IF (JIND(3).GT.0) THEN
C  If before starting point, skip to next part
        IF (1950+MELGYR+1.GE.JSTART(1,3)) THEN
C  Accumulate CPI increases to I2
          I2=MELGYR-1
          IF (1950+I2+2.GT.JSTART(2,3)) I2 = JSTART(2,3)-1950-2
C  I3 is starting year of CPI-indexed bend points
          I3 = JSTART(1,3)-1950-2
          CALL BENDPC(I3,MBENDP)
          DO 823 I=I3,I2
          MBENDP(2) = NINT(FLOAT(MBENDP(2))*(1.+CPIINC(I)/100.))
  823     MBENDP(3) = NINT(FLOAT(MBENDP(3))*(1.+CPIINC(I)/100.))
C  If beyond ending year, continue projecting at wage rate
          IF (1950+MELGYR+1.GT.JSTART(2,3)) THEN
            MBENDP(2) = NINT(FLOAT(MBENDP(2))*FQ(MELGYR+13)/FQ(I2+14))
            MBENDP(3) = NINT(FLOAT(MBENDP(3))*FQ(MELGYR+13)/FQ(I2+14))
          END IF
        END IF
      END IF
C  Reproject bend points if JIND(5) is set
      IF (JIND(5).GT.0) THEN
C  If during specified period, use specified bend points
        IF (1950+MELGYR+1.GE.JSTART(1,5).AND.
     &  1950+MELGYR+1.LE.JSTART(2,5)) THEN
          I4 = 1950+MELGYR+1-1936
          MBENDP(2) = IBENPA(2,I4)
          MBENDP(3) = IBENPA(3,I4)
          MBENDP(4) = IBENPA(4,I4)
        END IF
C  If after last year, project off of alternate bend points
        IF (1950+MELGYR+1.GT.JSTART(2,5)) THEN
          I4 = JSTART(2,5)-1936
          MBENDP(2) = NINT(IBENPA(2,I4)*FQ(MELGYR+13)/FQ(I4-2))
          MBENDP(3) = NINT(IBENPA(3,I4)*FQ(MELGYR+13)/FQ(I4-2))
          MBENDP(4) = NINT(IBENPA(4,I4)*FQ(MELGYR+13)/FQ(I4-2))
        END IF
      END IF
C  Reproject bend points if JIND(6) is set
      IF (JIND(6).GT.0) THEN
C  If before starting point, skip to next part
        IF (1950+MELGYR+1.GE.JSTART(1,6)) THEN
C  Accumulate ad hoc bend point increases to I2
          I2=MELGYR-1
          IF (1950+I2+2.GT.JSTART(2,6)) I2 = JSTART(2,6)-1950-2
C  I3 is starting year of ad hoc bend point increases
          I3 = JSTART(1,6)-1950-2
          CALL BENDPC(I3,MBENDP)
          DO 826 I=I3,I2
          MBENDP(2) = NINT(FLOAT(MBENDP(2))*(1.+BPINC(I+2)/100.))
  826     MBENDP(3) = NINT(FLOAT(MBENDP(3))*(1.+BPINC(I+2)/100.))
C  If beyond ending year, continue projecting at wage rate
          IF (1950+MELGYR+1.GT.JSTART(2,6)) THEN
            MBENDP(2)=INT(FLOAT(MBENDP(2))*FQ(MELGYR+13)/
     &      FQ(I2+14)+.5)
            MBENDP(3)=INT(FLOAT(MBENDP(3))*FQ(MELGYR+13)/
     &      FQ(I2+14)+.5)
          END IF
        END IF
      END IF
C  Reproject bend points if JIND(7) is set
      IF (JIND(7).GT.0) THEN
C  If before starting point, skip to next part
        IF (1950+MELGYR+1.GE.JSTART(1,7)) THEN
C  Accumulate bend point increases less CP to I2
          I2=MELGYR-1
          IF (1950+I2+2.GT.JSTART(2,7)) I2 = JSTART(2,7)-1950-2
C  I3 is starting year of decrease in bend point increases
          I3 = JSTART(1,7)-1950-2
          CALL BENDPC(I3,MBENDP)
          DO 828 I=I3,I2
          MBENDP(2) = NINT(FLOAT(MBENDP(2))*(1.+(FQINC(I+14)-CP)/100.))
  828     MBENDP(3) = NINT(FLOAT(MBENDP(3))*(1.+(FQINC(I+14)-CP)/100.))
C  If beyond ending year, continue projecting at wage rate
          IF (1950+MELGYR+1.GT.JSTART(2,7)) THEN
            MBENDP(2) = NINT(FLOAT(MBENDP(2))*FQ(MELGYR+13)/FQ(I2+14))
            MBENDP(3) = NINT(FLOAT(MBENDP(3))*FQ(MELGYR+13)/FQ(I2+14))
          END IF
        END IF
      END IF
      RETURN
      END
C
C  Subroutine to reset transitional guarantee
C
C  ITRANS = length of transitional guarantee period
C
      SUBROUTINE TRGRLC(ITRANS)
      INTEGER ITRANS,I1,J1,J2
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piadataf.h'
    1 FORMAT ('   Working on law-change PIA')
C  Function declarations
      DOUBLE PRECISION ROUND
      IF (IPRMPT.EQ.1) WRITE (6,1)
      IAPP(8) = 1
C  Set rounding index: see if entitled in June or later
      I1=IENT(2)-1951
      IF (IENT(1).GE.6) I1=I1+1
      IF (JIND(17).GT.0) THEN
        FACM = FLOAT(28+ITRANS-IELGYR(2))/FLOAT(ITRANS+1)
        PIAEL(8) = PIA(2)
        MFBEL(8) = MFB(2)
        PIA(8) = PIA(3) + FACM*(PIA(2)-PIA(3))
        PIA(2) = 0.
        PIA(4) = 0.
        MFB(8) = MFB(3) + FACM*(MFB(2)-MFB(3))
        MFB(2) = 0.
        MFB(4) = 0.
      END IF
      IF (JIND(18).GT.0) THEN
        FACM = FLOAT(28+ITRANS-IELGYR(2))/FLOAT(ITRANS+1)
        PIAEL(8) = PIA(4)
        MFBEL(8) = MFB(4)
        PIA(8) = PIA(3) + FACM*(PIA(4)-PIA(3))
        MFB(8) = MFB(3) + FACM*(MFB(4)-MFB(3))
        PIA(4) = 0.
        MFB(4) = 0.
      END IF
      IF (PIA(4).GT.0.AND.JIND(19).GT.0) THEN
        FACM = FACM19(IELGYR(2)-27)
        PIAEL(8) = PIA(2)
        MFBEL(8) = MFB(2)
        PIA(2) = PIA(2) - DMAX1(0.D0,FACM*(PIA(2)-PIA(3)))
        MFB(2) = MFB(2) - DMAX1(0.D0,FACM*(MFB(2)-MFB(3)))
        PIA(8) = DMAX1(PIA(2),PIA(4))
        MFB(8) = DMAX1(MFB(2),MFB(4))
        PIA(2) = 0.D0
        MFB(2) = 0.D0
      END IF
      IF (JIND(26).GT.0) THEN
        J1 = MIN0(JIND(26),2)
        J2 = MIN0(IELGYR(1)-27,10)
        IF (J2.LT.1) J2 = 1
C
C  Age reduction is 5% per year for Roybal, 4% for Sanford
C
        FACM = FACM26(J1,J2) -
     &  0.01*(J1+3)*AMIN1(FLOAT(IENT(2)-1951-IELGYR(1)),3.) 
        IF (FACM.LT.0.) FACM = 0.
        IF (FACM.GT.1.) FACM = 1.
        PIAEL(8) = PIA(2)
        MFBEL(8) = MFB(2)
        PIA(8) = DMAX1(PIA(3),PIA(4),PIA(5),PIA(6),PIA(1))
        MFB(8) = DMAX1(MFB(3),MFB(4),MFB(5),MFB(6),MFB(7))
        PIA(8) = PIA(2) - DMAX1(0.D0,FACM*(PIA(2)-PIA(8)))
        MFB(8) = MFB(2) - DMAX1(0.D0,FACM*(MFB(2)-MFB(8)))
        PIA(2) = 0.D0
        MFB(2) = 0.D0
      END IF
      PIA(8) = ROUND(PIA(8),I1)
      MFB(8) = ROUND(MFB(8),I1)
      RETURN
      END
C
C  Subroutine to reset formula percents for changes in law
C
      SUBROUTINE PERCAL(MELGYR,MPERCP)
      INTEGER MELGYR,I,I3
      REAL MPERCP(4)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
C  Reset formula percents if JIND(5) is set and new formula is effective
      IF (JIND(5).GT.0) THEN
C  If during specified period, use specified percents
        IF (MELGYR.GE.JSTART(1,5)-1951.AND.
     &  MELGYR.LE.JSTART(2,5)-1951) THEN
          MPERCP(1) = PERCPA(1,MELGYR+15)
          MPERCP(2) = PERCPA(2,MELGYR+15)
          MPERCP(3) = PERCPA(3,MELGYR+15)
          MPERCP(4) = PERCPA(4,MELGYR+15)
        END IF
C  If after end of period, use last percentages
        IF (MELGYR.GT.JSTART(2,5)-1951) THEN
          MPERCP(1) = PERCPA(1,JSTART(2,5)-1936)
          MPERCP(2) = PERCPA(2,JSTART(2,5)-1936)
          MPERCP(3) = PERCPA(3,JSTART(2,5)-1936)
          MPERCP(4) = PERCPA(4,JSTART(2,5)-1936)
        END IF
      END IF
C  Reset formula percents if JIND(9) is set and new formula is effective
      IF (JIND(9).GT.0.AND.MELGYR.GE.JSTART(1,9)-1951) THEN
C  I3 is number of years of decrease
        I3 = MIN0(JSTART(2,9)-JSTART(1,9)+1,MELGYR-JSTART(1,9)+1952)
C  Apply decrease to the percents
        DO 832 I=1,3
  832   MPERCP(I) = MPERCP(I)*(1.-CP/100.)**I3
      END IF
      RETURN
      END
C
C  Subroutine to calculate indexing series when a mixture of wages and
C  CPI
C
      SUBROUTINE FACTC()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'lawchgf.h'
      INCLUDE 'piaparmsf.h'
      INTEGER I2,I
      I2 = JSTART(1,4)-1936-1-2
      DO 805 I=1,I2
  805 FACT(I) = FQ(I)
      I2 = I2+1
      DO 807 I=I2,IX
      FACT(I) = FACT(I-1)*(FQINC(I)/100.+1.)
  807 IF (JSTART(2,4)-1936.GE.I+2) FACT(I) = FACT(I-1)*
     &(CPIINC(I-14)/100.+1.)
      RETURN
      END
C
C  Subroutine to apply Roybal-Daub-Sanford restriction on post-1978
C  earnings
C
C  I42    = count of post-78 years for HR1917 limit of 3.
C
      SUBROUTINE ROYBAL(I44,I45,I49,NORDER,WEARN)
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'lawchgf.h'
      INTEGER NORDER(IX),I40,I41,I42,I44,I45,I49,ITEMP
      DOUBLE PRECISION WEARN(IX)
      I42 = 0
      DO 40 I40 = I45,I44,-1
  60  ITEMP = NORDER(I40)
C  Limit earnings to 29700 for Roybal
      IF (JIND(20)+JIND(22)+JIND(26).GT.0.AND.WEARN(I40).GT.29700.) THEN
        WEARN(I40) = 29700.
        VEARN(IAPPN,ITEMP) = 29700.
      END IF
      IF (NORDER(I40).GT.I49) THEN
        I42 = I42 + 1
        IF (I42.GT.3) THEN
          VEARN(IAPPN,ITEMP) = 0.
          IF (I40.NE.I44) THEN
            DO 50 I41 = I40-1,I44,-1
            NORDER(I41+1) = NORDER(I41)
            WEARN(I41+1) = WEARN(I41)
   50       CONTINUE
            NORDER(I44) = ITEMP
            WEARN(I44) = 0.
            IF (WEARN(I40).GT.0.) GO TO 60
          END IF
          NORDER(I44) = ITEMP
          WEARN(I44) = 0.
        END IF
      END IF
   40 CONTINUE
      END
C
C  Function to count number of years of significant earnings for Myers
C  COLA-holdback
C
      INTEGER FUNCTION IERSET()
      INCLUDE 'wrkrdataf.h'
      INCLUDE 'piadataf.h'
      INCLUDE 'lawchgf.h'
      INTEGER I,J
      IERSET = 0
      IF (JIND(30).EQ.0) RETURN
      J = 0
      DO 10 I=1979,IERNYR+1950
   10 IF (EARNST(I-1936,1).GE.ERN30) J = J+1
      IERSET = J
      RETURN
      END
