C  @(#)wrkrdata.f	1.9   2/24/97
C
C  Functions to check workerdata structure values
C
C  Subroutine to set day before birth
C
C *BIRTH1 = month, day, and year of birth.
C *BIRTH2 = month, day, and year before day of birth.
C
      SUBROUTINE SETBIR(BIRTH1,BIRTH2)
      INTEGER BIRTH1(3),BIRTH2(3)
      BIRTH2(1) = BIRTH1(1)
      BIRTH2(2) = BIRTH1(2)-1
      BIRTH2(3) = BIRTH1(3)
C  Take care of birth on first of month
      IF(BIRTH2(2).LT.1) THEN
        BIRTH2(2) = 30
        BIRTH2(1) = BIRTH2(1) -1
      END IF
C  Take care of birth on January 1
      IF(BIRTH2(1).LT.1) THEN
        BIRTH2(1) = 12
        BIRTH2(3) = BIRTH2(3) -1
      END IF
      RETURN
      END
C
C  Subroutine to set benefit date when it is initial entitlement
C
      SUBROUTINE STBNDT()
      INCLUDE 'wrkrdataf.h'
      BENDAT(1) = IENT(1)
      BENDAT(2) = IENT(2)
      END
C
C  Function to check for PEBES case too old in initial year
C
      INTEGER FUNCTION AGECHK(IENTNR)
      INCLUDE 'wrkrdataf.h'
      INTEGER IENTNR(2), DATE1(2)
      INTEGER COMPMY
      DATE1(1) = MONTHN
      DATE1(2) = ISTART
      IF (COMPMY(IENTNR,DATE1).LE.0) THEN
        AGECHK = 152
      ELSE
        AGECHK = 0
      END IF
      RETURN
      END
C
C  Subroutine to set the value of ioasdi
C
      INTEGER FUNCTION SOASDI()
      INCLUDE 'wrkrdataf.h'
      IF (JOASDI.EQ.4) THEN
        SOASDI = 1
      ELSE
        SOASDI = JOASDI
      END IF
      RETURN
      END
C
C  Function to check date of disability
C
      INTEGER FUNCTION DISCHK()
      INTEGER IONST2(2)
      INCLUDE 'wrkrdataf.h'
C  Function declarations
      INTEGER COMPMY
      DISCHK = 0
      IONST2(1) = IONSET(1)
      IONST2(2) = IONSET(3)
C  Write error message if onset after entitlement
      IF (COMPMY(IONST2,IENT).GT.0) DISCHK = 127
C  Write error message if onset after death
      IF (JOASDI.EQ.2.AND.COMPMY(IONST2,IDEATH).GT.0) DISCHK = 157
      RETURN
      END
C
C  Function to check for death after entitlement
C
      INTEGER FUNCTION DTHCHK()
      INCLUDE 'wrkrdataf.h'
      INTEGER IBIRT2(2)
C  Function declarations
      INTEGER COMPMY
      DTHCHK = 0
      IF (JOASDI.EQ.2) THEN
        IF (IDEATH(1).LT.1.OR.IDEATH(1).GT.12) DTHCHK = 10
C  Write error message if death after entitlement
        IF (COMPMY(IDEATH,IENT).GT.0) DTHCHK = 12
        IBIRT2(1) = IBIRTH(1)
        IBIRT2(2) = IBIRTH(3)
C  Write error message if death before birth
        IF (COMPMY(IDEATH,IBIRT2).LT.0) DTHCHK = 113
        IBIRT2(1) = 1
        IBIRT2(2) = 1940
C  Write error message if death before 1940
        IF (COMPMY(IDEATH,IBIRT2).LT.0) DTHCHK = 11
      END IF
      RETURN
      END
C
C  Function to check date of prior entitlement to disability
C
      INTEGER FUNCTION PRRCHK()
      INTEGER IONST2(2)
      INCLUDE 'wrkrdataf.h'
C  Function declarations
      INTEGER COMPMY
      PRRCHK = 0
      IONST2(1) = IONSET(1)
      IONST2(2) = IONSET(3)
C  Write error message if prior entitlement before onset
      IF (COMPMY(PRRENT,IONST2).LT.0) PRRCHK = 163
      RETURN
      END
C
C  Function to check first month of waiting period
C
      INTEGER FUNCTION WAITCK()
      INTEGER IONST2(2)
      INCLUDE 'wrkrdataf.h'
C  Function declarations
      INTEGER COMPMY
      WAITCK = 0
      IONST2(1) = IONSET(1)
      IONST2(2) = IONSET(3)
C  Write error message if waiting period before onset
      IF (COMPMY(WAITPD,IONST2).LT.0) WAITCK = 160
C  Write error message if waiting period after entitlement
      IF (COMPMY(WAITPD,IENT).GT.0) WAITCK = 161
      RETURN
      END
C
C  Function to check widow's date of disability onset
C
      INTEGER FUNCTION WIDCHK()
      INTEGER JONST2(2)
      INCLUDE 'wrkrdataf.h'
C  Function declarations
      INTEGER COMPMY,CMPMDY
      JONST2(1) = JONSET(1)
      JONST2(2) = JONSET(3)
      WIDCHK = 0
C  Write error message if onset before birth
      IF (CMPMDY(JONSET,JBIRTH).LT.0) WIDCHK = 158
C  Write error message if onset after entitlement
      IF (COMPMY(JONST2,IENT).GT.0) WIDCHK = 138
      RETURN
      END
C
C  Subroutine to zero out catchup benefit increases
C
      SUBROUTINE ZEROCH()
      INCLUDE 'wrkrdataf.h'
      INTEGER I,I1
      DO 10 I=1,10
      DO 10 I1=1,8
   10 CACHUP(I,I1) = 0.0
      END
C
C  Function to check first year of earnings
C
      INTEGER FUNCTION BEGCHK()
      INCLUDE 'wrkrdataf.h'
      BEGCHK = 0
      IF (PRBACK.EQ.0) IBEGN1 = IBEGIN
      IF (IBEGIN.LT.IBIRTH(3)) BEGCHK = 122
      IF (IBIRTH(3).GT.1936.AND.IBEGIN.LT.1951) BEGCHK = 122
      IF (IBEGN1.LT.IBEGIN) BEGCHK = 101
      RETURN
      END
C
C  Function to check last year there are earnings
C
      INTEGER FUNCTION ENDCHK()
      INCLUDE 'wrkrdataf.h'
      ENDCHK = 0
      IF (PRFWRD.EQ.0) IEND1 = IEND
      IF (IEND.LT.IBEGIN) ENDCHK = 9
      IF (IEND-IBEGIN.GE.MAXYRS) ENDCHK = 26
      IF (IEND1.GT.IEND) ENDCHK = 102
      RETURN
      END
C
C  Function to check for correct numbers of QC's
C
      INTEGER FUNCTION QCCHK()
      INCLUDE 'wrkrdataf.h'
      IF (QC51TD.GT.QCTD) THEN
        QCCHK = 40
      ELSE
        QCCHK = 0
      END IF
      RETURN
      END
C
C  Function to sum quarters of coverage by year
C
      INTEGER FUNCTION QCSUM(IYR1,IYR2)
      INTEGER IYR1,IYR2,I,I1
      INCLUDE 'wrkrdataf.h'
      I1 = 0
      DO 10 I=IYR1-1936,IYR2-1936
   10 I1 = I1 + IQC(I)
      QCSUM = I1
      RETURN
      END
C
C  Function to sum quarters of coverage by quarter
C
      INTEGER FUNCTION QCSUMQ(QTRYR1,QTRYR2)
      INTEGER QTRYR1(2),QTRYR2(2),I,I1
      INCLUDE 'wrkrdataf.h'
      I1 = 0
C  Handle case with two different years
      IF (QTRYR1(2).LT.QTRYR2(2)) THEN
C  Start with QCs in first year
        I1 = MIN0(IQC(QTRYR1(2) - 1936), 5 - QTRYR1(1))
C  Continue with full years
        DO 10 I = QTRYR1(2)-1935, QTRYR2(2)-1937
   10   I1 = I1 + IQC(I)
C  End with QCs in last year
        I1 = I1 + MIN0(IQC(QTRYR2(2) - 1936), QTRYR2(1))
      ELSE
        I1 = MIN0(QTRYR2(1) - QTRYR1(1) + 1, IQC(QTRYR1(2) - 1936))
      END IF
      QCSUMQ = I1
      RETURN
      END
C
C  Function to check that date of benefit is at or after entitlement
C
      INTEGER FUNCTION BNDTCK()
      INCLUDE 'wrkrdataf.h'
      INTEGER COMPMY
      BNDTCK = 0
      IF (COMPMY(BENDAT,IENT).LT.0) BNDTCK = 114
      RETURN
      END
C
C  Function to check for type of survivor in bounds
C
      INTEGER FUNCTION JSURCK()
      INCLUDE 'wrkrdataf.h'
      JSURCK = 0
      IF (JOASDI.EQ.2.AND.(JSURV.LT.1.OR.JSURV.GT.3)) JSURCK = 13
      RETURN
      END
C
C  Function to check for month in bounds
C
C  MONTH  = month to check
C
      INTEGER FUNCTION MOCHEK(MONTH)
      INCLUDE 'wrkrdataf.h'
      INTEGER MONTH
      MOCHEK = 0
      IF (MONTH.LT.1.OR.MONTH.GT.12) MOCHEK = 1
      RETURN
      END
C
C  Function to check that date of entitlement is within bounds
C
      INTEGER FUNCTION IENTCK()
      INCLUDE 'wrkrdataf.h'
      INTEGER MOCHEK
      IENTCK = 0
      IF (MOCHEK(IENT(1)).GT.0) IENTCK = 2
      IF (IENT(2).LT.1940.OR.IENT(2).GT.1936+IX) IENTCK = 3
      RETURN
      END
C
C  Function to return last year of annual QCs
C
      INTEGER FUNCTION LSTQCY()
      INCLUDE 'wrkrdataf.h'
      LSTQCY = MIN0(IEND,1977)
      RETURN
      END
C
C  Function to see if quarters of coverage by year are needed
C
      LOGICAL FUNCTION QCBYYR()
      INCLUDE 'wrkrdataf.h'
      IF (TOTALI.OR.JOASDI.EQ.4) THEN
        QCBYYR = .TRUE.
      ELSE
        QCBYYR = .FALSE.
      END IF
      RETURN
      END
C
C  Function to check for valid assumption for PEBES
C
      INTEGER FUNCTION PBSACK()
      INCLUDE 'wrkrdataf.h'
      IF (IALTBI.LT.5.OR.IALTBI.GT.6.OR.IALTAW.LT.5.OR.
     &IALTAW.GT.6) THEN
        PBSACK = 12
      ELSE
        PBSACK = 0
      END IF
      RETURN
      END
C
C  Subroutine to check quarters of coverage to 1977
C
      SUBROUTINE QCTDCK()
      INCLUDE 'wrkrdataf.h'
      IF (IBEGIN.GT.1950) QC51TD = QCTD
      IF (IEND.LT.1951) QC51TD = 0
      IF (IBEGIN.GT.1977) THEN
        QCTD = 0
        QC51TD = 0
      END IF
      END
C
C  Function to check for month and day in bounds
C
C *MODY   = month, day, and year.
C
      INTEGER FUNCTION MODYCK(MODY)
      INTEGER MODY(3)
      INCLUDE 'wrkrdataf.h'
      INTEGER MOCHEK
      MODYCK = 0
      IF (MOCHEK(MODY(1)).GT.0) MODYCK = 1
      IF (MODY(2).LT.1.OR.MODY(2).GT.31) MODYCK = 2
      RETURN
      END
C
C  Subroutine to zero out earnings and quarters of coverage before
C  first year and after last year
C
      SUBROUTINE ZERERN
      INCLUDE 'wrkrdataf.h'
      INTEGER I
      DO 100 I=1,IBEGIN-1937
      ERNPBS(I) = 0.
      EARNHI(I) = 0.
      IQC(I) = 0
  100 CONTINUE
      DO 110 I=IEND1-1935,IX
      ERNPBS(I) = 0.
      EARNHI(I) = 0.
      IQC(I) = 0
  110 CONTINUE
      RETURN
      END
C
C  Subroutine to set some PEBES data
C
      SUBROUTINE STPBDT
      INCLUDE 'wrkrdataf.h'
      INTEGER I
      IBEGN1 = IBEGIN
      IEND1 = ISTART + 1952
      IEND = IEND1
      PRFWRD = 1
      PERCFD = 0.
      PRBACK = 0
      PERCBK = 0.
      VALDI = 0
      IDEATH(1) = 0
      IDEATH(2) = 0
      IONSET(1) = 0
      IONSET(2) = 0
      IONSET(3) = 0
      DO 100 I=1,IEND1-1936
  100 EARNTP(I) = 0
      RETURN
      END
C
C  Function to see if benefit increase assumptions are needed
C
      LOGICAL FUNCTION NEEDBI()
      INTEGER DATE1(2)
      INCLUDE 'wrkrdataf.h'
      INTEGER COMPMY
      NEEDBI = .FALSE.
      DATE1(1) = 12
      DATE1(2) = ISTART+1951
      IF (COMPMY(BENDAT,DATE1).GE.0) NEEDBI = .TRUE.
      RETURN
      END
C
C  Function to see if average wage increase assumptions are needed
C
      LOGICAL FUNCTION NEEDAW()
      INTEGER DATE1(2)
      INCLUDE 'wrkrdataf.h'
      INTEGER COMPMY
      NEEDAW = .FALSE.
      DATE1(1) = 12
      DATE1(2) = ISTART+1951
      IF (EARNTP(ISTART+14).EQ.2.OR.EARNTP(ISTART+14).EQ.3.OR.
     &EARNTP(ISTART+15).EQ.2.OR.EARNTP(ISTART+15).EQ.3.OR.
     &(PRFWRD.EQ.1.AND.IEND.GT.ISTART+1949).OR.
     &(PRBACK.EQ.1.AND.IBEGN1.GT.ISTART+1949))
     &DATE1(2) = DATE1(2) - 2
      IF (COMPMY(BENDAT,DATE1).GT.0) NEEDAW = .TRUE.
      RETURN
      END
C
C  Function to return primary beneficiary code:
C  0: never a primary beneficiary
C  1: is a primary beneficiary
C  2: is a deceased primary beneficiary
C
      INTEGER FUNCTION ISPRIM()
      INCLUDE 'wrkrdataf.h'
      IF (IOASDI.EQ.2) THEN
C  Assume was old-age benie if over age 62 or disabled
        IF ((IDEATH(2) - IBIRTH(3)).GT.62.OR.VALDI.GT.0) THEN
          ISPRIM = 2
        ELSE
          ISPRIM = 0
        END IF
        RETURN
      END IF
      IF (IOASDI.EQ.1.OR.IOASDI.EQ.3) THEN
        ISPRIM = 1
      ELSE
        ISPRIM = 0
      END IF
      RETURN
      END
